/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.thermodynamics;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.cli.LambdaParticleOptions;
import ffx.algorithms.dynamics.Barostat;
import ffx.algorithms.dynamics.integrators.Stochastic;
import ffx.algorithms.optimize.Minimize;
import ffx.algorithms.thermodynamics.HistogramData;
import ffx.algorithms.thermodynamics.LambdaData;
import ffx.algorithms.thermodynamics.SendAsynchronous;
import ffx.algorithms.thermodynamics.SendSynchronous;
import ffx.crystal.Crystal;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.numerics.integrate.DataSet;
import ffx.numerics.integrate.DoublesDataSet;
import ffx.numerics.integrate.Integrate1DNumeric;
import ffx.potential.MolecularAssembly;
import ffx.potential.SystemState;
import ffx.potential.Utilities;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.parsers.PDBFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFilter;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;

public class OrthogonalSpaceTempering
implements CrystalPotential,
LambdaInterface {
    private static final Logger logger = Logger.getLogger(OrthogonalSpaceTempering.class.getName());
    protected final CrystalPotential potential;
    protected final AlgorithmListener algorithmListener;
    protected final boolean print = false;
    protected final int nVariables;
    private final LambdaInterface lambdaInterface;
    private final List<Histogram> allHistograms = new ArrayList<Histogram>();
    private final OptimizationParameters optimizationParameters;
    private final CompositeConfiguration properties;
    protected MolecularAssembly molecularAssembly;
    protected Potential.STATE state = Potential.STATE.BOTH;
    protected double forceFieldEnergy;
    private Histogram histogram;
    private int histogramIndex;
    private boolean propagateLambda = true;
    private final double[] dUdXdL;
    private final double[] tempGradient;
    private double dForceFieldEnergydL;
    private double gLdEdL = 0.0;
    private double biasEnergy;
    private double totalEnergy;
    private double dUdLambda;
    private double d2UdL2;
    private boolean hardWallConstraint = false;
    private final DynamicsOptions dynamicsOptions;
    private final LambdaParticleOptions lambdaParticleOptions;

    public OrthogonalSpaceTempering(LambdaInterface lambdaInterface, CrystalPotential potential, HistogramData histogramData, LambdaData lambdaData, CompositeConfiguration properties, DynamicsOptions dynamicsOptions, LambdaParticleOptions lambdaParticleOptions, AlgorithmListener algorithmListener) {
        this.lambdaInterface = lambdaInterface;
        this.potential = potential;
        this.properties = properties;
        this.dynamicsOptions = dynamicsOptions;
        this.lambdaParticleOptions = lambdaParticleOptions;
        this.algorithmListener = algorithmListener;
        this.nVariables = potential.getNumberOfVariables();
        if (potential instanceof Barostat) {
            logger.severe(" The Barostat must wrap the OST instance.");
        }
        this.dUdXdL = new double[this.nVariables];
        this.tempGradient = new double[this.nVariables];
        this.histogram = new Histogram(this, properties, histogramData, lambdaData);
        this.histogramIndex = 0;
        this.allHistograms.add(this.histogram);
        this.optimizationParameters = new OptimizationParameters(this, properties);
    }

    public void addHistogram(HistogramData histogramData, LambdaData lambdaData) {
        Histogram newHisto = new Histogram(this, this.properties, histogramData, lambdaData);
        histogramData.asynchronous = this.histogram.hd.asynchronous;
        this.allHistograms.add(newHisto);
    }

    public boolean dEdLZeroAtEnds() {
        return false;
    }

    public boolean destroy() {
        this.histogram.destroy();
        return this.potential.destroy();
    }

    public double energy(double[] x) {
        double bias1D;
        if (this.state == Potential.STATE.FAST) {
            this.forceFieldEnergy = this.potential.energy(x);
            return this.forceFieldEnergy;
        }
        if (this.propagateLambda) {
            this.histogram.stochasticPreForce();
        }
        Arrays.fill(this.tempGradient, 0.0);
        this.forceFieldEnergy = this.potential.energyAndGradient(x, this.tempGradient);
        this.dForceFieldEnergydL = this.lambdaInterface.getdEdL();
        this.d2UdL2 = this.lambdaInterface.getd2EdL2();
        int lambdaBin = this.histogram.indexForLambda();
        this.dUdLambda = this.dForceFieldEnergydL;
        this.gLdEdL = 0.0;
        this.histogram.updateFreeEnergyDifference(false, false);
        if (this.histogram.hd.metaDynamics) {
            bias1D = this.histogram.energyAndGradientMeta(true);
        } else {
            if (this.histogram.hd.biasMag > 0.0) {
                double[] chainRule = new double[2];
                this.gLdEdL = this.histogram.energyAndGradient2D(this.dUdLambda, chainRule);
                double dGdLambda = chainRule[0];
                double dGdFLambda = chainRule[1];
                this.dUdLambda += dGdLambda + dGdFLambda * this.d2UdL2;
            }
            bias1D = this.histogram.energyAndGradient1D(true);
        }
        this.biasEnergy = bias1D + this.gLdEdL;
        if (this.propagateLambda) {
            this.histogram.stochasticPostForce();
            ++this.histogram.ld.stepsTaken;
            long energyCount = this.histogram.ld.stepsTaken;
            int printFrequency = this.dynamicsOptions.getReportFrequency(100);
            if (energyCount % (long)printFrequency == 0L) {
                double dBdL = this.dUdLambda - this.dForceFieldEnergydL;
                double lambda = this.histogram.ld.lambda;
                int lambdaBins = this.histogram.hd.getLambdaBins();
                if (lambdaBins < 1000) {
                    logger.info(String.format(" L=%6.4f (%3d) F_LU=%10.4f F_LB=%10.4f F_L=%10.4f V_L=%10.4f", lambda, lambdaBin, this.dForceFieldEnergydL, dBdL, this.dUdLambda, this.histogram.ld.thetaVelocity));
                } else {
                    logger.info(String.format(" L=%6.4f (%4d) F_LU=%10.4f F_LB=%10.4f F_L=%10.4f V_L=%10.4f", lambda, lambdaBin, this.dForceFieldEnergydL, dBdL, this.dUdLambda, this.histogram.ld.thetaVelocity));
                }
            }
            if (energyCount % (long)this.histogram.hd.countInterval == 0L) {
                this.histogram.addBias(this.dForceFieldEnergydL);
                if (this.optimizationParameters.doOptimization) {
                    this.optimizationParameters.optimize(this.forceFieldEnergy, x, this.tempGradient);
                }
                if (this.algorithmListener != null) {
                    this.algorithmListener.algorithmUpdate(this.molecularAssembly);
                }
            }
        }
        this.totalEnergy = this.forceFieldEnergy + this.biasEnergy;
        return this.totalEnergy;
    }

    public double energyAndGradient(double[] x, double[] gradient) {
        double bias1D;
        if (this.state != Potential.STATE.FAST && this.propagateLambda) {
            this.histogram.stochasticPreForce();
        }
        this.forceFieldEnergy = this.potential.energyAndGradient(x, gradient);
        if (this.state == Potential.STATE.FAST) {
            return this.forceFieldEnergy;
        }
        this.dUdLambda = this.dForceFieldEnergydL = this.lambdaInterface.getdEdL();
        this.d2UdL2 = this.lambdaInterface.getd2EdL2();
        this.gLdEdL = 0.0;
        this.histogram.updateFreeEnergyDifference(false, false);
        if (this.histogram.hd.metaDynamics) {
            bias1D = this.histogram.energyAndGradientMeta(true);
        } else {
            if (this.histogram.hd.biasMag > 0.0) {
                double[] chainRule = new double[2];
                this.gLdEdL = this.histogram.energyAndGradient2D(this.dUdLambda, chainRule);
                double dGdLambda = chainRule[0];
                double dGdFLambda = chainRule[1];
                this.dUdLambda += dGdLambda + dGdFLambda * this.d2UdL2;
                Arrays.fill(this.dUdXdL, 0.0);
                this.lambdaInterface.getdEdXdL(this.dUdXdL);
                for (int i = 0; i < this.nVariables; ++i) {
                    int n = i;
                    gradient[n] = gradient[n] + dGdFLambda * this.dUdXdL[i];
                }
            }
            bias1D = this.histogram.energyAndGradient1D(true);
        }
        this.biasEnergy = bias1D + this.gLdEdL;
        if (this.propagateLambda) {
            this.histogram.stochasticPostForce();
            ++this.histogram.ld.stepsTaken;
            long energyCount = this.histogram.ld.stepsTaken;
            int printFrequency = this.dynamicsOptions.getReportFrequency(100);
            if (energyCount % (long)printFrequency == 0L) {
                double dBdL = this.dUdLambda - this.dForceFieldEnergydL;
                int lambdaBin = this.histogram.indexForLambda();
                double lambda = this.histogram.ld.lambda;
                int lambdaBins = this.histogram.hd.getLambdaBins();
                if (lambdaBins < 1000) {
                    logger.info(String.format(" L=%6.4f (%3d) F_LU=%10.4f F_LB=%10.4f F_L=%10.4f V_L=%10.4f", lambda, lambdaBin, this.dForceFieldEnergydL, dBdL, this.dUdLambda, this.histogram.ld.thetaVelocity));
                } else {
                    logger.info(String.format(" L=%6.4f (%4d) F_LU=%10.4f F_LB=%10.4f F_L=%10.4f V_L=%10.4f", lambda, lambdaBin, this.dForceFieldEnergydL, dBdL, this.dUdLambda, this.histogram.ld.thetaVelocity));
                }
            }
            if (energyCount % (long)this.histogram.hd.countInterval == 0L) {
                this.histogram.addBias(this.dForceFieldEnergydL);
                if (this.optimizationParameters.doOptimization) {
                    this.optimizationParameters.optimize(this.forceFieldEnergy, x, gradient);
                }
                if (this.algorithmListener != null) {
                    this.algorithmListener.algorithmUpdate(this.molecularAssembly);
                }
            }
        }
        this.totalEnergy = this.forceFieldEnergy + this.biasEnergy;
        return this.totalEnergy;
    }

    public double[] getAcceleration(double[] acceleration) {
        return this.potential.getAcceleration(acceleration);
    }

    public Histogram[] getAllHistograms() {
        int nHisto = this.allHistograms.size();
        Histogram[] ret = new Histogram[nHisto];
        ret = this.allHistograms.toArray(ret);
        return ret;
    }

    public double[] getCoordinates(double[] doubles) {
        return this.potential.getCoordinates(doubles);
    }

    public void setCoordinates(double[] doubles) {
        this.potential.setCoordinates(doubles);
    }

    public Crystal getCrystal() {
        return this.potential.getCrystal();
    }

    public void setCrystal(Crystal crystal) {
        this.potential.setCrystal(crystal);
    }

    public long getEnergyCount() {
        return this.histogram.ld.stepsTaken;
    }

    public Potential.STATE getEnergyTermState() {
        return this.state;
    }

    public void setEnergyTermState(Potential.STATE state) {
        this.state = state;
        this.potential.setEnergyTermState(state);
    }

    public double getForceFieldEnergy() {
        return this.forceFieldEnergy;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public double getLambda() {
        return this.histogram.ld.lambda;
    }

    public void setLambda(double lambda) {
        if (this.histogram != null) {
            lambda = this.histogram.mapLambda(lambda);
        } else {
            logger.warning(" OrthogonalSpaceTempering.setLambda was called before histogram constructed!");
            logger.info(Utilities.stackTraceToString((Throwable)new RuntimeException()));
        }
        this.lambdaInterface.setLambda(lambda);
        this.histogram.ld.lambda = lambda;
        this.histogram.ld.theta = FastMath.asin((double)FastMath.sqrt((double)lambda));
    }

    public double[] getMass() {
        return this.potential.getMass();
    }

    public int getNumberOfVariables() {
        return this.potential.getNumberOfVariables();
    }

    public OptimizationParameters getOptimizationParameters() {
        return this.optimizationParameters;
    }

    public Potential getPotentialEnergy() {
        return this.potential;
    }

    public double[] getPreviousAcceleration(double[] previousAcceleration) {
        return this.potential.getPreviousAcceleration(previousAcceleration);
    }

    public double[] getScaling() {
        return this.potential.getScaling();
    }

    public void setScaling(double[] scaling) {
        this.potential.setScaling(scaling);
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public double getTotaldEdLambda() {
        return this.dUdLambda;
    }

    public Potential.VARIABLE_TYPE[] getVariableTypes() {
        return this.potential.getVariableTypes();
    }

    public double[] getVelocity(double[] velocity) {
        return this.potential.getVelocity(velocity);
    }

    public double getd2EdL2() {
        throw new UnsupportedOperationException(" Second derivatives of the bias are not implemented, as they require third derivatives of the potential.");
    }

    public double getdEdL() {
        return this.getTotaldEdLambda();
    }

    public void getdEdXdL(double[] gradient) {
        throw new UnsupportedOperationException(" Second derivatives of the bias are not implemented, as they require third derivatives of the potential.");
    }

    public void logOutputFiles(int index) {
        logger.info(String.format(" OST: Lambda file %s, histogram %s", this.histogram.ld.getLambdaFile(), this.allHistograms.get((int)index).hd.getHistogramFile()));
    }

    public void setAcceleration(double[] acceleration) {
        this.potential.setAcceleration(acceleration);
    }

    public void setHardWallConstraint(boolean hardWallConstraint) {
        this.hardWallConstraint = hardWallConstraint;
    }

    public void setMolecularAssembly(MolecularAssembly molecularAssembly) {
        this.molecularAssembly = molecularAssembly;
    }

    public void setPreviousAcceleration(double[] previousAcceleration) {
        this.potential.setPreviousAcceleration(previousAcceleration);
    }

    public void setPropagateLambda(boolean propagateLambda) {
        this.propagateLambda = propagateLambda;
    }

    public boolean getPropagateLambda() {
        return this.propagateLambda;
    }

    public void setVelocity(double[] velocity) {
        this.potential.setVelocity(velocity);
    }

    public void switchHistogram(int index) {
        this.histogramIndex = index;
        this.histogram = this.allHistograms.get(this.histogramIndex);
        logger.info(" OST switching to histogram " + this.histogramIndex);
    }

    public void writeAdditionalRestartInfo(boolean recursive) {
        this.histogram.writeRestart();
        if (recursive) {
            this.potential.writeAdditionalRestartInfo(recursive);
        }
    }

    double getLambdaWriteOut() {
        return this.histogram.hd.resetHistogramAtLambda;
    }

    double getForceFielddEdL() {
        return this.dForceFieldEnergydL;
    }

    double getBiasEnergy() {
        return this.biasEnergy;
    }

    boolean insideHardWallConstraint(double lambda, double dUdL) {
        if (this.hardWallConstraint) {
            double weight = this.histogram.getRecursionKernelValue(lambda, dUdL);
            return weight > 0.0;
        }
        return true;
    }

    public class Histogram {
        private static final double TWO_D_NORMALIZATION = 1.0;
        private static final double ONE_D_NORMALIZATION = Math.sqrt(Math.PI * 2);
        private static final double PSEUDO_BIAS_MAGNITUDE = 1.0;
        protected final Comm world;
        protected final int rank;
        final double[] ensembleAveragedUdL;
        private final double deltaT;
        private final Integrate1DNumeric.IntegrationType integrationType;
        private final SendAsynchronous sendAsynchronous;
        private final SendSynchronous sendSynchronous;
        private double temperingWeight;
        private double[] kernelValues;
        private double lastReceivedLambda;
        private double lastReceiveddUdL;
        private final boolean spreadBias;
        final HistogramData hd;
        final LambdaData ld;
        private final Stochastic stochastic;
        private final SystemState lambdaState;
        private int currentNumberOfHills;
        private double currentFreeEnergyDifference;
        final /* synthetic */ OrthogonalSpaceTempering this$0;

        Histogram(OrthogonalSpaceTempering this$0, CompositeConfiguration properties, HistogramData histogramData, LambdaData lambdaData) {
            Integrate1DNumeric.IntegrationType testType;
            OrthogonalSpaceTempering orthogonalSpaceTempering = this$0;
            Objects.requireNonNull(orthogonalSpaceTempering);
            this.this$0 = orthogonalSpaceTempering;
            this.temperingWeight = 1.0;
            this.currentNumberOfHills = 0;
            this.currentFreeEnergyDifference = 0.0;
            this.hd = histogramData;
            this.ld = lambdaData;
            this.deltaT = this.hd.temperingFactor * 0.0019872042586408316 * this$0.dynamicsOptions.getTemperature();
            this.ensembleAveragedUdL = new double[this.hd.getLambdaBins()];
            this.kernelValues = new double[this.hd.getDUDLBins()];
            String propString = properties.getString("ost-integrationType", "SIMPSONS");
            try {
                testType = Integrate1DNumeric.IntegrationType.valueOf((String)propString.toUpperCase());
            }
            catch (Exception ex) {
                logger.warning(String.format(" Invalid argument %s to ost-integrationType; resetting to SIMPSONS", propString));
                testType = Integrate1DNumeric.IntegrationType.SIMPSONS;
            }
            this.integrationType = testType;
            this.spreadBias = properties.getBoolean("ost-spread-bias", false);
            this.world = Comm.world();
            int numProc = this.world.size();
            this.rank = this.world.rank();
            if (this.hd.asynchronous) {
                this.sendAsynchronous = new SendAsynchronous(this);
                this.sendAsynchronous.start();
                this.sendSynchronous = null;
            } else {
                Histogram[] histograms = new Histogram[numProc];
                int[] rankToHistogramMap = new int[numProc];
                for (int i = 0; i < numProc; ++i) {
                    histograms[i] = this;
                    rankToHistogramMap[i] = 0;
                }
                this.sendSynchronous = new SendSynchronous(histograms, rankToHistogramMap);
                this.sendAsynchronous = null;
            }
            this.lastReceivedLambda = this.ld.lambda;
            if (this.hd.discreteLambda) {
                this.lastReceivedLambda = this.mapLambda(this.lastReceivedLambda);
                logger.info(String.format(" Discrete lambda: initializing lambda to nearest bin %.5f", this.lastReceivedLambda));
                this.ld.lambda = this.lastReceivedLambda;
                this.ld.theta = FastMath.asin((double)FastMath.sqrt((double)this.lastReceivedLambda));
                this$0.lambdaInterface.setLambda(this.lastReceivedLambda);
                this.lambdaState = null;
                this.stochastic = null;
            } else {
                this.lambdaState = new SystemState(1);
                this.stochastic = new Stochastic(this$0.lambdaParticleOptions.getLambdaFriction(), this.lambdaState);
                this.stochastic.setTemperature(this$0.dynamicsOptions.getTemperature());
                this.stochastic.setTimeStep(this$0.dynamicsOptions.getDtPsec());
                double[] mass = this.lambdaState.getMass();
                double[] thetaPosition = this.lambdaState.x();
                double[] thetaVelocity = this.lambdaState.v();
                double[] thetaAccel = this.lambdaState.a();
                mass[0] = this$0.lambdaParticleOptions.getLambdaMass();
                thetaPosition[0] = this.ld.theta;
                thetaVelocity[0] = this.ld.thetaVelocity;
                thetaAccel[0] = this.ld.thetaAcceleration;
            }
            this.lastReceiveddUdL = this$0.getdEdL();
            if (this.hd.wasHistogramRead()) {
                this.updateFreeEnergyDifference(true, false);
            }
        }

        public void disableResetStatistics() {
            this.hd.resetHistogram = false;
        }

        public StringBuffer evaluateTotalOSTBias(boolean bias) {
            StringBuffer sb = new StringBuffer();
            double[] chainRule = new double[2];
            for (int dUdLBin = 0; dUdLBin < this.hd.getDUDLBins(); ++dUdLBin) {
                double currentdUdL = this.dUdLforBin(dUdLBin);
                sb.append(String.format(" %16.8f", currentdUdL));
                for (int lambdaBin = 0; lambdaBin < this.hd.getLambdaBins(); ++lambdaBin) {
                    double currentLambda = this.lambdaForIndex(lambdaBin);
                    double bias1D = this.energyAndGradient1D(currentLambda, false);
                    double bias2D = this.energyAndGradient2D(currentLambda, currentdUdL, chainRule, this.hd.biasMag);
                    double totalBias = bias1D + bias2D;
                    if (!bias) {
                        totalBias = -totalBias;
                    }
                    sb.append(String.format(" %16.8f", totalBias));
                }
                sb.append("\n");
            }
            return sb;
        }

        public StringBuffer evaluate2DOSTBias(boolean bias) {
            StringBuffer sb = new StringBuffer();
            double[] chainRule = new double[2];
            for (int dUdLBin = 0; dUdLBin < this.hd.getDUDLBins(); ++dUdLBin) {
                double currentdUdL = this.dUdLforBin(dUdLBin);
                sb.append(String.format(" %16.8f", currentdUdL));
                for (int lambdaBin = 0; lambdaBin < this.hd.getLambdaBins(); ++lambdaBin) {
                    double currentLambda = this.lambdaForIndex(lambdaBin);
                    double bias2D = this.energyAndGradient2D(currentLambda, currentdUdL, chainRule, this.hd.biasMag);
                    if (!bias) {
                        bias2D = -bias2D;
                    }
                    sb.append(String.format(" %16.8f", bias2D));
                }
                sb.append("\n");
            }
            return sb;
        }

        public boolean getIndependentWalkers() {
            return this.hd.independentWalkers;
        }

        public double getLambdaResetValue() {
            return this.hd.resetHistogramAtLambda;
        }

        public int getRank() {
            return this.rank;
        }

        public boolean getResetStatistics() {
            return this.hd.resetHistogram;
        }

        public Optional<SendSynchronous> getSynchronousSend() {
            return Optional.ofNullable(this.sendSynchronous);
        }

        public void setLastReceiveddUdL(double lastReceiveddUdL) {
            this.lastReceiveddUdL = lastReceiveddUdL;
        }

        public double updateFreeEnergyDifference(boolean print, boolean save) {
            if (this.hd.metaDynamics) {
                return this.updateMetaDynamicsFreeEnergyDifference(print, save);
            }
            return this.updateOSTFreeEnergyDifference(print, save);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double updateMetaDynamicsFreeEnergyDifference(boolean print, boolean save) {
            Histogram histogram = this;
            synchronized (histogram) {
                if (!print && this.currentNumberOfHills == this.hd.counts) {
                    return this.currentFreeEnergyDifference;
                }
                double freeEnergyDifferenceMeta = 0.0;
                double freeEnergyDifferenceTI = 0.0;
                double minFL = Double.MAX_VALUE;
                int lambdaBins = this.hd.getLambdaBins();
                double[] metaFreeEnergy = new double[lambdaBins];
                double totalWeight = 0.0;
                StringBuilder stringBuilder = new StringBuilder();
                for (int lambdaBin = 0; lambdaBin < lambdaBins; ++lambdaBin) {
                    int firstdUdLBin = this.firstdUdLBin(lambdaBin);
                    int lastdUdLBin = this.lastdUdLBin(lambdaBin);
                    double lambdaCount = 0.0;
                    double mindUdLForLambda = 0.0;
                    double maxdUdLforLambda = 0.0;
                    double maxBias = 0.0;
                    if (firstdUdLBin == -1 || lastdUdLBin == -1) {
                        this.ensembleAveragedUdL[lambdaBin] = 0.0;
                        minFL = 0.0;
                    } else {
                        double ensembleAverageFLambda = 0.0;
                        double partitionFunction = 0.0;
                        double offset = this.evaluateKernelForLambda(lambdaBin, firstdUdLBin, lastdUdLBin);
                        for (int dUdLBin = firstdUdLBin; dUdLBin <= lastdUdLBin; ++dUdLBin) {
                            double kernel = this.kernelValues[dUdLBin];
                            if (kernel - offset > maxBias) {
                                maxBias = kernel - offset;
                            }
                            partitionFunction += kernel;
                            double currentdUdL = this.dUdLforBin(dUdLBin);
                            ensembleAverageFLambda += currentdUdL * kernel;
                            lambdaCount += this.getRecursionKernelValue(lambdaBin, dUdLBin);
                        }
                        if (minFL > maxBias) {
                            minFL = maxBias;
                        }
                        this.ensembleAveragedUdL[lambdaBin] = partitionFunction == 0.0 ? 0.0 : ensembleAverageFLambda / partitionFunction;
                        mindUdLForLambda = this.hd.dUdLMinimum + (double)firstdUdLBin * this.hd.dUdLBinWidth;
                        maxdUdLforLambda = this.hd.dUdLMinimum + (double)(lastdUdLBin + 1) * this.hd.dUdLBinWidth;
                    }
                    double deltaFreeEnergy = this.ensembleAveragedUdL[lambdaBin] * this.deltaForLambdaBin(lambdaBin);
                    freeEnergyDifferenceTI += deltaFreeEnergy;
                    totalWeight += lambdaCount;
                    double lambdaBinWidth = this.hd.lambdaBinWidth;
                    double llL = (double)lambdaBin * lambdaBinWidth - this.hd.lambdaBinWidth_2;
                    double ulL = llL + lambdaBinWidth;
                    if (llL < 0.0) {
                        llL = 0.0;
                    }
                    if (ulL > 1.0) {
                        ulL = 1.0;
                    }
                    double midLambda = llL;
                    if (!this.hd.discreteLambda) {
                        midLambda = (llL + ulL) / 2.0;
                    }
                    double bias1D = this.energyAndGradient1D(midLambda, false);
                    metaFreeEnergy[lambdaBin] = this.energyAndGradientMeta(midLambda, false);
                    freeEnergyDifferenceMeta = -(metaFreeEnergy[lambdaBin] - metaFreeEnergy[0]);
                    if (!print && !save) continue;
                    stringBuilder.append(String.format(" %6.2e %7.5f %7.1f %7.1f %9.2f %9.2f %9.2f %9.2f %9.2f\n", lambdaCount, midLambda, mindUdLForLambda, maxdUdLforLambda, this.ensembleAveragedUdL[lambdaBin], bias1D, freeEnergyDifferenceTI, metaFreeEnergy[lambdaBin], freeEnergyDifferenceMeta));
                }
                double temperingOffset = this.hd.getTemperingOffset();
                double temperEnergy = minFL > temperingOffset ? temperingOffset - minFL : 0.0;
                this.temperingWeight = FastMath.exp((double)(temperEnergy / this.deltaT));
                if (print) {
                    logger.info("  Weight   Lambda      dU/dL Bins   <dU/dL>      g(L) dG_OST(L)  Meta(L) dG_Meta(L)");
                    logger.info(stringBuilder.toString());
                    logger.info(" Histogram Evaluation");
                    logger.info(String.format("  Free Energy Difference: %12.4f kcal/mol", freeEnergyDifferenceMeta));
                    logger.info(String.format("  Number of Hills:        %12d", this.hd.counts));
                    logger.info(String.format("  Total Bias Added:       %12.4f kcal/mol", totalWeight * this.hd.biasMag));
                    logger.info(String.format("  Minimum Bias:           %12.4f kcal/mol", minFL));
                    logger.info(String.format("  Tempering Percentage:   %12.4f %%\n", this.temperingWeight * 100.0));
                }
                if (save) {
                    String modelFilename = this.this$0.molecularAssembly.getFile().getAbsolutePath();
                    File saveDir = new File(FilenameUtils.getFullPath((String)modelFilename));
                    String dirName = String.valueOf(saveDir) + File.separator;
                    String fileName = dirName + "histogram.txt";
                    try {
                        logger.info(" Writing " + fileName);
                        PrintWriter printWriter = new PrintWriter(fileName);
                        printWriter.write(stringBuilder.toString());
                        printWriter.close();
                    }
                    catch (Exception e) {
                        logger.info(String.format(" Failed to write %s.", fileName));
                    }
                }
                this.currentNumberOfHills = this.hd.counts;
                this.currentFreeEnergyDifference = freeEnergyDifferenceMeta;
                return this.currentFreeEnergyDifference;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double updateOSTFreeEnergyDifference(boolean print, boolean save) {
            Histogram histogram = this;
            synchronized (histogram) {
                if (!print && this.currentNumberOfHills == this.hd.counts) {
                    return this.currentFreeEnergyDifference;
                }
                double freeEnergyDifferenceOST = 0.0;
                double minFL = Double.MAX_VALUE;
                boolean biasMagZero = this.hd.biasMag <= 0.0;
                double totalWeight = 0.0;
                double beta = 1.0 / (0.0019872042586408316 * this.this$0.dynamicsOptions.getTemperature());
                StringBuilder stringBuilder = new StringBuilder();
                for (int lambdaBin = 0; lambdaBin < this.hd.lambdaBins; ++lambdaBin) {
                    int firstdUdLBin = this.firstdUdLBin(lambdaBin);
                    int lastdUdLBin = this.lastdUdLBin(lambdaBin);
                    double lambdaCount = 0.0;
                    double mindUdLforLambda = 0.0;
                    double maxdUdLforLambda = 0.0;
                    double maxBias = 0.0;
                    if (firstdUdLBin == -1 || lastdUdLBin == -1) {
                        this.ensembleAveragedUdL[lambdaBin] = 0.0;
                        minFL = 0.0;
                    } else {
                        double ensembleAverage = 0.0;
                        double partitionFunction = 0.0;
                        double offset = this.evaluateKernelForLambda(lambdaBin, firstdUdLBin, lastdUdLBin);
                        for (int dUdLBin = firstdUdLBin; dUdLBin <= lastdUdLBin; ++dUdLBin) {
                            double kernel = this.kernelValues[dUdLBin];
                            if (kernel - offset > maxBias) {
                                maxBias = kernel - offset;
                            }
                            double weight = biasMagZero ? kernel : FastMath.exp((double)(kernel * beta));
                            partitionFunction += weight;
                            double currentdUdL = this.dUdLforBin(dUdLBin);
                            ensembleAverage += currentdUdL * weight;
                            lambdaCount += this.getRecursionKernelValue(lambdaBin, dUdLBin);
                        }
                        if (minFL > maxBias) {
                            minFL = maxBias;
                        }
                        this.ensembleAveragedUdL[lambdaBin] = partitionFunction == 0.0 ? 0.0 : ensembleAverage / partitionFunction;
                        mindUdLforLambda = this.hd.dUdLMinimum + (double)firstdUdLBin * this.hd.dUdLBinWidth;
                        maxdUdLforLambda = this.hd.dUdLMinimum + (double)(lastdUdLBin + 1) * this.hd.dUdLBinWidth;
                    }
                    double deltaFreeEnergy = this.ensembleAveragedUdL[lambdaBin] * this.deltaForLambdaBin(lambdaBin);
                    freeEnergyDifferenceOST += deltaFreeEnergy;
                    totalWeight += lambdaCount;
                    if (!print && !save) continue;
                    double llL = (double)lambdaBin * this.hd.lambdaBinWidth - this.hd.lambdaBinWidth_2;
                    double ulL = llL + this.hd.lambdaBinWidth;
                    if (llL < 0.0) {
                        llL = 0.0;
                    }
                    if (ulL > 1.0) {
                        ulL = 1.0;
                    }
                    double midLambda = llL;
                    if (!this.hd.discreteLambda) {
                        midLambda = (llL + ulL) / 2.0;
                    }
                    double bias1D = this.energyAndGradient1D(midLambda, false);
                    double bias2D = 0.0;
                    if (!biasMagZero) {
                        bias2D = this.computeBiasEnergy(midLambda, this.ensembleAveragedUdL[lambdaBin]) - bias1D;
                    }
                    stringBuilder.append(String.format(" %6.2e %7.5f %7.1f %7.1f %8.2f %8.2f %8.2f %8.2f %8.2f   %8.2f\n", lambdaCount, midLambda, mindUdLforLambda, maxdUdLforLambda, this.ensembleAveragedUdL[lambdaBin], bias1D, bias2D, bias1D + bias2D, freeEnergyDifferenceOST, bias1D + bias2D + freeEnergyDifferenceOST));
                }
                if (!biasMagZero) {
                    double temperingOffset = this.hd.getTemperingOffset();
                    double temperEnergy = minFL > temperingOffset ? temperingOffset - minFL : 0.0;
                    this.temperingWeight = FastMath.exp((double)(temperEnergy / this.deltaT));
                }
                freeEnergyDifferenceOST = this.integrateNumeric(this.ensembleAveragedUdL, this.integrationType);
                if (print) {
                    logger.info("  Weight   Lambda      dU/dL Bins  <dU/dL>    g(L)  f(L,<dU/dL>) Bias    dG(L) Bias+dG(L)");
                    logger.info(stringBuilder.toString());
                    logger.info(" Histogram Evaluation");
                    logger.info(String.format("  Free Energy Difference: %12.4f kcal/mol", freeEnergyDifferenceOST));
                    logger.info(String.format("  Number of Hills:        %12d", this.hd.counts));
                    logger.info(String.format("  Total Bias Added:       %12.4f kcal/mol", totalWeight * this.hd.biasMag));
                    logger.info(String.format("  Minimum Bias:           %12.4f kcal/mol", minFL));
                    logger.info(String.format("  Tempering Percentage:   %12.4f %%\n", this.temperingWeight * 100.0));
                }
                if (save) {
                    String modelFilename = this.this$0.molecularAssembly.getFile().getAbsolutePath();
                    File saveDir = new File(FilenameUtils.getFullPath((String)modelFilename));
                    String dirName = String.valueOf(saveDir) + File.separator;
                    String fileName = dirName + "histogram.txt";
                    try {
                        logger.info("\n Writing " + fileName);
                        PrintWriter printWriter = new PrintWriter(fileName);
                        printWriter.write(stringBuilder.toString());
                        printWriter.close();
                    }
                    catch (Exception e) {
                        logger.info(String.format(" Failed to write %s.", fileName));
                    }
                }
                this.currentNumberOfHills = this.hd.counts;
                this.currentFreeEnergyDifference = freeEnergyDifferenceOST;
                return this.currentFreeEnergyDifference;
            }
        }

        private double deltaForLambdaBin(int lambdaBin) {
            if (!(this.hd.discreteLambda || lambdaBin != 0 && lambdaBin != this.hd.lambdaBins - 1)) {
                return this.hd.lambdaBinWidth_2;
            }
            if (this.hd.discreteLambda && lambdaBin == 0) {
                return 0.0;
            }
            return this.hd.lambdaBinWidth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int firstdUdLBin(int lambdaBin) {
            Histogram histogram = this;
            synchronized (histogram) {
                for (int jFL = 0; jFL < this.hd.dUdLBins; ++jFL) {
                    double count = this.hd.zHistogram[lambdaBin][jFL];
                    if (!(count > 0.0)) continue;
                    return jFL;
                }
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int lastdUdLBin(int lambdaBin) {
            Histogram histogram = this;
            synchronized (histogram) {
                for (int jFL = this.hd.dUdLBins - 1; jFL >= 0; --jFL) {
                    double count = this.hd.zHistogram[lambdaBin][jFL];
                    if (!(count > 0.0)) continue;
                    return jFL;
                }
                return -1;
            }
        }

        void writeRestart() {
            String message;
            if (this.rank == 0 || this.hd.independentWrite) {
                this.updateFreeEnergyDifference(true, false);
                try {
                    this.hd.writeHistogram();
                    logger.info(String.format(" Wrote histogram restart to: %s.", this.hd.getHistogramFileName()));
                }
                catch (Exception ex) {
                    message = String.format(" Exception writing histogram restart file %s.", this.hd.getHistogramFileName());
                    logger.log(Level.INFO, Utilities.stackTraceToString((Throwable)ex));
                    logger.log(Level.SEVERE, message, ex);
                }
            }
            try {
                this.ld.writeLambdaData();
                logger.info(String.format(" Wrote lambda restart to:    %s.", this.ld.getLambdaFileName()));
            }
            catch (Exception ex) {
                message = String.format(" Exception writing lambda restart file %s.", this.ld.getLambdaFileName());
                logger.log(Level.INFO, Utilities.stackTraceToString((Throwable)ex));
                logger.log(Level.SEVERE, message, ex);
            }
        }

        private double mapLambda(double lambda) {
            if (this.hd.discreteLambda) {
                return this.hd.lambdaLadder[this.indexForDiscreteLambda(lambda)];
            }
            return lambda;
        }

        int indexForLambda(double lambda) {
            if (this.hd.discreteLambda) {
                return this.indexForDiscreteLambda(lambda);
            }
            return this.indexForContinuousLambda(lambda);
        }

        int indexForLambda() {
            return this.indexForLambda(this.ld.lambda);
        }

        private double lambdaForIndex(int bin) {
            if (this.hd.discreteLambda) {
                return this.hd.lambdaLadder[bin];
            }
            return (double)bin * this.hd.lambdaBinWidth;
        }

        private int indexForContinuousLambda(double lambda) {
            int lambdaBin = (int)FastMath.floor((double)((lambda - this.hd.minLambda) / this.hd.lambdaBinWidth));
            if (lambdaBin < 0) {
                lambdaBin = 0;
            }
            if (lambdaBin >= this.hd.lambdaBins) {
                lambdaBin = this.hd.lambdaBins - 1;
            }
            return lambdaBin;
        }

        private int indexForDiscreteLambda(double lambda) {
            assert (this.hd.discreteLambda && this.hd.lambdaLadder != null && this.hd.lambdaLadder.length > 0);
            int initialGuess = this.indexForContinuousLambda(lambda);
            double minErr = Double.MAX_VALUE;
            int minErrBin = -1;
            for (int i = -1; i < 2; ++i) {
                double guessLam;
                double guessErr;
                int guessBin = i + initialGuess;
                if (guessBin < 0 || guessBin >= this.hd.lambdaBins || !((guessErr = Math.abs((guessLam = this.hd.lambdaLadder[guessBin]) - lambda)) < minErr)) continue;
                minErr = guessErr;
                minErrBin = guessBin;
            }
            assert (minErr < 1.0E-6);
            return minErrBin;
        }

        int binFordUdL(double dUdL) {
            if (dUdL < this.hd.dUdLMinimum) {
                return -1;
            }
            if (dUdL > this.hd.dUdLMaximum) {
                return -1;
            }
            int bin = (int)FastMath.floor((double)((dUdL - this.hd.dUdLMinimum) / this.hd.dUdLBinWidth));
            if (bin == this.hd.dUdLBins) {
                bin = this.hd.dUdLBins - 1;
            }
            if (bin < 0) {
                bin = 0;
            }
            return bin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        double getRecursionKernelValue(int lambdaBin, int dUdLBin) {
            Histogram histogram = this;
            synchronized (histogram) {
                lambdaBin = this.lambdaMirror(lambdaBin);
                if (dUdLBin < 0 || dUdLBin >= this.hd.dUdLBins) {
                    return 0.0;
                }
                return this.hd.zHistogram[lambdaBin][dUdLBin];
            }
        }

        double getRecursionKernelValue(double lambda, double dUdL) {
            return this.getRecursionKernelValue(this.indexForLambda(lambda), this.binFordUdL(dUdL));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addToRecursionKernelValue(double currentLambda, double currentdUdL, double value) {
            Histogram histogram = this;
            synchronized (histogram) {
                if (this.spreadBias) {
                    double deltaFL2;
                    double deltaFL;
                    int dUdLBin;
                    int jFL;
                    double L2exp;
                    double deltaL2;
                    double deltaL;
                    int lambdaBin;
                    int iL;
                    int dUdLbiasCutoff = this.hd.dUdLBiasCutoff;
                    this.checkRecursionKernelSize(this.dUdLforBin(this.binFordUdL(currentdUdL) - dUdLbiasCutoff));
                    this.checkRecursionKernelSize(this.dUdLforBin(this.binFordUdL(currentdUdL) + dUdLbiasCutoff));
                    int currentLambdaBin = this.indexForLambda(currentLambda);
                    int currentdUdLBin = this.binFordUdL(currentdUdL);
                    double invLs2 = 0.5 / this.hd.lambdaVariance;
                    double invFLs2 = 0.5 / this.hd.dUdLVariance;
                    double normalize = 0.0;
                    int lambdaBiasCutoff = this.hd.lambdaBiasCutoff;
                    for (iL = -lambdaBiasCutoff; iL <= lambdaBiasCutoff; ++iL) {
                        lambdaBin = currentLambdaBin + iL;
                        deltaL = currentLambda - (double)lambdaBin * this.hd.lambdaBinWidth;
                        deltaL2 = deltaL * deltaL;
                        L2exp = FastMath.exp((double)(-deltaL2 * invLs2));
                        for (jFL = -dUdLbiasCutoff; jFL <= dUdLbiasCutoff; ++jFL) {
                            dUdLBin = currentdUdLBin + jFL;
                            deltaFL = currentdUdL - this.dUdLforBin(dUdLBin);
                            deltaFL2 = deltaFL * deltaFL;
                            normalize += L2exp * FastMath.exp((double)(-deltaFL2 * invFLs2));
                        }
                    }
                    for (iL = -lambdaBiasCutoff; iL <= lambdaBiasCutoff; ++iL) {
                        lambdaBin = currentLambdaBin + iL;
                        deltaL = currentLambda - (double)lambdaBin * this.hd.lambdaBinWidth;
                        deltaL2 = deltaL * deltaL;
                        L2exp = FastMath.exp((double)(-deltaL2 * invLs2));
                        lambdaBin = this.lambdaMirror(lambdaBin);
                        for (jFL = -dUdLbiasCutoff; jFL <= dUdLbiasCutoff; ++jFL) {
                            dUdLBin = currentdUdLBin + jFL;
                            deltaFL = currentdUdL - this.dUdLforBin(dUdLBin);
                            deltaFL2 = deltaFL * deltaFL;
                            double weight = value / normalize * L2exp * FastMath.exp((double)(-deltaFL2 * invFLs2));
                            double[] dArray = this.hd.zHistogram[lambdaBin];
                            int n = dUdLBin;
                            dArray[n] = dArray[n] + weight;
                        }
                    }
                    ++this.hd.counts;
                } else {
                    this.checkRecursionKernelSize(currentdUdL);
                    int lambdaBin = this.indexForLambda(currentLambda);
                    int dUdLBin = this.binFordUdL(currentdUdL);
                    try {
                        double[] dArray = this.hd.zHistogram[lambdaBin];
                        int n = dUdLBin;
                        dArray[n] = dArray[n] + value;
                        ++this.hd.counts;
                    }
                    catch (IndexOutOfBoundsException e) {
                        logger.info(String.format(" Histogram dimensions %d %d", this.hd.lambdaBins, this.hd.dUdLBins));
                        logger.info(String.format(" Count skipped in addToRecursionKernelValue due to an index out of bounds exception.\n L=%10.8f (%d), dU/dL=%10.8f (%d) and count=%10.8f", currentLambda, lambdaBin, currentdUdL, dUdLBin, value));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void allocateRecursionKernel() {
            Histogram histogram = this;
            synchronized (histogram) {
                this.hd.zHistogram = new double[this.hd.lambdaBins][this.hd.dUdLBins];
                this.kernelValues = new double[this.hd.dUdLBins];
            }
        }

        private double integrateNumeric(double[] dUdLs, Integrate1DNumeric.IntegrationType type) {
            double val;
            if (this.hd.discreteLambda) {
                double[] lams = Integrate1DNumeric.generateXPoints((double)0.0, (double)1.0, (int)this.hd.lambdaBins, (boolean)false);
                DoublesDataSet dSet = new DoublesDataSet(lams, dUdLs, false);
                val = Integrate1DNumeric.integrateData((DataSet)dSet, (Integrate1DNumeric.IntegrationSide)Integrate1DNumeric.IntegrationSide.LEFT, (Integrate1DNumeric.IntegrationType)type);
            } else {
                double[] midLams = Integrate1DNumeric.generateXPoints((double)this.hd.lambdaBinWidth, (double)(1.0 - this.hd.lambdaBinWidth), (int)(this.hd.lambdaBins - 2), (boolean)false);
                double[] midVals = Arrays.copyOfRange(dUdLs, 1, this.hd.lambdaBins - 1);
                DoublesDataSet dSet = new DoublesDataSet(midLams, midVals, false);
                val = Integrate1DNumeric.integrateData((DataSet)dSet, (Integrate1DNumeric.IntegrationSide)Integrate1DNumeric.IntegrationSide.LEFT, (Integrate1DNumeric.IntegrationType)type);
                double dL_4 = this.hd.lambdaBinWidth_2 * 0.5;
                double val0 = 0.0;
                double val1 = 0.0;
                if (!this.this$0.lambdaInterface.dEdLZeroAtEnds()) {
                    double recipSlopeLen = 1.0 / (this.hd.lambdaBinWidth * 0.75);
                    double slope = dUdLs[0] - dUdLs[1];
                    val0 = dUdLs[0] + (slope *= recipSlopeLen) * dL_4;
                    slope = dUdLs[this.hd.lambdaBins - 1] - dUdLs[this.hd.lambdaBins - 2];
                    val1 = dUdLs[this.hd.lambdaBins - 1] + (slope *= recipSlopeLen) * dL_4;
                    logger.fine(String.format(" Inferred dU/dL values at 0 and 1: %10.5g , %10.5g", val0, val1));
                }
                val += this.trapezoid(0.0, dL_4, val0, dUdLs[0]);
                val += this.trapezoid(dL_4, this.hd.lambdaBinWidth, dUdLs[0], dUdLs[1]);
                val += this.trapezoid(1.0 - this.hd.lambdaBinWidth, 1.0 - dL_4, dUdLs[this.hd.lambdaBins - 2], dUdLs[this.hd.lambdaBins - 1]);
                val += this.trapezoid(1.0 - dL_4, 1.0, dUdLs[this.hd.lambdaBins - 1], val1);
            }
            return val;
        }

        private double trapezoid(double x0, double x1, double fx0, double fx1) {
            double val = 0.5 * (fx0 + fx1);
            return val *= x1 - x0;
        }

        private double evaluateKernelForLambda(int lambda, int llFL, int ulFL) {
            double maxKernel = Double.MIN_VALUE;
            double gaussianBiasMagnitude = this.hd.biasMag;
            if (this.hd.biasMag <= 0.0) {
                gaussianBiasMagnitude = 1.0;
            }
            for (int jFL = llFL; jFL <= ulFL; ++jFL) {
                double value;
                this.kernelValues[jFL] = value = this.evaluateKernel(lambda, jFL, gaussianBiasMagnitude);
                if (!(value > maxKernel)) continue;
                maxKernel = value;
            }
            double offset = 0.0;
            if (this.hd.biasMag > 0.0 && !this.hd.metaDynamics) {
                offset = -maxKernel;
                int jFL = llFL;
                while (jFL <= ulFL) {
                    int n = jFL++;
                    this.kernelValues[n] = this.kernelValues[n] + offset;
                }
            }
            return offset;
        }

        private int lambdaMirror(int bin) {
            if (bin < 0) {
                return -bin;
            }
            int lastBin = this.hd.lambdaBins - 1;
            if (bin > lastBin) {
                return lastBin - (bin -= lastBin);
            }
            return bin;
        }

        private double mirrorFactor(int bin) {
            if (this.hd.discreteLambda) {
                return 1.0;
            }
            if (bin == 0 || bin == this.hd.lambdaBins - 1) {
                return 2.0;
            }
            return 1.0;
        }

        private double dUdLforBin(int dUdLBin) {
            return this.hd.dUdLMinimum + (double)dUdLBin * this.hd.dUdLBinWidth + this.hd.dUdLBinWidth_2;
        }

        private double evaluateKernel(int currentLambdaBin, int currentdUdLBin, double gaussianBiasMagnitude) {
            double currentLambda = (double)currentLambdaBin * this.hd.lambdaBinWidth;
            double currentdUdL = this.dUdLforBin(currentdUdLBin);
            double invLs2 = 0.5 / this.hd.lambdaVariance;
            double invFLs2 = 0.5 / this.hd.dUdLVariance;
            double sum = 0.0;
            int lambdaBiasCutoff = this.hd.lambdaBiasCutoff;
            for (int iL = -lambdaBiasCutoff; iL <= lambdaBiasCutoff; ++iL) {
                int lambdaBin = currentLambdaBin + iL;
                double deltaL = currentLambda - (double)lambdaBin * this.hd.lambdaBinWidth;
                double deltaL2 = deltaL * deltaL;
                double L2exp = FastMath.exp((double)(-deltaL2 * invLs2));
                lambdaBin = this.lambdaMirror(lambdaBin);
                double mirrorFactor = this.mirrorFactor(lambdaBin);
                int dUdLbiasCutoff = this.hd.dUdLBiasCutoff;
                for (int jFL = -dUdLbiasCutoff; jFL <= dUdLbiasCutoff; ++jFL) {
                    int dUdLBin = currentdUdLBin + jFL;
                    double weight = mirrorFactor * this.getRecursionKernelValue(lambdaBin, dUdLBin);
                    if (weight <= 0.0) continue;
                    double deltaFL = currentdUdL - this.dUdLforBin(dUdLBin);
                    double deltaFL2 = deltaFL * deltaFL;
                    double e = weight * L2exp * FastMath.exp((double)(-deltaFL2 * invFLs2));
                    sum += e;
                }
            }
            return gaussianBiasMagnitude * sum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        double computeBiasEnergy(double currentLambda, double currentdUdL) {
            Histogram histogram = this;
            synchronized (histogram) {
                double bias1D;
                int currentLambdaBin = this.indexForLambda(currentLambda);
                int currentdUdLBin = this.binFordUdL(currentdUdL);
                double bias2D = 0.0;
                if (!this.hd.metaDynamics) {
                    if (this.hd.biasMag > 0.0) {
                        int lambdaBiasCutoff = this.hd.lambdaBiasCutoff;
                        for (int iL = -lambdaBiasCutoff; iL <= lambdaBiasCutoff; ++iL) {
                            int lambdaBin = currentLambdaBin + iL;
                            double deltaL = currentLambda - (double)lambdaBin * this.hd.lambdaBinWidth;
                            double deltaL2 = deltaL * deltaL;
                            double expL2 = FastMath.exp((double)(-deltaL2 / (2.0 * this.hd.lambdaVariance)));
                            lambdaBin = this.lambdaMirror(lambdaBin);
                            double mirrorFactor = this.mirrorFactor(lambdaBin);
                            int dUdLbiasCutoff = this.hd.dUdLBiasCutoff;
                            for (int iFL = -dUdLbiasCutoff; iFL <= dUdLbiasCutoff; ++iFL) {
                                int dUdLBin = currentdUdLBin + iFL;
                                double weight = mirrorFactor * this.getRecursionKernelValue(lambdaBin, dUdLBin);
                                if (weight <= 0.0) continue;
                                double deltaFL = currentdUdL - this.dUdLforBin(dUdLBin);
                                double deltaFL2 = deltaFL * deltaFL;
                                double bias = weight * this.hd.biasMag * expL2 * FastMath.exp((double)(-deltaFL2 / (2.0 * this.hd.dUdLVariance)));
                                bias2D += bias;
                            }
                        }
                    }
                    bias1D = this.energyAndGradient1D(currentLambda, false);
                } else {
                    bias1D = this.energyAndGradientMeta(currentLambda, false);
                }
                return bias1D + bias2D;
            }
        }

        double energyAndGradient2D(double currentdUdLambda, double[] chainRule) {
            return this.energyAndGradient2D(this.ld.lambda, currentdUdLambda, chainRule, this.hd.biasMag);
        }

        double energyAndGradient2D(double currentLambda, double currentdUdLambda, double[] chainRule, double gaussianBiasMagnitude) {
            if (gaussianBiasMagnitude <= 0.0) {
                chainRule[0] = 0.0;
                chainRule[1] = 0.0;
                return 0.0;
            }
            double gLdEdL = 0.0;
            double dGdLambda = 0.0;
            double dGdFLambda = 0.0;
            int currentLambdaBin = this.indexForLambda(currentLambda);
            int currentdUdLBin = this.binFordUdL(currentdUdLambda);
            int lambdaBiasCutoff = this.hd.lambdaBiasCutoff;
            for (int iL = -lambdaBiasCutoff; iL <= lambdaBiasCutoff; ++iL) {
                int lambdaBin = currentLambdaBin + iL;
                double deltaL = currentLambda - (double)lambdaBin * this.hd.lambdaBinWidth;
                double deltaL2 = deltaL * deltaL;
                double expL2 = FastMath.exp((double)(-deltaL2 / (2.0 * this.hd.lambdaVariance)));
                double mirrorFactor = this.mirrorFactor(lambdaBin);
                int dUdLbiasCutoff = this.hd.dUdLBiasCutoff;
                for (int iFL = -dUdLbiasCutoff; iFL <= dUdLbiasCutoff; ++iFL) {
                    int dUdLBin = currentdUdLBin + iFL;
                    double weight = mirrorFactor * this.getRecursionKernelValue(lambdaBin, dUdLBin);
                    if (weight <= 0.0) continue;
                    double deltaFL = currentdUdLambda - this.dUdLforBin(dUdLBin);
                    double deltaFL2 = deltaFL * deltaFL;
                    double bias = weight * gaussianBiasMagnitude * expL2 * FastMath.exp((double)(-deltaFL2 / (2.0 * this.hd.dUdLVariance)));
                    gLdEdL += bias;
                    dGdLambda -= deltaL / this.hd.lambdaVariance * bias;
                    dGdFLambda -= deltaFL / this.hd.dUdLVariance * bias;
                }
            }
            chainRule[0] = dGdLambda;
            chainRule[1] = dGdFLambda;
            return gLdEdL;
        }

        private double energyAndGradient1D(boolean gradient) {
            return this.energyAndGradient1D(this.ld.lambda, gradient);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double energyAndGradient1D(double currentLambda, boolean gradient) {
            Histogram histogram = this;
            synchronized (histogram) {
                double biasEnergy = 0.0;
                for (int iL0 = 0; iL0 < this.hd.lambdaBins - 1; ++iL0) {
                    int iL1 = iL0 + 1;
                    double L0 = (double)iL0 * this.hd.lambdaBinWidth;
                    double L1 = L0 + this.hd.lambdaBinWidth;
                    double FL0 = this.ensembleAveragedUdL[iL0];
                    double FL1 = this.ensembleAveragedUdL[iL1];
                    double deltaFL = FL1 - FL0;
                    boolean done = false;
                    if (currentLambda <= L1) {
                        done = true;
                        L1 = currentLambda;
                    }
                    biasEnergy += FL0 * L1 + deltaFL * L1 * (0.5 * L1 - L0) / this.hd.lambdaBinWidth;
                    biasEnergy -= FL0 * L0 + deltaFL * L0 * (-0.5 * L0) / this.hd.lambdaBinWidth;
                    if (!done) continue;
                    if (!gradient) break;
                    this.this$0.dUdLambda -= FL0 + (L1 - L0) * deltaFL / this.hd.lambdaBinWidth;
                    break;
                }
                return -biasEnergy;
            }
        }

        private double energyAndGradientMeta(boolean gradient) {
            return this.energyAndGradientMeta(this.ld.lambda, gradient);
        }

        private double energyAndGradientMeta(double currentLambda, boolean gradient) {
            double biasEnergy = 0.0;
            int currentBin = this.indexForLambda(currentLambda);
            int lambdaBiasCutoff = this.hd.lambdaBiasCutoff;
            for (int iL = -lambdaBiasCutoff; iL <= lambdaBiasCutoff; ++iL) {
                int lambdaBin = currentBin + iL;
                double deltaL = currentLambda - (double)lambdaBin * this.hd.lambdaBinWidth;
                double deltaL2 = deltaL * deltaL;
                double mirrorFactor = this.mirrorFactor(lambdaBin = this.lambdaMirror(lambdaBin));
                double weight = mirrorFactor * this.hd.biasMag * this.countsForLambda(lambdaBin);
                if (!(weight > 0.0)) continue;
                double e = weight * FastMath.exp((double)(-deltaL2 / (2.0 * this.hd.lambdaVariance)));
                biasEnergy += e;
                if (!gradient) continue;
                this.this$0.dUdLambda -= deltaL / this.hd.lambdaVariance * e;
            }
            return biasEnergy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double countsForLambda(int lambdaBin) {
            Histogram histogram = this;
            synchronized (histogram) {
                double count = 0.0;
                for (int i = 0; i < this.hd.dUdLBins; ++i) {
                    count += this.hd.zHistogram[lambdaBin][i];
                }
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkRecursionKernelSize(double currentdUdL) {
            Histogram histogram = this;
            synchronized (histogram) {
                double origDeltaG;
                if (currentdUdL > this.hd.dUdLMaximum) {
                    logger.info(String.format(" Current F_lambda %8.2f > maximum histogram size %8.2f.", currentdUdL, this.hd.dUdLMaximum));
                    origDeltaG = this.updateFreeEnergyDifference(false, false);
                    int newdUdLBins = this.hd.dUdLBins;
                    while (this.hd.dUdLMinimum + (double)newdUdLBins * this.hd.dUdLBinWidth < currentdUdL) {
                        newdUdLBins += 100;
                    }
                    double[][] newRecursionKernel = new double[this.hd.lambdaBins][newdUdLBins];
                    for (int i = 0; i < this.hd.lambdaBins; ++i) {
                        System.arraycopy(this.hd.zHistogram[i], 0, newRecursionKernel[i], 0, this.hd.dUdLBins);
                    }
                    this.hd.zHistogram = newRecursionKernel;
                    this.hd.dUdLBins = newdUdLBins;
                    this.kernelValues = new double[this.hd.dUdLBins];
                    this.hd.dUdLMaximum = this.hd.dUdLMinimum + this.hd.dUdLBinWidth * (double)this.hd.dUdLBins;
                    logger.info(String.format(" New histogram %8.2f to %8.2f with %d bins.\n", this.hd.dUdLMinimum, this.hd.dUdLMaximum, this.hd.dUdLBins));
                    double newFreeEnergy = this.updateFreeEnergyDifference(true, false);
                    assert (origDeltaG == newFreeEnergy);
                }
                if (currentdUdL < this.hd.dUdLMinimum) {
                    logger.info(String.format(" Current F_lambda %8.2f < minimum histogram size %8.2f.", currentdUdL, this.hd.dUdLMinimum));
                    origDeltaG = this.updateFreeEnergyDifference(false, false);
                    int offset = 100;
                    while (currentdUdL < this.hd.dUdLMinimum - (double)offset * this.hd.dUdLBinWidth) {
                        offset += 100;
                    }
                    int newdUdLBins = this.hd.dUdLBins + offset;
                    double[][] newRecursionKernel = new double[this.hd.lambdaBins][newdUdLBins];
                    for (int i = 0; i < this.hd.lambdaBins; ++i) {
                        System.arraycopy(this.hd.zHistogram[i], 0, newRecursionKernel[i], offset, this.hd.dUdLBins);
                    }
                    this.hd.zHistogram = newRecursionKernel;
                    this.hd.dUdLMinimum -= (double)offset * this.hd.dUdLBinWidth;
                    this.hd.dUdLBins = newdUdLBins;
                    this.kernelValues = new double[this.hd.dUdLBins];
                    logger.info(String.format(" New histogram %8.2f to %8.2f with %d bins.\n", this.hd.dUdLMinimum, this.hd.dUdLMaximum, this.hd.dUdLBins));
                    double newFreeEnergy = this.updateFreeEnergyDifference(true, false);
                    assert (origDeltaG == newFreeEnergy);
                }
            }
        }

        void addBias(double dUdL) {
            if (this.hd.asynchronous) {
                this.sendAsynchronous.send(this.ld.lambda, dUdL, this.temperingWeight);
            } else {
                this.sendSynchronous.send(this.ld.lambda, dUdL, this.temperingWeight);
            }
        }

        private void stochasticPreForce() {
            double[] thetaPosition = this.lambdaState.x();
            thetaPosition[0] = this.ld.theta;
            this.stochastic.preForce((Potential)this.this$0);
            this.ld.theta = thetaPosition[0];
            if (this.ld.theta > Math.PI) {
                this.ld.theta -= Math.PI * 2;
            } else if (this.ld.theta <= -Math.PI) {
                this.ld.theta += Math.PI * 2;
            }
            double sinTheta = FastMath.sin((double)this.ld.theta);
            this.ld.lambda = sinTheta * sinTheta;
            this.this$0.lambdaInterface.setLambda(this.ld.lambda);
        }

        private void stochasticPostForce() {
            double[] thetaPosition = this.lambdaState.x();
            double[] gradient = this.lambdaState.gradient();
            gradient[0] = this.this$0.dUdLambda * FastMath.sin((double)(2.0 * this.ld.theta));
            thetaPosition[0] = this.ld.theta;
            this.stochastic.postForce(gradient);
            double[] thetaVelocity = this.lambdaState.v();
            double[] thetaAcceleration = this.lambdaState.a();
            this.ld.theta = thetaPosition[0];
            this.ld.thetaVelocity = thetaVelocity[0];
            this.ld.thetaAcceleration = thetaAcceleration[0];
            if (this.ld.theta > Math.PI) {
                this.ld.theta -= Math.PI * 2;
            } else if (this.ld.theta <= -Math.PI) {
                this.ld.theta += Math.PI * 2;
            }
            double sinTheta = FastMath.sin((double)this.ld.theta);
            this.ld.lambda = sinTheta * sinTheta;
            this.this$0.lambdaInterface.setLambda(this.ld.lambda);
        }

        double getLastReceivedLambda() {
            return this.lastReceivedLambda;
        }

        public void setLastReceivedLambda(double lastReceivedLambda) {
            this.lastReceivedLambda = lastReceivedLambda;
        }

        double getLastReceivedDUDL() {
            return this.lastReceiveddUdL;
        }

        void destroy() {
            if (this.sendAsynchronous != null && this.sendAsynchronous.isAlive()) {
                double[] killMessage = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
                DoubleBuf killBuf = DoubleBuf.buffer((double[])killMessage);
                try {
                    logger.fine(" Sending the termination message.");
                    this.world.send(this.rank, (Buf)killBuf);
                    logger.fine(" Termination message was sent successfully.");
                    logger.fine(String.format(" Receive thread alive %b status %s", new Object[]{this.sendAsynchronous.isAlive(), this.sendAsynchronous.getState()}));
                }
                catch (Exception ex) {
                    String message = String.format(" Asynchronous Multiwalker OST termination signal failed to be sent for process %d.", this.rank);
                    logger.log(Level.SEVERE, message, ex);
                }
            } else {
                logger.fine(" CountReceiveThread was either not initialized, or is not alive. This is the case for the Histogram script.");
            }
        }
    }

    public class OptimizationParameters {
        private boolean doOptimization;
        private final boolean doUnitCellReset;
        private final double lambdaCutoff;
        private double optimumEnergy;
        private final int frequency;
        private final double eps;
        private final double tolerance;
        private final double energyWindow;
        private double[] optimumCoords;
        private File optimizationFile;
        private SystemFilter optimizationFilter;
        final /* synthetic */ OrthogonalSpaceTempering this$0;

        OptimizationParameters(OrthogonalSpaceTempering this$0, CompositeConfiguration properties) {
            OrthogonalSpaceTempering orthogonalSpaceTempering = this$0;
            Objects.requireNonNull(orthogonalSpaceTempering);
            this.this$0 = orthogonalSpaceTempering;
            this.doOptimization = false;
            this.optimumEnergy = Double.MAX_VALUE;
            this.energyWindow = properties.getDouble("ost-opt-energy-window", 10.0);
            this.eps = properties.getDouble("ost-opt-eps", 0.1);
            this.tolerance = properties.getDouble("ost-opt-tolerance", 1.0E-8);
            this.frequency = properties.getInt("ost-opt-frequency", 10000);
            this.lambdaCutoff = properties.getDouble("ost-opt-lambda-cutoff", 0.8);
            this.doUnitCellReset = properties.getBoolean("ost-opt-unitcell-reset", false);
        }

        private void log() {
            logger.info("\n Optimization Parameters");
            logger.info(String.format("  Energy Window:                  %6.3f (kcal/mol)", this.energyWindow));
            logger.info(String.format("  EPS:                            %6.4f RMS (kcal/mol/\u00c5)", this.eps));
            logger.info(String.format("  Tolerance:                      %6.4f (kcal/mol)", this.tolerance));
            logger.info(String.format("  Frequency:                      %6d (steps)", this.frequency));
            logger.info(String.format("  Lambda Cutoff:                  %6.4f", this.lambdaCutoff));
            logger.info(String.format("  Unit Cell Reset:                %6B", this.doUnitCellReset));
            logger.info(String.format("  File:                           %s", this.optimizationFile.getName()));
        }

        public double[] getOptimumCoordinates() {
            if (this.optimumEnergy < Double.MAX_VALUE) {
                return this.optimumCoords;
            }
            logger.info("Lambda optimization cutoff was not reached. Try increasing the number of timesteps.");
            return null;
        }

        public double getOptimumEnergy() {
            if (this.optimumEnergy == Double.MAX_VALUE) {
                logger.info("Lambda optimization cutoff was not reached. Try increasing the number of timesteps.");
            }
            return this.optimumEnergy;
        }

        public void optimize(double e, double[] x, @Nullable double[] gradient) {
            double lambda = this.this$0.histogram.ld.lambda;
            long stepsTaken = this.this$0.histogram.ld.stepsTaken;
            if (this.doOptimization && lambda > this.lambdaCutoff && stepsTaken % (long)this.frequency == 0L) {
                if (gradient == null) {
                    gradient = new double[x.length];
                }
            } else {
                return;
            }
            logger.info(String.format("\n OST Minimization (Step %d)", stepsTaken));
            this.this$0.lambdaInterface.setLambda(1.0);
            this.this$0.potential.setEnergyTermState(Potential.STATE.BOTH);
            try {
                double startingEnergy = this.this$0.potential.energy(x);
                Minimize minimize = new Minimize(this.this$0.molecularAssembly, (Potential)this.this$0.potential, this.this$0.algorithmListener);
                minimize.minimize(this.eps);
                double minEnergy = this.this$0.potential.getTotalEnergy();
                if (minEnergy < this.optimumEnergy + this.energyWindow) {
                    if (minEnergy < this.optimumEnergy) {
                        this.optimumEnergy = minEnergy;
                    }
                    int n = this.this$0.potential.getNumberOfVariables();
                    this.optimumCoords = new double[n];
                    this.optimumCoords = this.this$0.potential.getCoordinates(this.optimumCoords);
                    double mass = this.this$0.molecularAssembly.getMass();
                    Crystal crystal = this.this$0.molecularAssembly.getCrystal();
                    double density = crystal.getDensity(mass);
                    this.optimizationFilter.writeFile(this.optimizationFile, true);
                    Crystal uc = crystal.getUnitCell();
                    logger.info(String.format(" Minimum: %12.6f %s (%12.6f g/cc) optimized from %12.6f at step %d.", minEnergy, uc.toShortString(), density, startingEnergy, stepsTaken));
                }
            }
            catch (Exception ex) {
                String message = ex.getMessage();
                logger.info(String.format(" Exception minimizing coordinates at lambda=%8.6f\n %s.", lambda, message));
                logger.info(" Sampling will continue.");
            }
            this.this$0.lambdaInterface.setLambda(lambda);
            this.this$0.potential.setEnergyTermState(this.this$0.state);
            if (this.doUnitCellReset) {
                logger.info("\n Resetting Unit Cell");
                double mass = this.this$0.molecularAssembly.getMass();
                double density = this.this$0.molecularAssembly.getCrystal().getDensity(mass);
                this.this$0.molecularAssembly.applyRandomDensity(density);
                this.this$0.molecularAssembly.applyRandomSymOp(0.0);
                lambda = 0.0;
                this.this$0.lambdaInterface.setLambda(lambda);
            } else {
                double eCheck = this.this$0.potential.energyAndGradient(x, gradient);
                if (FastMath.abs((double)(eCheck - e)) > this.tolerance) {
                    logger.warning(String.format(" Optimization could not revert coordinates %16.8f vs. %16.8f.", e, eCheck));
                }
            }
        }

        public void setOptimization(boolean doOptimization, MolecularAssembly molecularAssembly) {
            this.doOptimization = doOptimization;
            this.this$0.molecularAssembly = molecularAssembly;
            File file = molecularAssembly.getFile();
            String fileName = FilenameUtils.removeExtension((String)file.getAbsolutePath());
            String ext = FilenameUtils.getExtension((String)file.getAbsolutePath());
            if (this.optimizationFilter == null) {
                if (ext.toUpperCase().contains("XYZ")) {
                    this.optimizationFile = new File(fileName + "_opt.arc");
                    this.optimizationFilter = new XYZFilter(this.optimizationFile, molecularAssembly, molecularAssembly.getForceField(), molecularAssembly.getProperties());
                } else {
                    this.optimizationFile = new File(fileName + "_opt.pdb");
                    PDBFilter pdbFilter = new PDBFilter(this.optimizationFile, molecularAssembly, molecularAssembly.getForceField(), molecularAssembly.getProperties());
                    int models = pdbFilter.countNumModels();
                    pdbFilter.setModelNumbering(models);
                    this.optimizationFilter = pdbFilter;
                }
            }
            if (this.doOptimization) {
                this.log();
            }
        }
    }
}

