/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.thermodynamics;

import ffx.utilities.FileUtils;
import ffx.utilities.HistogramXmlAdapter;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessOrder;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorOrder;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.File;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.CompositeConfiguration;

@XmlRootElement(name="HistogramData")
@XmlAccessorOrder(value=XmlAccessOrder.ALPHABETICAL)
@XmlAccessorType(value=XmlAccessType.NONE)
public class HistogramData {
    private static final Logger logger = Logger.getLogger(HistogramData.class.getName());
    private static final double DEFAULT_BIAS_MAG = 0.05;
    private static final int DEFAULT_DUDL_BIAS_CUTOFF = 5;
    private static final int DEFAULT_LAMBDA_BIAS_CUTOFF = 5;
    private static final int DEFAULT_COUNT_INTERVAL = 10;
    private static final double DEFAULT_LAMBDA_BIN_WIDTH = 0.005;
    private static final int DEFAULT_LAMBDA_BINS = 201;
    private static final double DEFAULT_DUDL_BIN_WIDTH = 2.0;
    private static final int DEFAULT_DUDL_BINS = 101;
    private static final double DEFAULT_DUDL_MINIMUM = -101.0;
    private static final boolean DEFAULT_METADYNAMICS = false;
    private static final double DEFAULT_TEMPERING_FACTOR = 2.0;
    private static final double DEFAULT_RESET_HISTOGRAM_AT_LAMBDA = 0.99;
    private static final boolean DEFAULT_RESET_HISTOGRAM = false;
    private final double DEFAULT_BIAS_TO_TEMPERING_OFFSET = 20.0;
    private final boolean DEFAULT_INDEPENDENT_WALKERS = false;
    private final boolean DEFAULT_INDEPENDENT_WRITE = false;
    private static final boolean DEFAULT_DISCRETE_LAMBDA = false;
    @XmlElement(name="BiasMag", defaultValue="0.05")
    double biasMag = 0.05;
    @XmlElement(name="LambdaBiasCutoff", defaultValue="5")
    int lambdaBiasCutoff = 5;
    @XmlElement(name="dUdLBiasCutoff", defaultValue="5")
    int dUdLBiasCutoff = 5;
    @XmlElement(name="CountInterval", defaultValue="10")
    int countInterval = 10;
    @XmlElement(name="LambdaBinWidth", defaultValue="0.005")
    double lambdaBinWidth = 0.005;
    @XmlElement(name="DiscreteLambda", defaultValue="false")
    boolean discreteLambda = false;
    @XmlElement(name="dUdLBinWidth", defaultValue="2.0")
    double dUdLBinWidth = 2.0;
    @XmlElement(name="dUdLMinimum", defaultValue="-101.0")
    double dUdLMinimum = -101.0;
    @XmlElement(name="MetaDynamics", defaultValue="false")
    boolean metaDynamics = false;
    @XmlElement(name="TemperingFactor", defaultValue="2.0")
    double temperingFactor = 2.0;
    @XmlElement(name="TemperingOffset", defaultValue="-1.0")
    private double temperingOffset = -1.0;
    @XmlElement(name="ResetHistogramAtLambda", defaultValue="0.99")
    double resetHistogramAtLambda = 0.99;
    @XmlElement(name="ResetHistogram", defaultValue="false")
    boolean resetHistogram = false;
    @XmlElement(name="IndependentWalkers", defaultValue="false")
    boolean independentWalkers = false;
    @XmlElement(name="IndependentWrite", defaultValue="false")
    boolean independentWrite = false;
    @XmlElement(name="Asynchronous", defaultValue="true")
    boolean asynchronous = true;
    @XmlElement(name="dUdLBins", defaultValue="101")
    public int dUdLBins = 101;
    @XmlElement(name="Counts", defaultValue="0")
    public int counts = 0;
    @XmlElement(name="Data", required=true)
    @XmlJavaTypeAdapter(value=HistogramXmlAdapter.class)
    double[][] zHistogram = new double[201][101];
    private File histogramFile = null;
    private String histogramFileName = null;
    private boolean histogramRead = false;
    public int lambdaBins = 201;
    public double lambdaBinWidth_2 = 0.0025;
    public double minLambda = -0.0025;
    public double[] lambdaLadder = null;
    public double lambdaVariance = Math.pow(0.01, 2.0);
    public double dUdLMaximum = 101.0;
    public double dUdLBinWidth_2 = 1.0;
    public double dUdLVariance = Math.pow(2.0 * this.dUdLBinWidth, 2.0);

    public static void writeHistogram(HistogramData histogramData, File file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{HistogramData.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)histogramData, file);
        }
        catch (Exception e) {
            logger.warning(" Exception writing histogram:\n " + String.valueOf(e));
        }
    }

    public static HistogramData readHistogram(@Nullable File file) {
        if (file != null && file.exists() && file.canRead()) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{HistogramData.class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                HistogramData histogramData = (HistogramData)unmarshaller.unmarshal(file);
                histogramData.setHistogramFile(file);
                histogramData.setHistogramRead(true);
                histogramData.rectify();
                return histogramData;
            }
            catch (Exception e) {
                logger.warning(" Exception reading histogram:\n " + String.valueOf(e));
            }
        }
        HistogramData histogramData = new HistogramData();
        histogramData.setHistogramFile(file);
        histogramData.rectify();
        return histogramData;
    }

    private void rectify() {
        int hisDUDLBins;
        int hisLambdaBins = this.zHistogram.length;
        if (this.lambdaBins != hisLambdaBins) {
            logger.fine(" Current LambdaBins: " + this.lambdaBins);
            logger.fine(" Updated to:         " + hisLambdaBins);
            this.lambdaBins = hisLambdaBins;
            this.lambdaBinWidth = 1.0 / (double)(this.lambdaBins - 1);
        }
        if (this.dUdLBins != (hisDUDLBins = this.zHistogram[0].length)) {
            logger.fine(" Current dUdLBins:   " + this.dUdLBins);
            logger.fine(" Updated to:         " + hisDUDLBins);
            this.dUdLBins = hisDUDLBins;
        }
        this.rectifyLambdaVariables();
        this.rectifyDUDLVariables();
    }

    private void rectifyDUDLVariables() {
        this.dUdLBinWidth_2 = this.dUdLBinWidth / 2.0;
        this.dUdLMaximum = this.dUdLMinimum + (double)this.dUdLBins * this.dUdLBinWidth;
        this.dUdLVariance = Math.pow(2.0 * this.dUdLBinWidth, 2.0);
    }

    private void rectifyLambdaVariables() {
        int n = (int)Math.round(1.0 / this.lambdaBinWidth);
        this.lambdaBinWidth = 1.0 / (double)n;
        this.lambdaBins = n + 1;
        if (this.discreteLambda) {
            this.lambdaLadder = new double[this.lambdaBins];
            this.lambdaLadder[0] = 0.0;
            this.lambdaLadder[this.lambdaBins - 1] = 1.0;
            for (int i = 1; i < this.lambdaBins - 1; ++i) {
                this.lambdaLadder[i] = this.lambdaBinWidth * (double)i;
            }
            this.lambdaBinWidth_2 = 0.0;
            this.minLambda = 0.0;
            this.lambdaBiasCutoff = 0;
        } else {
            this.lambdaLadder = null;
            this.lambdaBinWidth_2 = this.lambdaBinWidth / 2.0;
            this.minLambda = -this.lambdaBinWidth_2;
            if (this.lambdaBiasCutoff == 0) {
                this.lambdaBiasCutoff = 5;
            }
        }
        this.lambdaVariance = Math.pow(2.0 * this.lambdaBinWidth, 2.0);
    }

    public void setCountInterval(int countInterval) {
        this.countInterval = countInterval;
    }

    public void writeHistogram() {
        HistogramData.writeHistogram(this, this.histogramFile);
    }

    public String getHistogramFileName() {
        return this.histogramFileName;
    }

    public File getHistogramFile() {
        return this.histogramFile;
    }

    public void setHistogramFile(@Nullable File histogramFile) {
        this.histogramFile = histogramFile;
        if (histogramFile != null) {
            this.histogramFileName = FileUtils.relativePathTo((File)histogramFile).toString();
        }
    }

    public boolean wasHistogramRead() {
        return this.histogramRead;
    }

    public void setHistogramRead(boolean histogramRead) {
        this.histogramRead = histogramRead;
    }

    public void setIndependentWalkers(boolean independentWalkers) {
        this.independentWalkers = independentWalkers;
        if (independentWalkers) {
            this.setWriteIndependent(true);
        }
    }

    public void setWriteIndependent(boolean independentWrite) throws IllegalArgumentException {
        if (!independentWrite && this.independentWalkers) {
            throw new IllegalArgumentException(" Independent walkers implies independent writing.");
        }
        this.independentWrite = independentWrite;
    }

    public boolean independentWrite() {
        return this.independentWrite;
    }

    public double getBiasMag() {
        return this.biasMag;
    }

    public void setBiasMag(double biasMag) {
        this.biasMag = biasMag;
    }

    public void setTemperingFactor(double temperingFactor) {
        this.temperingFactor = temperingFactor;
    }

    public void setMetaDynamics(boolean metaDynamics) {
        this.metaDynamics = metaDynamics;
    }

    public double getLambdaBinWidth() {
        return this.lambdaBinWidth;
    }

    public int getLambdaBins() {
        return this.lambdaBins;
    }

    public int getDUDLBins() {
        return this.dUdLBins;
    }

    public void setLambdaBinWidth(double lambdaBinWidth) {
        this.lambdaBinWidth = lambdaBinWidth <= 0.0 || lambdaBinWidth > 1.0 ? 0.005 : lambdaBinWidth;
        this.rectifyLambdaVariables();
    }

    public void setdUdLBinWidth(double dUdLBinWidth) {
        double ratio = dUdLBinWidth / this.dUdLBinWidth;
        this.dUdLMinimum *= ratio;
        this.dUdLBinWidth = dUdLBinWidth;
        this.rectifyDUDLVariables();
    }

    public double getTemperingOffset() {
        if (this.temperingOffset >= 0.0) {
            return this.temperingOffset;
        }
        return this.biasMag * 20.0;
    }

    public void setTemperingOffset(double temperingOffset) {
        this.temperingOffset = temperingOffset;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public double resetHistogramAtLambda() {
        return this.resetHistogramAtLambda;
    }

    public void setResetHistogramAtLambda(double resetHistogramAtLambda) {
        if (resetHistogramAtLambda < 0.0 || resetHistogramAtLambda > 1.0) {
            this.resetHistogramAtLambda = 0.99;
            this.resetHistogram = false;
        } else {
            this.resetHistogramAtLambda = resetHistogramAtLambda;
            this.resetHistogram = true;
        }
    }

    public void setDiscreteLambda(boolean discreteLambda) {
        this.discreteLambda = discreteLambda;
        this.rectifyLambdaVariables();
    }

    public void applyProperties(CompositeConfiguration properties) {
        if (properties.containsKey("lambda-bias-cutoff")) {
            this.lambdaBiasCutoff = properties.getInt("lambda-bias-cutoff");
        }
        if (properties.containsKey("dudl-bias-cutoff")) {
            this.dUdLBiasCutoff = properties.getInt("dudl-bias-cutoff");
        }
        if (properties.containsKey("ost-bias-mag")) {
            double bias = properties.getDouble("ost-bias-mag");
            this.setBiasMag(bias);
        }
        if (properties.containsKey("ost-temperOffset")) {
            double offset = properties.getDouble("ost-temperOffset");
            this.setTemperingOffset(offset);
        }
        if (properties.containsKey("lambda-bin-width")) {
            double width = properties.getDouble("lambda-bin-width");
            this.setLambdaBinWidth(width);
        }
        if (properties.containsKey("flambda-bin-width")) {
            double dUdLBinWidth = properties.getDouble("flambda-bin-width");
            this.setdUdLBinWidth(dUdLBinWidth);
        }
        if (properties.containsKey("discrete-lambda")) {
            boolean discreteLambda = properties.getBoolean("discrete-lambda");
            this.setDiscreteLambda(discreteLambda);
        }
    }

    public String toString() {
        return String.format("  Lambda bins:      %6d\n", this.lambdaBins) + String.format("  Lambda bin width: %6.3f\n", this.lambdaBinWidth) + String.format("  dU/dL bins:       %6d\n", this.dUdLBins) + String.format("  dU/dL bin width:  %6.3f (kcal/mol)\n", this.dUdLBinWidth) + String.format("  Bias magnitude:   %6.3f (kcal/mol)\n", this.biasMag) + String.format("  Tempering offset: %6.3f (kcal/mol)\n", this.getTemperingOffset()) + String.format("  Tempering rate:   %6.3f\n", this.temperingFactor) + String.format("  Discrete lambda:  %6B\n", this.discreteLambda) + String.format("  Meta-dynamics:    %6B\n\n", this.metaDynamics);
    }
}

