/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.manybody;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.WorkerIntegerForLoop;
import edu.rit.pj.WorkerRegion;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.algorithms.optimize.manybody.DistanceMatrix;
import ffx.algorithms.optimize.manybody.EliminatedRotamers;
import ffx.algorithms.optimize.manybody.EnergyExpansion;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.Rotamer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class ThreeBodyEnergyRegion
extends WorkerRegion {
    private static final Logger logger = Logger.getLogger(ThreeBodyEnergyRegion.class.getName());
    private final Residue[] residues;
    private final RotamerOptimization rO;
    private final DistanceMatrix dM;
    private final EnergyExpansion eE;
    private final EliminatedRotamers eR;
    private final List<Residue> allResiduesList;
    private final Map<Integer, Integer[]> threeBodyEnergyMap;
    private final BufferedWriter energyWriter;
    private final Comm world;
    private final int numProc;
    private final double superpositionThreshold;
    private final boolean master;
    private final int rank;
    private final boolean verbose;
    private final boolean writeEnergyRestart;
    private final boolean printFiles;
    private Set<Integer> keySet;

    public ThreeBodyEnergyRegion(RotamerOptimization rotamerOptimization, DistanceMatrix dM, EnergyExpansion eE, EliminatedRotamers eR, Residue[] residues, List<Residue> allResiduesList, BufferedWriter energyWriter, Comm world, int numProc, double superpositionThreshold, boolean master, int rank, boolean verbose, boolean writeEnergyRestart, boolean printFiles) {
        this.rO = rotamerOptimization;
        this.dM = dM;
        this.eE = eE;
        this.eR = eR;
        this.residues = residues;
        this.allResiduesList = allResiduesList;
        this.energyWriter = energyWriter;
        this.world = world;
        this.numProc = numProc;
        this.superpositionThreshold = superpositionThreshold;
        this.master = master;
        this.rank = rank;
        this.verbose = verbose;
        this.writeEnergyRestart = writeEnergyRestart;
        this.printFiles = printFiles;
        this.threeBodyEnergyMap = eE.getThreeBodyEnergyMap();
        logger.info(String.format(" Number of 3-Body energies to calculate: %d", this.threeBodyEnergyMap.size()));
    }

    public void finish() {
        if (this.master && this.verbose) {
            for (int i = 0; i < this.residues.length; ++i) {
                Residue resI = this.residues[i];
                Rotamer[] rotI = resI.getRotamers();
                for (int ri = 0; ri < rotI.length; ++ri) {
                    if (this.eR.check(i, ri)) continue;
                    for (int j = i + 1; j < this.residues.length; ++j) {
                        Residue resJ = this.residues[j];
                        Rotamer[] rotJ = resJ.getRotamers();
                        for (int rj = 0; rj < rotJ.length; ++rj) {
                            if (this.eR.check(j, rj) || this.eR.check(i, ri, j, rj)) continue;
                            for (int k = j + 1; k < this.residues.length; ++k) {
                                Residue resK = this.residues[k];
                                Rotamer[] rotK = resK.getRotamers();
                                for (int rk = 0; rk < rotK.length; ++rk) {
                                    if (this.eR.check(k, rk) || this.eR.check(i, ri, k, rk) || this.eR.check(j, rj, k, rk)) continue;
                                    logger.info(String.format(" 3-Body energy %8s %-2d, %8s %-2d, %8s %-2d: %s", resI.toString(rotI[ri]), ri, resJ.toString(rotJ[rj]), rj, resK.toString(rotK[rk]), rk, this.rO.formatEnergy(this.eE.get3Body(this.residues, i, ri, j, rj, k, rk))));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void run() throws Exception {
        if (!this.keySet.isEmpty()) {
            this.execute(0, this.keySet.size() - 1, new ThreeBodyEnergyLoop(this));
        }
    }

    public void start() {
        int numTriple = this.threeBodyEnergyMap.size();
        int remainder = numTriple % this.numProc;
        Integer[] padding = new Integer[]{-1, -1, -1, -1, -1, -1};
        int padKey = numTriple;
        while (remainder != 0) {
            this.threeBodyEnergyMap.put(padKey++, padding);
            remainder = this.threeBodyEnergyMap.size() % this.numProc;
        }
        numTriple = this.threeBodyEnergyMap.size();
        if (numTriple % this.numProc != 0) {
            logger.severe(" Logic error padding triple energies.");
        }
        this.keySet = this.threeBodyEnergyMap.keySet();
    }

    private class ThreeBodyEnergyLoop
    extends WorkerIntegerForLoop {
        final DoubleBuf[] resultBuffer;
        final DoubleBuf myBuffer;
        final /* synthetic */ ThreeBodyEnergyRegion this$0;

        ThreeBodyEnergyLoop(ThreeBodyEnergyRegion threeBodyEnergyRegion) {
            ThreeBodyEnergyRegion threeBodyEnergyRegion2 = threeBodyEnergyRegion;
            Objects.requireNonNull(threeBodyEnergyRegion2);
            this.this$0 = threeBodyEnergyRegion2;
            this.resultBuffer = new DoubleBuf[threeBodyEnergyRegion.numProc];
            for (int i = 0; i < threeBodyEnergyRegion.numProc; ++i) {
                this.resultBuffer[i] = DoubleBuf.buffer((double[])new double[7]);
            }
            this.myBuffer = this.resultBuffer[threeBodyEnergyRegion.rank];
        }

        public void run(int lb, int ub) {
            for (int key = lb; key <= ub; ++key) {
                long time = -System.nanoTime();
                Integer[] job = this.this$0.threeBodyEnergyMap.get(key);
                int i = job[0];
                int ri = job[1];
                int j = job[2];
                int rj = job[3];
                int k = job[4];
                int rk = job[5];
                this.myBuffer.put(0, (double)i);
                this.myBuffer.put(1, (double)ri);
                this.myBuffer.put(2, (double)j);
                this.myBuffer.put(3, (double)rj);
                this.myBuffer.put(4, (double)k);
                this.myBuffer.put(5, (double)rk);
                this.myBuffer.put(6, 0.0);
                if (!(i < 0 || ri < 0 || j < 0 || rj < 0 || k < 0 || rk < 0 || this.this$0.eR.check(i, ri) && this.this$0.eR.check(j, rj) && this.this$0.eR.check(k, rk) && this.this$0.eR.check(i, ri, j, rj) && this.this$0.eR.check(i, ri, k, rk) && this.this$0.eR.check(j, rj, k, rk))) {
                    double threeBodyEnergy;
                    Residue residueI = this.this$0.residues[i];
                    Residue residueJ = this.this$0.residues[j];
                    Residue residueK = this.this$0.residues[k];
                    Rotamer[] rotI = residueI.getRotamers();
                    Rotamer[] rotJ = residueJ.getRotamers();
                    Rotamer[] rotK = residueK.getRotamers();
                    int indexI = this.this$0.allResiduesList.indexOf(residueI);
                    int indexJ = this.this$0.allResiduesList.indexOf(residueJ);
                    int indexK = this.this$0.allResiduesList.indexOf(residueK);
                    double rawDist = this.this$0.dM.getRawNBodyDistance(indexI, ri, indexJ, rj, indexK, rk);
                    double dIJ = this.this$0.dM.checkDistMatrix(indexI, ri, indexJ, rj);
                    double dIK = this.this$0.dM.checkDistMatrix(indexI, ri, indexK, rk);
                    double dJK = this.this$0.dM.checkDistMatrix(indexJ, rj, indexK, rk);
                    double minDist = FastMath.min((double)FastMath.min((double)dIJ, (double)dIK), (double)dJK);
                    double resDist = this.this$0.dM.get3BodyResidueDistance(indexI, ri, indexJ, rj, indexK, rk);
                    String resDistString = "     large";
                    if (resDist < Double.MAX_VALUE) {
                        resDistString = String.format("%5.3f", resDist);
                    }
                    String distString = "     large";
                    if (rawDist < Double.MAX_VALUE) {
                        distString = String.format("%10.3f", rawDist);
                    }
                    if (minDist < this.this$0.superpositionThreshold) {
                        threeBodyEnergy = Double.NaN;
                        logger.info(String.format(" 3-Body %8s %-2d, %8s %-2d, %8s %-2d:\t    NaN      at %13.6f Ang (%s Ang by residue) < %5.3f Ang.", residueI.toString(rotI[ri]), ri, residueJ.toString(rotJ[rj]), rj, residueK.toString(rotK[rk]), rk, minDist, resDistString, this.this$0.superpositionThreshold));
                    } else if (this.this$0.dM.checkTriDistThreshold(indexI, ri, indexJ, rj, indexK, rk)) {
                        threeBodyEnergy = 0.0;
                        logger.fine(String.format(" 3-Body %8s %-2d, %8s %-2d, %8s %-2d: %s at %s Ang (%s Ang by residue) in %6.4f (sec).", residueI.toString(rotI[ri]), ri, residueJ.toString(rotJ[rj]), rj, residueK.toString(rotK[rk]), rk, this.this$0.rO.formatEnergy(threeBodyEnergy), distString, resDistString, (double)(time += System.nanoTime()) * 1.0E-9));
                    } else {
                        try {
                            threeBodyEnergy = this.this$0.eE.compute3BodyEnergy(this.this$0.residues, i, ri, j, rj, k, rk);
                            logger.info(String.format(" 3-Body %8s %-2d, %8s %-2d, %8s %-2d: %s at %s Ang (%s Ang by residue) in %6.4f (sec).", residueI.toString(rotI[ri]), ri, residueJ.toString(rotJ[rj]), rj, residueK.toString(rotK[rk]), rk, this.this$0.rO.formatEnergy(threeBodyEnergy), distString, resDistString, (double)(time += System.nanoTime()) * 1.0E-9));
                        }
                        catch (ArithmeticException ex) {
                            threeBodyEnergy = Double.NaN;
                            logger.info(String.format(" 3-Body %8s %-2d, %8s %-2d, %8s %-2d:\t    NaN      at %s Ang (%s Ang by residue) in %6.4f (sec).", residueI.toString(rotI[ri]), ri, residueJ.toString(rotJ[rj]), rj, residueK.toString(rotK[rk]), rk, distString, resDistString, (double)(time += System.nanoTime()) * 1.0E-9));
                        }
                    }
                    this.myBuffer.put(6, threeBodyEnergy);
                }
                if (this.this$0.numProc > 1) {
                    try {
                        this.this$0.world.allGather((Buf)this.myBuffer, (Buf[])this.resultBuffer);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, " Exception communicating pair energies.", e);
                    }
                }
                for (DoubleBuf doubleBuf : this.resultBuffer) {
                    int resI = (int)doubleBuf.get(0);
                    int rotI = (int)doubleBuf.get(1);
                    int resJ = (int)doubleBuf.get(2);
                    int rotJ = (int)doubleBuf.get(3);
                    int resK = (int)doubleBuf.get(4);
                    int rotK = (int)doubleBuf.get(5);
                    double energy = doubleBuf.get(6);
                    if (resI < 0 || rotI < 0 || resJ < 0 || rotJ < 0 || resK < 0 || rotK < 0) continue;
                    if (!Double.isFinite(energy)) {
                        logger.info(" Rotamer pair eliminated: " + resI + ", " + rotI + ", " + resJ + ", " + rotJ);
                        this.this$0.eR.eliminateRotamerPair(this.this$0.residues, resI, rotI, resJ, rotJ, false);
                    }
                    this.this$0.eE.set3Body(this.this$0.residues, resI, rotI, resJ, rotJ, resK, rotK, energy);
                    if (this.this$0.rank != 0 || !this.this$0.writeEnergyRestart || !this.this$0.printFiles) continue;
                    try {
                        this.this$0.energyWriter.append(String.format("Triple %d %d, %d %d, %d %d: %16.8f", resI, rotI, resJ, rotJ, resK, rotK, energy));
                        this.this$0.energyWriter.newLine();
                        this.this$0.energyWriter.flush();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, " Exception writing energy restart file.", ex);
                    }
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }
    }
}

