/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.manybody;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.MultipleParallelException;
import edu.rit.pj.WorkerIntegerForLoop;
import edu.rit.pj.WorkerRegion;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.algorithms.optimize.manybody.EliminatedRotamers;
import ffx.algorithms.optimize.manybody.EnergyExpansion;
import ffx.potential.Utilities;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.Rotamer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SelfEnergyRegion
extends WorkerRegion {
    private static final Logger logger = Logger.getLogger(SelfEnergyRegion.class.getName());
    private final Residue[] residues;
    private final RotamerOptimization rO;
    private final EnergyExpansion eE;
    private final EliminatedRotamers eR;
    private final Map<Integer, Integer[]> selfEnergyMap;
    private final BufferedWriter energyWriter;
    private final Comm world;
    private final int numProc;
    private final boolean pruneClashes;
    private final boolean master;
    private final int rank;
    private final boolean verbose;
    private final boolean writeEnergyRestart;
    private final boolean printFiles;
    private Set<Integer> keySet;

    public SelfEnergyRegion(RotamerOptimization rO, EnergyExpansion eE, EliminatedRotamers eR, Residue[] residues, BufferedWriter energyWriter, Comm world, int numProc, boolean pruneClashes, boolean master, int rank, boolean verbose, boolean writeEnergyRestart, boolean printFiles) {
        this.rO = rO;
        this.eE = eE;
        this.eR = eR;
        this.residues = residues;
        this.energyWriter = energyWriter;
        this.world = world;
        this.numProc = numProc;
        this.pruneClashes = pruneClashes;
        this.master = master;
        this.rank = rank;
        this.verbose = verbose;
        this.writeEnergyRestart = writeEnergyRestart;
        this.printFiles = printFiles;
        this.selfEnergyMap = eE.getSelfEnergyMap();
        logger.info(String.format("\n Number of self energies: %d", this.selfEnergyMap.size()));
    }

    public void finish() {
        this.eR.prePruneSelves(this.residues);
        if (this.pruneClashes) {
            this.eR.pruneSingleClashes(this.residues);
        }
        if (this.master && this.verbose) {
            for (int i = 0; i < this.residues.length; ++i) {
                Residue residue = this.residues[i];
                Rotamer[] rotamers = residue.getRotamers();
                for (int ri = 0; ri < rotamers.length; ++ri) {
                    logger.info(String.format(" Self energy %8s %-2d: %s", this.residues[i].toString(rotamers[ri]), ri, this.rO.formatEnergy(this.eE.getSelf(i, ri))));
                }
            }
        }
    }

    public void run() throws Exception {
        if (!this.keySet.isEmpty()) {
            try {
                this.execute(0, this.keySet.size() - 1, new SelfEnergyLoop(this));
            }
            catch (MultipleParallelException mpx) {
                Collection subErrors = mpx.getExceptionMap().values();
                logger.info(String.format(" MultipleParallelException caught: %s\n Stack trace:\n%s", new Object[]{mpx, Utilities.stackTraceToString((Throwable)mpx)}));
                for (Throwable subError : subErrors) {
                    logger.info(String.format(" Exception %s\n Stack trace:\n%s", subError, Utilities.stackTraceToString((Throwable)subError)));
                }
                throw mpx;
            }
            catch (Throwable t) {
                Throwable cause = t.getCause();
                logger.info(String.format(" Throwable caught: %s\n Stack trace:\n%s", t, Utilities.stackTraceToString((Throwable)t)));
                if (cause != null) {
                    logger.info(String.format(" Cause: %s\n Stack trace:\n%s", cause, Utilities.stackTraceToString((Throwable)cause)));
                }
                throw t;
            }
        }
    }

    public void start() {
        int numSelf = this.selfEnergyMap.size();
        int remainder = numSelf % this.numProc;
        Integer[] padding = new Integer[]{-1, -1};
        int padKey = numSelf;
        while (remainder != 0) {
            this.selfEnergyMap.put(padKey++, padding);
            remainder = this.selfEnergyMap.size() % this.numProc;
        }
        numSelf = this.selfEnergyMap.size();
        if (numSelf % this.numProc != 0) {
            logger.severe(" Logic error padding self energies.");
        }
        this.keySet = this.selfEnergyMap.keySet();
        double backboneEnergy = 0.0;
        try {
            backboneEnergy = this.rO.computeBackboneEnergy(this.residues);
        }
        catch (ArithmeticException ex) {
            logger.severe(String.format(" Error in calculation of backbone energy %s", ex.getMessage()));
        }
        this.rO.logIfRank0(String.format(" Backbone energy:  %s\n", this.rO.formatEnergy(backboneEnergy)));
        this.eE.setBackboneEnergy(backboneEnergy);
    }

    private class SelfEnergyLoop
    extends WorkerIntegerForLoop {
        final DoubleBuf[] resultBuffer;
        final DoubleBuf myBuffer;
        final /* synthetic */ SelfEnergyRegion this$0;

        SelfEnergyLoop(SelfEnergyRegion selfEnergyRegion) {
            SelfEnergyRegion selfEnergyRegion2 = selfEnergyRegion;
            Objects.requireNonNull(selfEnergyRegion2);
            this.this$0 = selfEnergyRegion2;
            this.resultBuffer = new DoubleBuf[selfEnergyRegion.numProc];
            for (int i = 0; i < selfEnergyRegion.numProc; ++i) {
                this.resultBuffer[i] = DoubleBuf.buffer((double[])new double[3]);
            }
            this.myBuffer = this.resultBuffer[selfEnergyRegion.rank];
        }

        public void run(int lb, int ub) {
            for (int key = lb; key <= ub; ++key) {
                Integer[] job = this.this$0.selfEnergyMap.get(key);
                int i = job[0];
                int ri = job[1];
                this.myBuffer.put(0, (double)i);
                this.myBuffer.put(1, (double)ri);
                this.myBuffer.put(2, 0.0);
                if (i >= 0 && ri >= 0) {
                    if (!this.this$0.eR.check(i, ri)) {
                        double selfEnergy;
                        long time = -System.nanoTime();
                        Rotamer[] rotamers = this.this$0.residues[i].getRotamers();
                        try {
                            selfEnergy = this.this$0.eE.computeSelfEnergy(this.this$0.residues, i, ri);
                            logger.info(String.format(" Self %8s %-2d: %s in %6.4f (sec).", this.this$0.residues[i].toString(rotamers[ri]), ri, this.this$0.rO.formatEnergy(selfEnergy), (double)(time += System.nanoTime()) * 1.0E-9));
                        }
                        catch (ArithmeticException ex) {
                            selfEnergy = Double.NaN;
                            logger.info(String.format(" Self %8s %-2d:\t    pruned in %6.4f (sec).", this.this$0.residues[i].toString(rotamers[ri]), ri, (double)(time += System.nanoTime()) * 1.0E-9));
                        }
                        this.myBuffer.put(2, selfEnergy);
                    }
                } else {
                    this.myBuffer.put(2, 0.0);
                }
                if (this.this$0.numProc > 1) {
                    try {
                        this.this$0.world.allGather((Buf)this.myBuffer, (Buf[])this.resultBuffer);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, " Exception communicating self energies.", e);
                    }
                }
                for (DoubleBuf doubleBuf : this.resultBuffer) {
                    int resI = (int)doubleBuf.get(0);
                    int rotI = (int)doubleBuf.get(1);
                    double energy = doubleBuf.get(2);
                    if (resI < 0 || rotI < 0) continue;
                    if (Double.isNaN(energy)) {
                        logger.info(" Rotamer  eliminated: " + resI + ", " + rotI);
                        this.this$0.eR.eliminateRotamer(this.this$0.residues, resI, rotI, false);
                    }
                    this.this$0.eE.setSelf(resI, rotI, energy);
                    if (this.this$0.rank != 0 || !this.this$0.writeEnergyRestart || !this.this$0.printFiles) continue;
                    try {
                        this.this$0.energyWriter.append(String.format("Self %d %d: %16.8f", resI, rotI, energy));
                        this.this$0.energyWriter.newLine();
                        this.this$0.energyWriter.flush();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, " Exception writing energy restart file.", ex);
                    }
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }
    }
}

