/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.manybody;

import ffx.algorithms.mc.MCMove;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.algorithms.optimize.manybody.EliminatedRotamers;
import ffx.potential.bonded.Residue;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RotamerMatrixMove
implements MCMove {
    private final boolean useAllElims;
    private final int[] currentRots;
    private final List<Integer> allowedRes;
    private final List<List<Integer>> allowedRots;
    private final int nAllowed;
    private final RotamerOptimization rotamerOptimization;
    private final boolean monteCarloTesting;
    private int changedRes;
    private int changedRot;

    public RotamerMatrixMove(boolean useAllElims, int[] rotamers, Residue[] residues, RotamerOptimization rotamerOptimization, EliminatedRotamers eliminatedRotamers, boolean monteCarloTesting) {
        this.useAllElims = useAllElims;
        this.rotamerOptimization = rotamerOptimization;
        this.monteCarloTesting = monteCarloTesting;
        int nRes = rotamers.length;
        this.currentRots = rotamers;
        this.allowedRes = new ArrayList<Integer>(nRes);
        this.allowedRots = new ArrayList<List<Integer>>(nRes);
        for (int i = 0; i < nRes; ++i) {
            ArrayList<Integer> resAllowed = new ArrayList<Integer>();
            int lenRi = residues[i].getRotamers().length;
            for (int ri = 0; ri < lenRi; ++ri) {
                if (eliminatedRotamers.check(i, ri)) continue;
                resAllowed.add(ri);
            }
            if (resAllowed.size() <= 1) continue;
            resAllowed.trimToSize();
            this.allowedRes.add(i);
            this.allowedRots.add(resAllowed);
        }
        ((ArrayList)this.allowedRes).trimToSize();
        this.nAllowed = this.allowedRes.size();
    }

    @Override
    public void move() {
        int indexRI;
        int indexI;
        boolean validMove = !this.useAllElims;
        do {
            Random rand = new Random();
            if (this.monteCarloTesting) {
                rand.setSeed(this.nAllowed);
            }
            int resI = rand.nextInt(this.nAllowed);
            indexI = this.allowedRes.get(resI);
            List<Integer> allowedRotsI = this.allowedRots.get(resI);
            int lenRi = allowedRotsI.size();
            int rotI = rand.nextInt(lenRi);
            indexRI = allowedRotsI.get(rotI);
            if (!this.useAllElims) continue;
            validMove = this.rotamerOptimization.checkValidMove(indexI, indexRI, this.currentRots);
        } while (!validMove);
        this.changedRes = indexI;
        this.changedRot = this.currentRots[indexI];
        this.currentRots[indexI] = indexRI;
    }

    @Override
    public void revertMove() {
        this.currentRots[this.changedRes] = this.changedRot;
    }

    public String toString() {
        return "Rotamer moves utilizing a rotamer energy matrix";
    }
}

