/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.manybody;

import ffx.algorithms.mc.BoltzmannMC;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.potential.bonded.Residue;
import java.util.Arrays;

public class RotamerMatrixMC
extends BoltzmannMC {
    private final int[] currentRots;
    private final int[] oldRots;
    private final int nRes;
    private final Residue[] residues;
    private final RotamerOptimization rotamerOptimization;
    private final boolean useFullAMOEBAEnergy;

    public RotamerMatrixMC(int[] rotamers, Residue[] residues, boolean useFullAMOEBAEnergy, RotamerOptimization rotamerOptimization) {
        this.currentRots = rotamers;
        this.nRes = rotamers.length;
        this.oldRots = new int[this.nRes];
        System.arraycopy(rotamers, 0, this.oldRots, 0, this.nRes);
        this.residues = residues;
        this.useFullAMOEBAEnergy = useFullAMOEBAEnergy;
        this.rotamerOptimization = rotamerOptimization;
    }

    @Override
    public void revertStep() {
        System.arraycopy(this.oldRots, 0, this.currentRots, 0, this.nRes);
    }

    @Override
    protected double currentEnergy() {
        try {
            try {
                return this.useFullAMOEBAEnergy ? this.rotamerOptimization.currentEnergyWrapper(Arrays.asList(this.residues)) : this.rotamerOptimization.computeEnergy(this.residues, this.currentRots, false);
            }
            catch (ArithmeticException ex) {
                return 1.0E100;
            }
        }
        catch (NullPointerException ex) {
            return 1.0E100;
        }
    }

    @Override
    protected void storeState() {
        System.arraycopy(this.currentRots, 0, this.oldRots, 0, this.nRes);
    }
}

