/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.manybody;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.reduction.SharedDouble;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.potential.bonded.Residue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public class GoldsteinPairRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(GoldsteinPairRegion.class.getName());
    private RotamerOptimization rotamerOptimization;
    private Residue[] residues;
    private int i;
    private int riA;
    private int rjC;
    private int j;
    private int riB;
    private int rjD;
    private int[] possK;
    private int nK;
    private final GoldsteinRotamerPairLoop[] goldsteinRotamerPairLoop;
    private final SharedDouble sharedSumOverK = new SharedDouble();
    private ArrayList<Residue> blockedResidues;

    public GoldsteinPairRegion(int nThreads) {
        this.goldsteinRotamerPairLoop = new GoldsteinRotamerPairLoop[nThreads];
    }

    public void finish() {
        for (GoldsteinRotamerPairLoop rotamerPairLoop : this.goldsteinRotamerPairLoop) {
            this.blockedResidues.addAll(rotamerPairLoop.blockedResidues);
        }
    }

    public ArrayList<Residue> getMissedResidues() {
        return this.blockedResidues;
    }

    public double getSumOverK() {
        return this.sharedSumOverK.get();
    }

    public void init(Residue[] residues, int i, int riA, int riB, int j, int rjC, int rjD, int[][] bidiResNeighbors, RotamerOptimization rotamerOptimization) {
        this.residues = residues;
        this.i = i;
        this.riA = riA;
        this.riB = riB;
        this.j = j;
        this.rjC = rjC;
        this.rjD = rjD;
        this.rotamerOptimization = rotamerOptimization;
        int[] nI = bidiResNeighbors[i];
        int[] nJ = bidiResNeighbors[j];
        IntStream kStream = IntStream.concat(Arrays.stream(nI), Arrays.stream(nJ));
        this.possK = kStream.distinct().filter(k -> k != i && k != j).sorted().toArray();
        this.nK = this.possK.length;
    }

    public void run() {
        int threadID = this.getThreadIndex();
        if (this.goldsteinRotamerPairLoop[threadID] == null) {
            this.goldsteinRotamerPairLoop[threadID] = new GoldsteinRotamerPairLoop(this);
        }
        try {
            this.execute(0, this.nK - 1, this.goldsteinRotamerPairLoop[threadID]);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, " Exception in GoldsteinPairRegion.", e);
        }
    }

    public void start() {
        this.sharedSumOverK.set(0.0);
        this.blockedResidues = new ArrayList();
    }

    private class GoldsteinRotamerPairLoop
    extends IntegerForLoop {
        double sumOverK;
        ArrayList<Residue> blockedResidues;
        final /* synthetic */ GoldsteinPairRegion this$0;

        private GoldsteinRotamerPairLoop(GoldsteinPairRegion goldsteinPairRegion) {
            GoldsteinPairRegion goldsteinPairRegion2 = goldsteinPairRegion;
            Objects.requireNonNull(goldsteinPairRegion2);
            this.this$0 = goldsteinPairRegion2;
        }

        public void finish() {
            this.this$0.sharedSumOverK.addAndGet(this.sumOverK);
        }

        public void run(int lb, int ub) {
            if (this.blockedResidues.isEmpty()) {
                double locSumOverK = this.this$0.rotamerOptimization.goldsteinPairSumOverK(this.this$0.residues, lb, ub, this.this$0.i, this.this$0.riA, this.this$0.riB, this.this$0.j, this.this$0.rjC, this.this$0.rjD, this.blockedResidues, this.this$0.possK);
                this.sumOverK = Double.isFinite(locSumOverK) && this.blockedResidues.isEmpty() ? (this.sumOverK += locSumOverK) : 0.0;
            } else {
                this.this$0.rotamerOptimization.logIfRank0(String.format(" Skipping %d to %d because we cannot eliminate", lb, ub), Level.FINE);
            }
        }

        public void start() {
            this.sumOverK = 0.0;
            this.blockedResidues = new ArrayList();
        }
    }
}

