/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.anneal;

import ffx.algorithms.optimize.anneal.AnnealingSchedule;

public class FlatEndAnnealSchedule
implements AnnealingSchedule {
    private final AnnealingSchedule middle;
    private final double tLow;
    private final double tHigh;
    private final double lenBefore;
    private final double lenAfter;
    private final int totWindows;
    private final boolean useBefore;
    private final boolean useAfter;
    private final String description;

    public FlatEndAnnealSchedule(AnnealingSchedule middle, double tLow, double tHigh, double lengthBefore, double lengthAfter) {
        assert (tLow < tHigh);
        assert (tLow >= 0.0);
        assert (Double.isFinite(tHigh));
        assert (lengthBefore >= 0.0);
        assert (lengthAfter >= 0.0);
        this.middle = middle;
        this.tLow = tLow;
        this.tHigh = tHigh;
        this.lenBefore = lengthBefore;
        this.lenAfter = lengthAfter;
        int nWin = middle.getNumWindows();
        boolean bl = this.useBefore = lengthBefore > 0.0;
        if (this.useBefore) {
            ++nWin;
        }
        boolean bl2 = this.useAfter = lengthAfter > 0.0;
        if (this.useAfter) {
            ++nWin;
        }
        this.totWindows = nWin;
        StringBuilder sb = new StringBuilder(String.format("Flat-ended annealing schedule: starts at %10.4g K, ends at %10.4g K.", tHigh, tLow));
        if (this.useBefore) {
            sb.append(String.format("\nMain annealing is preceded by a %9.3f-long window at %10.4g K", this.lenBefore, tHigh));
        }
        if (this.useAfter) {
            sb.append(String.format("\nMain annealing is followed by a %9.3f-long window at %10.4g K", this.lenAfter, tLow));
        }
        sb.append("\nMain annealing schedule: ").append(middle);
        this.description = sb.toString();
    }

    @Override
    public double getHighTemp() {
        return this.tHigh;
    }

    @Override
    public double getLowTemp() {
        return this.tLow;
    }

    @Override
    public int getNumWindows() {
        return this.totWindows;
    }

    @Override
    public double getTemperature(int i) {
        assert (i >= 0 && i < this.totWindows);
        if (i == 0 && this.useBefore) {
            return this.tHigh;
        }
        if (i == this.totWindows - 1 && this.useAfter) {
            return this.tLow;
        }
        i = this.useBefore ? i - 1 : i;
        return this.middle.getTemperature(i);
    }

    @Override
    public double[] getTemperatures() {
        double[] temps = new double[this.totWindows];
        for (int i = 0; i < this.totWindows; ++i) {
            temps[i] = this.getTemperature(i);
        }
        return temps;
    }

    @Override
    public double maxWindowLength() {
        return Math.max(Math.max(this.lenBefore, this.lenAfter), this.middle.maxWindowLength());
    }

    @Override
    public double minWindowLength() {
        double len = this.middle.minWindowLength();
        if (this.useAfter) {
            len = Math.min(len, this.lenAfter);
        }
        if (this.useBefore) {
            len = Math.min(len, this.lenBefore);
        }
        return len;
    }

    public String toString() {
        return this.description;
    }

    @Override
    public double totalWindowLength() {
        return this.lenBefore + this.lenAfter + this.middle.totalWindowLength();
    }

    @Override
    public double windowLength(int window) {
        assert (window >= 0 && window < this.totWindows);
        if (this.useBefore && window == 0) {
            return this.lenBefore;
        }
        if (this.useAfter && window == this.totWindows - 1) {
            return this.lenAfter;
        }
        window = this.useBefore ? window - 1 : window;
        return this.middle.windowLength(window);
    }
}

