/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize;

import edu.rit.pj.Comm;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.WorkerRegion;
import edu.rit.pj.WorkerTeam;
import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.Terminatable;
import ffx.algorithms.mc.MCMove;
import ffx.algorithms.optimize.BoxOptimization;
import ffx.algorithms.optimize.manybody.DistanceMatrix;
import ffx.algorithms.optimize.manybody.EliminatedRotamers;
import ffx.algorithms.optimize.manybody.EnergyExpansion;
import ffx.algorithms.optimize.manybody.EnergyRegion;
import ffx.algorithms.optimize.manybody.FourBodyEnergyRegion;
import ffx.algorithms.optimize.manybody.GoldsteinPairRegion;
import ffx.algorithms.optimize.manybody.RotamerMatrixMC;
import ffx.algorithms.optimize.manybody.RotamerMatrixMove;
import ffx.algorithms.optimize.manybody.SelfEnergyRegion;
import ffx.algorithms.optimize.manybody.ThreeBodyEnergyRegion;
import ffx.algorithms.optimize.manybody.TwoBodyEnergyRegion;
import ffx.numerics.Potential;
import ffx.potential.DualTopologyEnergy;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.QuadTopologyEnergy;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.ResidueState;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.nonbonded.NonbondedCutoff;
import ffx.potential.nonbonded.VanDerWaals;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.TitrationUtils;
import ffx.potential.parsers.PDBFilter;
import ffx.utilities.ObjectPair;
import ffx.utilities.Resources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.ToDoubleFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;

public class RotamerOptimization
implements Terminatable {
    private static final Logger logger = Logger.getLogger(RotamerOptimization.class.getName());
    private static final double FALLBACK_TWO_BODY_CUTOFF = 0.0;
    protected MolecularAssembly molecularAssembly;
    protected final Potential potential;
    protected final AlgorithmListener algorithmListener;
    private final Comm world;
    private final int numProc;
    private final int rank;
    protected final boolean rank0;
    private final boolean print = false;
    private final boolean verboseEnergies = true;
    protected boolean writeEnergyRestart = true;
    BoxOptimization boxOpt;
    private final BiFunction<List<Residue>, List<Rotamer>, File> dirSupplier;
    private final ToDoubleFunction<File> eFunction;
    private final boolean verbose;
    private DistanceMatrix dM;
    private EnergyExpansion eE;
    private EliminatedRotamers eR;
    protected RotamerLibrary library = RotamerLibrary.getDefaultLibrary();
    private GoldsteinPairRegion goldsteinPairRegion;
    private EnergyRegion energyRegion;
    private boolean terminate = false;
    private boolean done = true;
    private double twoBodyCutoffDist;
    private boolean threeBodyTerm = false;
    private double threeBodyCutoffDist;
    private int[][] resNeighbors;
    private int[][] bidiResNeighbors;
    private boolean pruneClashes = true;
    private boolean prunePairClashes = true;
    private int evaluatedPermutations = 0;
    private int evaluatedPermutationsPrint = 0;
    private double temperature = 298.15;
    private double totalBoltzmann = 0.0;
    private double refEnergy = 0.0;
    private double[][] fraction;
    private double[][] populationBoltzmann;
    private double pH;
    private double pHRestraint = 0.0;
    private boolean recomputeSelf = false;
    boolean genZ = false;
    private List<Residue> residueList;
    protected int[] optimum;
    private int windowSize = 7;
    private int increment = 3;
    protected boolean revert;
    protected Direction direction = Direction.FORWARD;
    private double distance = 2.0;
    private DistanceMethod distanceMethod = DistanceMethod.RESIDUE;
    private Algorithm algorithm = null;
    private boolean useGoldstein = true;
    private int ensembleNumber = 1;
    private double ensembleBuffer = 0.0;
    private double ensembleBufferStep = 0.5;
    private double ensembleEnergy = 0.0;
    private File ensembleFile;
    private PDBFilter ensembleFilter;
    private double clashThreshold = 25.0;
    private double multiResClashThreshold = 80.0;
    private double pairClashThreshold = 25.0;
    private double multiResPairClashAddn = 80.0;
    private double[] x = null;
    private boolean useForceFieldEnergy = false;
    private double nucleicCorrectionThreshold = 0.0;
    private double approximateEnergy = 0.0;
    private int minNumberAcceptedNARotamers = 10;
    private double nucleicPruningFactor = 10.0;
    private double nucleicPairsPruningFactor = (1.0 + this.nucleicPruningFactor) / 2.0;
    private List<Residue> allResiduesList = null;
    private Residue[] allResiduesArray = null;
    private int nAllResidues = 0;
    protected int[] optimumSubset;
    protected boolean loadEnergyRestart = false;
    private File energyRestartFile;
    private ParallelTeam parallelTeam;
    private boolean compute4BodyEnergy = false;
    protected boolean usingBoxOptimization = false;
    private double superpositionThreshold = 0.25;
    private boolean decomposeOriginal = false;
    private boolean monteCarlo = false;
    private int nMCSteps = 1000000;
    private boolean mcUseAll = false;
    private boolean mcNoEnum = false;
    protected boolean printFiles = true;
    private List<ObjectPair<ResidueState[], Double>> ensembleStates;
    private int maxRotCheckDepth;
    protected BufferedWriter energyWriter;
    private boolean testing = false;
    private boolean monteCarloTesting = false;
    private boolean testSelfEnergyEliminations = false;
    private int testPairEnergyEliminations = -1;
    private int testTripleEnergyEliminations1 = -1;
    private int testTripleEnergyEliminations2 = -1;
    private boolean selfEliminationOn = true;
    private boolean pairEliminationOn = true;

    public RotamerOptimization(MolecularAssembly molecularAssembly, Potential potential, AlgorithmListener algorithmListener) {
        String superpositionThreshold;
        double value;
        String computeQuads;
        boolean monteCarloTesting;
        ForceFieldEnergy forceFieldEnergy;
        VanDerWaals vdW;
        this.molecularAssembly = molecularAssembly;
        this.potential = potential;
        if (potential instanceof ForceFieldEnergy) {
            ((ForceFieldEnergy)potential).setPrintOnFailure(false, true);
        } else if (potential instanceof DualTopologyEnergy) {
            ((DualTopologyEnergy)potential).setPrintOnFailure(false, true);
        } else if (potential instanceof QuadTopologyEnergy) {
            ((QuadTopologyEnergy)potential).setPrintOnFailure(false, true);
        }
        this.algorithmListener = algorithmListener;
        this.eFunction = this::currentPE;
        this.dirSupplier = (resList, rotList) -> null;
        this.world = Comm.world();
        this.numProc = this.world.size();
        this.rank = this.world.rank();
        this.rank0 = this.rank == 0;
        this.boxOpt = new BoxOptimization(this);
        CompositeConfiguration properties = molecularAssembly.getProperties();
        this.verbose = properties.getBoolean("verbose", false);
        String temp = properties.getString("temperature", "298.15");
        if (temp != null) {
            this.temperature = Double.parseDouble(temp);
            this.logIfRank0(String.format(" Temperature: %10.6f", this.temperature));
        }
        if ((vdW = (forceFieldEnergy = molecularAssembly.getPotentialEnergy()).getVdwNode()) != null) {
            NonbondedCutoff nonBondedCutoff = vdW.getNonbondedCutoff();
            this.twoBodyCutoffDist = nonBondedCutoff.off;
        } else {
            this.twoBodyCutoffDist = 0.0;
        }
        boolean testing = properties.getBoolean("manybody-testing", false);
        if (testing) {
            this.turnRotamerSingleEliminationOff();
            this.turnRotamerPairEliminationOff();
        }
        if (monteCarloTesting = properties.getBoolean("manybody-testing-mc", false)) {
            this.setMonteCarloTesting(true);
        }
        if ((computeQuads = properties.getString("ro-compute4BodyEnergy")) != null) {
            this.compute4BodyEnergy = Boolean.parseBoolean(computeQuads);
            logger.info(String.format(" (KEY) compute4BodyEnergy: %b", this.compute4BodyEnergy));
        }
        String direction = properties.getString("ro-direction");
        String boxDimensions = properties.getString("ro-boxDimensions");
        if (direction != null) {
            this.direction = Direction.valueOf(direction);
            logger.info(String.format(" (KEY) direction: %s", new Object[]{this.direction}));
        }
        if (boxDimensions != null) {
            this.boxOpt.update(boxDimensions);
        }
        String ensembleNumber = properties.getString("ro-ensembleNumber");
        String ensembleEnergy = properties.getString("ro-ensembleEnergy");
        String ensembleBuffer = properties.getString("ro-ensembleBuffer");
        if (ensembleNumber != null) {
            this.ensembleNumber = Integer.parseInt(ensembleNumber);
            this.ensembleBuffer = 5.0;
            this.ensembleBufferStep = 0.1 * this.ensembleBuffer;
            logger.info(String.format(" (KEY) ensembleNumber: %d", this.ensembleNumber));
        }
        if (ensembleBuffer != null) {
            this.ensembleBuffer = Double.parseDouble(ensembleBuffer);
            this.ensembleBufferStep = 0.1 * this.ensembleBuffer;
            logger.info(String.format(" (KEY) ensembleBuffer: %.2f", this.ensembleBuffer));
        }
        if (ensembleEnergy != null) {
            this.ensembleEnergy = Double.parseDouble(ensembleEnergy);
            logger.info(String.format(" (KEY) ensembleEnergy: %.2f", this.ensembleEnergy));
        }
        String nucleicPruningFactor = properties.getString("ro-nucleicPruningFactor");
        String nucleicCorrectionThreshold = properties.getString("ro-nucleicCorrectionThreshold");
        String minimumNumberAcceptedNARotamers = properties.getString("ro-minimumNumberAcceptedNARotamers");
        if (nucleicPruningFactor != null) {
            value = Double.parseDouble(nucleicPruningFactor);
            this.nucleicPruningFactor = value >= 0.0 ? value : 1.0;
            this.nucleicPairsPruningFactor = (1.0 + value) / 2.0;
            logger.info(String.format(" (KEY) nucleicPruningFactor: %.2f", this.nucleicPruningFactor));
        }
        if (nucleicCorrectionThreshold != null) {
            value = Double.parseDouble(nucleicCorrectionThreshold);
            this.nucleicCorrectionThreshold = value >= 0.0 ? value : 0.0;
            logger.info(String.format(" (KEY) nucleicCorrectionThreshold: %.2f", this.nucleicCorrectionThreshold));
        }
        if (minimumNumberAcceptedNARotamers != null) {
            int value2 = Integer.parseInt(minimumNumberAcceptedNARotamers);
            this.minNumberAcceptedNARotamers = value2 > 0 ? value2 : 10;
            logger.info(String.format(" (KEY) minimumNumberAcceptedNARotamers: %d", this.minNumberAcceptedNARotamers));
        }
        if ((superpositionThreshold = properties.getString("ro-superpositionThreshold")) != null) {
            this.superpositionThreshold = Double.parseDouble(superpositionThreshold);
            logger.info(String.format(" (KEY) superpositionThreshold: %.2f", this.superpositionThreshold));
        }
        String multiResClashThreshold = properties.getString("ro-multiResClashThreshold");
        String multiResPairClashAddition = properties.getString("ro-multiResPairClashAddition");
        if (multiResClashThreshold != null) {
            this.multiResClashThreshold = Double.parseDouble(multiResClashThreshold);
            logger.info(String.format(" (KEY) multiResClashThreshold: %.2f", this.multiResClashThreshold));
        }
        if (multiResPairClashAddition != null) {
            this.multiResPairClashAddn = Double.parseDouble(multiResPairClashAddition);
            logger.info(String.format(" (KEY) multiResPairClashAddition: %.2f", this.multiResPairClashAddn));
        }
        String mcUseAll = properties.getString("ro-mcUseAll");
        String mcNoEnum = properties.getString("ro-debug-mcNoEnum");
        if (mcUseAll != null) {
            this.mcUseAll = Boolean.parseBoolean(mcUseAll);
            this.logIfRank0(String.format(" (KEY) mcUseAll: %b", this.mcUseAll));
        }
        if (mcNoEnum != null) {
            this.mcNoEnum = Boolean.parseBoolean(mcNoEnum);
            this.logIfRank0(String.format(" (KEY) debug-mcNoEnum: %b", this.mcNoEnum));
        }
        String propStr = properties.getString("ro-maxRotCheckDepth");
        int defaultMaxRotCheckDepth = 1;
        if (propStr != null) {
            try {
                this.maxRotCheckDepth = Integer.parseInt(propStr);
                if (this.maxRotCheckDepth > 3 || this.maxRotCheckDepth < 0) {
                    throw new IllegalArgumentException(" ro-maxRotCheckDepth must be between 0-3 inclusive!");
                }
            }
            catch (Exception ex) {
                this.maxRotCheckDepth = defaultMaxRotCheckDepth;
                logger.warning(String.format(" Could not parse %s value %s as valid integer; defaulting to %d", "ro-maxRotCheckDepth", propStr, this.maxRotCheckDepth));
                logger.warning(String.format(" Exception: %s", ex));
            }
        } else {
            this.maxRotCheckDepth = defaultMaxRotCheckDepth;
        }
        this.setUpRestart();
    }

    public void setWriteEnergyRestart(boolean writeEnergyRestart) {
        this.writeEnergyRestart = writeEnergyRestart;
    }

    private static void turnOffAtoms(Residue residue) {
        switch (residue.getResidueType()) {
            case NA: 
            case AA: {
                List atomList = residue.getVariableAtoms();
                for (Atom atom : atomList) {
                    atom.setUse(false);
                }
                break;
            }
            default: {
                List atomList = residue.getAtomList();
                for (Atom atom : atomList) {
                    atom.setUse(false);
                }
            }
        }
    }

    private static void turnOnAtoms(Residue residue) {
        switch (residue.getResidueType()) {
            case NA: 
            case AA: {
                List atomList = residue.getVariableAtoms();
                for (Atom atom : atomList) {
                    atom.setUse(true);
                }
                break;
            }
            default: {
                List atomList = residue.getAtomList();
                for (Atom atom : atomList) {
                    atom.setUse(true);
                }
            }
        }
    }

    public boolean checkNeighboringPair(int i, int j) {
        int second;
        int first;
        assert (i != j);
        if (i > j) {
            first = j;
            second = i;
        } else {
            first = i;
            second = j;
        }
        return Arrays.stream(this.resNeighbors[first]).anyMatch(l -> l == second);
    }

    public boolean checkNeighboringTriple(int i, int j, int k) {
        assert (i != j && i != k && j != k);
        int[] vals = new int[]{i, j, k};
        Arrays.sort(vals);
        int first = vals[0];
        int second = vals[1];
        int third = vals[2];
        if (!this.checkNeighboringPair(first, second)) {
            return false;
        }
        return this.checkNeighboringPair(first, third) || this.checkNeighboringPair(second, third);
    }

    public boolean checkValidMove(int i, int ri, int[] currentRots) {
        int nRes = currentRots.length;
        for (int j = 0; j < nRes; ++j) {
            if (j == i || !this.eR.check(j, currentRots[j], i, ri)) continue;
            return false;
        }
        return true;
    }

    public double computeBackboneEnergy(Residue[] residues) throws ArithmeticException {
        Atom[] atoms;
        for (Atom atom : atoms = this.molecularAssembly.getAtomArray()) {
            atom.setUse(true);
        }
        this.turnOffAllResidues(residues);
        return this.currentEnergy(residues);
    }

    public double computeEnergy(Residue[] residues, int[] rotamers, boolean print) {
        double threeBodySum;
        double pairSum;
        double selfSum;
        try {
            if (this.parallelTeam == null) {
                this.parallelTeam = new ParallelTeam();
            }
            if (this.energyRegion == null) {
                this.energyRegion = new EnergyRegion(this.parallelTeam.getThreadCount());
            }
            this.energyRegion.init(this.eE, residues, rotamers, this.threeBodyTerm);
            this.parallelTeam.execute((ParallelRegion)this.energyRegion);
            selfSum = this.energyRegion.getSelf();
            pairSum = this.energyRegion.getTwoBody();
            threeBodySum = this.energyRegion.getThreeBody();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.approximateEnergy = this.eE.getBackboneEnergy() + selfSum + pairSum + threeBodySum;
        if (print) {
            logger.info(String.format(" Backbone                  %s", this.formatEnergy(this.eE.getBackboneEnergy())));
            logger.info(String.format(" Self Energy               %s", this.formatEnergy(selfSum)));
            logger.info(String.format(" Pair Energy               %s", this.formatEnergy(pairSum)));
            if (!this.threeBodyTerm) {
                logger.info(String.format(" Total Energy up to 2-Body %s", this.formatEnergy(this.approximateEnergy)));
            } else {
                logger.info(String.format(" 3-Body Energy             %s", this.formatEnergy(threeBodySum)));
                logger.info(String.format(" Total Energy up to 3-Body %s", this.formatEnergy(this.approximateEnergy)));
            }
        }
        return this.approximateEnergy;
    }

    public double currentEnergy(Residue[] resArray) throws ArithmeticException {
        return this.currentEnergy(Arrays.asList(resArray));
    }

    public double currentEnergyWrapper(List<Residue> resList) throws ArithmeticException {
        return this.currentEnergy(resList);
    }

    public double currentFFXPE() {
        if (this.x == null) {
            int n = this.potential.getNumberOfVariables();
            this.x = new double[n];
        }
        this.potential.getCoordinates(this.x);
        return ((OpenMMEnergy)this.potential).energyFFX(this.x, false);
    }

    public String formatEnergy(double energy) {
        if (FastMath.abs((double)energy) < 1000000.0) {
            return String.format("%16.8f", energy);
        }
        return String.format("*%15.4e", energy);
    }

    public double getApproximate() {
        return this.approximateEnergy;
    }

    public double getBackboneEnergy() {
        return this.eE.getBackboneEnergy();
    }

    public EliminatedRotamers getEliminatedRotamers() {
        return this.eR;
    }

    public EnergyExpansion getEnergyExpansion() {
        return this.eE;
    }

    public List<ResidueState[]> getEnsemble() {
        if (this.ensembleStates == null) {
            return null;
        }
        ArrayList<ResidueState[]> states = new ArrayList<ResidueState[]>(this.ensembleStates.size());
        this.ensembleStates.forEach(es -> states.add((ResidueState[])es.val()));
        return states;
    }

    public void setEnsemble(int ensemble) {
        this.setEnsemble(ensemble, 5.0);
    }

    public List<Residue> getResidues() {
        return this.residueList;
    }

    public void setResidues(List<Residue> residueList) {
        this.residueList = residueList;
    }

    public void initFraction(List<Residue> residueList) {
        this.fraction = new double[residueList.size()][56];
        this.genZ = true;
    }

    public File getRestartFile() {
        return this.energyRestartFile;
    }

    public double goldsteinPairSumOverK(Residue[] residues, int lb, int ub, int i, int riA, int riB, int j, int rjC, int rjD, List<Residue> blockedResidues, int[] possK) {
        double sumOverK = 0.0;
        for (int indK = lb; indK <= ub; ++indK) {
            int k = possK[indK];
            double minForResK = Double.MAX_VALUE;
            Residue resk = residues[k];
            Rotamer[] rotk = resk.getRotamers();
            int nrk = rotk.length;
            int rkEvals = 0;
            for (int rk = 0; rk < nrk; ++rk) {
                if (this.eR.check(k, rk) || this.eR.check(i, riA, k, rk) || this.eR.check(j, rjC, k, rk)) continue;
                if (this.eR.check(i, riB, k, rk) || this.eR.check(j, rjD, k, rk)) {
                    blockedResidues.add(resk);
                    return Double.NaN;
                }
                ++rkEvals;
                double currentResK = this.eE.get2Body(i, riA, k, rk) - this.eE.get2Body(i, riB, k, rk) + this.eE.get2Body(j, rjC, k, rk) - this.eE.get2Body(j, rjD, k, rk);
                if (this.threeBodyTerm) {
                    int[] possL;
                    double sumOverL = this.eE.get3Body(residues, i, riA, j, rjC, k, rk) - this.eE.get3Body(residues, i, riB, j, rjD, k, rk);
                    int[] nK = this.bidiResNeighbors[k];
                    IntStream lStream = IntStream.concat(Arrays.stream(possK), Arrays.stream(nK));
                    for (int l2 : possL = lStream.filter(l -> l != i && l != j && l != k).sorted().distinct().toArray()) {
                        if (l2 == k || l2 == i || l2 == j) continue;
                        Residue residuel = residues[l2];
                        Rotamer[] rotamersl = residuel.getRotamers();
                        int nrl = rotamersl.length;
                        int rlEvaluations = 0;
                        double minForResL = Double.MAX_VALUE;
                        for (int rl = 0; rl < nrl; ++rl) {
                            if (this.eR.check(l2, rl) || this.eR.check(k, rk, l2, rl) || this.eR.check(i, riA, l2, rl) || this.eR.check(j, rjC, l2, rl)) continue;
                            if (this.eR.check(i, riB, l2, rl) || this.eR.check(j, rjD, l2, rl)) {
                                blockedResidues.add(residuel);
                                return Double.NaN;
                            }
                            ++rlEvaluations;
                            double e = this.eE.get3Body(residues, i, riA, k, rk, l2, rl) - this.eE.get3Body(residues, i, riB, k, rk, l2, rl) + this.eE.get3Body(residues, j, rjC, k, rk, l2, rl) - this.eE.get3Body(residues, j, rjD, k, rk, l2, rl);
                            if (!(e < minForResL)) continue;
                            minForResL = e;
                        }
                        if (rlEvaluations == 0) {
                            minForResL = 0.0;
                        }
                        sumOverL += minForResL;
                    }
                    currentResK += sumOverL;
                }
                if (!(currentResK < minForResK)) continue;
                minForResK = currentResK;
            }
            if (rkEvals == 0) {
                minForResK = 0.0;
                blockedResidues.add(resk);
            }
            sumOverK += minForResK;
        }
        return sumOverK;
    }

    public void logIfRank0(String msg) {
        if (this.rank0) {
            logger.info(msg);
        }
    }

    public void logIfRank0(String msg, Level level) {
        if (this.rank0) {
            logger.log(level, msg);
        }
    }

    public double optimize(Algorithm algorithm) {
        this.algorithm = algorithm;
        return this.optimize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double optimize() {
        double e = 0.0;
        try {
            Polymer[] polymers;
            CompositeConfiguration properties = this.molecularAssembly.getProperties();
            boolean ignoreNA = properties.getBoolean("ignoreNA", false);
            if (ignoreNA) {
                logger.info(" Ignoring nucleic acids.");
            }
            logger.info(String.format("\n Rotamer Library:     %s", this.library.getLibrary()));
            logger.info(String.format(" Algorithm:           %s", new Object[]{this.algorithm}));
            logger.info(String.format(" Goldstein Criteria:  %b", this.useGoldstein));
            logger.info(String.format(" Three-Body Energies: %b\n", this.threeBodyTerm));
            this.allResiduesList = new ArrayList<Residue>();
            for (Polymer polymer : polymers = this.molecularAssembly.getChains()) {
                List current = polymer.getResidues();
                for (Residue residuej : current) {
                    residuej.setRotamers(this.library);
                    if (residuej.getRotamers() == null || ignoreNA && residuej.getResidueType() == Residue.ResidueType.NA) continue;
                    this.allResiduesList.add(residuej);
                }
            }
            this.sortResidues(this.allResiduesList);
            this.sortResidues(this.residueList);
            if (ignoreNA) {
                ArrayList<Residue> onlyAA = new ArrayList<Residue>();
                for (Residue res : this.residueList) {
                    if (res.getResidueType() == Residue.ResidueType.NA) continue;
                    onlyAA.add(res);
                }
                this.residueList = onlyAA;
            }
            RotamerLibrary.initializeDefaultAtomicCoordinates((Polymer[])this.molecularAssembly.getChains());
            this.nAllResidues = this.allResiduesList.size();
            this.allResiduesArray = this.allResiduesList.toArray(new Residue[this.nAllResidues]);
            if (this.distance > 0.0) {
                this.dM = new DistanceMatrix(this.molecularAssembly, this.algorithmListener, this.allResiduesArray, this.allResiduesList, this.distanceMethod, this.distance, this.twoBodyCutoffDist, this.threeBodyCutoffDist);
            }
            if (this.residueList != null) {
                this.optimum = new int[this.residueList.size()];
                this.done = false;
                this.terminate = false;
                switch (this.algorithm.ordinal()) {
                    case 0: {
                        e = this.independent(this.residueList);
                        break;
                    }
                    case 2: {
                        e = this.bruteForce(this.residueList);
                        break;
                    }
                    case 1: {
                        e = this.globalOptimization(this.residueList);
                        System.arraycopy(this.optimumSubset, 0, this.optimum, 0, this.residueList.size());
                        break;
                    }
                    case 3: {
                        if (this.genZ) {
                            e = this.slidingWindowCentered(this.residueList);
                            break;
                        }
                        e = this.slidingWindowOptimization(this.residueList, this.windowSize, this.increment, this.revert, this.distance, this.direction, -1);
                        break;
                    }
                    case 4: {
                        e = this.boxOpt.boxOptimization(this.residueList);
                        break;
                    }
                }
                this.terminate = false;
                this.done = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (this.energyWriter != null) {
                    this.energyWriter.close();
                }
            }
            catch (IOException ex) {
                logger.severe(" Exception in closing buffered energy writer.");
            }
        }
        return e;
    }

    public double rotamerOptimization(MolecularAssembly molecularAssembly, Residue[] residues, int i, double lowEnergy, int[] optimum) {
        if (i == 0) {
            this.evaluatedPermutations = 0;
        }
        int nResidues = residues.length;
        Residue current = residues[i];
        Rotamer[] rotamers = current.getRotamers();
        int lenri = rotamers.length;
        double currentEnergy = Double.MAX_VALUE;
        List<Residue> resList = Arrays.asList(residues);
        if (i < nResidues - 1) {
            int minRot = -1;
            for (int ri = 0; ri < lenri; ++ri) {
                RotamerLibrary.applyRotamer((Residue)current, (Rotamer)rotamers[ri]);
                double rotEnergy = this.rotamerOptimization(molecularAssembly, residues, i + 1, lowEnergy, optimum);
                if (rotEnergy < currentEnergy) {
                    currentEnergy = rotEnergy;
                }
                if (!(rotEnergy < lowEnergy)) continue;
                minRot = ri;
                lowEnergy = rotEnergy;
            }
            if (minRot > -1) {
                optimum[i] = minRot;
            }
        } else {
            int[] rotArray = Arrays.copyOf(optimum, nResidues);
            for (int ri = 0; ri < lenri; ++ri) {
                RotamerLibrary.applyRotamer((Residue)current, (Rotamer)rotamers[ri]);
                double rotEnergy = Double.NaN;
                try {
                    rotArray[nResidues - 1] = ri;
                    rotEnergy = this.currentEnergy(resList) + this.eE.getTotalRotamerPhBias(resList, rotArray, this.pH, this.pHRestraint);
                    logger.info(String.format(" %d Energy: %s", ++this.evaluatedPermutations, this.formatEnergy(rotEnergy)));
                }
                catch (ArithmeticException ex) {
                    logger.info(String.format(" %d Energy set to NaN (unreasonable conformation)", ++this.evaluatedPermutations));
                }
                if (this.algorithmListener != null) {
                    this.algorithmListener.algorithmUpdate(molecularAssembly);
                }
                if (rotEnergy < currentEnergy) {
                    currentEnergy = rotEnergy;
                }
                if (!(rotEnergy < lowEnergy)) continue;
                lowEnergy = rotEnergy;
                optimum[nResidues - 1] = ri;
            }
        }
        return currentEnergy;
    }

    public void setPHRestraint(double pHRestraint) {
        this.pHRestraint = pHRestraint;
    }

    public void setpH(double pH) {
        this.pH = pH;
    }

    public void setRecomputeSelf(boolean recomputeSelf) {
        this.recomputeSelf = recomputeSelf;
    }

    public double getPHRestraint() {
        return this.pHRestraint;
    }

    public double getPH() {
        return this.pH;
    }

    public void setApproxBoxLength(double approxBoxLength) {
        this.boxOpt.approxBoxLength = approxBoxLength;
    }

    public void setBoxBorderSize(double boxBorderSize) {
        this.boxOpt.cellBorderSize = boxBorderSize;
    }

    public void setBoxEnd(int boxEnd) {
        this.boxOpt.cellEnd = boxEnd;
    }

    public void setBoxInclusionCriterion(int boxInclusionCriterion) {
        this.boxOpt.boxInclusionCriterion = boxInclusionCriterion;
    }

    public void setBoxStart(int boxStart) {
        this.boxOpt.cellStart = boxStart;
    }

    public void setTitrationBoxes(boolean titrationBoxes) {
        this.boxOpt.titrationBoxes = titrationBoxes;
    }

    public void setTitrationBoxSize(double titrationBoxSize) {
        this.boxOpt.titrationBoxSize = titrationBoxSize;
    }

    public void setCoordinatesToEnsemble(int ensnum) {
        if (this.ensembleStates == null || this.ensembleStates.isEmpty()) {
            throw new IllegalArgumentException(" Ensemble states not initialized!");
        }
        ResidueState.revertAllCoordinates(this.residueList, (ResidueState[])((ResidueState[])this.ensembleStates.get(ensnum %= this.ensembleStates.size()).val()));
    }

    public void setDecomposeOriginal(boolean decomposeOriginal) {
        this.decomposeOriginal = decomposeOriginal;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setDistanceCutoff(double distance) {
        this.distance = distance;
    }

    public void setEnergyRestartFile(File file) {
        this.loadEnergyRestart = true;
        this.energyRestartFile = file;
    }

    public void setEnsemble(int ensemble, double ensembleBuffer) {
        this.ensembleNumber = ensemble;
        this.ensembleBuffer = ensembleBuffer;
        this.ensembleBufferStep = 0.1 * ensembleBuffer;
        if (ensemble > 1) {
            this.setPruning(0);
        }
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public void setMaxRotCheckDepth(int maxRotCheckDepth) {
        this.maxRotCheckDepth = maxRotCheckDepth;
    }

    public void setMinimumNumberAcceptedNARotamers(int minNumberAcceptedNARotamers) {
        if (minNumberAcceptedNARotamers > 0) {
            this.minNumberAcceptedNARotamers = minNumberAcceptedNARotamers;
        } else {
            logger.warning("\n Minimum number of accepted NA rotamers must be a positive integer.\n Setting to default value 10.\n");
            this.minNumberAcceptedNARotamers = 10;
        }
    }

    public void setMonteCarlo(boolean monteCarlo, int nMCsteps) {
        this.monteCarlo = monteCarlo;
        this.nMCSteps = nMCsteps;
    }

    public void setMonteCarloTesting(boolean bool) {
        this.monteCarloTesting = bool;
    }

    public void setNucleicCorrectionThreshold(double nucleicCorrectionThreshold) {
        if (nucleicCorrectionThreshold >= 0.0) {
            this.nucleicCorrectionThreshold = nucleicCorrectionThreshold;
        } else {
            logger.warning("\n Correction threshold must be >= 0. Setting to default of 0 (threshold inactive).\n");
            this.nucleicCorrectionThreshold = 0.0;
        }
    }

    public void setNucleicPruningFactor(double nucleicPruningFactor) {
        this.nucleicPruningFactor = nucleicPruningFactor;
        this.nucleicPairsPruningFactor = (1.0 + nucleicPruningFactor) / 2.0;
    }

    public void setNumXYZBoxes(int[] numXYZBoxes) {
        System.arraycopy(numXYZBoxes, 0, this.boxOpt.numXYZCells, 0, this.boxOpt.numXYZCells.length);
    }

    public void setPairClashThreshold(double pairClashThreshold) {
        this.pairClashThreshold = pairClashThreshold;
    }

    public void setPrintFiles(boolean printFiles) {
        this.printFiles = printFiles;
    }

    public void setPruning(int set) {
        if (set == 0) {
            this.pruneClashes = false;
            this.prunePairClashes = false;
        } else if (set == 1) {
            this.pruneClashes = true;
            this.prunePairClashes = false;
        } else if (set == 2) {
            this.pruneClashes = true;
            this.prunePairClashes = true;
        }
    }

    public void setResiduesIgnoreNull(List<Residue> residues) {
        this.residueList = new ArrayList<Residue>();
        logger.fine(" Optimizing these residues: ");
        for (Residue r : residues) {
            if (r.getRotamers() != null) {
                this.residueList.add(r);
                logger.fine(String.format("\t%s", r));
                continue;
            }
            logger.fine(String.format(" not \t%s", r));
        }
    }

    public void setRevert(boolean revert) {
        this.revert = revert;
    }

    public void setRotamerLibrary(RotamerLibrary lib) {
        this.library = lib;
    }

    public void setSingletonClashThreshold(double singletonClashThreshold) {
        this.clashThreshold = singletonClashThreshold;
    }

    public void setSuperpositionThreshold(double superpositionThreshold) {
        this.superpositionThreshold = superpositionThreshold;
    }

    public void setThreeBodyCutoff(double threeBodyCutoffDist) {
        this.threeBodyCutoffDist = threeBodyCutoffDist;
        if (this.threeBodyCutoffDist < 0.0) {
            logger.info("Warning: threeBodyCutoffDist should not be less than 0.");
        }
    }

    public void setThreeBodyEnergy(boolean threeBodyTerm) {
        this.threeBodyTerm = threeBodyTerm;
    }

    public void setTwoBodyCutoff(double twoBodyCutoffDist) {
        this.twoBodyCutoffDist = twoBodyCutoffDist;
        if (this.twoBodyCutoffDist < 0.0) {
            logger.info("Warning: threeBodyCutoffDist should not be less than 0.");
        }
    }

    public void setUseGoldstein(boolean useGoldstein) {
        this.useGoldstein = useGoldstein;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
        if (this.increment > windowSize) {
            logger.info(String.format(" Decreasing increment to match window size %d", windowSize));
            this.increment = windowSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        this.terminate = true;
        while (!this.done) {
            RotamerOptimization rotamerOptimization = this;
            synchronized (rotamerOptimization) {
                try {
                    this.wait(1L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, " Exception terminating rotamer optimization.\n", e);
                }
            }
        }
    }

    public String toString() {
        if (this.eR != null) {
            return this.eR.toString();
        }
        return null;
    }

    public void turnOffAllResidues(Residue[] residues) {
        if (residues == null) {
            return;
        }
        for (Residue residue : residues) {
            this.turnOffResidue(residue);
        }
    }

    public void turnOffResidue(Residue residue) {
        RotamerOptimization.turnOffAtoms(residue);
        this.applyDefaultRotamer(residue);
    }

    public void turnOnAllResidues(Residue[] residues) {
        if (residues == null) {
            return;
        }
        for (Residue residue : residues) {
            RotamerOptimization.turnOnAtoms(residue);
        }
    }

    public void turnOnResidue(Residue residue, int ri) {
        RotamerOptimization.turnOnAtoms(residue);
        Rotamer[] rotamers = residue.getRotamers();
        RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamers[ri]);
    }

    public void turnRotamerPairEliminationOff() {
        logger.info(" Turning off pair eliminations.");
        this.pairEliminationOn = false;
    }

    public void turnRotamerSingleEliminationOff() {
        logger.info(" Turning off single eliminations.");
        this.selfEliminationOn = false;
    }

    private double decomposedRotamerOptimization(Residue[] residues, int i, double lowEnergy, int[] optimum, int[] currentRotamers) {
        if (i == 0) {
            this.evaluatedPermutations = 0;
        }
        int nResidues = residues.length;
        Residue current = residues[i];
        Rotamer[] rotamers = current.getRotamers();
        int lenri = rotamers.length;
        double currentEnergy = Double.MAX_VALUE;
        if (i < nResidues - 1) {
            for (int ri = 0; ri < lenri; ++ri) {
                if (this.eR.check(i, ri)) continue;
                currentRotamers[i] = ri;
                double rotEnergy = this.decomposedRotamerOptimization(residues, i + 1, lowEnergy, optimum, currentRotamers);
                if (rotEnergy < lowEnergy) {
                    lowEnergy = rotEnergy;
                }
                if (!(rotEnergy < currentEnergy)) continue;
                currentEnergy = rotEnergy;
            }
        } else {
            for (int ri = 0; ri < lenri; ++ri) {
                if (this.eR.check(i, ri)) continue;
                currentRotamers[i] = ri;
                double rotEnergy = this.computeEnergy(residues, currentRotamers, false);
                ++this.evaluatedPermutations;
                if (rotEnergy < currentEnergy) {
                    currentEnergy = rotEnergy;
                }
                if (!(rotEnergy < lowEnergy)) continue;
                System.arraycopy(currentRotamers, 0, optimum, 0, optimum.length);
                if (this.evaluatedPermutations > 1) {
                    logger.info(String.format(" Minimum energy update: %f < %f, permutation %d", rotEnergy, lowEnergy, this.evaluatedPermutations));
                    Object permutation = " Rotamer permutation: " + optimum[0];
                    for (int j = 1; j < nResidues; ++j) {
                        permutation = ((String)permutation).concat(", " + optimum[j]);
                    }
                    logger.info((String)permutation);
                } else {
                    logger.info(String.format(" First minimum energy (permutation 1): %f", rotEnergy));
                }
                lowEnergy = rotEnergy;
            }
        }
        return currentEnergy;
    }

    private double rotamerOptimizationMC(Residue[] residues, int[] optimum, int[] initialRots, int maxIters, boolean randomizeRots, boolean useAllElims) {
        double initialEnergy;
        long initTime = -System.nanoTime();
        if (randomizeRots) {
            this.randomizeRotamers(initialRots, residues, true);
        }
        int nRes = residues.length;
        System.arraycopy(initialRots, 0, optimum, 0, nRes);
        assert (optimum.length == nRes);
        assert (initialRots.length == nRes);
        RotamerMatrixMC rmc = new RotamerMatrixMC(initialRots, residues, this.useForceFieldEnergy, this);
        rmc.setTemperature(this.temperature);
        RotamerMatrixMove rmove = new RotamerMatrixMove(useAllElims, initialRots, residues, this, this.eR, this.monteCarloTesting);
        ArrayList<MCMove> rmList = new ArrayList<MCMove>(1);
        rmList.add(rmove);
        double optimumEnergy = initialEnergy = this.computeEnergy(residues, initialRots, false);
        double currentEnergy = initialEnergy;
        int nAccept = 0;
        this.logIfRank0(String.format(" Beginning %d iterations of Monte Carlo search starting from energy %10.6f", maxIters, initialEnergy));
        for (int i = 0; i < maxIters; ++i) {
            if (rmc.mcStep(rmList, currentEnergy)) {
                currentEnergy = rmc.lastEnergy();
                ++nAccept;
                if (!(currentEnergy < optimumEnergy)) continue;
                optimumEnergy = currentEnergy;
                System.arraycopy(initialRots, 0, optimum, 0, nRes);
                continue;
            }
            currentEnergy = rmc.lastEnergy();
        }
        double fractAccept = (double)nAccept / (double)maxIters;
        this.logIfRank0(String.format(" %d steps of DEE-MC completed in %10.6f seconds", maxIters, (double)(initTime += System.nanoTime()) * 1.0E-9));
        this.logIfRank0(String.format(" Number of steps accepted: %d for %10.6f of total", nAccept, fractAccept));
        this.logIfRank0(String.format(" Lowest energy found: %10.6f kcal/mol", optimumEnergy));
        this.logIfRank0(String.format(" Final energy found: %10.6f kcal/mol", currentEnergy));
        return optimumEnergy;
    }

    private void randomizeRotamers(int[] rotamers, Residue[] residues, boolean useAllElims) {
        int nRes = rotamers.length;
        for (int i = 0; i < nRes; ++i) {
            int indexRI;
            Rotamer[] rotsi = residues[i].getRotamers();
            int lenri = rotsi.length;
            ArrayList<Integer> allowedRots = new ArrayList<Integer>(lenri);
            for (int ri = 0; ri < lenri; ++ri) {
                if (this.eR.check(i, ri)) continue;
                allowedRots.add(ri);
            }
            Random rand = new Random();
            int nRots = allowedRots.size();
            if (this.monteCarloTesting) {
                rand.setSeed(nRots);
            }
            if (nRots <= 1) continue;
            boolean validMove = !useAllElims;
            do {
                int ri = rand.nextInt(nRots);
                indexRI = (Integer)allowedRots.get(ri);
                if (!useAllElims) continue;
                validMove = this.checkValidMove(i, indexRI, rotamers);
            } while (!validMove);
            rotamers[i] = indexRI;
        }
    }

    private double rotamerOptimizationDEE(MolecularAssembly molecularAssembly, Residue[] residues, int i, int[] currentRotamers, double lowEnergy, int[] optimum, double[] permutationEnergies) {
        if (i == 0) {
            this.evaluatedPermutations = 0;
        }
        int nResidues = residues.length;
        Residue residuei = residues[i];
        Rotamer[] rotamersi = residuei.getRotamers();
        int lenri = rotamersi.length;
        double currentEnergy = Double.MAX_VALUE;
        List<Residue> resList = Arrays.asList(residues);
        if (i < nResidues - 1) {
            for (int ri = 0; ri < lenri; ++ri) {
                int rj;
                if (this.eR.check(i, ri)) continue;
                boolean deadEnd = false;
                for (int j = 0; j < i && !(deadEnd = this.eR.check(j, rj = currentRotamers[j], i, ri)); ++j) {
                }
                if (deadEnd) continue;
                RotamerLibrary.applyRotamer((Residue)residuei, (Rotamer)rotamersi[ri]);
                currentRotamers[i] = ri;
                double rotEnergy = this.rotamerOptimizationDEE(molecularAssembly, residues, i + 1, currentRotamers, lowEnergy, optimum, permutationEnergies);
                if (rotEnergy < currentEnergy) {
                    currentEnergy = rotEnergy;
                }
                if (!(rotEnergy < lowEnergy)) continue;
                optimum[i] = ri;
                lowEnergy = rotEnergy;
            }
        } else {
            if (this.ensembleStates == null) {
                this.ensembleStates = new ArrayList<ObjectPair<ResidueState[], Double>>();
            }
            for (int ri = 0; ri < lenri; ++ri) {
                int rj;
                if (this.eR.check(i, ri)) continue;
                currentRotamers[i] = ri;
                boolean deadEnd = false;
                for (int j = 0; j < i && !(deadEnd = this.eR.check(j, rj = currentRotamers[j], i, ri)); ++j) {
                }
                if (deadEnd) continue;
                RotamerLibrary.applyRotamer((Residue)residuei, (Rotamer)rotamersi[ri]);
                double comparisonEnergy = this.approximateEnergy = this.computeEnergy(residues, currentRotamers, false);
                ++this.evaluatedPermutations;
                if (this.useForceFieldEnergy) {
                    double amoebaEnergy = Double.NaN;
                    try {
                        amoebaEnergy = this.currentEnergy(resList) + this.eE.getTotalRotamerPhBias(resList, currentRotamers, this.pH, this.pHRestraint);
                    }
                    catch (ArithmeticException ex) {
                        logger.warning(String.format(" Exception %s in calculating full AMOEBA energy for permutation %d", ex, this.evaluatedPermutations));
                    }
                    comparisonEnergy = amoebaEnergy;
                }
                if (permutationEnergies != null) {
                    permutationEnergies[this.evaluatedPermutations - 1] = comparisonEnergy;
                }
                if (this.algorithmListener != null) {
                    this.algorithmListener.algorithmUpdate(molecularAssembly);
                }
                if (this.ensembleNumber > 1) {
                    if (this.rank0 && this.printFiles) {
                        try {
                            int j;
                            FileWriter fw = new FileWriter(this.ensembleFile, true);
                            BufferedWriter bw = new BufferedWriter(fw);
                            bw.write(String.format("MODEL        %d", this.evaluatedPermutations));
                            for (j = 0; j < 75; ++j) {
                                bw.write(" ");
                            }
                            bw.newLine();
                            bw.flush();
                            this.ensembleFilter.writeFile(this.ensembleFile, true);
                            bw.write("ENDMDL");
                            for (j = 0; j < 64; ++j) {
                                bw.write(" ");
                            }
                            bw.newLine();
                            bw.close();
                        }
                        catch (IOException e) {
                            logger.warning(String.format("Exception writing to file: %s", this.ensembleFile.getName()));
                        }
                    }
                    ResidueState[] states = ResidueState.storeAllCoordinates((Residue[])residues);
                    this.ensembleStates.add((ObjectPair<ResidueState[], Double>)new ObjectPair((Object)states, (Comparable)Double.valueOf(comparisonEnergy)));
                }
                if (comparisonEnergy < currentEnergy) {
                    currentEnergy = comparisonEnergy;
                }
                if (comparisonEnergy < lowEnergy) {
                    lowEnergy = comparisonEnergy;
                    optimum[i] = ri;
                }
                if (this.useForceFieldEnergy) {
                    this.logIfRank0(String.format(" %6e AMOEBA: %12.4f 3-Body: %12.4f Neglected: %12.4f (%12.4f)", this.evaluatedPermutations, comparisonEnergy, this.approximateEnergy, comparisonEnergy - this.approximateEnergy, lowEnergy));
                    continue;
                }
                this.logIfRank0(String.format(" %12s %25f %25f", this.evaluatedPermutations, this.approximateEnergy, lowEnergy));
            }
            this.ensembleStates.sort(null);
        }
        return currentEnergy;
    }

    private double dryRun(Residue[] residues, int i, int[] currentRotamers) {
        if (i == 0) {
            this.evaluatedPermutations = 0;
            this.evaluatedPermutationsPrint = 1000;
        }
        if (this.evaluatedPermutations >= this.evaluatedPermutationsPrint && this.evaluatedPermutations % this.evaluatedPermutationsPrint == 0) {
            this.logIfRank0(String.format(" The permutations have reached %10.4e.", this.evaluatedPermutationsPrint));
            this.evaluatedPermutationsPrint *= 10;
        }
        int nResidues = residues.length;
        Residue residuei = residues[i];
        Rotamer[] rotamersi = residuei.getRotamers();
        int lenri = rotamersi.length;
        if (i < nResidues - 1) {
            for (int ri = 0; ri < lenri; ++ri) {
                int rj;
                if (this.eR.check(i, ri)) continue;
                boolean deadEnd = false;
                for (int j = 0; j < i && !(deadEnd = this.eR.check(j, rj = currentRotamers[j], i, ri)); ++j) {
                }
                if (deadEnd) continue;
                currentRotamers[i] = ri;
                this.dryRun(residues, i + 1, currentRotamers);
            }
        } else {
            for (int ri = 0; ri < lenri; ++ri) {
                int rj;
                if (this.eR.check(i, ri)) continue;
                currentRotamers[i] = ri;
                boolean deadEnd = false;
                for (int j = 0; j < i && !(deadEnd = this.eR.check(j, rj = currentRotamers[j], i, ri)); ++j) {
                }
                if (deadEnd) continue;
                ++this.evaluatedPermutations;
            }
        }
        return 0.0;
    }

    private double dryRunForEnsemble(Residue[] residues, int i, int[] currentRotamers, double gmecEnergy, double[] permutationEnergies, int[][] permutations) {
        if (i == 0) {
            this.evaluatedPermutations = 0;
        }
        int nResidues = residues.length;
        Residue residuei = residues[i];
        Rotamer[] rotamersi = residuei.getRotamers();
        int lenri = rotamersi.length;
        if (i < nResidues - 1) {
            for (int ri = 0; ri < lenri; ++ri) {
                int rj;
                if (this.eR.check(i, ri)) continue;
                boolean deadEnd = false;
                for (int j = 0; j < i && !(deadEnd = this.eR.check(j, rj = currentRotamers[j], i, ri)); ++j) {
                }
                if (deadEnd) continue;
                currentRotamers[i] = ri;
                this.dryRunForEnsemble(residues, i + 1, currentRotamers, gmecEnergy, permutationEnergies, permutations);
            }
        } else {
            for (int ri = 0; ri < lenri; ++ri) {
                int rj;
                if (this.eR.check(i, ri)) continue;
                currentRotamers[i] = ri;
                boolean deadEnd = false;
                for (int j = 0; j < i && !(deadEnd = this.eR.check(j, rj = currentRotamers[j], i, ri)); ++j) {
                }
                if (deadEnd) continue;
                if (permutationEnergies[this.evaluatedPermutations] - gmecEnergy < this.ensembleEnergy) {
                    permutations[this.evaluatedPermutations] = new int[nResidues];
                    System.arraycopy(currentRotamers, 0, permutations[this.evaluatedPermutations], 0, nResidues);
                }
                ++this.evaluatedPermutations;
            }
        }
        return 0.0;
    }

    public void partitionFunction(Residue[] residues, int i, int[] currentRotamers) throws Exception {
        double LOG10 = FastMath.log((double)10.0);
        double beta = 1.0 / (0.831446261815324 * this.temperature);
        if (i == 0) {
            this.totalBoltzmann = 0.0;
            this.evaluatedPermutations = 0;
            this.evaluatedPermutationsPrint = 1000;
        }
        if (this.evaluatedPermutations >= this.evaluatedPermutationsPrint && this.evaluatedPermutations % this.evaluatedPermutationsPrint == 0) {
            this.logIfRank0(String.format(" The permutations have reached %10.4e.", this.evaluatedPermutationsPrint));
            this.evaluatedPermutationsPrint *= 10;
        }
        int nResidues = residues.length;
        Residue residuei = residues[i];
        Rotamer[] rotamersi = residuei.getRotamers();
        int lenri = rotamersi.length;
        if (i < nResidues - 1) {
            for (int ri = 0; ri < lenri; ++ri) {
                int rj;
                if (this.eR.check(i, ri)) continue;
                boolean deadEnd = false;
                for (int j = 0; j < i && !(deadEnd = this.eR.check(j, rj = currentRotamers[j], i, ri)); ++j) {
                }
                if (deadEnd) continue;
                currentRotamers[i] = ri;
                this.partitionFunction(residues, i + 1, currentRotamers);
            }
        } else {
            for (int ri = 0; ri < lenri; ++ri) {
                int rj;
                if (this.eR.check(i, ri)) continue;
                currentRotamers[i] = ri;
                boolean deadEnd = false;
                for (int j = 0; j < i && !(deadEnd = this.eR.check(j, rj = currentRotamers[j], i, ri)); ++j) {
                }
                if (deadEnd) continue;
                ++this.evaluatedPermutations;
                this.energyRegion.init(this.eE, residues, currentRotamers, this.threeBodyTerm);
                this.parallelTeam.execute((ParallelRegion)this.energyRegion);
                double selfEnergy = this.energyRegion.getSelf();
                if (this.recomputeSelf) {
                    int count = 0;
                    for (Residue residue : residues) {
                        double bias7 = 0.0;
                        double biasCurrent = 0.0;
                        Rotamer[] rotamers = residue.getRotamers();
                        int currentRotamer = currentRotamers[count];
                        switch (rotamers[currentRotamer].getName()) {
                            case "HIE": {
                                bias7 = LOG10 * 0.0019872042586408316 * this.temperature * (TitrationUtils.Titration.HIStoHIE.pKa - 7.0) - TitrationUtils.Titration.HIStoHIE.freeEnergyDiff;
                                biasCurrent = LOG10 * 0.0019872042586408316 * this.temperature * (TitrationUtils.Titration.HIStoHIE.pKa - this.pH) - TitrationUtils.Titration.HIStoHIE.freeEnergyDiff;
                                break;
                            }
                            case "HID": {
                                bias7 = LOG10 * 0.0019872042586408316 * this.temperature * (TitrationUtils.Titration.HIStoHID.pKa - 7.0) - TitrationUtils.Titration.HIStoHID.freeEnergyDiff;
                                biasCurrent = LOG10 * 0.0019872042586408316 * this.temperature * (TitrationUtils.Titration.HIStoHID.pKa - this.pH) - TitrationUtils.Titration.HIStoHID.freeEnergyDiff;
                                break;
                            }
                            case "ASP": {
                                bias7 = LOG10 * 0.0019872042586408316 * this.temperature * (TitrationUtils.Titration.ASHtoASP.pKa - 7.0) - TitrationUtils.Titration.ASHtoASP.freeEnergyDiff;
                                biasCurrent = LOG10 * 0.0019872042586408316 * this.temperature * (TitrationUtils.Titration.ASHtoASP.pKa - this.pH) - TitrationUtils.Titration.ASHtoASP.freeEnergyDiff;
                                break;
                            }
                            case "GLU": {
                                bias7 = LOG10 * 0.0019872042586408316 * this.temperature * (TitrationUtils.Titration.GLHtoGLU.pKa - 7.0) - TitrationUtils.Titration.GLHtoGLU.freeEnergyDiff;
                                biasCurrent = LOG10 * 0.0019872042586408316 * this.temperature * (TitrationUtils.Titration.GLHtoGLU.pKa - this.pH) - TitrationUtils.Titration.GLHtoGLU.freeEnergyDiff;
                                break;
                            }
                            case "LYD": {
                                bias7 = LOG10 * 0.0019872042586408316 * this.temperature * (TitrationUtils.Titration.LYStoLYD.pKa - 7.0) - TitrationUtils.Titration.LYStoLYD.freeEnergyDiff;
                                biasCurrent = LOG10 * 0.0019872042586408316 * this.temperature * (TitrationUtils.Titration.LYStoLYD.pKa - this.pH) - TitrationUtils.Titration.LYStoLYD.freeEnergyDiff;
                                break;
                            }
                        }
                        selfEnergy = selfEnergy - bias7 + biasCurrent;
                        ++count;
                    }
                }
                double totalEnergy = this.eE.getBackboneEnergy() + selfEnergy + this.energyRegion.getTwoBody() + this.energyRegion.getThreeBody();
                if (this.evaluatedPermutations == 1) {
                    this.refEnergy = totalEnergy;
                }
                double boltzmannWeight = FastMath.exp((double)(-beta * (totalEnergy - this.refEnergy)));
                for (int res = 0; res < residues.length; ++res) {
                    int currentRotamer = currentRotamers[res];
                    double[] dArray = this.populationBoltzmann[res];
                    int n = currentRotamer;
                    dArray[n] = dArray[n] + boltzmannWeight;
                }
                this.totalBoltzmann += boltzmannWeight;
            }
        }
    }

    public double getRefEnergy() {
        return this.refEnergy;
    }

    public double getTotalBoltzmann() {
        return this.totalBoltzmann;
    }

    public double[][] getFraction() {
        return this.fraction;
    }

    public double[][] getPopulationBoltzmann() {
        return this.populationBoltzmann;
    }

    public void getFractions(Residue[] residues, int i, int[] currentRotamers) throws Exception {
        this.populationBoltzmann = new double[residues.length][56];
        if (!this.usingBoxOptimization) {
            this.partitionFunction(residues, i, currentRotamers);
            this.optimum = new int[residues.length];
            for (int m = 0; m < this.fraction.length; ++m) {
                for (int n = 0; n < 56; ++n) {
                    this.fraction[m][n] = this.populationBoltzmann[m][n] / this.totalBoltzmann;
                    if (n > 0 && this.fraction[m][n] > this.fraction[m][n - 1]) {
                        this.optimum[m] = n;
                        continue;
                    }
                    if (n != 0) continue;
                    this.optimum[m] = n;
                }
                Rotamer highestPopRot = residues[m].getRotamers()[this.optimum[m]];
                RotamerLibrary.applyRotamer((Residue)residues[m], (Rotamer)highestPopRot);
            }
        }
        logger.info("\n   Total permutations evaluated: " + this.evaluatedPermutations + "\n");
    }

    public void getFractions(Residue[] residues, int i, int[] currentRotamers, boolean usingBoxOptimization) throws Exception {
        double[][] fractionSubset = new double[residues.length][56];
        this.populationBoltzmann = new double[residues.length][56];
        this.partitionFunction(residues, i, currentRotamers);
        this.optimumSubset = new int[residues.length];
        for (int m = 0; m < fractionSubset.length; ++m) {
            for (int n = 0; n < 56; ++n) {
                fractionSubset[m][n] = this.populationBoltzmann[m][n] / this.totalBoltzmann;
                if (n > 0 && fractionSubset[m][n] > fractionSubset[m][n - 1]) {
                    this.optimumSubset[m] = n;
                    continue;
                }
                if (n != 0) continue;
                this.optimumSubset[m] = n;
            }
            Rotamer highestPopRot = residues[m].getRotamers()[this.optimumSubset[m]];
            RotamerLibrary.applyRotamer((Residue)residues[m], (Rotamer)highestPopRot);
            Residue residue = residues[m];
            int index = this.residueList.indexOf(residue);
            this.fraction[index] = fractionSubset[m];
            this.optimum[index] = this.optimumSubset[m];
        }
        logger.info("\n   Total permutations evaluated: " + this.evaluatedPermutations + "\n");
    }

    public double[][] getProtonationPopulations(Residue[] residues) {
        double[][] populations = new double[residues.length][3];
        int residueIndex = 0;
        for (Residue residue : residues) {
            int index = this.residueList.indexOf(residue);
            double protSum = 0.0;
            double deprotSum = 0.0;
            double tautomerSum = 0.0;
            Rotamer[] rotamers = residue.getRotamers();
            block39: for (int rotIndex = 0; rotIndex < rotamers.length; ++rotIndex) {
                switch (rotamers[rotIndex].getName()) {
                    case "HIS": 
                    case "LYS": 
                    case "GLH": 
                    case "ASH": 
                    case "CYS": {
                        populations[residueIndex][0] = protSum += this.fraction[index][rotIndex];
                        continue block39;
                    }
                    case "HIE": 
                    case "LYD": 
                    case "GLU": 
                    case "ASP": 
                    case "CYD": {
                        populations[residueIndex][1] = deprotSum += this.fraction[index][rotIndex];
                        continue block39;
                    }
                    case "HID": {
                        populations[residueIndex][2] = tautomerSum += this.fraction[index][rotIndex];
                        continue block39;
                    }
                }
            }
            String formatedProtSum = String.format("%.6f", protSum);
            String formatedDeprotSum = String.format("%.6f", deprotSum);
            String formatedTautomerSum = String.format("%.6f", tautomerSum);
            switch (residue.getName()) {
                case "HIS": 
                case "HIE": 
                case "HID": {
                    logger.info(residue.getResidueNumber() + "\tHIS\t" + formatedProtSum + "\tHIE\t" + formatedDeprotSum + "\tHID\t" + formatedTautomerSum);
                    break;
                }
                case "LYS": 
                case "LYD": {
                    logger.info(residue.getResidueNumber() + "\tLYS\t" + formatedProtSum + "\tLYD\t" + formatedDeprotSum);
                    break;
                }
                case "ASH": 
                case "ASP": {
                    logger.info(residue.getResidueNumber() + "\tASP\t" + formatedDeprotSum + "\tASH\t" + formatedProtSum);
                    break;
                }
                case "GLH": 
                case "GLU": {
                    logger.info(residue.getResidueNumber() + "\tGLU\t" + formatedDeprotSum + "\tGLH\t" + formatedProtSum);
                    break;
                }
                case "CYS": 
                case "CYD": {
                    logger.info(residue.getResidueNumber() + "\tCYS\t" + formatedProtSum + "\tCYD\t" + formatedDeprotSum);
                    break;
                }
            }
            ++residueIndex;
        }
        return populations;
    }

    public double slidingWindowCentered(List<Residue> residueList) throws Exception {
        String[] titratableResidues = new String[]{"HIS", "HIE", "HID", "GLU", "GLH", "ASP", "ASH", "LYS", "LYD", "CYS", "CYD"};
        List<String> titratableResiudesList = Arrays.asList(titratableResidues);
        double e = 0.0;
        for (Residue titrationResidue : residueList) {
            if (!titratableResiudesList.contains(titrationResidue.getName())) continue;
            e = this.slidingWindowOptimization(residueList, this.windowSize, this.increment, this.revert, this.distance, Direction.FORWARD, residueList.indexOf(titrationResidue));
        }
        return e;
    }

    public int[][] getConformers() throws Exception {
        int[][] conformers = new int[this.fraction.length][3];
        for (int i = 0; i < this.fraction.length; ++i) {
            double[] tempArray = new double[this.fraction[0].length];
            System.arraycopy(this.fraction[i], 0, tempArray, 0, this.fraction[0].length);
            ArrayList<Double> elements = new ArrayList<Double>();
            for (int j = 0; j < tempArray.length; ++j) {
                elements.add(tempArray[j]);
            }
            Arrays.sort(tempArray);
            int count = -1;
            for (int k = tempArray.length - 3; k < tempArray.length; ++k) {
                conformers[i][++count] = elements.indexOf(tempArray[k]);
            }
        }
        return conformers;
    }

    public int[] getOptimumRotamers() {
        return this.optimum;
    }

    private double independent(List<Residue> residues) {
        double e = 0.0;
        ArrayList<Object> singletonResidue = new ArrayList<Object>(Collections.nCopies(1, null));
        for (int i = 0; i < residues.size(); ++i) {
            Residue residue = residues.get(i);
            singletonResidue.set(0, residue);
            logger.info(String.format(" Optimizing %s side-chain.", residue));
            Rotamer[] rotamers = residue.getRotamers();
            e = Double.MAX_VALUE;
            int bestRotamer = 0;
            double startingEnergy = 0.0;
            for (int j = 0; j < rotamers.length; ++j) {
                Rotamer rotamer = rotamers[j];
                RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamer);
                if (this.algorithmListener != null) {
                    this.algorithmListener.algorithmUpdate(this.molecularAssembly);
                }
                double newE = Double.NaN;
                try {
                    newE = rotamer.isTitrating ? this.currentEnergy(singletonResidue) + rotamer.getRotamerPhBias() : this.currentEnergy(singletonResidue);
                    if (j == 0) {
                        startingEnergy = newE;
                        newE = 0.0;
                    } else {
                        newE -= startingEnergy;
                    }
                    logger.info(String.format("  Energy %8s %-2d: %s", residue.toString(rotamers[j]), j, this.formatEnergy(newE)));
                    double singularityThreshold = -100000.0;
                    if (newE < singularityThreshold) {
                        String message = String.format("   Rejecting as energy (%s << %s) is likely an error.", this.formatEnergy(newE), this.formatEnergy(singularityThreshold));
                        logger.info(message);
                        newE = Double.MAX_VALUE;
                    }
                }
                catch (ArithmeticException ex) {
                    logger.info(String.format(" Exception %s in energy calculations during independent for %s-%d", ex, residue, j));
                }
                if (!(newE < e)) continue;
                e = newE;
                bestRotamer = j;
            }
            Rotamer rotamer = rotamers[bestRotamer];
            RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamer);
            this.optimum[i] = bestRotamer;
            logger.info(String.format(" Best Energy %8s %-2d: %s", residue.toString(rotamer), bestRotamer, this.formatEnergy(e)));
            if (this.algorithmListener != null) {
                this.algorithmListener.algorithmUpdate(this.molecularAssembly);
            }
            if (!this.terminate) continue;
            logger.info(String.format("\n Terminating after residue %s.\n", residue));
            break;
        }
        return e;
    }

    private boolean firstValidPerm(Residue[] residues, int i, int[] currentRotamers) {
        int nResidues = residues.length;
        Residue residuei = residues[i];
        Rotamer[] rotamersi = residuei.getRotamers();
        int lenri = rotamersi.length;
        if (i < nResidues - 1) {
            for (int ri = 0; ri < lenri; ++ri) {
                int rj;
                if (this.eR.check(i, ri)) continue;
                boolean deadEnd = false;
                for (int j = 0; j < i && !(deadEnd = this.eR.check(j, rj = currentRotamers[j], i, ri)); ++j) {
                }
                if (deadEnd) continue;
                currentRotamers[i] = ri;
                if (!this.firstValidPerm(residues, i + 1, currentRotamers)) continue;
                return true;
            }
        } else {
            for (int ri = 0; ri < lenri; ++ri) {
                int rj;
                if (this.eR.check(i, ri)) continue;
                currentRotamers[i] = ri;
                boolean deadEnd = false;
                for (int j = 0; j < i && !(deadEnd = this.eR.check(j, rj = currentRotamers[j], i, ri)); ++j) {
                }
                if (!deadEnd) break;
            }
            return true;
        }
        return false;
    }

    protected double globalOptimization(List<Residue> residueList) {
        int currentEnsemble = Integer.MAX_VALUE;
        Residue[] residues = residueList.toArray(new Residue[0]);
        int nResidues = residues.length;
        int[] currentRotamers = new int[nResidues];
        this.optimumSubset = new int[nResidues];
        int iterations = 0;
        boolean finalTry = false;
        int bestEnsembleTargetDiffThusFar = Integer.MAX_VALUE;
        double bestBufferThusFar = this.ensembleBuffer;
        double startingBuffer = this.ensembleBuffer;
        if (this.ensembleEnergy > 0.0) {
            double e;
            int ri;
            int i;
            int i2;
            this.ensembleBuffer = this.ensembleEnergy;
            this.applyEliminationCriteria(residues, true, true);
            double permutations = 1.0;
            double singletonPermutations = 1.0;
            for (int i3 = 0; i3 < nResidues; ++i3) {
                Residue residue = residues[i3];
                Rotamer[] rotamers = residue.getRotamers();
                int nr = rotamers.length;
                if (nr <= 1) continue;
                int nrot = 0;
                for (int ri2 = 0; ri2 < nr; ++ri2) {
                    if (this.eR.eliminatedSingles[i3][ri2]) continue;
                    ++nrot;
                }
                permutations *= (double)rotamers.length;
                if (nrot <= 1) continue;
                singletonPermutations *= (double)nrot;
            }
            this.dryRun(residues, 0, currentRotamers);
            double pairTotalElimination = singletonPermutations - (double)this.evaluatedPermutations;
            double afterPairElim = singletonPermutations - pairTotalElimination;
            if (this.evaluatedPermutations == 0) {
                logger.severe(" No valid path through rotamer space found; try recomputing without pruning or using ensemble.");
            }
            if (this.rank0 && this.printFiles && this.ensembleFile == null) {
                File file = this.molecularAssembly.getFile();
                String filename = FilenameUtils.removeExtension((String)file.getAbsolutePath());
                this.ensembleFile = new File(filename + ".ens");
                if (this.ensembleFile.exists()) {
                    for (i2 = 2; i2 < 1000; ++i2) {
                        this.ensembleFile = new File(filename + ".ens_" + i2);
                        if (!this.ensembleFile.exists()) break;
                    }
                    if (this.ensembleFile.exists()) {
                        logger.warning(String.format(" Versioning failed: appending to end of file %s", this.ensembleFile.getName()));
                    }
                }
                this.ensembleFilter = new PDBFilter(new File(this.ensembleFile.getName()), this.molecularAssembly, null, null);
                logger.info(String.format(" Ensemble file: %s", this.ensembleFile.getName()));
            }
            this.logIfRank0(String.format("%30s %35s %35s", "Condition", "Number of Permutations Left", "Number of Permutations Removed"));
            this.logIfRank0(String.format("%30s %35s %35s", "No Eliminations", permutations, ""));
            this.logIfRank0(String.format("%30s %35s %35s", "Single Eliminations", singletonPermutations, permutations - singletonPermutations));
            this.logIfRank0(String.format("%30s %35s %35s", "Pair Eliminations", afterPairElim, pairTotalElimination));
            this.logIfRank0(String.format("%30s %35s %35s", "Single and Pair Eliminations", (double)this.evaluatedPermutations, pairTotalElimination + (permutations - singletonPermutations)));
            this.logIfRank0("\n Energy of permutations:");
            this.logIfRank0(String.format(" %12s %25s %25s", "Permutation", "Energy", "Lowest Possible Energy"));
            if (this.useMonteCarlo()) {
                this.firstValidPerm(residues, 0, currentRotamers);
                System.arraycopy(currentRotamers, 0, this.optimumSubset, 0, nResidues);
                this.rotamerOptimizationMC(residues, this.optimumSubset, currentRotamers, this.nMCSteps, false, this.mcUseAll);
                this.logIfRank0(" Ensembles not currently compatible with Monte Carlo search");
            } else {
                double[] permutationEnergies = new double[this.evaluatedPermutations];
                this.ensembleStates = new ArrayList<ObjectPair<ResidueState[], Double>>();
                double e2 = this.rotamerOptimizationDEE(this.molecularAssembly, residues, 0, currentRotamers, Double.MAX_VALUE, this.optimumSubset, permutationEnergies);
                int[][] acceptedPermutations = new int[this.evaluatedPermutations][];
                this.logIfRank0(String.format("\n Checking permutations for distance < %5.3f kcal/mol from GMEC energy %10.8f kcal/mol", this.ensembleEnergy, e2));
                this.dryRunForEnsemble(residues, 0, currentRotamers, e2, permutationEnergies, acceptedPermutations);
                int numAcceptedPermutations = 0;
                for (int i4 = 0; i4 < acceptedPermutations.length; ++i4) {
                    if (acceptedPermutations[i4] == null) continue;
                    ++numAcceptedPermutations;
                    this.logIfRank0(String.format(" Accepting permutation %d at %8.6f < %8.6f", i4, permutationEnergies[i4] - e2, this.ensembleEnergy));
                    for (int j = 0; j < nResidues; ++j) {
                        Residue residuej = residues[j];
                        Rotamer[] rotamersj = residuej.getRotamers();
                        RotamerLibrary.applyRotamer((Residue)residuej, (Rotamer)rotamersj[acceptedPermutations[i4][j]]);
                    }
                    ResidueState[] states = ResidueState.storeAllCoordinates((Residue[])residues);
                    this.ensembleStates.add((ObjectPair<ResidueState[], Double>)new ObjectPair((Object)states, (Comparable)Double.valueOf(permutationEnergies[i4])));
                    if (!this.printFiles || !this.rank0) continue;
                    try {
                        int j;
                        FileWriter fw = new FileWriter(this.ensembleFile, true);
                        BufferedWriter bw = new BufferedWriter(fw);
                        bw.write(String.format("MODEL        %d", numAcceptedPermutations));
                        for (j = 0; j < 75; ++j) {
                            bw.write(" ");
                        }
                        bw.newLine();
                        bw.flush();
                        this.ensembleFilter.writeFile(this.ensembleFile, true);
                        bw.write("ENDMDL");
                        for (j = 0; j < 64; ++j) {
                            bw.write(" ");
                        }
                        bw.newLine();
                        bw.close();
                        continue;
                    }
                    catch (IOException ex) {
                        logger.warning(String.format(" Exception writing to file: %s", this.ensembleFile.getName()));
                    }
                }
                this.logIfRank0(String.format(" Number of permutations within %5.3f kcal/mol of GMEC energy: %6.4e", this.ensembleEnergy, (double)numAcceptedPermutations));
                this.ensembleStates.sort(null);
            }
            this.logIfRank0(" Final rotamers:");
            this.logIfRank0(String.format("%17s %10s %11s %12s %11s", "Residue", "Chi 1", "Chi 2", "Chi 3", "Chi 4"));
            for (i2 = 0; i2 < nResidues; ++i2) {
                Residue residue = residues[i2];
                Rotamer[] rotamers = residue.getRotamers();
                int ri3 = this.optimumSubset[i2];
                Rotamer rotamer = rotamers[ri3];
                this.logIfRank0(String.format(" %c (%7s,%2d) %s", residue.getChainID(), residue.toString(rotamer), ri3, rotamer.toAngleString()));
                RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamer);
            }
            this.logIfRank0("\n");
            double sumSelfEnergy = 0.0;
            double sumPairEnergy = 0.0;
            double sumTrimerEnergy = 0.0;
            for (i = 0; i < nResidues; ++i) {
                Residue residue = residues[i];
                Rotamer[] rotamers = residue.getRotamers();
                ri = this.optimumSubset[i];
                sumSelfEnergy += this.eE.getSelf(i, ri);
                this.logIfRank0(String.format(" Final self Energy (%8s,%2d): %12.4f", residue.toString(rotamers[ri]), ri, this.eE.getSelf(i, ri)));
            }
            for (i = 0; i < nResidues - 1; ++i) {
                Residue residueI = residues[i];
                Rotamer[] rotI = residueI.getRotamers();
                ri = this.optimumSubset[i];
                for (int j = i + 1; j < nResidues; ++j) {
                    Residue residueJ = residues[j];
                    Rotamer[] rotJ = residueJ.getRotamers();
                    int rj = this.optimumSubset[j];
                    sumPairEnergy += this.eE.get2Body(i, ri, j, rj);
                    if (!(this.eE.get2Body(i, ri, j, rj) > 10.0)) continue;
                    this.logIfRank0(String.format(" Large Final Pair Energy (%8s,%2d) (%8s,%2d): %12.4f", residueI.toString(rotI[ri]), ri, residueJ.toString(rotJ[rj]), rj, this.eE.get2Body(i, ri, j, rj)));
                }
            }
            try {
                e = this.currentEnergy(residueList) + this.eE.getTotalRotamerPhBias(residueList, this.optimumSubset, this.pH, this.pHRestraint);
            }
            catch (ArithmeticException ex) {
                e = Double.NaN;
                logger.severe(String.format(" Exception %s in calculating current energy at the end of triples", ex));
            }
            this.logIfRank0(String.format(" %12s %25s %25s", "Type", "Energy", "Lowest Possible Energy"));
            this.logIfRank0(String.format(" %12s %25f %25s", "Self:", sumSelfEnergy, ""));
            this.logIfRank0(String.format(" %12s %25f %25s", "Pair:", sumPairEnergy, ""));
            this.approximateEnergy = this.eE.getBackboneEnergy() + sumSelfEnergy + sumPairEnergy;
            if (this.threeBodyTerm) {
                for (int i5 = 0; i5 < nResidues - 2; ++i5) {
                    int ri4 = this.optimumSubset[i5];
                    for (int j = i5 + 1; j < nResidues - 1; ++j) {
                        int rj = this.optimumSubset[j];
                        for (int k = j + 1; k < nResidues; ++k) {
                            int rk = this.optimumSubset[k];
                            try {
                                sumTrimerEnergy += this.eE.get3Body(residues, i5, ri4, j, rj, k, rk);
                                continue;
                            }
                            catch (Exception ex) {
                                logger.warning(ex.toString());
                            }
                        }
                    }
                }
                this.approximateEnergy += sumTrimerEnergy;
                double higherOrderEnergy = e - sumSelfEnergy - sumPairEnergy - sumTrimerEnergy - this.eE.getBackboneEnergy();
                this.logIfRank0(String.format(" %12s %25f %25s", "Trimer:", sumTrimerEnergy, ""));
                this.logIfRank0(String.format(" %12s %25f %25s", "Neglected:", higherOrderEnergy, ""));
            } else {
                double higherOrderEnergy = e - sumSelfEnergy - sumPairEnergy - this.eE.getBackboneEnergy();
                this.logIfRank0(String.format(" %12s %25f %25s", "Neglected:", higherOrderEnergy, ""));
            }
            this.logIfRank0(String.format(" %12s %25f %25s", "Approximate:", this.approximateEnergy, ""));
            return e;
        }
        int nPerms = 1;
        for (Residue residue : residues) {
            Rotamer[] rotamers = residue.getRotamers();
            int nr = rotamers.length;
            if (nr > 1) {
                nPerms *= rotamers.length;
            }
            if (nPerms > this.ensembleNumber) break;
        }
        if (nPerms < this.ensembleNumber) {
            logger.info(String.format(" Requested an ensemble of %d, but only %d permutations exist; returning full ensemble", this.ensembleNumber, nPerms));
            this.ensembleNumber = nPerms;
        }
        while (currentEnsemble != this.ensembleNumber) {
            if (this.monteCarlo) {
                this.logIfRank0(" Ensemble search not currently compatible with Monte Carlo");
                this.ensembleNumber = 1;
            }
            if (iterations == 0) {
                this.applyEliminationCriteria(residues, true, true);
            } else {
                this.applyEliminationCriteria(residues, false, false);
            }
            double permutations = 1.0;
            double singletonPermutations = 1.0;
            for (int i = 0; i < nResidues; ++i) {
                Residue residue = residues[i];
                Rotamer[] rotamers = residue.getRotamers();
                int nr = rotamers.length;
                if (nr <= 1) continue;
                int nrot = 0;
                for (int ri = 0; ri < nr; ++ri) {
                    if (this.eR.eliminatedSingles[i][ri]) continue;
                    ++nrot;
                }
                permutations *= (double)rotamers.length;
                if (nrot <= 1) continue;
                singletonPermutations *= (double)nrot;
            }
            this.logIfRank0(" Collecting Permutations:");
            this.dryRun(residues, 0, currentRotamers);
            double pairTotalElimination = singletonPermutations - (double)this.evaluatedPermutations;
            double afterPairElim = singletonPermutations - pairTotalElimination;
            currentEnsemble = this.evaluatedPermutations;
            if (this.ensembleNumber == 1 && currentEnsemble == 0) {
                logger.severe(" No valid path through rotamer space found; try recomputing without pruning or using ensemble.");
            }
            if (this.ensembleNumber > 1) {
                if (this.rank0 && this.printFiles && this.ensembleFile == null) {
                    File file = this.molecularAssembly.getFile();
                    String filename = FilenameUtils.removeExtension((String)file.getAbsolutePath());
                    this.ensembleFile = new File(filename + ".ens");
                    if (this.ensembleFile.exists()) {
                        for (int i = 2; i < 1000; ++i) {
                            this.ensembleFile = new File(filename + ".ens_" + i);
                            if (!this.ensembleFile.exists()) break;
                        }
                        if (this.ensembleFile.exists()) {
                            logger.warning(String.format(" Versioning failed: appending to end of file %s", this.ensembleFile.getName()));
                        }
                    }
                    this.ensembleFilter = new PDBFilter(new File(this.ensembleFile.getName()), this.molecularAssembly, null, null);
                    logger.info(String.format(" Ensemble file: %s", this.ensembleFile.getName()));
                }
                this.logIfRank0(String.format(" Ensemble Search Stats: (buffer: %5.3f, current: %d, target: %d)", this.ensembleBuffer, currentEnsemble, this.ensembleNumber));
            }
            if (this.ensembleNumber == 1 || finalTry) {
                this.logIfRank0(String.format("%30s %35s %35s", "Condition", "Number of Permutations Left", "Number of Permutations Removed"));
                this.logIfRank0(String.format("%30s %35s %35s", "No Eliminations", permutations, ""));
                this.logIfRank0(String.format("%30s %35s %35s", "Single Eliminations", singletonPermutations, permutations - singletonPermutations));
                this.logIfRank0(String.format("%30s %35s %35s", "Pair Eliminations", afterPairElim, pairTotalElimination));
                this.logIfRank0(String.format("%30s %35s %35s", "Single and Pair Eliminations", (double)this.evaluatedPermutations, pairTotalElimination + (permutations - singletonPermutations)));
                this.logIfRank0("\n Energy of permutations:");
                this.logIfRank0(String.format(" %12s %25s %25s", "Permutation", "Energy", "Lowest Possible Energy"));
                break;
            }
            if (FastMath.abs((int)(currentEnsemble - this.ensembleNumber)) < bestEnsembleTargetDiffThusFar) {
                bestEnsembleTargetDiffThusFar = Math.abs(currentEnsemble - this.ensembleNumber);
                bestBufferThusFar = this.ensembleBuffer;
            }
            if (currentEnsemble > this.ensembleNumber) {
                this.ensembleBuffer -= this.ensembleBufferStep;
                this.ensembleBufferStep -= this.ensembleBufferStep * 0.01;
                ++iterations;
            } else if (currentEnsemble < this.ensembleNumber) {
                this.ensembleBuffer += this.ensembleBufferStep;
                this.ensembleBufferStep -= this.ensembleBufferStep * 0.01;
                ++iterations;
            }
            if (iterations <= 100) continue;
            if (currentEnsemble == 0) {
                this.logIfRank0(" Ensemble still empty; increasing buffer energy.");
                startingBuffer = 3.0 * startingBuffer;
                this.setEnsemble(10, startingBuffer);
                iterations = 0;
                continue;
            }
            this.ensembleBuffer = bestBufferThusFar;
            finalTry = true;
        }
        if (currentEnsemble == 0) {
            logger.warning(" No valid rotamer permutations found; results will be unreliable.  Try increasing the starting ensemble buffer.");
        }
        double[] permutationEnergyStub = null;
        if (this.useMonteCarlo()) {
            this.firstValidPerm(residues, 0, currentRotamers);
            this.rotamerOptimizationMC(residues, this.optimumSubset, currentRotamers, this.nMCSteps, false, this.mcUseAll);
        } else {
            this.rotamerOptimizationDEE(this.molecularAssembly, residues, 0, currentRotamers, Double.MAX_VALUE, this.optimumSubset, permutationEnergyStub);
        }
        double[] residueEnergy = new double[nResidues];
        double sumSelfEnergy = 0.0;
        double sumLowSelfEnergy = 0.0;
        this.logIfRank0("\n Energy contributions:");
        this.logIfRank0(String.format(" %15s %25s %25s", "Type", "Energy", "Lowest Possible Energy"));
        for (int i = 0; i < nResidues; ++i) {
            double self;
            int ri = this.optimumSubset[i];
            Residue residue = residues[i];
            Rotamer[] rotamers = residue.getRotamers();
            RotamerOptimization.turnOnAtoms(residue);
            RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamers[ri]);
            residueEnergy[i] = self = this.eE.getSelf(i, ri);
            sumSelfEnergy += self;
            double lowest = this.eE.lowestSelfEnergy(residues, i);
            sumLowSelfEnergy += lowest;
            if (!(self - lowest > 10.0)) continue;
            this.logIfRank0(String.format(" %15s %25f %25f", "Self (" + String.valueOf(residues[i]) + "," + ri + "):", self, lowest));
        }
        double sumPairEnergy = 0.0;
        double sumLowPairEnergy = 0.0;
        double[] resPairEnergy = new double[nResidues];
        double[] lowPairEnergy = new double[nResidues];
        for (int i = 0; i < nResidues - 1; ++i) {
            StringBuilder sb = new StringBuilder();
            int ri = this.optimumSubset[i];
            double sumPairEnergyI = 0.0;
            double sumLowPairEnergyI = 0.0;
            for (int j = i + 1; j < nResidues; ++j) {
                int rj = this.optimumSubset[j];
                double pair = this.eE.get2Body(i, ri, j, rj);
                int n = i;
                residueEnergy[n] = residueEnergy[n] + 0.5 * pair;
                int n2 = j;
                residueEnergy[n2] = residueEnergy[n2] + 0.5 * pair;
                sumPairEnergy += pair;
                sumPairEnergyI += pair;
                double lowest = this.eE.lowestPairEnergy(residues, i, ri, j);
                sumLowPairEnergy += lowest;
                sumLowPairEnergyI += lowest;
                resPairEnergy[i] = 0.5 * pair;
                resPairEnergy[j] = 0.5 * pair;
                lowPairEnergy[i] = 0.5 * lowest;
                lowPairEnergy[j] = 0.5 * lowest;
                if (!(resPairEnergy[i] - lowPairEnergy[i] > 10.0)) continue;
                sb.append(String.format("  Pair Energy (%8s,%2d) (%8s,%2d): %12.4f (Lowest: %12.4f).\n", residues[i].toFormattedString(false, true), ri, residues[j].toFormattedString(false, true), rj, pair, lowest));
            }
            if (!(sumPairEnergyI - sumLowPairEnergyI > 10.0)) continue;
            this.logIfRank0(String.format(" %15s %25f %25f", "Self (" + String.valueOf(residues[i]) + "," + ri + ")", sumPairEnergyI, sumLowPairEnergyI));
            sb.trimToSize();
            if (sb.toString().isEmpty()) continue;
            this.logIfRank0(sb.toString());
        }
        double e = Double.NaN;
        try {
            e = this.currentEnergy(residueList) + this.eE.getTotalRotamerPhBias(residueList, this.optimumSubset, this.pH, this.pHRestraint);
        }
        catch (ArithmeticException ex) {
            logger.severe(String.format(" Exception %s in calculating current energy at the end of self and pairs", ex));
        }
        this.logIfRank0(String.format(" %15s %25f %25s", "Backbone:", this.eE.getBackboneEnergy(), ""));
        this.logIfRank0(String.format(" %15s %25f %25f", "Self:", sumSelfEnergy, sumLowSelfEnergy));
        this.logIfRank0(String.format(" %15s %25f %25f", "Pair:", sumPairEnergy, sumLowPairEnergy));
        this.approximateEnergy = this.eE.getBackboneEnergy() + sumSelfEnergy + sumPairEnergy;
        double sumTrimerEnergy = 0.0;
        if (this.threeBodyTerm) {
            for (int i = 0; i < nResidues - 2; ++i) {
                int ri = this.optimumSubset[i];
                for (int j = i + 1; j < nResidues - 1; ++j) {
                    int rj = this.optimumSubset[j];
                    for (int k = j + 1; k < nResidues; ++k) {
                        int rk = this.optimumSubset[k];
                        try {
                            double triple = this.eE.get3Body(residues, i, ri, j, rj, k, rk);
                            double thirdTrip = triple / 3.0;
                            int n = i;
                            residueEnergy[n] = residueEnergy[n] + thirdTrip;
                            int n3 = j;
                            residueEnergy[n3] = residueEnergy[n3] + thirdTrip;
                            int n4 = k;
                            residueEnergy[n4] = residueEnergy[n4] + thirdTrip;
                            sumTrimerEnergy += triple;
                            continue;
                        }
                        catch (Exception ex) {
                            logger.warning(ex.toString());
                        }
                    }
                }
            }
            this.approximateEnergy += sumTrimerEnergy;
            higherOrderEnergy = e - sumSelfEnergy - sumPairEnergy - sumTrimerEnergy - this.eE.getBackboneEnergy();
            this.logIfRank0(String.format(" %15s %25f %25s", "Trimer:", sumTrimerEnergy, ""));
            this.logIfRank0(String.format(" %15s %25f %25s", "Neglected:", higherOrderEnergy, ""));
        } else {
            higherOrderEnergy = e - sumSelfEnergy - sumPairEnergy - this.eE.getBackboneEnergy();
            this.logIfRank0(String.format(" %15s %25f %25s", "Neglected:", higherOrderEnergy, ""));
        }
        this.logIfRank0(String.format(" %15s %25f %25s", "Approximate:", this.approximateEnergy, ""));
        this.logIfRank0("\n Final rotamers:");
        this.logIfRank0(String.format("%17s %10s %11s %12s %11s %14s", "Residue", "Chi 1", "Chi 2", "Chi 3", "Chi 4", "Energy"));
        for (int i = 0; i < nResidues; ++i) {
            Residue residue = residues[i];
            Rotamer[] rotamers = residue.getRotamers();
            int ri = this.optimumSubset[i];
            Rotamer rotamer = rotamers[ri];
            this.logIfRank0(String.format(" %3d %c (%7s,%2d) %s %12.4f ", i + 1, residue.getChainID(), residue.toString(rotamers[ri]), ri, rotamer.toAngleString(), residueEnergy[i]));
            RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamer);
        }
        this.logIfRank0("\n");
        return e;
    }

    private boolean useMonteCarlo() {
        return this.monteCarlo && (this.mcNoEnum || this.nMCSteps < this.evaluatedPermutations);
    }

    private double bruteForce(List<Residue> residueList) {
        double e;
        Rotamer[] rotamers;
        Residue[] residues = residueList.toArray(new Residue[0]);
        int nResidues = residues.length;
        double permutations = 1.0;
        for (Residue residue : residues) {
            rotamers = residue.getRotamers();
            permutations *= (double)rotamers.length;
        }
        logger.info(String.format(" Number of permutations: %16.8e.", permutations));
        this.useForceFieldEnergy = this.molecularAssembly.getProperties().getBoolean("ro-use-force-field-energy", false);
        if (!this.useForceFieldEnergy) {
            this.setPruning(0);
            this.rotamerEnergies(residues);
            int[] currentRotamers = new int[nResidues];
            e = this.decomposedRotamerOptimization(residues, 0, Double.MAX_VALUE, this.optimum, currentRotamers);
            for (int i = 0; i < nResidues; ++i) {
                Residue residue = residues[i];
                Rotamer[] rotamers2 = residue.getRotamers();
                RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamers2[this.optimum[i]]);
                RotamerOptimization.turnOnAtoms(residue);
            }
            double fullEnergy = 0.0;
            try {
                fullEnergy = this.currentEnergy(residueList) + this.eE.getTotalRotamerPhBias(residueList, this.optimum, this.pH, this.pHRestraint);
            }
            catch (Exception ex) {
                logger.severe(String.format(" Exception %s in calculating full energy; FFX shutting down", ex));
            }
            logger.info(String.format(" Final summation of energies:    %16.5f", e));
            logger.info(String.format(" Final energy of optimized structure:    %16.5f", fullEnergy));
            logger.info(String.format(" Neglected:    %16.5f", fullEnergy - e));
        } else {
            e = this.rotamerOptimization(this.molecularAssembly, residues, 0, Double.MAX_VALUE, this.optimum);
        }
        for (int i = 0; i < nResidues; ++i) {
            Residue residue = residues[i];
            rotamers = residue.getRotamers();
            int ri = this.optimum[i];
            Rotamer rotamer = rotamers[ri];
            logger.info(String.format(" %s %s (%d)", residue.getResidueNumber(), rotamer.toString(), ri));
            RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamer);
            if (!this.useForceFieldEnergy) continue;
            try {
                e = this.currentEnergy(residueList) + this.eE.getTotalRotamerPhBias(residueList, this.optimum, this.pH, this.pHRestraint);
                continue;
            }
            catch (ArithmeticException ex) {
                logger.fine(String.format(" Exception %s in calculating full AMOEBA energy at the end of brute force", ex));
            }
        }
        return e;
    }

    /*
     * Unable to fully structure code
     */
    private double slidingWindowOptimization(List<Residue> residueList, int windowSize, int increment, boolean revert, double distance, Direction direction, int windowCenter) throws Exception {
        beginTime = -System.nanoTime();
        incrementTruncated = false;
        firstWindowSaved = false;
        counter = 1;
        nOptimize = residueList.size();
        if (nOptimize < windowSize) {
            windowSize = nOptimize;
            RotamerOptimization.logger.info(" Window size too small for given residue range; truncating window size.");
        }
        block3 : switch (direction.ordinal()) {
            case 1: {
                temp = new ArrayList<Residue>();
                for (i = nOptimize - 1; i >= 0; --i) {
                    temp.add(residueList.get(i));
                }
                residueList = temp;
            }
            case 0: {
                windowStart = 0;
                while (windowStart + (windowSize - 1) < nOptimize) {
                    windowTime = -System.nanoTime();
                    if (windowCenter > -1) {
                        windowStart = windowCenter - windowSize / 2;
                        if (windowStart < 0) {
                            windowStart = 0;
                        }
                        if ((windowEnd = windowCenter + windowSize / 2) >= residueList.size()) {
                            windowEnd = residueList.size() - 1;
                        }
                    } else {
                        windowEnd = windowStart + (windowSize - 1);
                    }
                    if (windowCenter > -1) {
                        this.logIfRank0(String.format("\n Center window at residue %d.\n", new Object[]{residueList.get(windowCenter).getResidueNumber()}));
                    } else {
                        this.logIfRank0(String.format("\n Iteration %d of the sliding window.\n", new Object[]{counter++}));
                    }
                    firstResidue = residueList.get(windowStart);
                    lastResidue = residueList.get(windowEnd);
                    if (firstResidue != lastResidue) {
                        this.logIfRank0(String.format(" Residues %s ... %s", new Object[]{firstResidue.toString(), lastResidue.toString()}));
                    } else {
                        this.logIfRank0(String.format(" Residue %s", new Object[]{firstResidue.toString()}));
                    }
                    currentWindow = new ArrayList<Residue>();
                    for (i = windowStart; i <= windowEnd; ++i) {
                        residue = residueList.get(i);
                        currentWindow.add(residue);
                    }
                    if (distance > 0.0) {
                        for (i = windowStart; i <= windowEnd; ++i) {
                            if (windowCenter > -1) {
                                i = windowCenter;
                            }
                            residuei = residueList.get(i);
                            indexI = this.allResiduesList.indexOf(residuei);
                            lengthRi = residuei.getRotamers().length;
                            for (ri = 0; ri < lengthRi; ++ri) {
                                block15: for (j = 0; j < this.nAllResidues; ++j) {
                                    residuej = this.allResiduesArray[j];
                                    rotamersj = residuej.getRotamers();
                                    if (currentWindow.contains(residuej) || rotamersj == null) continue;
                                    lengthRj = rotamersj.length;
                                    for (rj = 0; rj < lengthRj; ++rj) {
                                        rotamerSeparation = this.dM.get2BodyDistance(indexI, ri, j, rj);
                                        if (!(rotamerSeparation <= distance)) continue;
                                        if (currentWindow.contains(residuej)) continue block15;
                                        this.logIfRank0(String.format(" Adding residue %s at distance %16.8f Ang from %s %d.", new Object[]{residuej.toFormattedString(false, true), rotamerSeparation, residuei.toFormattedString(false, true), ri}));
                                        currentWindow.add(residuej);
                                        continue block15;
                                    }
                                }
                            }
                            if (windowCenter > -1) break;
                        }
                    }
                    if (counter > 2 && windowSize <= increment && firstResidue.getResidueType() == Residue.ResidueType.NA && (prevResidue = firstResidue.getPreviousResidue()) != null && prevResidue.getResidueType() == Residue.ResidueType.NA && !currentWindow.contains(prevResidue) && prevResidue.getRotamers() != null) {
                        this.logIfRank0(String.format(" Adding nucleic acid residue 5' of window start %s to give it flexibility about its sugar pucker.", new Object[]{prevResidue}));
                        currentWindow.add(prevResidue);
                    }
                    this.sortResidues(currentWindow);
                    if (revert) {
                        coordinates = ResidueState.storeAllCoordinates(currentWindow);
                        startingEnergy = NaN;
                        try {
                            startingEnergy = this.currentEnergy(currentWindow);
                        }
                        catch (ArithmeticException ex) {
                            RotamerOptimization.logger.severe(String.format(" Exception %s in calculating starting energy of a window; FFX shutting down", new Object[]{ex}));
                        }
                        this.globalOptimization(currentWindow);
                        finalEnergy = NaN;
                        try {
                            finalEnergy = this.currentEnergy(currentWindow);
                        }
                        catch (ArithmeticException ex) {
                            RotamerOptimization.logger.severe(String.format(" Exception %s in calculating final energy of a window; FFX shutting down", new Object[]{ex}));
                        }
                        if (startingEnergy <= finalEnergy) {
                            RotamerOptimization.logger.info("Optimization did not yield a better energy. Reverting to original coordinates.");
                            ResidueState.revertAllCoordinates(currentWindow, (ResidueState[])coordinates);
                        } else {
                            i = 0;
                            for (Residue residue : currentWindow) {
                                index = residueList.indexOf(residue);
                                this.optimum[index] = this.optimumSubset[i++];
                            }
                        }
                    } else {
                        this.globalOptimization(currentWindow);
                        i = 0;
                        for (Residue residue : currentWindow) {
                            index = residueList.indexOf(residue);
                            this.optimum[index] = this.optimumSubset[i++];
                        }
                    }
                    if (!incrementTruncated && windowStart + (windowSize - 1) + increment > nOptimize - 1) {
                        increment = nOptimize - windowStart - windowSize;
                        if (increment == 0) break block3;
                        RotamerOptimization.logger.warning(" Increment truncated in order to optimize entire residue range.");
                        incrementTruncated = true;
                    }
                    if (!this.rank0 || !this.printFiles) ** GOTO lbl131
                    file = this.molecularAssembly.getFile();
                    if (firstWindowSaved) {
                        file.delete();
                    }
                    if (windowStart + windowSize == nOptimize) ** GOTO lbl143
                    windowFilter = new PDBFilter(file, this.molecularAssembly, null, null);
                    try {
                        windowFilter.writeFile(file, false);
                        if (firstResidue != lastResidue) {
                            RotamerOptimization.logger.info(String.format(" File with residues %s ... %s in window written to.", new Object[]{firstResidue, lastResidue}));
                        } else {
                            RotamerOptimization.logger.info(String.format(" File with residue %s in window written to.", new Object[]{firstResidue}));
                        }
                    }
                    catch (Exception e) {
                        RotamerOptimization.logger.warning(String.format("Exception writing to file: %s", new Object[]{file.getName()}));
                    }
                    firstWindowSaved = true;
lbl131:
                    // 2 sources

                    currentTime = System.nanoTime();
                    this.logIfRank0(String.format(" Time elapsed for this iteration: %11.3f sec", new Object[]{(double)(windowTime += currentTime) * 1.0E-9}));
                    this.logIfRank0(String.format(" Overall time elapsed: %11.3f sec", new Object[]{(double)(currentTime + beginTime) * 1.0E-9}));
                    if (this.genZ) {
                        currentRotamers = new int[this.optimumSubset.length];
                        this.usingBoxOptimization = true;
                        residueSubsetArray = currentWindow.toArray(new Residue[currentWindow.size()]);
                        this.getFractions(residueSubsetArray, 0, currentRotamers, true);
                        titrationResidueArray = new Residue[]{residueList.get(windowCenter)};
                        this.getProtonationPopulations(titrationResidueArray);
                    }
                    if (windowCenter > -1) break block3;
lbl143:
                    // 2 sources

                    windowStart += increment;
                }
                break;
            }
        }
        return 0.0;
    }

    private void sortResidues(List<Residue> residues) {
        Comparator<Residue> comparator = Comparator.comparing(Residue::getChainID).thenComparingInt(Residue::getResidueNumber);
        residues.sort(comparator);
    }

    private void applyEliminationCriteria(Residue[] residues, boolean getEnergies, boolean verbose) {
        Level prevLevel = logger.getLevel();
        if (!verbose) {
            logger.setLevel(Level.WARNING);
        }
        if (getEnergies) {
            this.applyEliminationCriteria(residues);
        } else {
            boolean pairEliminated;
            int i = 0;
            do {
                pairEliminated = false;
                if (this.useGoldstein) {
                    if (this.selfEliminationOn) {
                        this.logIfRank0(String.format("\n Iteration %d: Applying Single Goldstein DEE conditions ", ++i));
                        while (this.goldsteinDriver(residues)) {
                            this.logIfRank0(this.toString());
                            this.logIfRank0(String.format("\n Iteration %d: Applying Single Rotamer Goldstein DEE conditions ", ++i));
                        }
                    }
                    if (this.pairEliminationOn) {
                        this.logIfRank0(String.format("\n Iteration %d: Applying Rotamer Pair Goldstein DEE conditions ", ++i));
                        pairEliminated = false;
                        while (this.goldsteinPairDriver(residues)) {
                            pairEliminated = true;
                            this.logIfRank0(this.toString());
                            this.logIfRank0(String.format("\n Iteration %d: Applying Rotamer Pair Goldstein DEE conditions ", ++i));
                        }
                    }
                } else {
                    if (this.selfEliminationOn) {
                        this.logIfRank0(String.format("\n Iteration %d: Applying Single DEE conditions ", ++i));
                        while (this.deeRotamerElimination(residues)) {
                            this.logIfRank0(this.toString());
                            this.logIfRank0(String.format("\n Iteration %d: Applying Single Rotamer DEE conditions ", ++i));
                        }
                    }
                    if (this.pairEliminationOn) {
                        this.logIfRank0(String.format("\n Iteration %d: Applying Rotamer Pair DEE conditions ", ++i));
                        pairEliminated = false;
                        while (this.deeRotamerPairElimination(residues)) {
                            pairEliminated = true;
                            this.logIfRank0(this.toString());
                            this.logIfRank0(String.format("\n Iteration %d: Applying Rotamer Pair DEE conditions ", ++i));
                        }
                    }
                }
                this.eR.validateDEE(residues);
                this.logIfRank0(this.toString());
            } while (pairEliminated);
            this.logIfRank0(" Self-consistent DEE rotamer elimination achieved.\n");
        }
        if (!verbose) {
            logger.setLevel(prevLevel);
        }
    }

    private void applyEliminationCriteria(Residue[] residues) {
        boolean pairEliminated;
        try {
            this.logIfRank0(String.format("\n Beginning Energy %s", this.formatEnergy(this.currentEnergy(residues))));
        }
        catch (ArithmeticException ex) {
            logger.severe(String.format(" Exception %s in calculating beginning energy; FFX shutting down.", ex));
        }
        this.rotamerEnergies(residues);
        if (this.testing) {
            int nres = residues.length;
            this.eR.onlyPrunedSingles = new boolean[nres][];
            this.eR.onlyPrunedPairs = new boolean[nres][][][];
            for (int i = 0; i < nres; ++i) {
                Residue residuei = residues[i];
                Rotamer[] rotamersi = residuei.getRotamers();
                int lenri = rotamersi.length;
                this.eR.onlyPrunedSingles[i] = new boolean[lenri];
                this.eR.onlyPrunedSingles[i] = Arrays.copyOf(this.eR.eliminatedSingles[i], this.eR.eliminatedSingles[i].length);
                this.eR.onlyPrunedPairs[i] = new boolean[lenri][][];
                for (int ri = 0; ri < lenri; ++ri) {
                    this.eR.onlyPrunedPairs[i][ri] = new boolean[nres][];
                    for (int j = i + 1; j < nres; ++j) {
                        Residue residuej = residues[j];
                        Rotamer[] rotamersj = residuej.getRotamers();
                        int lenrj = rotamersj.length;
                        this.eR.onlyPrunedPairs[i][ri][j] = new boolean[lenrj];
                        this.eR.onlyPrunedPairs[i][ri][j] = Arrays.copyOf(this.eR.eliminatedPairs[i][ri][j], this.eR.eliminatedPairs[i][ri][j].length);
                    }
                }
            }
        }
        if (this.testSelfEnergyEliminations) {
            this.testSelfEnergyElimination(residues);
        } else if (this.testPairEnergyEliminations > -1) {
            this.testPairEnergyElimination(residues, this.testPairEnergyEliminations);
        } else if (this.testTripleEnergyEliminations1 > -1 && this.testTripleEnergyEliminations2 > -1) {
            this.testTripleEnergyElimination(residues, this.testTripleEnergyEliminations1, this.testTripleEnergyEliminations2);
        }
        if (this.pruneClashes) {
            this.eR.validateDEE(residues);
        }
        int i = 0;
        do {
            pairEliminated = false;
            if (this.useGoldstein) {
                if (this.selfEliminationOn) {
                    this.logIfRank0(String.format("\n Iteration %d: Applying Single Goldstein DEE conditions ", ++i));
                    while (this.goldsteinDriver(residues)) {
                        this.logIfRank0(this.toString());
                        this.logIfRank0(String.format("\n Iteration %d: Applying Single Rotamer Goldstein DEE conditions ", ++i));
                    }
                }
                if (this.pairEliminationOn) {
                    this.logIfRank0(String.format("\n Iteration %d: Applying Rotamer Pair Goldstein DEE conditions ", ++i));
                    while (this.goldsteinPairDriver(residues)) {
                        pairEliminated = true;
                        this.logIfRank0(this.toString());
                        this.logIfRank0(String.format("\n Iteration %d: Applying Rotamer Pair Goldstein DEE conditions ", ++i));
                    }
                }
            } else {
                if (this.selfEliminationOn) {
                    this.logIfRank0(String.format("\n Iteration %d: Applying Single DEE conditions ", ++i));
                    while (this.deeRotamerElimination(residues)) {
                        this.logIfRank0(this.toString());
                        this.logIfRank0(String.format("\n Iteration %d: Applying Single Rotamer DEE conditions ", ++i));
                    }
                }
                if (this.pairEliminationOn) {
                    this.logIfRank0(String.format("\n Iteration %d: Applying Rotamer Pair DEE conditions ", ++i));
                    while (this.deeRotamerPairElimination(residues)) {
                        pairEliminated = true;
                        this.logIfRank0(this.toString());
                        this.logIfRank0(String.format("\n Iteration %d: Applying Rotamer Pair DEE conditions ", ++i));
                    }
                }
            }
            this.eR.validateDEE(residues);
            this.logIfRank0(this.toString());
        } while (pairEliminated);
        this.logIfRank0(" Self-consistent DEE rotamer elimination achieved.\n");
    }

    private double currentEnergy(List<Residue> resList) throws ArithmeticException {
        List rots = resList.stream().filter(Objects::nonNull).map(Residue::getRotamer).collect(Collectors.toList());
        File energyDir = this.dirSupplier.apply(resList, rots);
        return this.eFunction.applyAsDouble(energyDir);
    }

    private double currentPE(File dir) {
        if (this.x == null) {
            int nVar = this.potential.getNumberOfVariables();
            this.x = new double[nVar];
        }
        this.potential.getCoordinates(this.x);
        return this.potential.energy(this.x);
    }

    private void generateResidueNeighbors(Residue[] residues) {
        int nRes = residues.length;
        this.resNeighbors = new int[nRes][];
        this.bidiResNeighbors = new int[nRes][];
        for (int i = 0; i < nRes; ++i) {
            HashSet<Integer> nearby = new HashSet<Integer>();
            Residue resi = residues[i];
            Rotamer[] rotsi = resi.getRotamers();
            int lenri = rotsi.length;
            int indexI = this.allResiduesList.indexOf(resi);
            for (int j2 = 0; j2 < nRes; ++j2) {
                if (i == j2) continue;
                Residue resj = residues[j2];
                Rotamer[] rotsj = resj.getRotamers();
                int lenrj = rotsj.length;
                int indexJ = this.allResiduesList.indexOf(resj);
                boolean foundClose = false;
                for (int ri = 0; ri < lenri; ++ri) {
                    for (int rj = 0; rj < lenrj; ++rj) {
                        if (this.dM.checkPairDistThreshold(indexI, ri, indexJ, rj)) continue;
                        foundClose = true;
                        break;
                    }
                    if (foundClose) break;
                }
                if (!foundClose) continue;
                nearby.add(j2);
            }
            int[] nI = nearby.stream().mapToInt(Integer::intValue).toArray();
            this.bidiResNeighbors[i] = nI;
            int fi = i;
            nI = nearby.stream().mapToInt(Integer::intValue).filter(j -> j > fi).toArray();
            this.resNeighbors[i] = nI;
        }
    }

    private void setUpRestart() {
        File restartFile;
        if (this.loadEnergyRestart) {
            restartFile = this.energyRestartFile;
        } else {
            File file = this.molecularAssembly.getFile();
            String filename = FilenameUtils.removeExtension((String)file.getAbsolutePath());
            Path restartPath = Paths.get(filename + ".restart", new String[0]);
            this.energyRestartFile = restartFile = restartPath.toFile();
        }
        try {
            this.energyWriter = new BufferedWriter(new FileWriter(restartFile, true));
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Couldn't open energy restart file.", ex);
        }
        logger.info(String.format("\n Energy restart file: %s", restartFile.getName()));
    }

    private double rotamerEnergies(Residue[] residues) {
        if (residues == null) {
            logger.warning(" Attempt to compute rotamer energies for an empty array of residues.");
            return 0.0;
        }
        int nResidues = residues.length;
        Atom[] atoms = this.molecularAssembly.getAtomArray();
        this.generateResidueNeighbors(residues);
        this.eR = new EliminatedRotamers(this, this.dM, this.allResiduesList, this.maxRotCheckDepth, this.clashThreshold, this.pairClashThreshold, this.multiResClashThreshold, this.nucleicPruningFactor, this.nucleicPairsPruningFactor, this.multiResPairClashAddn, this.pruneClashes, this.prunePairClashes, false, residues);
        if (this.decomposeOriginal) {
            assert (this.library.getUsingOrigCoordsRotamer());
            for (int i = 0; i < nResidues; ++i) {
                Residue resi = residues[i];
                Rotamer[] rotsi = resi.getRotamers();
                int lenri = rotsi.length;
                for (int ri = 1; ri < lenri; ++ri) {
                    this.eR.eliminateRotamer(residues, i, ri, false);
                }
            }
        }
        for (Atom atom : atoms) {
            atom.setUse(true);
        }
        this.eE = new EnergyExpansion(this, this.dM, this.eR, this.molecularAssembly, this.potential, this.algorithmListener, this.allResiduesList, this.resNeighbors, this.threeBodyTerm, this.decomposeOriginal, this.usingBoxOptimization, this.verbose, this.pruneClashes, this.prunePairClashes, this.rank0);
        this.eR.setEnergyExpansion(this.eE);
        int loaded = 0;
        if (this.loadEnergyRestart) {
            loaded = this.usingBoxOptimization ? this.eE.loadEnergyRestart(this.energyRestartFile, residues, this.boxOpt.boxLoadIndex, this.boxOpt.boxLoadCellIndices) : this.eE.loadEnergyRestart(this.energyRestartFile, residues);
        }
        long energyStartTime = System.nanoTime();
        WorkerTeam energyWorkerTeam = new WorkerTeam(this.world);
        try {
            if (loaded < 1) {
                this.eE.allocateSelfJobMap(residues, nResidues, false);
            }
            SelfEnergyRegion selfEnergyRegion = new SelfEnergyRegion(this, this.eE, this.eR, residues, this.energyWriter, this.world, this.numProc, this.pruneClashes, this.rank0, this.rank, this.verbose, this.writeEnergyRestart, this.printFiles);
            energyWorkerTeam.execute((WorkerRegion)selfEnergyRegion);
            long singlesTime = System.nanoTime() - energyStartTime;
            this.logIfRank0(String.format(" Time for single energies: %12.4g", (double)singlesTime * 1.0E-9));
            if (logger.isLoggable(Level.FINE)) {
                Resources.logResources();
            }
            if (loaded < 2) {
                this.eE.allocate2BodyJobMap(residues, nResidues, false);
            }
            TwoBodyEnergyRegion twoBodyEnergyRegion = new TwoBodyEnergyRegion(this, this.dM, this.eE, this.eR, residues, this.allResiduesList, this.energyWriter, this.world, this.numProc, this.prunePairClashes, this.superpositionThreshold, this.rank0, this.rank, this.verbose, this.writeEnergyRestart, this.printFiles);
            energyWorkerTeam.execute((WorkerRegion)twoBodyEnergyRegion);
            long pairsTime = System.nanoTime() - (singlesTime + energyStartTime);
            long triplesTime = 0L;
            long quadsTime = 0L;
            this.logIfRank0(String.format(" Time for 2-body energies:   %12.4g", (double)pairsTime * 1.0E-9));
            if (logger.isLoggable(Level.FINE)) {
                Resources.logResources();
            }
            if (this.threeBodyTerm) {
                if (loaded < 3) {
                    this.eE.allocate3BodyJobMap(residues, nResidues, false);
                }
                ThreeBodyEnergyRegion threeBodyEnergyRegion = new ThreeBodyEnergyRegion(this, this.dM, this.eE, this.eR, residues, this.allResiduesList, this.energyWriter, this.world, this.numProc, this.superpositionThreshold, this.rank0, this.rank, this.verbose, this.writeEnergyRestart, this.printFiles);
                energyWorkerTeam.execute((WorkerRegion)threeBodyEnergyRegion);
                triplesTime = System.nanoTime() - (pairsTime + singlesTime + energyStartTime);
                this.logIfRank0(String.format(" Time for 3-Body energies: %12.4g", (double)triplesTime * 1.0E-9));
                if (logger.isLoggable(Level.FINE)) {
                    Resources.logResources();
                }
            }
            if (this.compute4BodyEnergy) {
                this.eE.allocate4BodyJobMap(residues, nResidues);
                FourBodyEnergyRegion fourBodyEnergyRegion = new FourBodyEnergyRegion(this, this.dM, this.eE, this.eR, residues, this.allResiduesList, this.superpositionThreshold);
                energyWorkerTeam.execute((WorkerRegion)fourBodyEnergyRegion);
                quadsTime = System.nanoTime() - (triplesTime + pairsTime + singlesTime + energyStartTime);
                this.logIfRank0(String.format(" Time for 4-Body energies:   %12.4g", (double)quadsTime * 1.0E-9));
            }
            long allTime = singlesTime + pairsTime + triplesTime + quadsTime;
            this.logIfRank0(String.format(" Time for all energies:    %12.4g", (double)allTime * 1.0E-9));
        }
        catch (Exception ex) {
            String message = " Exception computing rotamer energies in parallel.";
            logger.log(Level.SEVERE, message, ex);
        }
        for (Atom atom : atoms) {
            atom.setUse(true);
        }
        if (this.rank0) {
            try {
                double defaultEnergy = this.currentEnergy(residues);
                logger.info(String.format(" Energy of the system with rotamers in their default conformation: %s", this.formatEnergy(defaultEnergy)));
            }
            catch (ArithmeticException ex) {
                logger.severe(String.format(" Exception %s in calculating default energy; FFX shutting down", ex));
            }
        }
        return this.eE.getBackboneEnergy();
    }

    private void applyDefaultRotamer(Residue residue) {
        RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)residue.getRotamers()[0]);
    }

    private boolean deeRotamerElimination(Residue[] residues) {
        int nres = residues.length;
        boolean eliminated = false;
        double[] minMax = new double[2];
        double[] minEnergySingles = null;
        double[] maxEnergySingles = null;
        for (int i = 0; i < nres; ++i) {
            int ri;
            Residue residuei = residues[i];
            Rotamer[] rotamersi = residuei.getRotamers();
            int lenri = rotamersi.length;
            if (minEnergySingles == null || minEnergySingles.length < lenri) {
                minEnergySingles = new double[lenri];
                maxEnergySingles = new double[lenri];
            }
            for (int ri2 = 0; ri2 < lenri; ++ri2) {
                if (this.eR.check(i, ri2)) continue;
                minEnergySingles[ri2] = this.eE.getSelf(i, ri2);
                maxEnergySingles[ri2] = minEnergySingles[ri2];
                for (int j = 0; j < nres; ++j) {
                    if (j == i) continue;
                    if (this.eE.minMaxPairEnergy(residues, minMax, i, ri2, j)) {
                        if (Double.isFinite(minMax[0]) && Double.isFinite(minEnergySingles[ri2])) {
                            int n = ri2;
                            minEnergySingles[n] = minEnergySingles[n] + minMax[0];
                        } else {
                            minEnergySingles[ri2] = Double.NaN;
                        }
                        if (Double.isFinite(minMax[0]) && Double.isFinite(maxEnergySingles[ri2])) {
                            int n = ri2;
                            maxEnergySingles[n] = maxEnergySingles[n] + minMax[1];
                            continue;
                        }
                        maxEnergySingles[ri2] = Double.NaN;
                        continue;
                    }
                    Residue residuej = residues[j];
                    logger.info(String.format(" Inconsistent Pair: %8s %2d, %8s.", residuei.toFormattedString(false, true), ri2, residuej.toFormattedString(false, true)));
                }
            }
            double eliminationEnergy = Double.MAX_VALUE;
            int eliminatingRotamer = 0;
            for (ri = 0; ri < lenri; ++ri) {
                if (this.eR.check(i, ri) || !Double.isFinite(maxEnergySingles[ri]) || !(maxEnergySingles[ri] < eliminationEnergy)) continue;
                eliminationEnergy = maxEnergySingles[ri];
                eliminatingRotamer = ri;
            }
            if (eliminationEnergy == Double.MAX_VALUE) {
                this.logIfRank0(" Could not eliminate any i,ri because eliminationEnergy was never set!", Level.FINE);
                continue;
            }
            for (ri = 0; ri < lenri; ++ri) {
                if (this.eR.check(i, ri)) continue;
                if (!Double.isFinite(minEnergySingles[ri]) && this.eR.eliminateRotamer(residues, i, ri, false)) {
                    this.logIfRank0(String.format("  Rotamer elimination of (%8s,%2d) that always clashes.", residuei.toFormattedString(false, true), ri));
                    eliminated = true;
                }
                if (!(minEnergySingles[ri] > eliminationEnergy + this.ensembleBuffer) || !this.eR.eliminateRotamer(residues, i, ri, false)) continue;
                this.logIfRank0(String.format("  Rotamer elimination of (%8s,%2d) by (%8s,%2d): %12.4f > %6.4f.", residuei.toFormattedString(false, true), ri, residuei.toFormattedString(false, true), eliminatingRotamer, minEnergySingles[ri], eliminationEnergy + this.ensembleBuffer));
                eliminated = true;
            }
        }
        return eliminated;
    }

    private boolean deeRotamerPairElimination(Residue[] residues) {
        int nres = residues.length;
        boolean eliminated = false;
        for (int i = 0; i < nres - 1; ++i) {
            Residue residuei = residues[i];
            Rotamer[] rotamersi = residuei.getRotamers();
            int lenri = rotamersi.length;
            double[][] minPairEnergies = new double[lenri][];
            double[][] maxPairEnergies = new double[lenri][];
            for (int j = i + 1; j < nres; ++j) {
                Residue residuej = residues[j];
                Rotamer[] rotamersj = residuej.getRotamers();
                int lenrj = rotamersj.length;
                for (int ri = 0; ri < lenri; ++ri) {
                    if (this.eR.check(i, ri)) continue;
                    minPairEnergies[ri] = new double[lenrj];
                    maxPairEnergies[ri] = new double[lenrj];
                    for (int rj = 0; rj < lenrj; ++rj) {
                        if (this.eR.check(j, rj) || this.eR.check(i, ri, j, rj)) continue;
                        minPairEnergies[ri][rj] = this.eE.getSelf(i, ri) + this.eE.getSelf(j, rj) + this.eE.get2Body(i, ri, j, rj);
                        maxPairEnergies[ri][rj] = minPairEnergies[ri][rj];
                        double[] minMax = new double[2];
                        if (this.eE.minMaxE2(residues, minMax, i, ri, j, rj)) {
                            if (Double.isFinite(minPairEnergies[ri][rj]) && Double.isFinite(minMax[0])) {
                                double[] dArray = minPairEnergies[ri];
                                int n = rj;
                                dArray[n] = dArray[n] + minMax[0];
                            } else {
                                logger.severe(String.format(" An ri-rj pair %s-%d %s-%d with NaN minimum was caught incorrectly!", residuei.toFormattedString(false, true), ri, residuej.toFormattedString(false, true), rj));
                            }
                            if (Double.isFinite(maxPairEnergies[ri][rj]) && Double.isFinite(minMax[1])) {
                                double[] dArray = maxPairEnergies[ri];
                                int n = rj;
                                dArray[n] = dArray[n] + minMax[1];
                                continue;
                            }
                            maxPairEnergies[ri][rj] = Double.NaN;
                            continue;
                        }
                        minPairEnergies[ri][rj] = Double.NaN;
                        logger.info(String.format(" Eliminating pair %s-%d %s-%d that always clashes.", residuei.toFormattedString(false, true), ri, residuej.toFormattedString(false, true), rj));
                        this.eR.eliminateRotamerPair(residues, i, ri, j, rj, false);
                        eliminated = true;
                    }
                }
                double pairEliminationEnergy = Double.MAX_VALUE;
                for (int ri = 0; ri < lenri; ++ri) {
                    if (this.eR.check(i, ri)) continue;
                    for (int rj = 0; rj < lenrj; ++rj) {
                        if (this.eR.check(j, rj) || this.eR.check(i, ri, j, rj) || !Double.isFinite(maxPairEnergies[ri][rj]) || !(maxPairEnergies[ri][rj] < pairEliminationEnergy)) continue;
                        pairEliminationEnergy = maxPairEnergies[ri][rj];
                    }
                }
                if (pairEliminationEnergy == Double.MAX_VALUE) {
                    this.logIfRank0(String.format(" All rotamer pairs for residues %s and %s have possible conflicts; cannot perform any eliminations!", residuei.toFormattedString(false, true), residuej), Level.FINE);
                } else {
                    double comparisonEnergy = pairEliminationEnergy + this.ensembleBuffer;
                    for (int ri = 0; ri < lenri; ++ri) {
                        if (this.eR.check(i, ri)) continue;
                        for (int rj = 0; rj < lenrj; ++rj) {
                            if (this.eR.check(j, rj) || this.eR.check(i, ri, j, rj) || !(minPairEnergies[ri][rj] > comparisonEnergy)) continue;
                            if (this.eR.eliminateRotamerPair(residues, i, ri, j, rj, false)) {
                                eliminated = true;
                                this.logIfRank0(String.format(" Eliminating rotamer pair: %s %d, %s %d (%s > %s + %6.6f)", residuei.toFormattedString(false, true), ri, residuej.toFormattedString(false, true), rj, this.formatEnergy(minPairEnergies[ri][rj]), this.formatEnergy(pairEliminationEnergy), this.ensembleBuffer), Level.INFO);
                                continue;
                            }
                            this.logIfRank0(String.format(" Already eliminated rotamer pair! %s %d, %s %d (%s > %1s + %6.6f)", residuei.toFormattedString(false, true), ri, residuej.toFormattedString(false, true), rj, this.formatEnergy(minPairEnergies[ri][rj]), this.formatEnergy(pairEliminationEnergy), this.ensembleBuffer), Level.WARNING);
                        }
                    }
                }
                if (!this.eR.pairsToSingleElimination(residues, i, j)) continue;
                eliminated = true;
            }
        }
        return eliminated;
    }

    private boolean goldsteinDriver(Residue[] residues) {
        int nres = residues.length;
        boolean eliminated = false;
        for (int i = 0; i < nres; ++i) {
            Residue resi = residues[i];
            Rotamer[] roti = resi.getRotamers();
            int nri = roti.length;
            block1: for (int riA = 0; riA < nri; ++riA) {
                if (this.eR.check(i, riA)) continue;
                for (int riB = 0; riB < nri; ++riB) {
                    if (riA == riB || this.eR.check(i, riB) || !this.goldsteinElimination(residues, i, riA, riB)) continue;
                    eliminated = true;
                    continue block1;
                }
            }
        }
        if (!eliminated) {
            this.logIfRank0(" No more single rotamers to eliminate.");
        }
        return eliminated;
    }

    private boolean goldsteinElimination(Residue[] residues, int i, int riA, int riB) {
        double selfDiff;
        Residue resi = residues[i];
        double goldsteinEnergy = selfDiff = this.eE.getSelf(i, riA) - this.eE.getSelf(i, riB);
        double sumPairDiff = 0.0;
        double sumTripleDiff = 0.0;
        for (int j : this.bidiResNeighbors[i]) {
            Residue resj = residues[j];
            Rotamer[] rotj = resj.getRotamers();
            int nrj = rotj.length;
            double minForResJ = Double.MAX_VALUE;
            double minPairDiff = 0.0;
            double minTripleDiff = 0.0;
            int rjEvals = 0;
            for (int rj = 0; rj < nrj; ++rj) {
                double sumOverK;
                if (this.eR.check(j, rj) || this.eR.check(i, riA, j, rj)) continue;
                if (this.eR.check(i, riB, j, rj)) {
                    return false;
                }
                double pairI = this.eE.get2Body(i, riA, j, rj);
                double pairJ = this.eE.get2Body(i, riB, j, rj);
                double pairDiff = pairI - pairJ;
                ++rjEvals;
                double tripleDiff = 0.0;
                if (this.threeBodyTerm) {
                    int[] possKs;
                    IntStream kStream = IntStream.concat(Arrays.stream(this.bidiResNeighbors[i]), Arrays.stream(this.bidiResNeighbors[j]));
                    for (int k : possKs = kStream.distinct().sorted().toArray()) {
                        if (k == i || k == j) continue;
                        Residue resk = residues[k];
                        Rotamer[] rotk = resk.getRotamers();
                        int nrk = rotk.length;
                        int rkEvals = 0;
                        double minForResK = Double.MAX_VALUE;
                        for (int rk = 0; rk < nrk; ++rk) {
                            if (this.eR.check(k, rk) || this.eR.check(j, rj, k, rk) || this.eR.check(i, riA, k, rk)) continue;
                            if (this.eR.check(i, riB, k, rk)) {
                                return false;
                            }
                            ++rkEvals;
                            double e = this.eE.get3Body(residues, i, riA, j, rj, k, rk) - this.eE.get3Body(residues, i, riB, j, rj, k, rk);
                            if (!(e < minForResK)) continue;
                            minForResK = e;
                        }
                        if (rkEvals == 0) {
                            minForResK = 0.0;
                        }
                        tripleDiff += minForResK;
                    }
                }
                if (!((sumOverK = pairDiff + tripleDiff) < minForResJ)) continue;
                minForResJ = sumOverK;
                minPairDiff = pairDiff;
                minTripleDiff = tripleDiff;
            }
            if (rjEvals == 0) {
                minForResJ = 0.0;
                minPairDiff = 0.0;
                minTripleDiff = 0.0;
            }
            sumPairDiff += minPairDiff;
            sumTripleDiff += minTripleDiff;
            goldsteinEnergy += minForResJ;
        }
        if (goldsteinEnergy > this.ensembleBuffer && this.eR.eliminateRotamer(residues, i, riA, false)) {
            this.logIfRank0(String.format("  Rotamer elimination of (%8s,%2d) by (%8s,%2d): %12.4f > %6.4f.", resi.toFormattedString(false, true), riA, resi.toFormattedString(false, true), riB, goldsteinEnergy, this.ensembleBuffer));
            this.logIfRank0(String.format("   Self: %12.4f, Pairs: %12.4f, Triples: %12.4f.", selfDiff, sumPairDiff, sumTripleDiff));
            return true;
        }
        return false;
    }

    private boolean goldsteinPairDriver(Residue[] residues) {
        int nRes = residues.length;
        boolean eliminated = false;
        for (int i = 0; i < nRes; ++i) {
            Residue resi = residues[i];
            Rotamer[] rotsi = resi.getRotamers();
            int lenri = rotsi.length;
            for (int riA = 0; riA < lenri; ++riA) {
                if (this.eR.check(i, riA)) continue;
                for (int j = 0; j < nRes; ++j) {
                    if (i == j) continue;
                    Residue resj = residues[j];
                    Rotamer[] rotsj = resj.getRotamers();
                    int lenrj = rotsj.length;
                    for (int rjC = 0; rjC < lenrj; ++rjC) {
                        if (this.eR.check(j, rjC) || this.eR.check(i, riA, j, rjC)) continue;
                        boolean breakOut = false;
                        for (int riB = 0; riB < lenri && !breakOut; ++riB) {
                            if (this.eR.check(i, riB)) continue;
                            for (int rjD = 0; rjD < lenrj && !breakOut; ++rjD) {
                                if (this.eR.check(j, rjD) || this.eR.check(i, riB, j, rjD) || riA == riB && rjC == rjD || !this.goldsteinPairElimination(residues, i, riA, riB, j, rjC, rjD)) continue;
                                breakOut = true;
                                eliminated = true;
                            }
                        }
                    }
                    if (!this.eR.pairsToSingleElimination(residues, i, j)) continue;
                    eliminated = true;
                }
            }
        }
        return eliminated;
    }

    private boolean goldsteinPairElimination(Residue[] residues, int i, int riA, int riB, int j, int rjC, int rjD) {
        ArrayList<Residue> missedResidues = null;
        double goldsteinEnergy = this.eE.getSelf(i, riA) + this.eE.getSelf(j, rjC) + this.eE.get2Body(i, riA, j, rjC) - this.eE.getSelf(i, riB) - this.eE.getSelf(j, rjD) - this.eE.get2Body(i, riB, j, rjD);
        try {
            if (this.parallelTeam == null) {
                this.parallelTeam = new ParallelTeam();
            }
            if (this.goldsteinPairRegion == null) {
                this.goldsteinPairRegion = new GoldsteinPairRegion(this.parallelTeam.getThreadCount());
            }
            this.goldsteinPairRegion.init(residues, i, riA, riB, j, rjC, rjD, this.bidiResNeighbors, this);
            this.parallelTeam.execute((ParallelRegion)this.goldsteinPairRegion);
            goldsteinEnergy += this.goldsteinPairRegion.getSumOverK();
            missedResidues = this.goldsteinPairRegion.getMissedResidues();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, " Exception in GoldsteinPairRegion.", e);
        }
        if (missedResidues != null && !missedResidues.isEmpty()) {
            this.logIfRank0(String.format(" Skipping energy comparison due to a missed residue: i %d riA %d riB %d j %d rjC %d rjD %d", i, riA, riB, j, rjC, rjD), Level.FINE);
            return false;
        }
        if (goldsteinEnergy > this.ensembleBuffer) {
            if (missedResidues.isEmpty()) {
                if (this.eR.eliminateRotamerPair(residues, i, riA, j, rjC, false)) {
                    this.logIfRank0(String.format("  Pair elimination of [(%8s,%2d),(%8s,%2d)] by [(%8s,%2d),(%8s,%2d)]: %12.4f > %6.4f", residues[i].toFormattedString(false, true), riA, residues[j].toFormattedString(false, true), rjC, residues[i].toFormattedString(false, true), riB, residues[j].toFormattedString(false, true), rjD, goldsteinEnergy, this.ensembleBuffer));
                    return true;
                }
            } else {
                this.logIfRank0(String.format("  No Pair elimination of [(%8s,%2d),(%8s,%2d)] by [(%8s,%2d),(%8s,%2d)]: %12.4f > %6.4f", residues[i].toFormattedString(false, true), riA, residues[j].toFormattedString(false, true), rjC, residues[i].toFormattedString(false, true), riB, residues[j].toFormattedString(false, true), rjD, goldsteinEnergy, this.ensembleBuffer));
                StringBuilder sb = new StringBuilder();
                for (Residue residueM : missedResidues) {
                    sb.append(residueM);
                }
                this.logIfRank0(String.format("   due to %s.", sb));
            }
        }
        return false;
    }

    void setTestOverallOpt(boolean testing) {
        this.testing = testing;
        this.distanceMethod = DistanceMethod.ROTAMER;
        this.setTwoBodyCutoff(Double.MAX_VALUE);
        this.setThreeBodyCutoff(9.0);
    }

    void setTestSelfEnergyEliminations(boolean testSelfEnergyEliminations) {
        this.testing = true;
        this.testSelfEnergyEliminations = testSelfEnergyEliminations;
        this.testPairEnergyEliminations = -1;
        this.testTripleEnergyEliminations1 = -1;
        this.testTripleEnergyEliminations2 = -1;
        this.distanceMethod = DistanceMethod.ROTAMER;
        this.setTwoBodyCutoff(Double.MAX_VALUE);
        this.setThreeBodyCutoff(9.0);
    }

    void setTestPairEnergyEliminations(int testPairEnergyEliminations) {
        this.testing = true;
        this.testPairEnergyEliminations = testPairEnergyEliminations;
        this.testSelfEnergyEliminations = false;
        this.testTripleEnergyEliminations1 = -1;
        this.testTripleEnergyEliminations2 = -1;
        this.distanceMethod = DistanceMethod.ROTAMER;
        this.setTwoBodyCutoff(Double.MAX_VALUE);
        this.setThreeBodyCutoff(9.0);
    }

    void setTestTripleEnergyEliminations(int testTripleEnergyEliminations1, int testTripleEnergyEliminations2) {
        this.testing = true;
        this.testTripleEnergyEliminations1 = testTripleEnergyEliminations1;
        this.testTripleEnergyEliminations2 = testTripleEnergyEliminations2;
        this.testSelfEnergyEliminations = false;
        this.testPairEnergyEliminations = -1;
        this.distanceMethod = DistanceMethod.ROTAMER;
        this.setTwoBodyCutoff(Double.MAX_VALUE);
        this.setThreeBodyCutoff(9.0);
    }

    private void testSelfEnergyElimination(Residue[] residues) {
        int nRes = residues.length;
        for (int i = 0; i < nRes; ++i) {
            Residue resI = residues[i];
            Rotamer[] rotI = resI.getRotamers();
            int nI = rotI.length;
            for (int ri = 0; ri < nI; ++ri) {
                for (int j = i + 1; j < nRes; ++j) {
                    Residue resJ = residues[j];
                    Rotamer[] rotJ = resJ.getRotamers();
                    int nJ = rotJ.length;
                    for (int rj = 0; rj < nJ; ++rj) {
                        try {
                            this.eE.set2Body(i, ri, j, rj, 0.0, true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!this.threeBodyTerm) continue;
                        for (int k = j + 1; k < nRes; ++k) {
                            Residue resK = residues[k];
                            Rotamer[] rotK = resK.getRotamers();
                            int nK = rotK.length;
                            for (int rk = 0; rk < nK; ++rk) {
                                try {
                                    this.eE.set3Body(residues, i, ri, j, rj, k, rk, 0.0, true);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void testPairEnergyElimination(Residue[] residues, int resID) {
        int nRes = residues.length;
        if (resID >= nRes) {
            return;
        }
        for (int i = 0; i < nRes; ++i) {
            Residue resI = residues[i];
            Rotamer[] rotI = resI.getRotamers();
            int nI = rotI.length;
            for (int ri = 0; ri < nI; ++ri) {
                try {
                    this.eE.setSelf(i, ri, 0.0, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int j = i + 1; j < nRes; ++j) {
                    Residue resJ = residues[j];
                    Rotamer[] rotJ = resJ.getRotamers();
                    int nJ = rotJ.length;
                    for (int rj = 0; rj < nJ; ++rj) {
                        if (i != resID && j != resID) {
                            try {
                                this.eE.set2Body(i, ri, j, rj, 0.0, true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!this.threeBodyTerm) continue;
                        for (int k = j + 1; k < nRes; ++k) {
                            Residue resK = residues[k];
                            Rotamer[] rotK = resK.getRotamers();
                            int nK = rotK.length;
                            for (int rk = 0; rk < nK; ++rk) {
                                try {
                                    this.eE.set3Body(residues, i, ri, j, rj, k, rk, 0.0, true);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void testTripleEnergyElimination(Residue[] residues, int resID1, int resID2) {
        int nRes = residues.length;
        if (resID1 >= nRes) {
            return;
        }
        if (resID2 >= nRes) {
            return;
        }
        if (resID1 == resID2) {
            return;
        }
        for (int i = 0; i < nRes; ++i) {
            Residue resI = residues[i];
            Rotamer[] rotI = resI.getRotamers();
            int nI = rotI.length;
            for (int ri = 0; ri < nI; ++ri) {
                try {
                    this.eE.setSelf(i, ri, 0.0, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int j = i + 1; j < nRes; ++j) {
                    Residue resJ = residues[j];
                    Rotamer[] rotJ = resJ.getRotamers();
                    int nJ = rotJ.length;
                    for (int rj = 0; rj < nJ; ++rj) {
                        try {
                            this.eE.set2Body(i, ri, j, rj, 0.0, true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!this.threeBodyTerm) continue;
                        for (int k = j + 1; k < nRes; ++k) {
                            Residue resK = residues[k];
                            Rotamer[] rotK = resK.getRotamers();
                            int nK = rotK.length;
                            for (int rk = 0; rk < nK; ++rk) {
                                if (i != resID1 && j != resID1 && k != resID1) {
                                    try {
                                        this.eE.set3Body(residues, i, ri, j, rj, k, rk, 0.0, true);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (i == resID2 || j == resID2 || k == resID2) continue;
                                try {
                                    this.eE.set3Body(residues, i, ri, j, rj, k, rk, 0.0, true);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }

    public static enum DistanceMethod {
        ROTAMER,
        RESIDUE;

    }

    public static enum Algorithm {
        INDEPENDENT,
        ALL,
        BRUTE_FORCE,
        WINDOW,
        BOX;


        public static Algorithm getAlgorithm(int algorithm) {
            switch (algorithm) {
                case 1: {
                    return INDEPENDENT;
                }
                case 2: {
                    return ALL;
                }
                case 3: {
                    return BRUTE_FORCE;
                }
                case 4: {
                    return WINDOW;
                }
                case 5: {
                    return BOX;
                }
            }
            throw new IllegalArgumentException(String.format(" Algorithm choice was %d, not in range 1-5!", algorithm));
        }
    }
}

