/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.Terminatable;
import ffx.algorithms.optimize.MinimizeOpenMM;
import ffx.numerics.OptimizationInterface;
import ffx.numerics.Potential;
import ffx.numerics.optimization.LBFGS;
import ffx.numerics.optimization.LineSearch;
import ffx.numerics.optimization.OptimizationListener;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.Platform;
import ffx.potential.openmm.OpenMMEnergy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;

public class Minimize
implements OptimizationListener,
Terminatable {
    private static final Logger logger = Logger.getLogger(Minimize.class.getName());
    protected final MolecularAssembly molecularAssembly;
    protected final Potential potential;
    protected final AlgorithmListener algorithmListener;
    protected final int n;
    protected final double[] x;
    protected final double[] grad;
    protected final double[] scaling;
    protected boolean done = false;
    protected boolean terminate = false;
    protected long time;
    protected List<Double> energyList = new ArrayList<Double>();
    protected double energy;
    protected int status;
    protected int nSteps;
    double rmsGradient;
    public static final int DEFAULT_LBFGS_VECTORS = 7;

    public Minimize(MolecularAssembly molecularAssembly, Potential potential, AlgorithmListener algorithmListener) {
        this.molecularAssembly = molecularAssembly;
        this.algorithmListener = algorithmListener;
        this.potential = potential;
        this.n = potential.getNumberOfVariables();
        this.x = new double[this.n];
        this.grad = new double[this.n];
        this.scaling = new double[this.n];
        Arrays.fill(this.scaling, 12.0);
    }

    public Minimize(MolecularAssembly molecularAssembly, AlgorithmListener algorithmListener) {
        this.molecularAssembly = molecularAssembly;
        this.algorithmListener = algorithmListener;
        if (molecularAssembly.getPotentialEnergy() == null) {
            molecularAssembly.setPotential(ForceFieldEnergy.energyFactory((MolecularAssembly)molecularAssembly));
        }
        this.potential = molecularAssembly.getPotentialEnergy();
        this.n = this.potential.getNumberOfVariables();
        this.x = new double[this.n];
        this.grad = new double[this.n];
        this.scaling = new double[this.n];
        Arrays.fill(this.scaling, 12.0);
    }

    public static MinimizationEngine defaultEngine(MolecularAssembly molecularAssembly, Potential potentialEnergy) {
        CompositeConfiguration properties = molecularAssembly.getProperties();
        String minimizeEngine = properties.getString("minimize-engine", null);
        if (minimizeEngine != null) {
            if (minimizeEngine.equalsIgnoreCase("OMM")) {
                return MinimizationEngine.OPENMM;
            }
            return MinimizationEngine.FFX;
        }
        if (potentialEnergy instanceof OpenMMEnergy) {
            return MinimizationEngine.OPENMM;
        }
        return MinimizationEngine.FFX;
    }

    public static Minimize minimizeFactory(MolecularAssembly assembly, Potential potentialEnergy, AlgorithmListener listener, MinimizationEngine engine) {
        return switch (engine.ordinal()) {
            case 1 -> new MinimizeOpenMM(assembly, (OpenMMEnergy)potentialEnergy, listener);
            default -> new Minimize(assembly, potentialEnergy, listener);
        };
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getRMSGradient() {
        return this.rmsGradient;
    }

    public int getStatus() {
        return this.status;
    }

    public int getIterations() {
        return this.nSteps;
    }

    public List<Double> getEnergyList() {
        return this.energyList;
    }

    public Potential minimize() {
        return this.minimize(7, 1.0, Integer.MAX_VALUE);
    }

    public Potential minimize(double eps) {
        return this.minimize(7, eps, Integer.MAX_VALUE);
    }

    public Potential minimize(double eps, int maxIterations) {
        return this.minimize(7, eps, maxIterations);
    }

    public Potential minimize(int m, double eps, int maxIterations) {
        this.time = System.nanoTime();
        this.potential.getCoordinates(this.x);
        this.potential.setScaling(this.scaling);
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            this.x[n] = this.x[n] * this.scaling[i];
        }
        this.done = false;
        this.energy = this.potential.energyAndGradient(this.x, this.grad);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format(" Minimize initial energy: %16.8f", this.energy));
        }
        this.status = LBFGS.minimize((int)this.n, (int)m, (double[])this.x, (double)this.energy, (double[])this.grad, (double)eps, (int)maxIterations, (OptimizationInterface)this.potential, (OptimizationListener)this);
        this.done = true;
        switch (this.status) {
            case 0: {
                logger.info(String.format("\n Optimization achieved convergence criteria: %8.5f", this.rmsGradient));
                break;
            }
            case 1: {
                logger.info(String.format("\n Optimization terminated at step %d.", this.nSteps));
                break;
            }
            default: {
                logger.warning("\n Optimization failed.");
            }
        }
        this.potential.setScaling(null);
        return this.potential;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" Minimize Results:\n");
        sb.append(String.format("  Number of Variables:    %16d\n", this.n));
        sb.append(String.format("  Number of Iterations:   %16d\n", this.nSteps));
        sb.append(String.format("  Final Energy:           %16.6f (kcal/mol)\n", this.energy));
        sb.append(String.format("  RMS Gradient:           %16.6f (kcal/mol/A)\n", this.rmsGradient));
        return sb.toString();
    }

    public boolean optimizationUpdate(int iteration, int nBFGS, int functionEvaluations, double rmsGradient, double rmsCoordinateChange, double energy, double energyChange, double angle, LineSearch.LineSearchResult lineSearchResult) {
        long currentTime = System.nanoTime();
        Double seconds = (double)(currentTime - this.time) * 1.0E-9;
        this.time = currentTime;
        this.rmsGradient = rmsGradient;
        this.nSteps = iteration;
        this.energy = energy;
        if (iteration == 0) {
            this.energyList.clear();
            if (nBFGS > 0) {
                logger.info("\n Limited Memory BFGS Quasi-Newton Optimization: \n");
            } else {
                logger.info("\n Steepest Decent Optimization: \n");
            }
            logger.info(" Cycle       Energy      G RMS    Delta E   Delta X    Angle  Evals     Time\n");
        }
        this.energyList.add(energy);
        if (lineSearchResult == null) {
            logger.info(String.format("%6d%13.4f%11.4f", iteration, energy, rmsGradient));
        } else if (lineSearchResult == LineSearch.LineSearchResult.Success) {
            logger.info(String.format("%6d%13.4f%11.4f%11.4f%10.4f%9.2f%7d %8.3f", iteration, energy, rmsGradient, energyChange, rmsCoordinateChange, angle, functionEvaluations, seconds));
        } else {
            logger.info(String.format("%6d%13.4f%11.4f%11.4f%10.4f%9.2f%7d %8s", iteration, energy, rmsGradient, energyChange, rmsCoordinateChange, angle, functionEvaluations, lineSearchResult));
        }
        if (this.algorithmListener != null) {
            this.algorithmListener.algorithmUpdate(this.molecularAssembly);
        }
        if (this.terminate) {
            logger.info(" The optimization received a termination request.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        this.terminate = true;
        while (!this.done) {
            Minimize minimize = this;
            synchronized (minimize) {
                try {
                    this.wait(1L);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception terminating minimization.\n", e);
                }
            }
        }
    }

    public static enum MinimizationEngine {
        FFX(true, true),
        OPENMM(false, true);

        private final EnumSet<Platform> platforms = EnumSet.noneOf(Platform.class);

        private MinimizationEngine(boolean ffx, boolean openMM) {
            if (ffx) {
                this.platforms.add(Platform.FFX);
            }
            if (openMM) {
                this.platforms.add(Platform.OMM);
                this.platforms.add(Platform.OMM_REF);
                this.platforms.add(Platform.OMM_CUDA);
                this.platforms.add(Platform.OMM_OPENCL);
                this.platforms.add(Platform.OMM_CPU);
            }
        }

        public EnumSet<Platform> getSupportedPlatforms() {
            return EnumSet.copyOf(this.platforms);
        }

        public boolean supportsPlatform(Platform platform) {
            return this.platforms.contains(platform);
        }
    }
}

