/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.mc;

import ffx.algorithms.mc.MCMove;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.ResidueState;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.bonded.Torsion;
import java.util.concurrent.ThreadLocalRandom;

public class RosenbluthChi0Move
implements MCMove {
    public final double theta;
    private final Residue target;
    private final ResidueState origState;
    private final Rotamer newState;

    RosenbluthChi0Move(Residue target) {
        this.target = target;
        AminoAcidUtils.AminoAcid3 name = AminoAcidUtils.AminoAcid3.valueOf((String)target.getName());
        this.origState = target.storeState();
        double[] chi = RotamerLibrary.measureRotamer((Residue)target, (boolean)false);
        chi[0] = this.theta = ThreadLocalRandom.current().nextDouble(360.0) - 180.0;
        double[] values = new double[chi.length * 2];
        for (int i = 0; i < chi.length; ++i) {
            int ii = 2 * i;
            values[ii] = chi[i];
            values[ii + 1] = 0.0;
        }
        this.newState = new Rotamer(name, values);
    }

    @Override
    public void move() {
        RotamerLibrary.applyRotamer((Residue)this.target, (Rotamer)this.newState);
        this.updateTorsions();
    }

    @Override
    public void revertMove() {
        this.target.revertState(this.origState);
        this.updateTorsions();
    }

    public String toString() {
        return String.format("Rosenbluth Rotamer Move:\n   Res:   %s\n   Theta: %3.2f", this.target.toString(), this.theta);
    }

    private void updateTorsions() {
        for (Torsion torsion : this.target.getTorsionList()) {
            torsion.update();
        }
    }
}

