/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.mc;

import ffx.algorithms.mc.BoltzmannMC;
import ffx.numerics.Potential;
import ffx.potential.AssemblyState;
import ffx.potential.MolecularAssembly;
import java.util.logging.Logger;

public class MolecularMC
extends BoltzmannMC {
    private static final Logger logger = Logger.getLogger(MolecularMC.class.getName());
    private final MolecularAssembly molecularAssembly;
    private final Potential potential;
    private double[] x;
    private AssemblyState initialState;

    public MolecularMC(MolecularAssembly molecularAssembly) {
        this(molecularAssembly, (Potential)molecularAssembly.getPotentialEnergy());
    }

    public MolecularMC(MolecularAssembly molecularAssembly, Potential potential) {
        this.molecularAssembly = molecularAssembly;
        this.potential = potential;
    }

    public MolecularAssembly getMolecularAssembly() {
        return this.molecularAssembly;
    }

    public Potential getPotential() {
        return this.potential;
    }

    @Override
    public void revertStep() {
        this.initialState.revertState();
    }

    public String toString() {
        return "Default Metropolis Monte Carlo implementation\nTemperature: " + this.getTemperature() + String.format("\ne1: %10.6f   e2: %10.6f\nMolecular Assembly", this.getE1(), this.getE2()) + this.molecularAssembly.toString() + "\nPotential: " + this.potential.toString();
    }

    @Override
    protected double currentEnergy() {
        if (this.x == null) {
            int nVar = this.potential.getNumberOfVariables();
            this.x = new double[nVar * 3];
        }
        try {
            this.potential.getCoordinates(this.x);
            return this.potential.energy(this.x);
        }
        catch (ArithmeticException ex) {
            logger.warning(ex.getMessage());
            return 1.0E100;
        }
    }

    @Override
    protected void storeState() {
        this.initialState = new AssemblyState(this.molecularAssembly);
    }
}

