/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.mc;

import ffx.algorithms.dynamics.thermostats.Thermostat;
import ffx.algorithms.mc.MonteCarloListener;
import ffx.algorithms.optimize.Minimize;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.utils.Loop;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class MCLoop
implements MonteCarloListener {
    private static final Logger logger = Logger.getLogger(MCLoop.class.getName());
    private final MolecularAssembly molecularAssembly;
    private final Thermostat thermostat;
    private final int firstResidue;
    private final int endResidue;
    private final Random random = new Random();
    private final ForceFieldEnergy forceFieldEnergy;
    final Loop loop;
    private int stepCount = 0;
    private final int mcStepFrequency;
    private int numMovesAccepted = 0;
    private int iterations;
    private Atom[] atoms;
    private boolean skipAlgorithm = false;

    MCLoop(MolecularAssembly molecularAssembly, int mcStepFrequency, Thermostat thermostat, int firstResidue, int endResidue) {
        this.molecularAssembly = molecularAssembly;
        this.atoms = molecularAssembly.getAtomArray();
        this.forceFieldEnergy = molecularAssembly.getPotentialEnergy();
        this.mcStepFrequency = mcStepFrequency == 0 ? Integer.MAX_VALUE : mcStepFrequency;
        this.thermostat = thermostat;
        double systemReferenceEnergy = molecularAssembly.getPotentialEnergy().energy(false, true);
        this.firstResidue = firstResidue;
        this.endResidue = endResidue;
        this.iterations = 1;
        if (endResidue - firstResidue < 3) {
            logger.info("MCLoop requires at least 3 residues. First and last residues are anchors.");
            this.skipAlgorithm = true;
        }
        String sb = " Running MCLoop:\n" + String.format("     mcStepFrequency: %4d\n", mcStepFrequency) + String.format("     referenceEnergy: %7.2f\n", systemReferenceEnergy);
        logger.info(sb);
        this.loop = new Loop(molecularAssembly);
    }

    public double getAcceptanceRate() {
        int numTries = this.stepCount / this.mcStepFrequency;
        return (double)this.numMovesAccepted / (double)numTries;
    }

    @Override
    public boolean mcUpdate(double temperature) {
        ++this.stepCount;
        if (this.skipAlgorithm) {
            return false;
        }
        if (this.stepCount % this.mcStepFrequency != 0) {
            return false;
        }
        this.atoms = this.molecularAssembly.getAtomArray();
        int midResidue = ThreadLocalRandom.current().nextInt(this.firstResidue + 1, this.endResidue);
        List loopSolutions = this.loop.generateLoops(midResidue - 1, midResidue + 1);
        for (int i = 1; i < this.iterations; ++i) {
            midResidue = ThreadLocalRandom.current().nextInt(this.firstResidue + 1, this.endResidue);
            if (!loopSolutions.isEmpty()) {
                List tempLoops = this.loop.generateLoops(midResidue - 1, midResidue + 1, (double[])loopSolutions.get(this.random.nextInt(loopSolutions.size())));
                loopSolutions.addAll(tempLoops);
                continue;
            }
            loopSolutions = this.loop.generateLoops(midResidue - 1, midResidue + 1);
        }
        int numLoopsFound = loopSolutions.size();
        if (numLoopsFound <= 1) {
            return false;
        }
        return this.tryLoopStep(loopSolutions);
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    private boolean tryLoopStep(List<double[]> loopSolutions) {
        double[] newCoords = loopSolutions.get(this.random.nextInt(loopSolutions.size()));
        double[] oldCoords = this.storeActiveCoordinates();
        Minimize minimize1 = new Minimize(null, (Potential)this.forceFieldEnergy, null);
        minimize1.minimize();
        double originalLoopEnergy = this.forceFieldEnergy.energy(false, true);
        this.performLoopMove(newCoords);
        Minimize minimize2 = new Minimize(null, (Potential)this.forceFieldEnergy, null);
        minimize2.minimize();
        double newLoopEnergy = this.forceFieldEnergy.energy(false, true);
        double temperature = this.thermostat.getCurrentTemperature();
        double kT = 0.0019872042586408316 * temperature;
        double dE = Math.abs(originalLoopEnergy - newLoopEnergy);
        if (newLoopEnergy < originalLoopEnergy) {
            dE = -dE;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" Assessing possible MC loop move step:\n");
        sb.append(String.format("     original loop: %16.8f\n", originalLoopEnergy));
        sb.append(String.format("     possible loop: %16.8f\n", newLoopEnergy));
        sb.append("     -----\n");
        if (dE < 0.0) {
            sb.append("     Accepted!");
            logger.info(sb.toString());
            ++this.numMovesAccepted;
            return true;
        }
        double criterion = FastMath.exp((double)(-dE / kT));
        double metropolis = FastMath.random();
        sb.append(String.format("     criterion:  %9.4f\n", criterion));
        sb.append(String.format("     rng:        %9.4f\n", metropolis));
        if (metropolis < criterion) {
            sb.append("     Accepted!");
            logger.info(sb.toString());
            ++this.numMovesAccepted;
            return true;
        }
        sb.append("     Denied.");
        logger.info(sb.toString());
        this.performLoopMove(oldCoords);
        return false;
    }

    private void performLoopMove(double[] newCoordinates) {
        int index = 0;
        for (Atom a : this.atoms) {
            double x = newCoordinates[index++];
            double y = newCoordinates[index++];
            double z = newCoordinates[index++];
            a.moveTo(x, y, z);
        }
    }

    private double[] storeActiveCoordinates() {
        double[] coords = new double[this.atoms.length * 3];
        int index = 0;
        for (Atom a : this.atoms) {
            coords[index++] = a.getX();
            coords[index++] = a.getY();
            coords[index++] = a.getZ();
        }
        return coords;
    }
}

