/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.dynamics.thermostats;

import ffx.algorithms.dynamics.thermostats.Thermostat;
import ffx.algorithms.dynamics.thermostats.ThermostatEnum;
import ffx.numerics.Constraint;
import ffx.numerics.Potential;
import ffx.potential.SystemState;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.util.FastMath;

public class Bussi
extends Thermostat {
    private final Random bussiRandom;
    private double tau;

    public Bussi(SystemState state, Potential.VARIABLE_TYPE[] type, double targetTemperature, double tau) {
        this(state, type, targetTemperature, tau, Collections.emptyList());
    }

    public Bussi(SystemState state, Potential.VARIABLE_TYPE[] type, double targetTemperature, double tau, List<Constraint> constraints) {
        super(state, type, targetTemperature, constraints);
        this.name = ThermostatEnum.BUSSI;
        this.tau = tau;
        this.bussiRandom = new Random();
    }

    public Bussi(SystemState state, Potential.VARIABLE_TYPE[] type, double targetTemperature) {
        this(state, type, targetTemperature, 0.2);
    }

    @Override
    public void fullStep(double dt) {
        double expTau = FastMath.exp((double)(-dt / this.tau));
        double tempRatio = this.targetTemperature / this.state.getTemperature();
        double rate = (1.0 - expTau) * tempRatio / (double)this.degreesOfFreedom;
        double r = this.bussiRandom.nextGaussian();
        double s = 0.0;
        for (int i = 0; i < this.degreesOfFreedom - 1; ++i) {
            double si = this.bussiRandom.nextGaussian();
            s += si * si;
        }
        double scale = expTau + (s + r * r) * rate + 2.0 * r * FastMath.sqrt((double)(expTau * rate));
        scale = FastMath.sqrt((double)scale);
        if (r + FastMath.sqrt((double)(expTau / rate)) < 0.0) {
            scale = -scale;
        }
        double[] v = this.state.v();
        double[] mass = this.state.getMass();
        for (int i = 0; i < this.state.getNumberOfVariables(); ++i) {
            if (!(mass[i] > 0.0)) continue;
            int n = i;
            v[n] = v[n] * scale;
        }
    }

    public double getTau() {
        return this.tau;
    }

    public void setTau(double tau) {
        this.tau = tau;
    }

    @Override
    public void halfStep(double dt) {
    }

    @Override
    public void setRandomSeed(long seed) {
        this.bussiRandom.setSeed(seed);
    }

    public String toThermostatString() {
        return String.format("\n Bussi Thermostat (tau = %8.3f psec)\n%s", this.tau, super.toString());
    }

    @Override
    public String toString() {
        return "Bussi";
    }
}

