/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.dynamics.integrators;

import ffx.algorithms.dynamics.integrators.Integrator;
import ffx.numerics.Potential;
import ffx.potential.SystemState;
import java.util.Arrays;

public class VelocityVerlet
extends Integrator {
    private double[] xPrior;

    public VelocityVerlet(SystemState state) {
        super(state);
    }

    @Override
    public void postForce(double[] gradient) {
        this.copyAccelerationToPrevious();
        double[] a = this.state.a();
        double[] v = this.state.v();
        double[] x = this.state.x();
        double[] mass = this.state.getMass();
        for (int i = 0; i < this.state.getNumberOfVariables(); ++i) {
            double m = mass[i];
            if (!(m > 0.0)) continue;
            a[i] = -418.4 * gradient[i] / mass[i];
            v[i] = v[i] + a[i] * this.dt_2;
        }
        this.constraints.forEach(c -> c.applyConstraintToVelocities(x, v, mass, 1.0E-4));
    }

    @Override
    public void preForce(Potential potential) {
        double[] x = this.state.x();
        double[] v = this.state.v();
        double[] a = this.state.a();
        double[] mass = this.state.getMass();
        int nVariables = this.state.getNumberOfVariables();
        if (this.useConstraints) {
            if (this.xPrior == null) {
                this.xPrior = Arrays.copyOf(x, nVariables);
            } else {
                System.arraycopy(x, 0, this.xPrior, 0, nVariables);
            }
        }
        for (int i = 0; i < nVariables; ++i) {
            double m = mass[i];
            if (!(m > 0.0)) continue;
            v[i] = v[i] + a[i] * this.dt_2;
            x[i] = x[i] + v[i] * this.dt;
        }
        if (this.useConstraints) {
            this.constraints.forEach(c -> c.applyConstraintToStep(this.xPrior, x, mass, 1.0E-4));
            double velScale = 1.0 / this.dt;
            for (int i = 0; i < nVariables; ++i) {
                double m = mass[i];
                if (!(m > 0.0)) continue;
                v[i] = velScale * (x[i] - this.xPrior[i]);
            }
        }
    }

    @Override
    public void setTimeStep(double dt) {
        this.dt = dt;
        this.dt_2 = dt * 0.5;
    }

    public String toString() {
        return "Velocity Verlet";
    }
}

