/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.dynamics.integrators;

import ffx.algorithms.dynamics.integrators.Integrator;
import ffx.numerics.Constraint;
import ffx.numerics.Potential;
import ffx.potential.SystemState;
import ffx.potential.constraint.ShakeChargeConstraint;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.math3.util.FastMath;

public class Stochastic
extends Integrator {
    private final double friction;
    private final Random random;
    private final double[] vFriction;
    private final double[] vRandom;
    private double inverseFriction;
    private double fdt;
    private double efdt;
    private double temperature;
    private double[] xPrior;
    private final int nVariables;
    private double[] africArray;

    public Stochastic(double friction, SystemState state) {
        super(state);
        this.friction = friction;
        this.inverseFriction = friction >= 0.0 ? 1.0 / friction : Double.POSITIVE_INFINITY;
        this.nVariables = state.getNumberOfVariables();
        this.vFriction = new double[this.nVariables];
        this.vRandom = new double[this.nVariables];
        this.fdt = friction * this.dt;
        this.efdt = FastMath.exp((double)(-this.fdt));
        this.temperature = 298.15;
        this.random = new Random();
    }

    @Override
    public void postForce(double[] gradient) {
        this.copyAccelerationToPrevious();
        double[] a = this.state.a();
        double[] v = this.state.v();
        double[] mass = this.state.getMass();
        for (int i = 0; i < this.state.getNumberOfVariables(); ++i) {
            double m = mass[i];
            if (!(m > 0.0)) continue;
            a[i] = -418.4 * gradient[i] / m;
            int n = i;
            v[n] = v[n] + (0.5 * a[i] * this.vFriction[i] + this.vRandom[i]);
        }
    }

    @Override
    public void preForce(Potential potential) throws RuntimeException {
        double[] mass = this.state.getMass();
        double[] x = this.state.x();
        double[] v = this.state.v();
        double[] a = this.state.a();
        if (this.useConstraints) {
            if (this.xPrior == null) {
                this.xPrior = Arrays.copyOf(x, this.nVariables);
            } else {
                System.arraycopy(x, 0, this.xPrior, 0, this.nVariables);
            }
            if (this.africArray == null) {
                this.africArray = new double[this.nVariables];
            }
        }
        for (int i = 0; i < this.state.getNumberOfVariables(); ++i) {
            double prand;
            double afric;
            double pfric;
            double m = mass[i];
            if (this.fdt <= 0.0) {
                pfric = 1.0;
                this.vFriction[i] = this.dt;
                afric = 0.5 * this.dt * this.dt;
                prand = 0.0;
                this.vRandom[i] = 0.0;
            } else {
                double rho;
                double vterm;
                double pterm;
                if (this.fdt >= 0.05) {
                    pfric = this.efdt;
                    this.vFriction[i] = (1.0 - this.efdt) * this.inverseFriction;
                    afric = (this.dt - this.vFriction[i]) * this.inverseFriction;
                    pterm = 2.0 * this.fdt - 3.0 + (4.0 - this.efdt) * this.efdt;
                    vterm = 1.0 - this.efdt * this.efdt;
                    rho = (1.0 - this.efdt) * (1.0 - this.efdt) / FastMath.sqrt((double)(pterm * vterm));
                } else {
                    double fdt2 = this.fdt * this.fdt;
                    double fdt3 = this.fdt * fdt2;
                    double fdt4 = this.fdt * fdt3;
                    double fdt5 = this.fdt * fdt4;
                    double fdt6 = this.fdt * fdt5;
                    double fdt7 = this.fdt * fdt6;
                    double fdt8 = this.fdt * fdt7;
                    double fdt9 = this.fdt * fdt8;
                    afric = (fdt2 / 2.0 - fdt3 / 6.0 + fdt4 / 24.0 - fdt5 / 120.0 + fdt6 / 720.0 - fdt7 / 5040.0 + fdt8 / 40320.0 - fdt9 / 362880.0) / (this.friction * this.friction);
                    this.vFriction[i] = this.dt - this.friction * afric;
                    pfric = 1.0 - this.friction * this.vFriction[i];
                    pterm = 2.0 * fdt3 / 3.0 - fdt4 / 2.0 + 7.0 * fdt5 / 30.0 - fdt6 / 12.0 + 31.0 * fdt7 / 1260.0 - fdt8 / 160.0 + 127.0 * fdt9 / 90720.0;
                    vterm = 2.0 * this.fdt - 2.0 * fdt2 + 4.0 * fdt3 / 3.0 - 2.0 * fdt4 / 3.0 + 4.0 * fdt5 / 15.0 - 4.0 * fdt6 / 45.0 + 8.0 * fdt7 / 315.0 - 2.0 * fdt8 / 315.0 + 4.0 * fdt9 / 2835.0;
                    rho = FastMath.sqrt((double)3.0) * (0.5 - this.fdt / 16.0 - 17.0 * fdt2 / 1280.0 + 17.0 * fdt3 / 6144.0 + 40967.0 * fdt4 / 3.44064E7 - 57203.0 * fdt5 / 2.752512E8 - 1429487.0 * fdt6 / 1.32120576E10 + 1877509.0 * fdt7 / 1.056964608E11);
                }
                double ktm = 0.831446261815324 * this.temperature / m;
                double psig = FastMath.sqrt((double)(ktm * pterm)) / this.friction;
                double vsig = FastMath.sqrt((double)(ktm * vterm));
                double rhoc = FastMath.sqrt((double)(1.0 - rho * rho));
                double pnorm = this.random.nextGaussian();
                double vnorm = this.random.nextGaussian();
                prand = psig * pnorm;
                this.vRandom[i] = vsig * (rho * pnorm + rhoc * vnorm);
            }
            int n = i;
            x[n] = x[n] + (v[i] * this.vFriction[i] + a[i] * afric + prand);
            v[i] = v[i] * pfric + 0.5 * a[i] * this.vFriction[i];
        }
        if (this.useConstraints) {
            for (Constraint c : this.constraints) {
                if (c instanceof ShakeChargeConstraint) {
                    ((ShakeChargeConstraint)c).applyChargeConstraintToStep(x, mass);
                    double velScale = 1.0 / this.dt;
                    for (int i = 0; i < this.nVariables; ++i) {
                        v[i] = velScale * (x[i] - this.xPrior[i]);
                    }
                    continue;
                }
                c.applyConstraintToStep(this.xPrior, x, mass, 1.0E-4);
            }
        }
    }

    public void setRandomSeed(long seed) {
        this.random.setSeed(seed);
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Override
    public void setTimeStep(double dt) {
        this.dt = dt;
        this.fdt = this.friction * dt;
        this.efdt = FastMath.exp((double)(-this.fdt));
        this.inverseFriction = this.friction >= 0.0 ? 1.0 / this.friction : Double.POSITIVE_INFINITY;
    }

    public String toString() {
        return "Stochastic";
    }
}

