/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.dynamics.integrators;

import ffx.algorithms.dynamics.integrators.Integrator;
import ffx.numerics.Potential;
import ffx.potential.SystemState;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Respa
extends Integrator {
    private static final Logger logger = Logger.getLogger(Respa.class.getName());
    private int innerSteps;
    private double innerTimeStep;
    private double halfInnerTimeStep;
    private double halfStepEnergy = 0.0;
    private final double[] innerGradient;

    public Respa(SystemState state) {
        super(state);
        this.innerGradient = new double[state.getNumberOfVariables()];
        this.innerSteps = 4;
        this.innerTimeStep = this.dt / (double)this.innerSteps;
        this.halfInnerTimeStep = 0.5 * this.innerTimeStep;
    }

    public double getHalfStepEnergy() {
        return this.halfStepEnergy;
    }

    @Override
    public void postForce(double[] gradient) {
        double[] a = this.state.a();
        double[] v = this.state.v();
        double[] mass = this.state.getMass();
        for (int i = 0; i < this.state.getNumberOfVariables(); ++i) {
            double m = mass[i];
            if (!(m > 0.0)) continue;
            a[i] = -418.4 * gradient[i] / m;
            int n = i;
            v[n] = v[n] + a[i] * this.dt_2;
        }
    }

    @Override
    public void preForce(Potential potential) {
        int i;
        int nVariables = this.state.getNumberOfVariables();
        double[] x = this.state.x();
        double[] v = this.state.v();
        double[] a = this.state.a();
        double[] aPrevious = this.state.aPrevious();
        double[] mass = this.state.getMass();
        for (i = 0; i < nVariables; ++i) {
            if (!(mass[i] > 0.0)) continue;
            int n = i;
            v[n] = v[n] + a[i] * this.dt_2;
        }
        potential.setEnergyTermState(Potential.STATE.FAST);
        this.halfStepEnergy = potential.energyAndGradient(x, this.innerGradient);
        for (i = 0; i < nVariables; ++i) {
            if (!(mass[i] > 0.0)) continue;
            aPrevious[i] = -418.4 * this.innerGradient[i] / mass[i];
        }
        for (int j = 0; j < this.innerSteps; ++j) {
            int i2;
            for (i2 = 0; i2 < nVariables; ++i2) {
                if (!(mass[i2] > 0.0)) continue;
                int n = i2;
                v[n] = v[n] + aPrevious[i2] * this.halfInnerTimeStep;
                int n2 = i2;
                x[n2] = x[n2] + v[i2] * this.innerTimeStep;
            }
            this.halfStepEnergy = potential.energyAndGradient(x, this.innerGradient);
            for (i2 = 0; i2 < nVariables; ++i2) {
                double m = mass[i2];
                if (!(m > 0.0)) continue;
                aPrevious[i2] = -418.4 * this.innerGradient[i2] / m;
                int n = i2;
                v[n] = v[n] + aPrevious[i2] * this.halfInnerTimeStep;
            }
        }
        potential.setEnergyTermState(Potential.STATE.SLOW);
    }

    public void setInnerTimeSteps(int n) {
        if (n < 2) {
            n = 2;
        }
        this.innerSteps = n;
        this.setTimeStep(this.dt);
    }

    @Override
    public void setTimeStep(double dt) {
        if (dt < 5.0E-4) {
            dt = 5.0E-4;
        }
        this.dt = dt;
        this.dt_2 = 0.5 * dt;
        this.innerTimeStep = dt / (double)this.innerSteps;
        this.halfInnerTimeStep = 0.5 * this.innerTimeStep;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format(" Time step set at %f (psec) and inner time step set at %f (psec) \n", this.dt, this.innerTimeStep));
        }
    }

    public String toString() {
        return "Respa";
    }
}

