/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.dynamics.integrators;

import ffx.crystal.Crystal;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Rattle {
    private static final Logger logger = Logger.getLogger(Rattle.class.getName());
    private MolecularAssembly molAss;
    private double[] xold;
    private double[] yold;
    private double[] zold;
    private double[][] vel;
    private final int nVariables;
    private final Crystal cryst;

    public Rattle(int nVariables, MolecularAssembly molAss, double[] v) {
        int i;
        this.cryst = this.molAss.getCrystal();
        int j = 0;
        Atom[] tempArray = molAss.getAtomArray();
        int size = tempArray.length;
        this.nVariables = nVariables;
        for (i = 0; i < v.length; i += 3) {
            this.vel[j][0] = v[i];
            this.vel[j][1] = v[i + 1];
            this.vel[j][2] = v[i + 2];
            ++j;
        }
        for (i = 0; i < size; ++i) {
            this.xold[i] = tempArray[i].getX();
            this.yold[i] = tempArray[i].getY();
            this.zold[i] = tempArray[i].getZ();
        }
    }

    public void postForce1(MolecularAssembly molAss, double dt) {
        double rateps;
        int i;
        double[] xyzr = new double[3];
        double[] xyzo = new double[3];
        int n = molAss.getAtomArray().length;
        int nrat = molAss.getBondList().size();
        boolean[] moved = new boolean[n];
        boolean[] update = new boolean[n];
        Atom[] atomArray = new Atom[n];
        double[] x = new double[n];
        double[] y = new double[n];
        double[] z = new double[n];
        double[] krat = new double[nrat];
        int[][] bondAtmNum = new int[nrat][2];
        for (i = 0; i < nrat; ++i) {
            bondAtmNum[i][0] = molAss.getBond(i).getAtomArray()[0].getIndex();
            bondAtmNum[i][1] = molAss.getBond(i).getAtomArray()[1].getIndex();
            krat[i] = molAss.getBond((int)i).bondType.distance;
        }
        for (i = 0; i < n; ++i) {
            moved[i] = atomArray[i].isActive();
            update[i] = false;
        }
        int maxiter = 500;
        double sor = 1.25;
        double eps = rateps = 1.0E-6;
        int niter = 0;
        boolean done = false;
        while (!done && niter < maxiter) {
            ++niter;
            done = true;
            for (i = 0; i < nrat; ++i) {
                int ia = bondAtmNum[i][0];
                int ib = bondAtmNum[i][1];
                if (!moved[ia] && !moved[ib]) continue;
                double xr = x[ib] - x[ia];
                double yr = y[ib] - y[ia];
                double zr = z[ib] - z[ia];
                xyzr[0] = xr;
                xyzr[1] = yr;
                xyzr[2] = zr;
                double dist2 = this.cryst.image(xyzr);
                xr = xyzr[0];
                yr = xyzr[1];
                zr = xyzr[2];
                double delta = krat[i] * krat[i] - dist2;
                if (!(Math.abs(delta) > eps)) continue;
                done = false;
                update[ia] = true;
                update[ib] = true;
                double xo = this.xold[ib] - this.xold[ia];
                double yo = this.yold[ib] - this.yold[ia];
                double zo = this.zold[ib] - this.zold[ia];
                xyzo[0] = xo;
                xyzo[1] = yo;
                xyzo[2] = zo;
                this.cryst.image(xyzo);
                xo = xyzo[0];
                yo = xyzo[1];
                zo = xyzo[2];
                double dot = xr * xo + yr * yo + zr * zo;
                double rma = 1.0 / atomArray[ia].getMass();
                double rmb = 1.0 / atomArray[ib].getMass();
                double term = sor * delta / (2.0 * (rma + rmb) * dot);
                double xterm = xo * term;
                double yterm = yo * term;
                double zterm = zo * term;
                x[ia] = x[ia] - xterm * rma;
                y[ia] = y[ia] - yterm * rma;
                z[ia] = z[ia] - zterm * rma;
                x[ib] = x[ib] - xterm * rmb;
                y[ib] = y[ib] - yterm * rmb;
                z[ib] = z[ib] - zterm * rmb;
                this.vel[ia][0] = this.vel[ia][0] - xterm * (rma /= dt);
                this.vel[ia][1] = this.vel[ia][1] - yterm * rma;
                this.vel[ia][2] = this.vel[ia][2] - zterm * rma;
                this.vel[ib][0] = this.vel[ib][0] - xterm * (rmb /= dt);
                this.vel[ib][1] = this.vel[ib][1] - yterm * rmb;
                this.vel[ib][2] = this.vel[ib][2] - zterm * rmb;
            }
            for (i = 0; i < n; ++i) {
                moved[i] = update[i];
                update[i] = false;
            }
        }
        if (niter == maxiter) {
            logger.log(Level.SEVERE, "Rattle: Distance constraints not satisfied.\n");
        }
    }

    public void postForce2(double dt) {
        int i;
        double[] xyzr = new double[3];
        int n = this.molAss.getAtomArray().length;
        boolean[] moved = new boolean[n];
        boolean[] update = new boolean[n];
        boolean[] ratimage = new boolean[this.molAss.getBondList().size()];
        Atom[] atomArray = new Atom[n];
        int[][] bondAtmNum = new int[this.molAss.getBondList().size()][2];
        double[] krat = new double[this.molAss.getBondList().size()];
        double[] x = new double[this.molAss.getAtomArray().length];
        double[] y = new double[this.molAss.getAtomArray().length];
        double[] z = new double[this.molAss.getAtomArray().length];
        n = this.molAss.getAtomArray().length;
        for (i = 0; i < n; ++i) {
            x[i] = atomArray[i].getX();
            y[i] = atomArray[i].getY();
            z[i] = atomArray[i].getZ();
        }
        int nrat = this.molAss.getBondList().size();
        for (i = 0; i < nrat; ++i) {
            bondAtmNum[i][0] = this.molAss.getBond(i).getAtomArray()[0].getIndex();
            bondAtmNum[i][1] = this.molAss.getBond(i).getAtomArray()[1].getIndex();
            krat[i] = this.molAss.getBond((int)i).bondType.distance;
        }
        for (i = 0; i < nrat; ++i) {
            ratimage[i] = true;
        }
        atomArray = this.molAss.getAtomArray();
        for (i = 0; i < n; ++i) {
            moved[i] = atomArray[i].isActive();
            update[i] = false;
        }
        int maxiter = 500;
        int niter = 0;
        boolean done = false;
        double sor = 1.25;
        double eps = 1.0E-6 / dt;
        while (!done && niter < maxiter) {
            ++niter;
            done = true;
            for (i = 1; i < nrat; ++i) {
                int ia = bondAtmNum[i][0];
                int ib = bondAtmNum[i][1];
                if (!moved[ia] && !moved[ib]) continue;
                double xr = x[ib] - x[ia];
                double yr = y[ib] - y[ia];
                double zr = z[ib] - z[ia];
                xyzr[0] = xr;
                xyzr[1] = yr;
                xyzr[2] = zr;
                this.cryst.image(xyzr);
                xr = xyzr[0];
                yr = xyzr[1];
                zr = xyzr[2];
                double xv = this.vel[ib][0] - this.vel[ia][0];
                double yv = this.vel[ib][1] - this.vel[ia][1];
                double zv = this.vel[ib][2] - this.vel[ia][2];
                double dot = xr * xv + yr * yv + zr * zv;
                double rma = 1.0 / atomArray[ia].getMass();
                double rmb = 1.0 / atomArray[ib].getMass();
                double term = -dot / ((rma + rmb) * (krat[i] * krat[i]));
                if (!(Math.abs(term) > eps)) continue;
                done = false;
                update[ia] = true;
                update[ib] = true;
                term = sor * term;
                double xterm = xr * term;
                double yterm = yr * term;
                double zterm = zr * term;
                this.vel[ia][0] = this.vel[ia][0] - xterm * rma;
                this.vel[ia][1] = this.vel[ia][1] - yterm * rma;
                this.vel[ia][2] = this.vel[ia][2] - zterm * rma;
                this.vel[ib][0] = this.vel[ib][0] + xterm * rma;
                this.vel[ib][1] = this.vel[ib][1] + yterm * rma;
                this.vel[ib][2] = this.vel[ib][2] + zterm * rma;
            }
            for (i = 0; i < n; ++i) {
                moved[i] = update[i];
                update[i] = false;
            }
        }
        if (niter == maxiter) {
            logger.log(Level.SEVERE, "Rattle: Velocity constraints not satisfied.\n");
        }
    }
}

