/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.dynamics.integrators;

import ffx.algorithms.dynamics.integrators.IntegratorEnum;
import ffx.numerics.Constraint;
import ffx.numerics.Potential;
import ffx.potential.SystemState;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class Integrator {
    private static final Logger logger = Logger.getLogger(Integrator.class.getName());
    protected final double constraintTolerance = 1.0E-4;
    protected final SystemState state;
    protected double dt;
    protected List<Constraint> constraints = new ArrayList<Constraint>();
    protected boolean useConstraints = false;
    double dt_2;

    public Integrator(SystemState state) {
        this.state = state;
        this.dt = 0.001;
        this.dt_2 = this.dt / 2.0;
    }

    public static IntegratorEnum parseIntegrator(String str) {
        try {
            String integrator = str.toUpperCase().replaceAll("\\s+", "");
            integrator = integrator.replaceAll("-", "_");
            return IntegratorEnum.valueOf(integrator);
        }
        catch (Exception e) {
            logger.info(String.format(" Could not parse %s as an integrator; defaulting to Verlet.", str));
            return IntegratorEnum.VERLET;
        }
    }

    public void addConstraints(List<Constraint> addedConstraints) {
        this.constraints.addAll(addedConstraints);
        this.useConstraints = true;
    }

    public void copyAccelerationToPrevious() {
        this.state.copyAccelerationsToPrevious();
    }

    public List<Constraint> getConstraints() {
        return new ArrayList<Constraint>(this.constraints);
    }

    public double getTimeStep() {
        return this.dt;
    }

    public abstract void setTimeStep(double var1);

    public abstract void postForce(double[] var1);

    public abstract void preForce(Potential var1);
}

