/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.dynamics;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.utils.PotentialsUtils;
import ffx.potential.utils.StructureMetrics;
import ffx.potential.utils.Superpose;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;

public class WeightedEnsembleManager {
    private static final Logger logger = Logger.getLogger(WeightedEnsembleManager.class.getName());
    private final int rank;
    private final int worldSize;
    private final double[][] weightsBins;
    private final double[][] weightsBinsCopyRank;
    private final double[][] globalValues;
    private final Comm world = Comm.world();
    private final DoubleBuf[] weightsBinsBuf;
    private final DoubleBuf[] globalValuesBuf;
    private final DoubleBuf myWeightBinBuf;
    private final DoubleBuf myGlobalValueBuf;
    private boolean restart;
    private boolean staticBins;
    private boolean resample;
    private final boolean[] enteredNewBins;
    private int numBins;
    private int optNumPerBin;
    private long totalSteps;
    private long numStepsPerResample;
    private long cycle;
    private double weight;
    private double dt;
    private double temp;
    private double trajInterval;
    private double[] refCoords;
    private double[] binBounds;
    private double[] x;
    private File dynFile;
    private File dynTemp;
    private File trajFile;
    private File trajTemp;
    private File currentDir;
    private File refStructureFile;
    private final Random random;
    private final MolecularDynamics molecularDynamics;
    private Potential potential;
    private final OneDimMetric metric;

    public WeightedEnsembleManager(OneDimMetric metric, int optNumPerBin, MolecularDynamics md, File refStructureFile, boolean resample) {
        this.rank = this.world.rank();
        this.worldSize = this.world.size();
        if (this.worldSize < 2) {
            logger.severe(" Weighted Ensemble requires at least 2 ranks.");
            System.exit(1);
        } else if (this.worldSize < 10) {
            logger.warning(" Weighted Ensemble is not recommended for small scale parallel simulations.");
        }
        this.refStructureFile = refStructureFile;
        this.refCoords = WeightedEnsembleManager.getRefCoords(refStructureFile);
        if (this.refCoords == null) {
            logger.severe(" Failed to get reference coordinates.");
            System.exit(1);
        }
        this.dynFile = md.getDynFile();
        this.molecularDynamics = md;
        this.potential = null;
        if (this.molecularDynamics.molecularAssembly != null) {
            this.potential = this.molecularDynamics.molecularAssembly[0].getPotentialEnergy();
            this.x = this.potential.getCoordinates(new double[this.potential.getNumberOfVariables()]);
        } else {
            logger.severe(" Molecular Assembly not set for Molecular Dynamics.");
            System.exit(1);
        }
        logger.info("\n\n ----------------------------- Initializing Weighted Ensemble Run -----------------------------");
        if (this.initFilesOrPrepRestart()) {
            if (this.restart) {
                logger.info(" Restarting from previous Weighted Ensemble run.");
            }
        } else {
            logger.severe(" Failed to initialize Weighted Ensemble run.");
            System.exit(1);
        }
        CompositeConfiguration properties = this.molecularDynamics.molecularAssembly[0].getProperties();
        this.random = new Random();
        this.random.setSeed(44L);
        this.binBounds = this.getPropertyList(properties, "WE.BinBounds");
        logger.info(" Bin bounds: " + Arrays.toString(this.binBounds));
        this.numBins = this.binBounds.length + 1;
        boolean bl = this.staticBins = this.binBounds.length > 0;
        if (this.staticBins) {
            logger.info(" Using static binning with " + this.numBins + " bins.");
        } else {
            logger.info(" Using dynamic binning.");
        }
        this.resample = resample;
        this.numBins = this.staticBins ? this.numBins : this.worldSize / optNumPerBin;
        this.optNumPerBin = optNumPerBin;
        this.metric = metric;
        this.weight = 1.0 / (double)this.worldSize;
        this.cycle = 0L;
        this.enteredNewBins = new boolean[this.worldSize];
        this.globalValues = new double[this.worldSize][1];
        this.weightsBins = new double[this.worldSize][2];
        this.weightsBinsCopyRank = new double[this.worldSize][3];
        this.weightsBinsBuf = new DoubleBuf[this.worldSize];
        this.globalValuesBuf = new DoubleBuf[this.worldSize];
        for (int i = 0; i < this.worldSize; ++i) {
            this.weightsBinsBuf[i] = DoubleBuf.buffer((double[])this.weightsBins[i]);
            this.globalValuesBuf[i] = DoubleBuf.buffer((double[])this.globalValues[i]);
        }
        this.myWeightBinBuf = this.weightsBinsBuf[this.rank];
        this.myGlobalValueBuf = this.globalValuesBuf[this.rank];
        this.weightsBins[this.rank][0] = this.weight;
    }

    private double[] getPropertyList(CompositeConfiguration properties, String propertyName) {
        ArrayList<Double> list = new ArrayList<Double>();
        String[] split = properties.getString(propertyName, "").trim().replace("[", "").replace("]", "").replace(",", " ").split(" ");
        if (split[0].isEmpty()) {
            return new double[0];
        }
        for (String s1 : split) {
            if (s1.isEmpty()) continue;
            list.add(Double.parseDouble(s1));
        }
        return list.stream().sorted().mapToDouble(Double::doubleValue).toArray();
    }

    private static double[] getRefCoords(File refStructureFile) {
        PotentialsUtils utils = new PotentialsUtils();
        MolecularAssembly assembly = utils.open(refStructureFile);
        return assembly.getPotentialEnergy().getCoordinates(new double[0]);
    }

    private boolean initFilesOrPrepRestart() {
        logger.info("\n Rank " + this.rank + " structure is based on: " + this.refStructureFile.getAbsolutePath());
        File parent = this.refStructureFile.getParentFile();
        logger.info(" Rank " + this.rank + " is using parent directory: " + parent.getAbsolutePath());
        this.currentDir = new File(String.valueOf(parent) + File.separator + this.rank);
        logger.info(" Rank " + this.rank + " is using directory: " + this.currentDir.getAbsolutePath());
        this.trajFile = new File(String.valueOf(this.currentDir) + File.separator + FilenameUtils.getBaseName((String)this.refStructureFile.getName()) + ".arc");
        logger.info(" Rank " + this.rank + " is using trajectory file: " + this.trajFile.getAbsolutePath());
        this.molecularDynamics.setArchiveFiles(new File[]{this.trajFile});
        this.dynFile = new File(String.valueOf(this.currentDir) + File.separator + FilenameUtils.getBaseName((String)this.refStructureFile.getName()) + ".dyn");
        logger.info(" Rank " + this.rank + " is using dyn restart file: " + this.dynFile.getAbsolutePath());
        this.molecularDynamics.setFallbackDynFile(this.dynFile);
        this.restart = !this.currentDir.mkdir() && this.checkRestartFiles();
        logger.info(" \n");
        return this.currentDir.exists();
    }

    private boolean checkRestartFiles() {
        Path dynPath = this.dynFile.toPath();
        Path trajPath = this.trajFile.toPath();
        return dynPath.toFile().exists() && trajPath.toFile().exists();
    }

    public void run(long totalSteps, long numStepsPerResample, double temp, double dt) {
        this.totalSteps = totalSteps;
        this.numStepsPerResample = numStepsPerResample;
        this.temp = temp;
        this.dt = dt;
        if (!this.staticBins) {
            this.dynamics(numStepsPerResample * 3L);
        }
        if (this.restart) {
            long restartFrom = this.getRestartTime(this.dynFile);
            logger.info(" Restarting from " + restartFrom + " femtoseconds.");
            logger.info(" Remaining cycles: " + (int)Math.ceil((double)(totalSteps -= restartFrom) / (double)numStepsPerResample));
        }
        logger.info("\n ----------------------------- Start Weighted Ensemble Run -----------------------------");
        int numCycles = (int)Math.ceil((double)totalSteps / (double)numStepsPerResample);
        for (int i = 0; i < numCycles; ++i) {
            this.cycle = i;
            this.dynamics(numStepsPerResample);
            this.calculateMyMetric();
            this.comms();
            this.binAssignment();
            if (this.resample) {
                this.resample();
            }
            this.comms();
            if (!this.resample) continue;
            this.sanityCheckAndFileMigration();
            logger.info("\n ----------------------------- Resampling cycle #" + (i + 1) + " complete ----------------------------- ");
        }
        logger.info("\n\n\n ----------------------------- End Weighted Ensemble Run -----------------------------");
    }

    private long getRestartTime(File dynFile) {
        return 0L;
    }

    private void dynamics(long numSteps) {
        double dynamicTotalTime = (double)numSteps * this.dt / 1000.0;
        this.molecularDynamics.setCoordinates(this.x);
        this.potential.energy(this.x, false);
        this.molecularDynamics.dynamic(numSteps, this.dt, dynamicTotalTime / 3.0, dynamicTotalTime / 3.0, this.temp, true, this.dynFile);
        this.x = this.molecularDynamics.getCoordinates();
        this.molecularDynamics.writeRestart();
    }

    private void calculateMyMetric() {
        switch (this.metric.ordinal()) {
            case 0: {
                this.globalValues[this.rank][0] = Superpose.rmsd((double[])this.refCoords, (double[])this.x, (double[])this.potential.getMass());
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                double refEnergy = this.potential.energy(this.refCoords, false);
                double myEnergy = this.potential.energy(this.x, false);
                this.globalValues[this.rank][0] = myEnergy - refEnergy;
                break;
            }
            case 5: {
                StructureMetrics.radiusOfGyration((double[])this.x, (double[])this.potential.getMass());
                break;
            }
        }
    }

    private void binAssignment() {
        double[] global = new double[this.worldSize];
        for (int i = 0; i < this.worldSize; ++i) {
            global[i] = this.globalValues[i][0];
        }
        double[] binBounds = this.getOneDimBinBounds(global);
        this.numBins = binBounds.length + 1;
        for (int j = 0; j < this.worldSize; ++j) {
            int oldBin = (int)Math.round(this.weightsBins[j][1]);
            for (int i = 0; i < this.numBins - 2; ++i) {
                if (i == 0 && global[j] < binBounds[i]) {
                    this.weightsBins[j][1] = i;
                    break;
                }
                if (global[j] >= binBounds[i] && global[j] < binBounds[i + 1]) {
                    this.weightsBins[j][1] = i + 1;
                    break;
                }
                if (i != this.numBins - 3 || !(global[j] >= binBounds[i + 1])) continue;
                this.weightsBins[j][1] = i + 2;
                break;
            }
            this.enteredNewBins[j] = (double)oldBin != this.weightsBins[j][1];
        }
        logger.info("\n Bin bounds:        " + Arrays.toString(binBounds));
        logger.info(" Rank global values with metric \"" + this.metricToString(this.metric) + "\": " + Arrays.toString(global));
        logger.info(" Entered new bins: " + Arrays.toString(this.enteredNewBins));
    }

    private String metricToString(OneDimMetric metric) {
        return switch (metric.ordinal()) {
            case 0 -> "RMSD";
            case 1 -> "Residue Distance";
            case 2 -> "COM Distance";
            case 3 -> "Atom Distance";
            case 4 -> "Potential";
            default -> "Invalid Metric";
        };
    }

    private void resample() {
        int i;
        logger.info("\n\n ----------------------------- Resampling ----------------------------- ");
        ArrayList binRank = new ArrayList();
        PriorityQueue<Decision> merges = new PriorityQueue<Decision>();
        PriorityQueue<Decision> splits = new PriorityQueue<Decision>();
        for (i = 0; i < this.numBins; ++i) {
            binRank.add(new ArrayList());
        }
        for (i = 0; i < this.worldSize; ++i) {
            int bin = (int)Math.round(this.weightsBins[i][1]);
            ((List)binRank.get(bin)).add(i);
        }
        int m = 2;
        for (int i2 = 0; i2 < this.numBins; ++i2) {
            double weight;
            int rank;
            List ranks = ((List)binRank.get(i2)).stream().sorted((a, b) -> Double.compare(this.weightsBins[a][0], this.weightsBins[b][0])).toList();
            if (ranks.isEmpty()) continue;
            double idealWeight = ranks.stream().mapToDouble(a -> this.weightsBins[a][0]).sum() / (double)this.optNumPerBin;
            logger.info("\n Bin #" + i2 + " has " + ranks.size() + " ranks with ideal weight " + idealWeight + ".");
            ArrayList<Integer> splitRanks = new ArrayList<Integer>();
            Iterator iterator = ranks.iterator();
            while (iterator.hasNext()) {
                rank = (Integer)iterator.next();
                weight = this.weightsBins[rank][0];
                if (!(this.weightsBins[rank][0] > 2.0 * idealWeight) && !this.enteredNewBins[rank]) continue;
                splits.add(new Decision(new ArrayList<Integer>(List.of(Integer.valueOf(rank))), new ArrayList<Double>(List.of(Double.valueOf(weight)))));
                splitRanks.add(rank);
            }
            Iterator ranksIterator = ranks.stream().iterator();
            rank = (Integer)ranksIterator.next();
            weight = this.weightsBins[rank][0];
            double combinedWeight = 0.0;
            ArrayList<Decision> binMergeList = new ArrayList<Decision>();
            binMergeList.add(new Decision(new ArrayList<Integer>(), new ArrayList<Double>()));
            while (weight < idealWeight / 2.0) {
                boolean split = false;
                if (splitRanks.contains(rank) && ranks.size() > this.optNumPerBin) {
                    double choice = this.random.nextDouble();
                    if (choice < 0.5) {
                        int finalRank = rank;
                        splits.removeIf(decision -> decision.ranks.contains(finalRank));
                    } else {
                        split = true;
                    }
                }
                if (!split) {
                    if (combinedWeight + weight < idealWeight) {
                        ((Decision)binMergeList.getLast()).ranks.add(rank);
                        ((Decision)binMergeList.getLast()).weights.add(weight);
                        combinedWeight += weight;
                    } else if (combinedWeight + weight <= idealWeight * 1.5) {
                        ((Decision)binMergeList.getLast()).ranks.add(rank);
                        ((Decision)binMergeList.getLast()).weights.add(weight);
                        combinedWeight = 0.0;
                        binMergeList.add(new Decision(new ArrayList<Integer>(), new ArrayList<Double>()));
                    } else {
                        binMergeList.add(new Decision(new ArrayList<Integer>(), new ArrayList<Double>()));
                        combinedWeight = 0.0;
                        continue;
                    }
                }
                if (!ranksIterator.hasNext()) break;
                rank = (Integer)ranksIterator.next();
                weight = this.weightsBins[rank][0];
            }
            for (Decision decision2 : binMergeList) {
                if (decision2.ranks.size() <= 1) continue;
                merges.add(decision2);
            }
        }
        StringBuilder mergeString = new StringBuilder();
        for (int i3 = 0; i3 < this.worldSize; ++i3) {
            this.weightsBinsCopyRank[i3][0] = this.weightsBins[i3][0];
            this.weightsBinsCopyRank[i3][1] = this.weightsBins[i3][1];
            this.weightsBinsCopyRank[i3][2] = -1.0;
        }
        ArrayList<Integer> freedRanks = new ArrayList<Integer>();
        int desiredFreeRanks = splits.size() * m - splits.size();
        while (!merges.isEmpty() && desiredFreeRanks > 0) {
            Decision decision3 = (Decision)merges.poll();
            if (decision3.ranks.size() - 1 > desiredFreeRanks) {
                decision3.ranks.subList(desiredFreeRanks + 1, decision3.ranks.size()).clear();
                decision3.weights.subList(desiredFreeRanks + 1, decision3.weights.size()).clear();
            }
            desiredFreeRanks -= decision3.ranks.size() - 1;
            ArrayList<Double> weights = new ArrayList<Double>(decision3.weights);
            double totalWeight = weights.stream().mapToDouble(Double::doubleValue).sum();
            weights.replaceAll(a -> a / totalWeight);
            double rand = this.random.nextDouble();
            double cumulativeWeight = 0.0;
            int rankToMergeInto = -1;
            for (int i4 = 0; i4 < weights.size(); ++i4) {
                if (!(rand <= (cumulativeWeight += weights.get(i4).doubleValue()))) continue;
                rankToMergeInto = decision3.ranks.get(i4);
                break;
            }
            mergeString.append("\t Ranks ").append(decision3.ranks).append(" --> ").append(rankToMergeInto).append("\n");
            for (int rank : decision3.ranks) {
                if (rank != rankToMergeInto) {
                    freedRanks.add(rank);
                    continue;
                }
                this.weightsBinsCopyRank[rank][0] = decision3.getTotalWeight();
            }
        }
        StringBuilder splitString = new StringBuilder();
        double[] global = new double[this.worldSize];
        for (int i5 = 0; i5 < this.worldSize; ++i5) {
            global[i5] = this.globalValues[i5][0];
        }
        while (!splits.isEmpty() && !freedRanks.isEmpty()) {
            if (freedRanks.size() < m - 1) {
                m = freedRanks.size() + 1;
            }
            Decision decision4 = (Decision)splits.poll();
            int parent = decision4.ranks.getFirst();
            double weightToEach = decision4.getTotalWeight() / (double)m;
            ArrayList<Integer> ranksUsed = new ArrayList<Integer>();
            ranksUsed.add(parent);
            this.weightsBinsCopyRank[parent][0] = weightToEach;
            for (int i6 = 0; i6 < m - 1; ++i6) {
                int childRank = (Integer)freedRanks.removeFirst();
                ranksUsed.add(childRank);
                this.weightsBinsCopyRank[childRank][0] = weightToEach;
                this.weightsBinsCopyRank[childRank][1] = this.weightsBinsCopyRank[parent][1];
                this.weightsBinsCopyRank[childRank][2] = parent;
                global[childRank] = this.globalValues[parent][0];
            }
            splitString.append("\t Rank ").append(parent).append(" --> ").append(ranksUsed).append("\n");
        }
        this.weightsBins[this.rank][0] = this.weightsBinsCopyRank[this.rank][0];
        this.weightsBins[this.rank][1] = this.weightsBinsCopyRank[this.rank][1];
        this.globalValues[this.rank][0] = global[this.rank];
        logger.info("\n ----------------------------- Resampling Decisions ----------------------------- ");
        double[] weights = new double[this.worldSize];
        int[] bins = new int[this.worldSize];
        for (int i7 = 0; i7 < this.worldSize; ++i7) {
            weights[i7] = this.weightsBinsCopyRank[i7][0];
            bins[i7] = (int)Math.round(this.weightsBinsCopyRank[i7][1]);
        }
        logger.info("\n Rank bin numbers: " + Arrays.toString(bins));
        logger.info(" Bin bounds:     " + Arrays.toString(this.binBounds));
        logger.info(" Rank weights:     " + Arrays.toString(weights));
        logger.info(" Weight sum:      " + Arrays.stream(weights).sum());
        logger.info(" Merges: \n" + String.valueOf(mergeString) + "\n");
        logger.info(" Splits: \n" + String.valueOf(splitString) + "\n");
        if (Arrays.stream(weights).sum() - 1.0 > 1.0E-6) {
            logger.severe(" Weights do not sum to 1.0.");
        }
    }

    private double[] getOneDimBinBounds(double[] globalValues) {
        if (this.staticBins) {
            return this.binBounds;
        }
        logger.severe(" Automatic binning not implemented yet.");
        return new double[0];
    }

    private void comms() {
        this.comms(false);
    }

    private void comms(boolean log) {
        int i;
        double[] global;
        double[] weights;
        if (log) {
            weights = new double[this.worldSize];
            global = new double[this.worldSize];
            for (i = 0; i < this.worldSize; ++i) {
                weights[i] = this.weightsBinsCopyRank[i][0];
                global[i] = this.globalValues[i][0];
            }
            logger.info(" Rank bin numbers Pre: " + Arrays.toString(weights));
            logger.info(" Rank global values Pre: " + Arrays.toString(global));
        }
        try {
            this.world.allGather((Buf)this.myWeightBinBuf, (Buf[])this.weightsBinsBuf);
            this.world.allGather((Buf)this.myGlobalValueBuf, (Buf[])this.globalValuesBuf);
        }
        catch (IOException e) {
            String message = " WeightedEnsemble allGather for weightsbins failed.";
            logger.severe(message);
        }
        if (log) {
            weights = new double[this.worldSize];
            global = new double[this.worldSize];
            for (i = 0; i < this.worldSize; ++i) {
                weights[i] = this.weightsBinsCopyRank[i][0];
                global[i] = this.globalValues[i][0];
            }
            logger.info(" Rank bin numbers Post: " + Arrays.toString(weights));
            logger.info(" Rank global values Post: " + Arrays.toString(global));
        }
    }

    private void sanityCheckAndFileMigration() {
        for (int i = 0; i < this.worldSize; ++i) {
            if (this.weightsBins[i][0] == this.weightsBinsCopyRank[i][0] && this.weightsBins[i][1] == this.weightsBinsCopyRank[i][1]) continue;
            String message = " Rank " + i + " has mismatched weightsBins and weightsBinsCopyRank.";
            logger.info(" WeightsBins: " + Arrays.deepToString((Object[])this.weightsBins));
            logger.info(" WeightsBinsCopyRank: " + Arrays.deepToString((Object[])this.weightsBinsCopyRank));
            logger.severe(message);
            System.exit(1);
        }
        if (this.weightsBinsCopyRank[this.rank][2] != -1.0 && this.weightsBinsCopyRank[this.rank][2] != (double)this.rank) {
            this.copyOver((int)this.weightsBinsCopyRank[this.rank][2]);
        }
        this.comms();
        if (this.weightsBinsCopyRank[this.rank][2] != -1.0 && this.weightsBinsCopyRank[this.rank][2] != (double)this.rank) {
            this.moveOnto();
        }
    }

    private void copyOver(int rank) {
        String message;
        File dyn = new File(this.currentDir.getParent() + File.separator + rank + File.separator + this.dynFile.getName());
        this.dynTemp = new File(this.currentDir.getParent() + File.separator + rank + File.separator + this.dynFile.getName() + ".temp");
        File traj = new File(this.currentDir.getParent() + File.separator + rank + File.separator + this.trajFile.getName());
        this.trajTemp = new File(this.currentDir.getParent() + File.separator + rank + File.separator + this.trajFile.getName() + ".temp");
        try {
            Files.copy(dyn.toPath(), this.dynTemp.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            message = " Failed to copy dyn file from rank " + rank + " to rank " + this.rank;
            logger.log(Level.SEVERE, message, e);
        }
        try {
            Files.copy(traj.toPath(), this.trajTemp.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            message = " Failed to copy traj file from rank " + rank + " to rank " + this.rank;
            logger.log(Level.SEVERE, message, e);
        }
    }

    private void moveOnto() {
        String message;
        try {
            Files.move(this.dynTemp.toPath(), this.dynFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            message = " Failed to move dyn file from rank " + this.rank + " to rank " + this.rank;
            logger.log(Level.SEVERE, message, e);
        }
        try {
            Files.move(this.trajTemp.toPath(), this.trajFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            message = " Failed to move traj file from rank " + this.rank + " to rank " + this.rank;
            logger.log(Level.SEVERE, message, e);
        }
    }

    public static enum OneDimMetric {
        RMSD,
        RESIDUE_DISTANCE,
        COM_DISTANCE,
        ATOM_DISTANCE,
        POTENTIAL,
        RADIUS_OF_GYRATION;

    }

    private record Decision(ArrayList<Integer> ranks, ArrayList<Double> weights) implements Comparable<Decision>
    {
        public double getTotalWeight() {
            return this.weights.stream().mapToDouble(Double::doubleValue).sum();
        }

        @Override
        public int compareTo(Decision decision) {
            return Double.compare(this.getTotalWeight(), decision.getTotalWeight());
        }
    }
}

