/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.dynamics;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.buf.IntegerMatrixBuf_1;
import edu.rit.pj.Comm;
import ffx.algorithms.Terminatable;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.algorithms.dynamics.MolecularDynamicsOpenMM;
import ffx.numerics.Potential;
import ffx.potential.bonded.Residue;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.parameters.TitrationUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;

public class PhReplicaExchange
implements Terminatable {
    private static final Logger logger = Logger.getLogger(PhReplicaExchange.class.getName());
    private final MolecularDynamics replica;
    private final MolecularDynamicsOpenMM openMM;
    private final Potential potential;
    private final ExtendedSystem extendedSystem;
    private final Random random;
    private final Comm world;
    private File dyn;
    private File esv;
    private File esvBackup;
    private File dynBackup;
    private ArrayList<Double> readPhScale;
    private final DoubleBuf[] parametersBuf;
    private final DoubleBuf myParametersBuf;
    private final double[][] parameters;
    private final int[][][] parametersHis;
    private final IntegerBuf[] parametersHisBuf;
    private final int[] pH2Rank;
    private final int[] rank2Ph;
    private final int[] pHAcceptedCount;
    private final int[] pHTrialCount;
    private final int rank;
    private final int nReplicas;
    private boolean done = false;
    private boolean restart;
    private boolean terminate = false;
    private boolean backupNeeded = false;
    private final double[] myParameters;
    private final double[] pHScale;
    private double[] x;
    private final double pH;
    private final double temp;
    private int restartStep;

    public PhReplicaExchange(MolecularDynamics molecularDynamics, File structureFile, double pH, double[] pHLadder, double temp, ExtendedSystem extendedSystem, double[] x, int worldSize) throws Exception {
        this(molecularDynamics, structureFile, pH, pHLadder, temp, extendedSystem, x, null, null, worldSize);
    }

    public PhReplicaExchange(MolecularDynamics molecularDynamics, File structureFile, double pH, double[] pHLadder, double temp, ExtendedSystem extendedSystem, @Nullable double[] x, @Nullable MolecularDynamicsOpenMM molecularDynamicsOpenMM, @Nullable Potential potential, int worldSize) throws Exception {
        int i;
        this.replica = molecularDynamics;
        this.temp = temp;
        this.extendedSystem = extendedSystem;
        this.pH = pH;
        this.pHScale = pHLadder;
        this.x = x;
        this.openMM = molecularDynamicsOpenMM;
        this.potential = potential;
        this.world = Comm.world();
        int numProc = worldSize;
        this.rank = this.world.rank();
        this.nReplicas = numProc;
        this.pH2Rank = new int[this.nReplicas];
        this.rank2Ph = new int[this.nReplicas];
        this.pHAcceptedCount = new int[this.nReplicas];
        this.pHTrialCount = new int[this.nReplicas];
        for (i = 0; i < this.nReplicas; ++i) {
            this.rank2Ph[i] = i;
            this.pH2Rank[i] = i;
        }
        extendedSystem.setConstantPh(this.pHScale[this.rank]);
        this.random = new Random();
        this.random.setSeed(0L);
        this.parameters = new double[this.nReplicas][pHLadder.length + 1];
        this.parametersHis = new int[this.nReplicas][extendedSystem.getTitratingResidueList().size()][100];
        this.parametersBuf = new DoubleBuf[this.nReplicas];
        this.parametersHisBuf = new IntegerMatrixBuf_1[this.nReplicas];
        for (i = 0; i < this.nReplicas; ++i) {
            this.parametersBuf[i] = DoubleBuf.buffer((double[])this.parameters[i]);
            this.parametersHisBuf[i] = IntegerMatrixBuf_1.buffer((int[][])this.parametersHis[i]);
        }
        this.myParameters = this.parameters[this.rank];
        this.myParametersBuf = this.parametersBuf[this.rank];
        if (!this.manageFilesAndRestart(structureFile)) {
            throw new Exception("Failed to restart Replica Exchange.");
        }
        logger.info(" Startup Successful! ");
        extendedSystem.getESVHistogram(this.parametersHis[this.rank]);
    }

    public boolean manageFilesAndRestart(File structureFile) {
        File parent = structureFile.getParentFile();
        File rankDir = new File(String.valueOf(parent) + File.separator + this.rank);
        this.restart = !rankDir.mkdir();
        this.esv = new File(rankDir.getPath() + File.separator + FilenameUtils.removeExtension((String)structureFile.getName()) + ".esv");
        this.dyn = new File(rankDir.getPath() + File.separator + FilenameUtils.removeExtension((String)structureFile.getName()) + ".dyn");
        this.esvBackup = new File(FilenameUtils.removeExtension((String)this.esv.getAbsolutePath()) + "_backup.esv");
        this.dynBackup = new File(FilenameUtils.removeExtension((String)this.dyn.getAbsolutePath()) + "_backup.dyn");
        this.extendedSystem.setRestartFile(this.esv);
        this.replica.setFallbackDynFile(this.dyn);
        this.replica.setArchiveFiles(new File[]{new File(rankDir.getPath() + File.separator + FilenameUtils.removeExtension((String)structureFile.getName()) + ".arc")});
        if (this.openMM != null) {
            this.openMM.setAutomaticWriteouts(false);
        }
        this.restartStep = 0;
        if (this.restart) {
            File checkThisESV;
            int i;
            logger.info(" Attempting to restart. ");
            this.readPhScale = new ArrayList();
            this.backupNeeded = false;
            if (this.checkForRestartFiles(parent, this.esv.getName()) && this.checkForRestartFiles(parent, this.dyn.getName())) {
                for (i = 0; i < this.nReplicas; ++i) {
                    checkThisESV = new File(parent.getAbsolutePath() + File.separator + i + File.separator + this.esv.getName());
                    boolean bl = this.backupNeeded = !this.readESV(checkThisESV, i);
                    if (!this.backupNeeded) continue;
                    logger.warning(" Searching backup esv files.");
                    break;
                }
                if (!this.backupNeeded) {
                    logger.info(" Reading in from: " + String.valueOf(this.esv));
                    this.extendedSystem.readESVInfoFrom(this.esv);
                }
            } else {
                logger.info(" Directories do not contain all of the correct restart files.");
                this.backupNeeded = true;
            }
            if (this.backupNeeded && this.checkForRestartFiles(parent, this.esvBackup.getName()) && this.checkForRestartFiles(parent, this.dynBackup.getName())) {
                for (i = 0; i < this.nReplicas; ++i) {
                    checkThisESV = new File(parent.getAbsolutePath() + File.separator + i + File.separator + this.esvBackup.getName());
                    if (this.readESV(checkThisESV, i)) continue;
                    logger.info(" Restart files & Backups are messed up.");
                    return false;
                }
                logger.info(" Reading in from: " + String.valueOf(this.esvBackup));
                this.extendedSystem.readESVInfoFrom(this.esvBackup);
            } else if (this.backupNeeded) {
                logger.info(" Directories do not contain all of the correct backup restart files.");
                logger.info(" No backup files found, treating as a fresh start.");
                this.restart = false;
                return true;
            }
        } else {
            logger.info(" Not a restart.");
            return true;
        }
        logger.info(" Rank " + this.rank + " staring at pH " + this.pHScale[this.rank2Ph[this.rank]]);
        this.extendedSystem.setConstantPh(this.pHScale[this.rank2Ph[this.rank]]);
        logger.info(" Rank " + this.rank + " starting hist:");
        this.extendedSystem.writeLambdaHistogram(true);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readESV(File file, int i) {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String data = br.readLine();
            while (data != null) {
                int sum;
                List<String> tokens = Arrays.asList(data.split(" +"));
                if (tokens.contains("pH:")) {
                    boolean j;
                    double pHOfRankI = Double.parseDouble(tokens.get(tokens.indexOf("pH:") + 1));
                    for (j = false; j < this.pHScale.length; j += 1) {
                        if (!(Math.abs(this.pHScale[j] / pHOfRankI - 1.0) < 1.0E-5)) continue;
                        this.rank2Ph[i] = j;
                        this.pH2Rank[j] = i;
                    }
                    if (this.readPhScale.stream().anyMatch(d -> Math.abs(d / pHOfRankI - 1.0) < 1.0E-5)) {
                        logger.warning(" Duplicate pH value found in file: " + file.getAbsolutePath());
                        this.readPhScale.clear();
                        this.restartStep = 0;
                        j = false;
                        return j;
                    }
                    this.readPhScale.add(pHOfRankI);
                    br.readLine();
                    br.readLine();
                    sum = 0;
                } else {
                    data = br.readLine();
                    continue;
                }
                for (int j = 0; j < 10; ++j) {
                    data = br.readLine().trim();
                    tokens = List.of(data.split(" +"));
                    for (int k = 0; k < 10; sum += Integer.parseInt(tokens.get(k + 1)), ++k) {
                    }
                }
                if (this.restartStep == 0) {
                    this.restartStep = sum;
                    break;
                }
                if (this.restartStep == sum) break;
                logger.warning(" Restart received uneven sums from esv file: " + file.getAbsolutePath());
                logger.info(" Restart Step: " + this.restartStep + "    Found: " + sum);
                this.restartStep = 0;
                this.readPhScale.clear();
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | IndexOutOfBoundsException e) {
            logger.warning("Failed to read file: " + file.getAbsolutePath());
            return false;
        }
    }

    private boolean checkForRestartFiles(File parent, String fileNameWithExtension) {
        for (int i = 0; i < this.nReplicas; ++i) {
            File searchFile = new File(parent.getAbsolutePath() + File.separator + i + File.separator + fileNameWithExtension);
            if (searchFile.exists()) continue;
            return false;
        }
        return true;
    }

    public void sample(int cycles, long nSteps, double timeStep, double printInterval, double trajInterval, int initTitrDynamics) {
        this.sample(cycles, nSteps, 0L, timeStep, printInterval, trajInterval, initTitrDynamics);
    }

    public void sample(int cycles, long titrSteps, long confSteps, double timeStep, double printInterval, double trajInterval, int initDynamics) {
        this.done = false;
        this.terminate = false;
        this.replica.setRestartFrequency((double)((long)cycles * (titrSteps + confSteps)) * this.replica.dt + 100.0);
        this.replica.setCoordinates(this.x);
        int startCycle = 0;
        if (initDynamics > 0 && !this.restart) {
            this.extendedSystem.reGuessLambdas();
            this.extendedSystem.setFixedTitrationState(true);
            this.extendedSystem.setFixedTautomerState(true);
            logger.info(" ");
            logger.info(" ------------------Start of Equilibration Dynamics------------------\n");
            logger.info(" ");
            if (this.openMM == null) {
                this.replica.dynamic(initDynamics, timeStep, printInterval, trajInterval, this.temp, true, this.dyn);
            } else {
                this.x = this.replica.getCoordinates();
                this.potential.energy(this.x);
                this.openMM.setCoordinates(this.x);
                this.openMM.dynamic(initDynamics, timeStep, printInterval, trajInterval, this.temp, true, this.dyn);
                this.x = this.openMM.getCoordinates();
                this.replica.setCoordinates(this.x);
            }
            this.extendedSystem.setFixedTitrationState(false);
            this.extendedSystem.setFixedTautomerState(false);
            logger.info(this.extendedSystem.getLambdaList());
            this.extendedSystem.writeLambdaHistogram(true);
            this.extendedSystem.copyESVHistogramTo(this.parametersHis[this.rank]);
            logger.info(" ");
            logger.info(" ------------------End of Equilibration Dynamics------------------\n");
            logger.info(" ");
        } else if (initDynamics == 0 && !this.restart) {
            this.extendedSystem.reGuessLambdas();
        } else if (this.restart) {
            logger.info(" Omitting initialization steps because this is a restart.");
            startCycle = (int)((long)this.restartStep / titrSteps) + 1;
            logger.info(" Restarting pH-REX at cycle " + startCycle + " of " + cycles);
        }
        for (int i = startCycle; i < cycles; ++i) {
            if (this.terminate) {
                this.done = true;
                break;
            }
            if (this.openMM != null) {
                if (confSteps < 3L) {
                    logger.severe(" Increase number of steps per cycle.");
                }
                this.dynamicsOpenMM(titrSteps, confSteps, timeStep, printInterval, trajInterval);
            } else {
                this.dynamics(titrSteps, timeStep, printInterval, trajInterval);
            }
            if (i == 0 || this.backupNeeded) {
                this.replica.writeRestart();
            }
            this.copyToBackups();
            this.replica.writeRestart();
            if (i % 100 == 0) {
                this.extendedSystem.writeLambdaHistogram(true);
            }
            try {
                logger.info("\n Predicting pKa...");
                logger.info(this.pkaPred(this.parametersHis));
            }
            catch (Exception e) {
                logger.info(e.getMessage());
                logger.warning("Failed to predict pKa. Simulation may be too early on.");
            }
            logger.info(" ");
            logger.info(String.format(" ------------------Exchange Cycle %d------------------\n", i + 1));
            if (i != cycles - 1) {
                this.exchange();
            }
            logger.info(" ");
            logger.info(" Setting rank " + this.rank + " esv to pH " + this.pHScale[this.rank2Ph[this.rank]]);
            logger.info(" ");
        }
    }

    private String pkaPred(int[][][] parametersHis) {
        double[][][] collapsedSum = new double[parametersHis.length][parametersHis[0].length][10];
        double[][] collapsedRatio = new double[parametersHis.length][parametersHis[0].length];
        for (int i = 0; i < parametersHis.length; ++i) {
            for (int j = 0; j < parametersHis[0].length; ++j) {
                double ratio;
                for (int k = 0; k < 10; ++k) {
                    double sum = 0.0;
                    for (int l = 0; l < 10; ++l) {
                        sum += (double)parametersHis[i][j][k * 10 + l];
                    }
                    collapsedSum[i][j][k] = sum;
                }
                collapsedRatio[i][j] = ratio = collapsedSum[i][j][0] / (collapsedSum[i][j][0] + collapsedSum[i][j][9]);
            }
        }
        StringBuilder output = new StringBuilder();
        double[] n = new double[parametersHis[0].length];
        double[] pka = new double[parametersHis[0].length];
        double[][] residueRatios = new double[parametersHis[0].length][parametersHis.length];
        for (int i = 0; i < parametersHis[0].length; ++i) {
            for (int j = 0; j < parametersHis.length; ++j) {
                residueRatios[i][j] = collapsedRatio[j][i];
            }
            double[] pHArray = new double[this.nReplicas];
            for (int j = 0; j < this.nReplicas; ++j) {
                pHArray[j] = this.parameters[j][0];
            }
            double[] temp = TitrationUtils.predictHillCoeffandPka((double[])pHArray, (double[])residueRatios[i]);
            n[i] = temp[0];
            pka[i] = temp[1];
            String residueName = ((Residue)this.extendedSystem.getTitratingResidueList().get(i)).toString();
            output.append(" Residue: ").append(residueName).append("\n");
            output.append(" Fractions (Dep / (Dep + Pro)): ").append(Arrays.toString(residueRatios[i])).append("\n");
            output.append(" pH window: ").append(Arrays.toString(pHArray)).append("\n");
            output.append(" n: ").append(n[i]).append("\n");
            output.append(" pKa: ").append(pka[i]).append("\n");
            output.append("\n");
        }
        return output.toString();
    }

    public static double[] setEvenSpacePhLadder(double pHGap, double pH, int nReplicas) {
        double range = (double)nReplicas * pHGap;
        double pHMin = pH - range / 2.0;
        if (nReplicas % 2 != 0) {
            pHMin += pHGap / 2.0;
        }
        double[] pHScale = new double[nReplicas];
        for (int i = 0; i < nReplicas; ++i) {
            pHScale[i] = pHMin + (double)i * pHGap;
        }
        return pHScale;
    }

    public double[] getPhScale() {
        return this.pHScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        this.terminate = true;
        while (!this.done) {
            PhReplicaExchange phReplicaExchange = this;
            synchronized (phReplicaExchange) {
                try {
                    this.wait(1L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Exception terminating replica exchange.\n", e);
                }
            }
        }
    }

    private void compareTwo(int pH) {
        int rankA = this.pH2Rank[pH];
        int rankB = this.pH2Rank[pH + 1];
        int acidAIndex = this.rank2Ph[rankA] + 1;
        int acidBIndex = this.rank2Ph[rankB] + 1;
        double pHA = this.parameters[rankA][0];
        double pHB = this.parameters[rankB][0];
        double beta = 418.4 / (this.temp * 0.831446261815324);
        double acidostatA = this.parameters[rankA][acidAIndex];
        double acidostatB = this.parameters[rankB][acidBIndex];
        double acidostatAatB = this.parameters[rankA][acidBIndex];
        double acidostatBatA = this.parameters[rankB][acidAIndex];
        logger.info(" ");
        logger.info(" From rank " + this.rank + ": Comparing ranks " + rankA + " (pH = " + pHA + ") & " + rankB + " (pH = " + pHB + ")");
        double deltaE = beta * (acidostatAatB + acidostatBatA - (acidostatA + acidostatB));
        logger.info("pHA = " + pHA + " " + acidostatA + " " + acidostatAatB);
        logger.info("pHB = " + pHB + " " + acidostatB + " " + acidostatBatA);
        logger.info("exp(" + beta + " * ((" + acidostatAatB + " + " + acidostatBatA + ") - (" + acidostatA + " + " + acidostatB + ")))");
        logger.info(" DeltaE: " + deltaE);
        int n = pH;
        this.pHTrialCount[n] = this.pHTrialCount[n] + 1;
        if (deltaE < 0.0 || this.random.nextDouble() < FastMath.exp((double)(-deltaE))) {
            int[][] tempHis = new int[this.extendedSystem.getTitratingResidueList().size()][100];
            for (int i = 0; i < this.extendedSystem.getTitratingResidueList().size(); ++i) {
                System.arraycopy(this.parametersHis[rankA][i], 0, tempHis[i], 0, tempHis[i].length);
                System.arraycopy(this.parametersHis[rankB][i], 0, this.parametersHis[rankA][i], 0, this.parametersHis[rankA][i].length);
                System.arraycopy(tempHis[i], 0, this.parametersHis[rankB][i], 0, this.parametersHis[rankB][i].length);
            }
            this.parameters[rankA][0] = pHB;
            this.parameters[rankB][0] = pHA;
            logger.info(" pH After swap " + this.parameters[rankA][0] + " rankA " + rankA + " acidostat: " + Arrays.toString(this.parameters[rankA]));
            logger.info(" pH After swap " + this.parameters[rankB][0] + " rankB " + rankB + " acidostat: " + Arrays.toString(this.parameters[rankB]));
            this.pH2Rank[pH] = rankB;
            this.pH2Rank[pH + 1] = rankA;
            this.rank2Ph[rankA] = pH + 1;
            this.rank2Ph[rankB] = pH;
            int n2 = pH;
            this.pHAcceptedCount[n2] = this.pHAcceptedCount[n2] + 1;
        }
    }

    private void exchange() {
        for (int pH = 0; pH < this.nReplicas - 1; ++pH) {
            this.compareTwo(pH);
        }
        logger.info(" ");
        for (int i = 0; i < this.pHScale.length - 1; ++i) {
            double pHAcceptance = (double)this.pHAcceptedCount[i] * 100.0 / (double)this.pHTrialCount[i];
            logger.info(" Acceptance for pH " + this.pHScale[i] + " to be exchanged with pH " + this.pHScale[i + 1] + ": " + pHAcceptance);
        }
        logger.info(" ");
    }

    private void dynamicsOpenMM(long titrSteps, long confSteps, double timeStep, double printInterval, double saveInterval) {
        int i = this.rank2Ph[this.rank];
        this.myParameters[0] = this.pHScale[i];
        this.extendedSystem.setConstantPh(this.myParameters[0]);
        this.extendedSystem.copyESVHistogramTo(this.parametersHis[this.rank]);
        boolean initVelocities = true;
        this.x = this.replica.getCoordinates();
        this.potential.energy(this.x);
        this.openMM.setCoordinates(this.x);
        this.openMM.dynamic(confSteps, timeStep, printInterval, saveInterval, this.temp, initVelocities, this.dyn);
        this.x = this.openMM.getCoordinates();
        this.replica.setCoordinates(this.x);
        double forceWriteInterval = (double)titrSteps * 0.001;
        this.replica.dynamic(titrSteps, timeStep, printInterval, forceWriteInterval, this.temp, initVelocities, this.dyn);
        this.reEvaulateAcidostats();
        this.extendedSystem.getESVHistogram(this.parametersHis[this.rank]);
        try {
            this.world.allGather((Buf)this.myParametersBuf, (Buf[])this.parametersBuf);
            this.world.allGather((Buf)this.parametersHisBuf[this.rank], (Buf[])this.parametersHisBuf);
        }
        catch (IOException ex) {
            String message = " Replica Exchange allGather failed.";
            logger.log(Level.SEVERE, message, ex);
        }
    }

    private void dynamics(long nSteps, double timeStep, double printInterval, double saveInterval) {
        int i = this.rank2Ph[this.rank];
        this.myParameters[0] = this.pHScale[i];
        this.extendedSystem.setConstantPh(this.myParameters[0]);
        this.extendedSystem.copyESVHistogramTo(this.parametersHis[this.rank]);
        boolean initVelocities = true;
        this.replica.dynamic(nSteps, timeStep, printInterval, saveInterval, this.temp, initVelocities, this.dyn);
        this.reEvaulateAcidostats();
        this.extendedSystem.getESVHistogram(this.parametersHis[this.rank]);
        try {
            this.world.allGather((Buf)this.myParametersBuf, (Buf[])this.parametersBuf);
            this.world.allGather((Buf)this.parametersHisBuf[this.rank], (Buf[])this.parametersHisBuf);
        }
        catch (IOException ex) {
            String message = " Replica Exchange allGather failed.";
            logger.log(Level.SEVERE, message, ex);
        }
    }

    private void reEvaulateAcidostats() {
        for (int j = 0; j < this.pHScale.length; ++j) {
            this.extendedSystem.setConstantPh(this.pHScale[j]);
            this.myParameters[1 + j] = this.extendedSystem.getBiasEnergy();
        }
        this.extendedSystem.setConstantPh(this.myParameters[0]);
    }

    private void copyToBackups() {
        try {
            Files.move(this.esv.toPath(), this.esv.toPath().resolveSibling(this.esvBackup.getName()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            String message = " Could not copy ESV histogram to backup - dynamics terminated.";
            logger.log(Level.WARNING, message);
            throw new RuntimeException(e);
        }
        try {
            Files.move(this.dyn.toPath(), this.dyn.toPath().resolveSibling(this.dynBackup.getName()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            String message = " Could not copy dyn restart to backup - dynamics terminated.";
            logger.log(Level.WARNING, message);
            throw new RuntimeException(e);
        }
    }

    public int[] setTestingParametersAndExchangeOnce() {
        int[] temp = new int[]{2, 3, 0, 1, 6, 7, 4, 5};
        System.arraycopy(temp, 0, this.pH2Rank, 0, temp.length);
        System.arraycopy(temp, 0, this.rank2Ph, 0, temp.length);
        double[][] temp1 = new double[][]{{9.4, 43.26009292113161, 43.259888231035, 43.2596835409384, 43.259478850841795, 43.25927416074519, 43.25906947064859, 43.25886478055198, 43.25866009045538}, {9.9, 43.28675891594523, 43.286736736302245, 43.28671455665926, 43.28669237701629, 43.286670197373304, 43.28664801773032, 43.286625838087346, 43.28660365844436}, {8.4, 43.256007542834105, 43.25577488677315, 43.2555422307122, 43.25530957465124, 43.25507691859029, 43.25484426252933, 43.25461160646838, 43.25437895040743}, {8.9, 43.28985267712731, 43.28985166897153, 43.28985066081576, 43.28984965265999, 43.28984864450421, 43.28984763634844, 43.28984662819267, 43.28984562003689}, {11.4, 0.7237124623360065, 0.041741256298356136, -0.6402299497392943, -1.3222011557769446, -2.004172361814595, -2.686143567852245, -3.3681147738898956, -4.050085979927546}, {11.9, 0.7229705409794663, 0.0410229865156607, -0.6409245679481451, -1.3228721224119508, -2.0048196768757567, -2.6867672313395623, -3.368714785803368, -4.050662340267174}, {10.4, 0.7191692742214747, 0.037342984956673264, -0.6444833043081281, -1.3263095935729294, -2.0081358828377307, -2.689962172102532, -3.3717884613673337, -4.053614750632135}, {10.9, 0.6741663046798972, -0.006213315424885665, -0.6865929355296684, -1.3669725556344512, -2.047352175739234, -2.727731795844017, -3.4081114159487997, -4.088491036053583}};
        for (int i = 0; i < temp1.length; ++i) {
            System.arraycopy(temp1[i], 0, this.parameters[i], 0, temp1[i].length);
        }
        this.exchange();
        int[] temp2 = new int[this.pH2Rank.length + this.rank2Ph.length];
        System.arraycopy(this.pH2Rank, 0, temp2, 0, this.pH2Rank.length);
        System.arraycopy(this.rank2Ph, 0, temp2, this.pH2Rank.length, this.rank2Ph.length);
        return temp2;
    }
}

