/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.dynamics;

import ffx.numerics.math.RunningStatistics;
import java.util.logging.Logger;

public class NonEquilbriumDynamics {
    private static final Logger logger = Logger.getLogger(NonEquilbriumDynamics.class.getName());
    private final boolean reverseNEQ;
    private final int nonEquilibriumLambdaSteps;
    private final RunningStatistics nonEquilibriumWorkValues;
    private long totalMDSteps = 1L;
    private long nonEquilibiumLambdaUpdateFrequency = Long.MAX_VALUE;

    public NonEquilbriumDynamics(int nonEquilibriumLambdaSteps, boolean reverseNEQ) {
        this.nonEquilibriumLambdaSteps = nonEquilibriumLambdaSteps < 1 ? 100 : nonEquilibriumLambdaSteps;
        this.reverseNEQ = reverseNEQ;
        this.nonEquilibriumWorkValues = new RunningStatistics();
    }

    public int getNonEquilibriumLambdaSteps() {
        return this.nonEquilibriumLambdaSteps;
    }

    public double getInitialLambda() {
        return this.reverseNEQ ? 1.0 : 0.0;
    }

    public long setMDSteps(long nSteps) {
        if (nSteps < 1L) {
            long defaultSteps = 100L * (long)this.nonEquilibriumLambdaSteps;
            logger.info(String.format(" Invalid number of MD steps %d. Setting the number of steps to %d.", nSteps, defaultSteps));
            nSteps = defaultSteps;
        }
        if (nSteps % (long)this.nonEquilibriumLambdaSteps != 0L) {
            logger.info(String.format(" Non-equilibrium lambda steps (%d) is not a multiple of total steps (%d).", this.nonEquilibriumLambdaSteps, nSteps));
            nSteps -= nSteps % (long)this.nonEquilibriumLambdaSteps;
            logger.info(String.format(" Number of steps adjusted to %d.", nSteps));
        }
        this.nonEquilibiumLambdaUpdateFrequency = nSteps / (long)this.nonEquilibriumLambdaSteps;
        this.totalMDSteps = nSteps;
        return nSteps;
    }

    public boolean isUpdateStep(long step) {
        if (step < 1L || step > this.totalMDSteps) {
            logger.severe(String.format(" Invalid MD step number %d. Must be between 1 and %d.", step, this.totalMDSteps));
            return false;
        }
        if (step == this.totalMDSteps) {
            return true;
        }
        return (step - 1L) % this.nonEquilibiumLambdaUpdateFrequency == 0L;
    }

    public void addWork(double work) {
        this.nonEquilibriumWorkValues.addValue(work);
    }

    public double getWork() {
        return this.nonEquilibriumWorkValues.getSum();
    }

    public double getNextLambda(long step, double currentLambda) {
        if (this.isUpdateStep(step)) {
            int lambdaBin = this.getCurrentLambdaBin(step);
            double lambdaStepSize = 1.0 / (double)this.nonEquilibriumLambdaSteps;
            if (this.reverseNEQ) {
                return 1.0 - (double)lambdaBin * lambdaStepSize;
            }
            return (double)lambdaBin * lambdaStepSize;
        }
        logger.warning(String.format(" Non-equilibrium lambda update frequency is %d, but step %d is not a multiple of this frequency.", this.nonEquilibiumLambdaUpdateFrequency, step - 1L));
        logger.warning(String.format(" Returning the current lambda value %6.4f.", currentLambda));
        return currentLambda;
    }

    public int getCurrentLambdaBin(long step) {
        if (step == this.totalMDSteps) {
            return this.nonEquilibriumLambdaSteps;
        }
        if (this.isUpdateStep(step)) {
            return (int)((step - 1L) / this.nonEquilibiumLambdaUpdateFrequency);
        }
        logger.warning(String.format(" Non-equilibrium lambda update frequency is %d, but step %d is not a multiple of this frequency.", this.nonEquilibiumLambdaUpdateFrequency, step - 1L));
        return 0;
    }
}

