/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands.test;

import edu.rit.pj.ParallelTeam;
import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.TopologyOptions;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.parsers.XPHFilter;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" The SortXPH command unwinds .ARC files from CpHMD runs."}, name="test.SortXPH")
public class SortXPH
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private TopologyOptions topology;
    @CommandLine.Option(names={"--nw", "--nWindows"}, paramLabel="-1", defaultValue="-1", description={"If set, auto-determine lambda values and subdirectories (overrides other flags)."})
    private int nWindows;
    @CommandLine.Option(names={"--bT", "--sortByTemp"}, paramLabel="false", defaultValue="false", description={"If set, sort archive files by temperature values"})
    private boolean sortTemp;
    @CommandLine.Option(names={"--sT", "--startTemp"}, paramLabel="298.15", defaultValue="298.15", description={"Sets the starting temperature for the exponential temperature ladder if sorting by temperature."})
    private double lowTemperature;
    @CommandLine.Option(names={"--pH"}, paramLabel="7.4", defaultValue="7.4", description={"Sets the middle of the pH ladder"})
    private double pH;
    @CommandLine.Option(names={"--pHGaps"}, paramLabel="1", defaultValue="1", description={"Sets the size of the gaps in the pH ladder"})
    private double pHGap;
    @CommandLine.Option(names={"--ex", "--exponent"}, paramLabel="0.5", defaultValue="0.5", description={"Sets the exponent for the exponential temperature ladder if sorting by temperature."})
    private double exponent;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"Trajectory files for the first end of the window, followed by trajectories for the other end"})
    private String filename = null;
    private double[] lambdaValues;
    private double[] temperatureValues;
    private double[] pHValues;
    private XPHFilter opener;
    private XPHFilter[] writers;
    private CompositeConfiguration additionalProperties;
    private List<String> windowFiles = new ArrayList<String>();
    private MolecularAssembly molecularAssembly;
    private int threadsAvail;
    private int threadsPer = this.threadsAvail = ParallelTeam.getDefaultThreadCount();
    private ExtendedSystem extendedSystem;

    public void setProperties(CompositeConfiguration additionalProps) {
        this.additionalProperties = additionalProps;
    }

    public SortXPH() {
    }

    public SortXPH(FFXBinding binding) {
        super(binding);
    }

    public SortXPH(String[] args) {
        super(args);
    }

    public SortXPH run() {
        logger.info(" Running");
        if (!this.init()) {
            return this;
        }
        if (this.nWindows != -1) {
            int i;
            for (i = 0; i < this.nWindows; ++i) {
                String fullPathToFile = FilenameUtils.getFullPath((String)this.filename);
                String directoryFullPath = fullPathToFile.replace(this.filename, "") + i;
                this.windowFiles.add(directoryFullPath + File.separator + i);
            }
            this.lambdaValues = new double[this.nWindows];
            this.temperatureValues = new double[this.nWindows];
            this.pHValues = new double[this.nWindows];
            for (i = 0; i < this.nWindows; ++i) {
                if (this.sortTemp) {
                    this.temperatureValues[i] = this.lowTemperature * Math.exp(this.exponent * (double)i);
                    continue;
                }
                double range = (double)this.nWindows * this.pHGap;
                double pHMin = this.pH - range / 2.0;
                if (this.nWindows % 2 != 0) {
                    pHMin += this.pHGap / 2.0;
                }
                this.pHValues[i] = pHMin + (double)i * this.pHGap;
            }
        }
        String[] archiveFullPaths = new String[this.nWindows];
        File file = new File(this.filename);
        String directoryPath = file.getAbsoluteFile().getParent() + File.separator;
        String[] archiveNewPath = new String[this.nWindows];
        File[] saveFile = new File[this.nWindows];
        File[] arcFiles = new File[this.nWindows];
        String archiveName = FilenameUtils.getBaseName((String)this.filename) + ".arc";
        this.writers = new XPHFilter[this.nWindows];
        for (int i = 0; i < this.nWindows; ++i) {
            File arcFile;
            archiveFullPaths[i] = directoryPath + i + File.separator + archiveName;
            arcFiles[i] = arcFile = new File(archiveFullPaths[i]);
            archiveNewPath[i] = directoryPath + i + File.separator + FilenameUtils.getBaseName((String)this.filename) + "_E" + i + ".arc";
            saveFile[i] = new File(archiveNewPath[i]);
        }
        this.molecularAssembly = this.getActiveAssembly(this.filename);
        this.extendedSystem = new ExtendedSystem(this.molecularAssembly, this.pH, null);
        this.molecularAssembly.getPotentialEnergy().attachExtendedSystem(this.extendedSystem);
        int numParallel = this.topology.getTopologiesInParallel(1);
        this.threadsPer = this.threadsAvail / numParallel;
        for (int i = 0; i < this.nWindows; ++i) {
            File arc = saveFile[i];
            this.writers[i] = new XPHFilter(arc, this.molecularAssembly, this.molecularAssembly.getForceField(), this.additionalProperties, this.extendedSystem);
        }
        this.opener = new XPHFilter(this.algorithmFunctions.getFilter(), this.extendedSystem);
        double tolerance = this.sortTemp ? 0.01 : 0.1;
        for (int i = 0; i < this.nWindows; ++i) {
            this.opener.setFile(arcFiles[i]);
            this.molecularAssembly.setFile(arcFiles[i]);
            logger.info("Set file to:" + arcFiles[i].toString());
            int snapshots = this.opener.countNumModels();
            logger.info(String.valueOf(snapshots));
            for (int n = 0; n < snapshots; ++n) {
                boolean resetPosition = n == 0;
                this.opener.readNext(resetPosition, false);
                String remarkLine = this.opener.getRemarkLines()[0];
                double snapshotLambda = 0.0;
                double snapshotTemp = 0.0;
                double snapshotPH = 0.0;
                if (remarkLine.contains(" Lambda: ")) {
                    String[] tokens = remarkLine.split(" +");
                    for (int p = 0; p < tokens.length; ++p) {
                        if (tokens[p].startsWith("Lambda")) {
                            snapshotLambda = Double.parseDouble(tokens[p + 1]);
                        }
                        if (tokens[p].startsWith("Temp")) {
                            snapshotTemp = Double.parseDouble(tokens[p + 1]);
                        }
                        if (!tokens[p].startsWith("pH")) continue;
                        snapshotPH = Double.parseDouble(tokens[p + 1]);
                    }
                }
                for (int k = 0; k < this.nWindows; ++k) {
                    double diff = this.sortTemp ? Math.abs(this.temperatureValues[k] - snapshotTemp) : Math.abs(this.pHValues[k] - snapshotPH);
                }
            }
        }
        return this;
    }
}

