/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands.test;

import edu.rit.pj.Comm;
import ffx.algorithms.cli.RepexOSTOptions;
import ffx.algorithms.cli.ThermodynamicsOptions;
import ffx.algorithms.commands.Thermodynamics;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.algorithms.thermodynamics.HistogramData;
import ffx.algorithms.thermodynamics.LambdaData;
import ffx.algorithms.thermodynamics.MonteCarloOST;
import ffx.algorithms.thermodynamics.OrthogonalSpaceTempering;
import ffx.algorithms.thermodynamics.RepExOST;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.LambdaInterface;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Use Orthogonal Space Tempering with histogram replica exchange to estimate a free energy difference."}, name="test.RepexThermo")
public class RepexThermo
extends Thermodynamics {
    @CommandLine.Mixin
    private RepexOSTOptions repex;
    private RepExOST repExOST;
    private CrystalPotential finalPotential;

    public RepexThermo() {
    }

    public RepexThermo(FFXBinding binding) {
        super(binding);
    }

    public RepexThermo(String[] args) {
        super(args);
    }

    @Override
    public RepexThermo run() {
        boolean lambdaTerm;
        boolean fromActive;
        List<String> arguments;
        if (!this.init()) {
            return this;
        }
        if (this.filenames != null && !this.filenames.isEmpty()) {
            arguments = this.filenames;
            fromActive = false;
        } else {
            logger.warning(" Untested: use of active assembly instead of provided filenames!");
            MolecularAssembly mola = this.algorithmFunctions.getActiveAssembly();
            if (mola == null) {
                logger.info(this.helpString());
                return this;
            }
            arguments = Collections.singletonList(mola.getFile().getName());
            fromActive = true;
        }
        int nArgs = arguments.size();
        this.topologies = new MolecularAssembly[nArgs];
        int numTopologies = this.topologyOptions.getNumberOfTopologies(this.filenames);
        int threadsPer = this.topologyOptions.getThreadsPerTopology(numTopologies);
        this.topologies = new MolecularAssembly[numTopologies];
        boolean bl = lambdaTerm = nArgs == 1 || this.alchemicalOptions.hasSoftcore() || this.topologyOptions.hasSoftcore();
        if (lambdaTerm) {
            System.setProperty("lambdaterm", "true");
        }
        if (nArgs >= 2) {
            System.setProperty("ligand-vapor-elec", "false");
        }
        ArrayList<MolecularAssembly> topologyList = new ArrayList<MolecularAssembly>(nArgs);
        Comm world = Comm.world();
        int size = world.size();
        if (size < 2) {
            logger.severe(" RepexThermo requires multiple processes, found only one!");
        }
        int rank = size > 1 ? world.rank() : 0;
        double initLambda = this.alchemicalOptions.getInitialLambda(size, rank);
        List structureFiles = arguments.stream().map(fn -> new File(new File(FilenameUtils.normalize((String)fn)).getAbsolutePath())).collect(Collectors.toList());
        File firstStructure = (File)structureFiles.get(0);
        String filePathNoExtension = firstStructure.getAbsolutePath().replaceFirst("\\.[^.]+$", "");
        String filepath = FilenameUtils.getFullPath((String)filePathNoExtension);
        String fileBase = FilenameUtils.getBaseName((String)FilenameUtils.getName((String)filePathNoExtension));
        Object rankDirName = String.format("%s%d", filepath, rank);
        File rankDirectory = new File((String)rankDirName);
        if (!rankDirectory.exists()) {
            rankDirectory.mkdir();
        }
        rankDirName = (String)rankDirName + File.separator;
        String withRankName = (String)rankDirName + fileBase;
        File lambdaRestart = new File(withRankName + ".lam");
        boolean lamExists = lambdaRestart.exists();
        logger.info(String.format(" Initializing %d topologies...", nArgs));
        if (fromActive) {
            topologyList.add(this.alchemicalOptions.processFile(this.topologyOptions, this.activeAssembly, 0));
        } else {
            for (int i = 0; i < nArgs; ++i) {
                topologyList.add(this.multiDynamicsOptions.openFile(this.algorithmFunctions, this.topologyOptions, threadsPer, arguments.get(i), i, this.alchemicalOptions, (File)structureFiles.get(i), rank));
            }
        }
        MolecularAssembly[] topologies = topologyList.toArray(new MolecularAssembly[0]);
        StringBuilder sb = new StringBuilder("\n Running ");
        switch (this.thermodynamicsOptions.getAlgorithm()) {
            case OST: {
                sb.append("Orthogonal Space Tempering");
                break;
            }
            default: {
                throw new IllegalArgumentException(" RepexThermo currently does not support fixed-lambda alchemy!");
            }
        }
        sb.append(" with histogram replica exchange for ");
        this.potential = (CrystalPotential)this.topologyOptions.assemblePotential(topologies, sb);
        LambdaInterface linter = (LambdaInterface)this.potential;
        logger.info(sb.toString());
        double[] x = new double[this.potential.getNumberOfVariables()];
        this.potential.getCoordinates(x);
        linter.setLambda(initLambda);
        this.potential.energy(x, true);
        if (nArgs == 1) {
            this.randomSymopOptions.randomize(topologies[0]);
        }
        this.multiDynamicsOptions.distribute(topologies, this.potential, this.algorithmFunctions, rank, size);
        boolean isMC = this.ostOptions.isMonteCarlo();
        boolean twoStep = this.ostOptions.isTwoStep();
        MonteCarloOST mcOST = null;
        if (this.thermodynamicsOptions.getAlgorithm() == ThermodynamicsOptions.ThermodynamicsAlgorithm.OST) {
            MolecularDynamics md;
            File firstHisto = new File(filepath + "0" + File.separator + fileBase + ".his");
            this.orthogonalSpaceTempering = this.ostOptions.constructOST(this.potential, lambdaRestart, firstHisto, topologies[0], this.additionalProperties, this.dynamicsOptions, this.thermodynamicsOptions, this.lambdaParticleOptions, this.algorithmListener, false);
            this.finalPotential = this.ostOptions.applyAllOSTOptions(this.orthogonalSpaceTempering, topologies[0], this.dynamicsOptions, this.barostatOptions);
            if (isMC) {
                mcOST = this.ostOptions.setupMCOST(this.orthogonalSpaceTempering, topologies, this.finalPotential, this.dynamicsOptions, this.thermodynamicsOptions, this.verbose, null, this.algorithmListener);
                md = mcOST.getMD();
            } else {
                md = this.ostOptions.assembleMolecularDynamics(topologies, this.finalPotential, this.dynamicsOptions, this.algorithmListener);
            }
            if (!lamExists) {
                if (this.finalPotential instanceof LambdaInterface) {
                    ((LambdaInterface)this.finalPotential).setLambda(initLambda);
                } else {
                    this.orthogonalSpaceTempering.setLambda(initLambda);
                }
            }
            CompositeConfiguration allProperties = new CompositeConfiguration((Configuration)topologies[0].getProperties());
            if (this.additionalProperties != null) {
                allProperties.addConfiguration(this.additionalProperties);
            }
            for (int i = 1; i < size; ++i) {
                File histogramFile = new File(filepath + i + File.separator + fileBase + ".his");
                File lambdaFile = new File(filepath + i + File.separator + fileBase + ".lam");
                HistogramData histogramData = HistogramData.readHistogram(histogramFile);
                LambdaData lambdaData = LambdaData.readLambdaData(lambdaFile);
                this.orthogonalSpaceTempering.addHistogram(histogramData, lambdaData);
            }
            if (isMC) {
                try {
                    this.repExOST = RepExOST.repexMC(this.orthogonalSpaceTempering, mcOST, this.dynamicsOptions, this.ostOptions, topologies[0].getProperties(), this.writeoutOptions.getFileType(), twoStep, this.repex.getRepexFrequency());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.repExOST = RepExOST.repexMD(this.orthogonalSpaceTempering, md, this.dynamicsOptions, this.ostOptions, topologies[0].getProperties(), this.writeoutOptions.getFileType(), this.repex.getRepexFrequency());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            long eSteps = this.thermodynamicsOptions.getEquilSteps();
            if (eSteps > 0L) {
                try {
                    this.repExOST.mainLoop(eSteps, true);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.repExOST.mainLoop(this.dynamicsOptions.getNumSteps(), false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        logger.severe(" RepexThermo currently does not support fixed-lambda alchemy!");
        logger.info(" " + String.valueOf((Object)this.thermodynamicsOptions.getAlgorithm()) + " with Histogram Replica Exchange Done.");
        return this;
    }

    @Override
    public OrthogonalSpaceTempering getOST() {
        return this.repExOST == null ? null : this.repExOST.getOST();
    }

    @Override
    public CrystalPotential getPotential() {
        return this.repExOST == null ? this.potential : this.repExOST.getOST();
    }

    @Override
    public List<Potential> getPotentials() {
        if (this.repExOST == null) {
            if (this.potential == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.potential);
        }
        return Collections.singletonList(this.repExOST.getOST());
    }
}

