/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands.test;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.ManyBodyOptions;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.NamingUtils;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.RotamerLibrary;
import ffx.utilities.FFXBinding;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(description={" Identify the rotamers a system is in."}, name="test.IdentifyRotamers")
public class IdentifyRotamers
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private ManyBodyOptions mbOpts;
    @CommandLine.Parameters(arity="1", paramLabel="files", description={"The atomic coordinate file in PDB or XYZ format."})
    private List<String> filenames;

    public IdentifyRotamers() {
    }

    public IdentifyRotamers(FFXBinding binding) {
        super(binding);
    }

    public IdentifyRotamers(String[] args) {
        super(args);
    }

    public IdentifyRotamers run() {
        if (!this.init()) {
            return this;
        }
        this.mbOpts.setOriginalCoordinates(false);
        if (this.filenames != null && !this.filenames.isEmpty()) {
            MolecularAssembly[] assemblies = new MolecularAssembly[]{this.algorithmFunctions.open(this.filenames.get(0))};
            this.activeAssembly = assemblies[0];
            if (Boolean.parseBoolean(System.getProperty("standardizeAtomNames", "false"))) {
                NamingUtils.renameAtomsToPDBStandard((MolecularAssembly)this.activeAssembly);
            }
        } else if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.activeAssembly.getPotentialEnergy().setPrintOnFailure(false, false);
        RotamerOptimization rotopt = new RotamerOptimization(this.activeAssembly, (Potential)this.activeAssembly.getPotentialEnergy(), this.algorithmListener);
        this.mbOpts.initRotamerOptimization(rotopt, this.activeAssembly);
        List<Residue> residues = rotopt.getResidues();
        RotamerLibrary rLib = this.mbOpts.getRotamerLibrary(false);
        for (Residue residue : residues) {
            RotamerLibrary.RotamerGuess guess = rLib.guessRotamer(residue);
            logger.info(guess.toString());
        }
        return this;
    }
}

