/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands.test;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Molecule;
import ffx.utilities.FFXBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(description={" Find guest atoms to restrain near host molecule."}, name="test.FindRestraints")
public class FindRestraints
extends AlgorithmsCommand {
    @CommandLine.Option(names={"--hostName"}, paramLabel="BCD", defaultValue="BCD", description={"Host molecule name in the file."})
    private String hostName;
    @CommandLine.Option(names={"--guestName"}, paramLabel="LIG", defaultValue="LIG", description={"Ligand molecule name in the file."})
    private String guestName;
    @CommandLine.Option(names={"--distanceCutoff"}, paramLabel="5", defaultValue="5", description={"Cutoff to use when selecting guest atoms near host COM"})
    private double distanceCutoff;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"XYZ or PDB input files."})
    private List<String> filenames;
    public Potential potential;

    public Potential getPotentialObject() {
        return this.potential;
    }

    public FindRestraints() {
    }

    public FindRestraints(FFXBinding binding) {
        super(binding);
    }

    public FindRestraints(String[] args) {
        super(args);
    }

    public FindRestraints run() {
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filenames.get(0));
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        Molecule[] molArr = this.activeAssembly.getMoleculeArray();
        ArrayList<Atom> restrainHostList = new ArrayList<Atom>();
        ArrayList<Atom> restrainList = new ArrayList<Atom>();
        double[] COM = new double[3];
        double[] subCOM = new double[3];
        int[] restrainHostIndices = new int[]{11, 16, 17, 20, 23, 26, 31, 32, 39, 40, 51, 63, 64, 70, 71, 82, 94, 95, 101, 102, 113, 125, 126, 132, 133, 144, 156, 157, 163, 164, 175, 187, 188, 191, 198};
        for (Molecule molecule : molArr) {
            Atom[] guest_atoms;
            logger.info(String.format(" Molecule name: " + molecule.getName(), new Object[0]));
            if (molecule.getName().contains(this.hostName)) {
                Atom[] host_atoms = molecule.getAtomList().toArray(new Atom[0]);
                COM = FindRestraints.getCOM(host_atoms);
                logger.info(String.format(" Center of mass of host molecule: " + Arrays.toString(COM), new Object[0]));
                for (Atom atom : host_atoms) {
                    if (!FindRestraints.contains(restrainHostIndices, atom.getIndex())) continue;
                    restrainHostList.add(atom);
                    logger.info(String.format(" Atom: " + String.valueOf(atom), new Object[0]));
                }
                Atom[] subAtoms = restrainHostList.toArray(new Atom[0]);
                subCOM = FindRestraints.getCOM(subAtoms);
                logger.info(String.format(" Center of mass of subsection host atoms: " + Arrays.toString(subCOM), new Object[0]));
                double comdist = Math.sqrt(Math.pow(subCOM[0] - COM[0], 2.0) + Math.pow(subCOM[1] - COM[1], 2.0) + Math.pow(subCOM[2] - COM[2], 2.0));
                logger.info(String.format(" Distance between COMs: " + comdist, new Object[0]));
                continue;
            }
            if (!molecule.getName().contains(this.guestName)) continue;
            for (Atom atom : guest_atoms = molecule.getAtomList().toArray(new Atom[0])) {
                double dist = Math.sqrt(Math.pow(atom.getXYZ().get()[0] - subCOM[0], 2.0) + Math.pow(atom.getXYZ().get()[1] - subCOM[1], 2.0) + Math.pow(atom.getXYZ().get()[2] - subCOM[2], 2.0));
                if (!(dist < this.distanceCutoff) || !atom.isHeavy()) continue;
                restrainList.add(atom);
            }
        }
        logger.info(String.format(" Number of atoms to restrain: " + restrainList.size(), new Object[0]));
        int[] restrainIndices = restrainList.stream().mapToInt(Atom::getIndex).toArray();
        logger.info(String.format(" Restrain list indices: " + Arrays.toString(restrainIndices), new Object[0]));
        return this;
    }

    private static double[] getCOM(Atom[] atoms) {
        double[] COM = new double[3];
        double totalMass = 0.0;
        for (Atom s : atoms) {
            double[] pos = s.getXYZ().get();
            COM[0] = COM[0] + pos[0] * s.getMass();
            COM[1] = COM[1] + pos[1] * s.getMass();
            COM[2] = COM[2] + pos[2] * s.getMass();
            totalMass += s.getMass();
        }
        totalMass = 1.0 / totalMass;
        COM[0] = COM[0] * totalMass;
        COM[1] = COM[1] * totalMass;
        COM[2] = COM[2] * totalMass;
        return COM;
    }

    private static boolean contains(int[] array, int value) {
        return Arrays.stream(array).anyMatch(element -> element == value);
    }
}

