/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands.test;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.MinimizeOptions;
import ffx.algorithms.optimize.Minimize;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.ResidueState;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import ffx.utilities.FFXBinding;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Creates a set of conformation dependent rotamers."}, name="test.CreateRotamers")
public class CreateRotamers
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private MinimizeOptions minimizeOptions;
    @CommandLine.Option(names={"-L", "--library"}, paramLabel="2", description={"Ponder and Richards (1) or Richardson (2) rotamer library."})
    private String library = "2";
    @CommandLine.Option(names={"-d", "--rmsd"}, paramLabel="0.1", description={"RMSD cut off for rotamer exclusion: only rotamers with an RMSD greater than this cut off value to all previously saved rotamers will be kept"})
    private double rmsdCutoff = 0.1;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"Atomic coordinate file in PDB or XYZ format."})
    private List<String> filenames = null;
    public ForceFieldEnergy forceFieldEnergy = null;

    public CreateRotamers() {
    }

    public CreateRotamers(FFXBinding binding) {
        super(binding);
    }

    public CreateRotamers(String[] args) {
        super(args);
    }

    public CreateRotamers run() {
        if (!this.init()) {
            return this;
        }
        if (this.filenames != null && !this.filenames.isEmpty()) {
            MolecularAssembly[] assemblies = new MolecularAssembly[]{this.algorithmFunctions.open(this.filenames.get(0))};
            this.activeAssembly = assemblies[0];
        } else if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        String filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info(" Running CreateRotamers on " + filename);
        Atom[] atoms = this.activeAssembly.getAtomArray();
        int nAtoms = atoms.length;
        for (int i = 0; i < nAtoms; ++i) {
            atoms[i].setActive(false);
        }
        boolean useOriginalRotamers = true;
        RotamerLibrary rotamerLibrary = new RotamerLibrary(RotamerLibrary.ProteinLibrary.getProteinLibrary((String)this.library), useOriginalRotamers);
        Polymer[] polymers = this.activeAssembly.getChains();
        RotamerLibrary.initializeDefaultAtomicCoordinates((Polymer[])polymers);
        List residues = this.activeAssembly.getResidueList().stream().filter(r -> {
            Rotamer[] rots = r.setRotamers(rotamerLibrary);
            return rots != null && rots.length > 1;
        }).collect(Collectors.toList());
        logger.info(String.format(" Number of residues: %d\n", residues.size()));
        for (Residue residue : residues) {
            for (Atom atom : residue.getVariableAtoms()) {
                atom.setUse(false);
            }
        }
        String rotFileName = String.format("%s.rot", FilenameUtils.removeExtension((String)filename));
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(new File(rotFileName)));){
            bw.write("ALGORITHM:GLOBAL:1");
            bw.newLine();
            for (Residue residue : residues) {
                StringBuilder resLine = new StringBuilder(" RES:");
                resLine.append(residue.getChainID()).append(":");
                resLine.append(residue.getSegID()).append(":");
                resLine.append(residue.getName()).append(":");
                resLine.append(residue.getResidueNumber()).append("\n");
                bw.write(resLine.toString());
                Rotamer[] rotamers = residue.getRotamers();
                assert (rotamers != null && rotamers.length > 1);
                List sideChainAtoms = residue.getVariableAtoms();
                for (Atom atom : sideChainAtoms) {
                    atom.setActive(true);
                    atom.setUse(true);
                }
                ArrayList<ResidueState> keptRotamers = new ArrayList<ResidueState>();
                int keptRotamersCount = 0;
                for (int i = 0; i < rotamers.length; ++i) {
                    Rotamer rotamer = rotamers[i];
                    RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamer);
                    if (i > 0 || !useOriginalRotamers) {
                        Minimize.MinimizationEngine engine = Minimize.defaultEngine(this.activeAssembly, (Potential)this.activeAssembly.getPotentialEnergy());
                        Minimize minimize = Minimize.minimizeFactory(this.activeAssembly, (Potential)this.activeAssembly.getPotentialEnergy(), this.algorithmListener, engine);
                        minimize.minimize(this.minimizeOptions.getNBFGS(), this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
                    } else {
                        logger.info(" Skipping minimization of original-coordinates rotamer.");
                    }
                    ResidueState newResState = new ResidueState(residue);
                    if (i == 0) {
                        keptRotamers.add(newResState);
                        bw.write(String.format("  ROT:%d\n", keptRotamersCount));
                        for (Atom atom : sideChainAtoms) {
                            double x = atom.getX();
                            double y = atom.getY();
                            double z = atom.getZ();
                            logger.info(String.format(" %s %16.8f %16.8f %16.8f", atom.toString(), x, y, z));
                            StringBuilder atomLine = new StringBuilder("   ATOM:");
                            atomLine.append(atom.getName()).append(":");
                            atomLine.append(x).append(":");
                            atomLine.append(y).append(":");
                            atomLine.append(z).append("\n");
                            bw.write(atomLine.toString());
                        }
                        bw.write("  ENDROT\n");
                        ++keptRotamersCount;
                        continue;
                    }
                    logger.info("Number of rotamers kept for this residue: " + keptRotamers.size());
                    boolean withinRange = false;
                    for (int k = 0; k < keptRotamers.size(); ++k) {
                        double RMSD = newResState.compareTo((ResidueState)keptRotamers.get(k));
                        logger.info("RMSD: " + RMSD + "\n");
                        if (!(RMSD <= this.rmsdCutoff)) continue;
                        withinRange = true;
                    }
                    if (withinRange) {
                        logger.info("Rotamer not kept");
                        continue;
                    }
                    bw.write(String.format("  ROT:%d\n", keptRotamersCount));
                    for (Atom atom : sideChainAtoms) {
                        double x = atom.getX();
                        double y = atom.getY();
                        double z = atom.getZ();
                        logger.info(String.format(" %s %16.8f %16.8f %16.8f", atom.toString(), x, y, z));
                        StringBuilder atomLine = new StringBuilder("   ATOM:");
                        atomLine.append(atom.getName()).append(":");
                        atomLine.append(x).append(":");
                        atomLine.append(y).append(":");
                        atomLine.append(z).append("\n");
                        bw.write(atomLine.toString());
                    }
                    bw.write("  ENDROT\n");
                    keptRotamers.add(newResState);
                    ++keptRotamersCount;
                }
                RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamers[0]);
                for (Atom atom : sideChainAtoms) {
                    atom.setActive(false);
                    atom.setUse(false);
                }
            }
        }
        catch (IOException e) {
            logger.severe("Error writing rotamer file: " + e.getMessage());
            throw new RuntimeException(e);
        }
        return this;
    }
}

