/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands.test;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.misc.GenerateRotamers;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.RotamerLibrary;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Apply a set of torsions to a system."}, name="test.ApplyTorsions")
public class ApplyTorsions
extends AlgorithmsCommand {
    @CommandLine.Option(names={"-c", "--chain"}, paramLabel=" ", description={"Single character chain name (default is \" \")."})
    private String chain = " ";
    @CommandLine.Option(names={"-r", "--resID"}, paramLabel="1", description={"Residue number."})
    private int resID = 1;
    @CommandLine.Option(names={"-t", "--torsionSets"}, paramLabel="0,0:180,0", arity="1..*", split=":", description={"Torsion sets to apply (torsions comma-separated, sets colon-separated)."})
    private String[] torSets = null;
    @CommandLine.Option(names={"-n", "--nChi"}, paramLabel="1", description={"Number of torsions (unspecified torsions are filled with 0)."})
    private int nChi = 1;
    @CommandLine.Option(names={"-v", "--videoFile"}, description={"File to print torsion snapshots to."})
    private String vidFileName = null;
    @CommandLine.Parameters(arity="1", paramLabel="files", description={"XYZ or PDB input files."})
    private List<String> filenames = null;

    public ApplyTorsions() {
    }

    public ApplyTorsions(FFXBinding binding) {
        super(binding);
    }

    public ApplyTorsions(String[] args) {
        super(args);
    }

    public ApplyTorsions run() {
        String modelFilename;
        if (!this.init()) {
            return this;
        }
        if (this.filenames != null && !this.filenames.isEmpty()) {
            MolecularAssembly[] assemblies = new MolecularAssembly[]{this.algorithmFunctions.open(this.filenames.get(0))};
            this.activeAssembly = assemblies[0];
            modelFilename = this.filenames.get(0);
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            modelFilename = this.activeAssembly.getFile().getAbsolutePath();
        }
        String newName = FilenameUtils.getBaseName((String)modelFilename);
        Object videoFile = this.vidFileName != null ? this.vidFileName : newName + "_rots.pdb";
        File outFile = new File(newName + ".rotout.tmp");
        outFile.deleteOnExit();
        logger.info("\n Saving torsions for residue number " + this.resID + " of chain " + this.chain + ".");
        RotamerLibrary.initializeDefaultAtomicCoordinates((Polymer[])this.activeAssembly.getChains());
        Polymer polymer = this.activeAssembly.getChain(this.chain);
        if (polymer == null) {
            logger.info(" Polymer " + this.chain + " does not exist.");
            return this;
        }
        Residue residue = polymer.getResidue(this.resID);
        if (residue == null) {
            logger.info(" Residue " + this.resID + " does not exist.");
            return this;
        }
        GenerateRotamers generateRotamers = new GenerateRotamers(this.activeAssembly, (Potential)this.activeAssembly.getPotentialEnergy(), residue, outFile, this.nChi, this.algorithmListener);
        generateRotamers.setVideo((String)videoFile);
        if (this.torSets != null) {
            generateRotamers.applyAndSaveTorsions(this.torSets);
        } else {
            logger.info(" No torsion sets specified. Use -t option to apply torsions.");
        }
        return this;
    }
}

