/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import edu.rit.pj.Comm;
import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.optimize.TorsionSearch;
import ffx.numerics.Potential;
import ffx.potential.AssemblyState;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;
import picocli.CommandLine;

@CommandLine.Command(description={" The TorsionSearch command enumerates conformations of a molecule using torsional scans around rotatable bonds."}, name="TorsionSearch")
public class TorsionScan
extends AlgorithmsCommand {
    @CommandLine.Option(names={"--th", "--theta"}, paramLabel="60.0", defaultValue="60.0", description={"Step size for bond rotations (in Degrees)."})
    private double increment = 60.0;
    @CommandLine.Option(names={"--saveNumStates", "--sns"}, paramLabel="10", defaultValue="10", description={"Save this many of the lowest energy states per worker. This is the default."})
    private int saveNumStates = 10;
    @CommandLine.Option(names={"--elimMax", "--em"}, paramLabel="0", defaultValue="0", description={"Eliminate bonds where one torsion causes high energies. Reduces the complexity of the search."})
    private int elimMax = 0;
    @CommandLine.Option(names={"--saveAll"}, paramLabel="false", defaultValue="false", description={"Save out all states. Not recommended for large systems."})
    private boolean saveAll = false;
    @CommandLine.Option(names={"--sc", "--staticComparison"}, paramLabel="false", defaultValue="false", description={"If set, each bond is rotated independently (faster, but fewer permutations)."})
    private boolean staticCompare;
    @CommandLine.Option(names={"--eliminationThreshold", "--et"}, paramLabel="50.0", defaultValue="50.0", description={"Remove bonds that cause > this energy change during static analysis (kcal/mol)."})
    private double eliminationThreshold = 50.0;
    @CommandLine.Option(names={"--startIndex"}, paramLabel="0", defaultValue="0", description={"Start at this hilbert index."})
    private long startIndex = 0L;
    @CommandLine.Option(names={"--endIndex"}, paramLabel="0", defaultValue="0", description={"End at this hilbert index."})
    private long endIndex = 0L;
    @CommandLine.Parameters(arity="1", paramLabel="files", description={"Atomic coordinate file(s) to permute in XYZ format."})
    String filename = null;

    public TorsionScan() {
    }

    public TorsionScan(FFXBinding binding) {
        super(binding);
    }

    public TorsionScan(String[] args) {
        super(args);
    }

    public TorsionScan run() {
        block34: {
            System.setProperty("polarization", "direct");
            if (!this.init()) {
                return this;
            }
            if (this.filename == null) {
                logger.info(this.helpString());
                return this;
            }
            this.activeAssembly = this.getActiveAssembly(this.filename);
            SystemFilter systemFilter = this.algorithmFunctions.getFilter();
            MolecularAssembly ma = systemFilter.getActiveMolecularSystem();
            logger.info("");
            ForceFieldEnergy forceFieldEnergy = this.activeAssembly.getPotentialEnergy();
            double[] x = new double[forceFieldEnergy.getNumberOfVariables()];
            Comm world = Comm.world();
            int rank = world.rank();
            int size = world.size();
            if (this.saveAll) {
                this.saveNumStates = -1;
            }
            int numTorsions = (int)FastMath.ceil((double)(360.0 / this.increment));
            TorsionSearch torsionSearch = new TorsionSearch(ma, ma.getMoleculeArray()[0], numTorsions, this.saveNumStates);
            if (size > 1 && rank == 0) {
                torsionSearch.staticAnalysis(this.elimMax, this.eliminationThreshold);
            } else if (size == 1) {
                torsionSearch.staticAnalysis(this.elimMax, this.eliminationThreshold);
            }
            if (world.size() > 1 && !this.staticCompare) {
                torsionSearch.buildWorker(rank, size);
                torsionSearch.runWorker();
            } else if (!this.staticCompare) {
                this.endIndex = this.endIndex == 0L ? torsionSearch.getEnd() : this.endIndex;
                torsionSearch.spinTorsions(this.startIndex, this.endIndex);
            }
            List<AssemblyState> states = torsionSearch.getStates();
            List<Double> energies = torsionSearch.getEnergies();
            List<Long> hilbertIndices = torsionSearch.getHilbertIndices();
            int count = 0;
            logger.info("\n Saving " + states.size() + " states.");
            Object extension = "_rot.arc";
            if (world.size() > 1) {
                extension = "_rank" + world.rank() + (String)extension;
            }
            File saveLocation = new File(FilenameUtils.removeExtension((String)this.filename) + (String)extension);
            logger.info(" Logging structures into: " + String.valueOf(saveLocation));
            XYZFilter xyzFilter = new XYZFilter(saveLocation, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
            while (!states.isEmpty()) {
                AssemblyState assembly = states.get(0);
                states.remove(0);
                assembly.revertState();
                forceFieldEnergy.getCoordinates(x);
                double e = energies.get(0);
                energies.remove(0);
                long hilbertIndex = hilbertIndices.get(0);
                hilbertIndices.remove(0);
                logger.info(String.format(" Writing to file. Configuration #%-6d energy: %-12.5f Hilbert index: %-15d", count + 1, e, hilbertIndex));
                xyzFilter.writeFile(saveLocation, true);
                ++count;
            }
            logger.info("\n -1 indices come from static torsion scan.");
            File key = new File(FilenameUtils.removeExtension((String)this.filename) + ".key");
            File properties = new File(FilenameUtils.removeExtension((String)this.filename) + ".properties");
            try {
                if (key.exists()) {
                    File keyComparison = new File(FilenameUtils.removeExtension((String)this.filename) + "_rot.key");
                    if (keyComparison.createNewFile()) {
                        FileUtils.copyFile((File)key, (File)keyComparison);
                    }
                } else if (properties.exists()) {
                    File propertiesComparison = new File(FilenameUtils.removeExtension((String)this.filename) + "_rot.properties");
                    if (propertiesComparison.createNewFile()) {
                        FileUtils.copyFile((File)properties, (File)propertiesComparison);
                    }
                } else {
                    logger.info(" No key or properties file found.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (world.rank() == 0 && world.size() > 1) {
                logger.info("\n Combining all rank files into one file.");
                File combined = new File(FilenameUtils.removeExtension((String)this.filename) + "_rot.arc");
                try {
                    if (!combined.createNewFile()) break block34;
                    try (FileOutputStream fos = new FileOutputStream(combined);){
                        for (int i = 0; i < world.size(); ++i) {
                            File rankFile = new File(FilenameUtils.removeExtension((String)this.filename) + "_rank" + i + "_rot.arc");
                            if (!rankFile.exists()) continue;
                            try (FileInputStream fis = new FileInputStream(rankFile);){
                                int length;
                                byte[] buffer = new byte[1024];
                                while ((length = fis.read(buffer)) > 0) {
                                    fos.write(buffer, 0, length);
                                }
                                continue;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        return Collections.emptyList();
    }
}

