/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.utilities.FFXBinding;
import ffx.utilities.PortUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(description={" The Scheduler runs parallel jobs over nodes."}, name="Scheduler")
public class Scheduler
extends AlgorithmsCommand {
    @CommandLine.Option(names={"-v", "--verbose"}, paramLabel="", defaultValue="false", description={"Turn on verbose logging during backend Parallel Java startup."})
    private boolean v = false;
    @CommandLine.Option(names={"-p", "--threadsPerProcess"}, paramLabel="all", defaultValue="-1", description={"The number of cores (threads) per process (requires -Dpj.nt=X satisfies X <= p)."})
    private int p = -1;
    @CommandLine.Option(names={"-P", "--port"}, paramLabel="20617", defaultValue="20617", description={"Set the port the front end server will listen on."})
    private int port = 20617;
    @CommandLine.Option(names={"-W", "--webPort"}, paramLabel="8080", description={"Set the port the server will serve a webpage to."})
    private int webPort = 8080;
    @CommandLine.Option(names={"--ib", "--ipoib"}, description={"Replace the \"hpc\" domain with the \"ipoib\" domain to use the Argon high-speed network."})
    private boolean ipoib = false;
    @CommandLine.Option(names={"-e", "--hostfile"}, paramLabel="PE_HOSTFILE", description={"Environment variable that points to the host file."})
    private String hostfileName = "PE_HOSTFILE";
    @CommandLine.Option(names={"-m", "--memory"}, paramLabel="2G", description={"String value of -Xmx to pass to worker nodes."})
    private String memory = "2G";

    public Scheduler() {
    }

    public Scheduler(FFXBinding binding) {
        super(binding);
    }

    public Scheduler(String[] args) {
        super(args);
    }

    public Scheduler run() {
        block20: {
            int n;
            if (!this.init()) {
                return this;
            }
            int CPUs = Runtime.getRuntime().availableProcessors();
            int processes = 1;
            if (this.p > 0 && (n = this.p) < CPUs && CPUs % n == 0) {
                processes = CPUs / n;
                CPUs = n;
            }
            String hostsFile = System.getenv(this.hostfileName);
            String[] hostnames = new String[]{"localhost"};
            if (hostsFile == null) {
                logger.info(" The " + this.hostfileName + " environment variable is empty.");
                logger.info(" Only localhost will be used.\n");
            } else {
                File host = new File(hostsFile);
                if (!host.exists() || !host.canRead()) {
                    logger.info(" The file path specified by the " + this.hostfileName + " environment variable does not exist or cannot be read.");
                    logger.info(" Only localhost will be used.\n");
                } else {
                    try {
                        List<String> nodes = Files.readAllLines(host.toPath());
                        hostnames = new String[nodes.size()];
                        int i = 0;
                        for (String line : nodes) {
                            hostnames[i] = line.split(" +")[0];
                            if (this.ipoib) {
                                hostnames[i] = hostnames[i].replace("hpc", "ipoib");
                            }
                            ++i;
                        }
                    }
                    catch (IOException e) {
                        logger.info(" Error reading host file: " + e.getMessage());
                        logger.info(" Only localhost will be used.\n");
                    }
                }
            }
            if (this.port <= 1) {
                logger.info(" The scheduler port must be greater than 1; the default of 20617 will be used.");
                this.port = 20617;
            }
            while (!PortUtils.isTcpPortAvailable((int)this.port)) {
                logger.info(String.format(" Scheduler port %d is not available.", this.port));
                if (++this.port <= 65535) continue;
                logger.severe(" Reached port 65535 without finding an open scheduler port!");
            }
            logger.info(String.format(" Scheduler port: %d.", this.port));
            String logFile = String.format("scheduler.%d.log", this.port);
            while (!PortUtils.isTcpPortAvailable((int)this.webPort) || this.webPort == this.port) {
                logger.info(String.format(" Web port %d is not available.", this.webPort));
                if (++this.webPort <= 65535) continue;
                logger.severe(" Reached port 65535 without finding an open web port!");
            }
            logger.info(String.format(" Web port: %d.", this.webPort));
            String frontend = hostnames[0];
            StringBuilder sb = new StringBuilder();
            sb.append("# Force Field X Cluster Configuration File\n");
            sb.append("cluster Force Field X Cluster\n");
            sb.append(String.format("logfile %s\n", logFile));
            sb.append("webhost 127.0.0.1\n");
            sb.append(String.format("webport %d\n", this.webPort));
            sb.append("schedulerhost localhost\n");
            sb.append(String.format("schedulerport %d\n", this.port));
            sb.append(String.format("frontendhost %s\n", frontend));
            String javaHome = System.getProperty("java.home");
            String java = javaHome + "/bin/java";
            String classpath = System.getProperty("java.class.path");
            String arg = "-Xmx" + this.memory;
            if (this.v) {
                arg = arg + " -Dpj.verbose=true";
            }
            arg = arg + " --add-modules jdk.incubator.vector";
            int i = 0;
            for (int proc = 0; proc < processes; ++proc) {
                for (String node : hostnames) {
                    sb.append("backend node" + i + " " + CPUs + " " + node + " " + java + " " + classpath + " " + arg + "\n");
                    ++i;
                }
            }
            String pjConfig = "cluster.txt";
            File config = new File(pjConfig);
            try {
                Files.writeString(config.toPath(), (CharSequence)sb.toString(), new OpenOption[0]);
            }
            catch (IOException e) {
                logger.severe(" Error writing configuration file: " + e.getMessage());
                return this;
            }
            String ffxHome = System.getProperty("basedir");
            try {
                ProcessBuilder pb = new ProcessBuilder(ffxHome + "/bin/scheduler", pjConfig);
                Process process = pb.start();
                process.waitFor();
            }
            catch (IOException | InterruptedException e) {
                logger.severe(" Error executing scheduler: " + e.getMessage());
                if (!(e instanceof InterruptedException)) break block20;
                Thread.currentThread().interrupt();
            }
        }
        return this;
    }
}

