/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.MinimizeOptions;
import ffx.crystal.Crystal;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.parsers.PDBFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XPHFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.utilities.FFXBinding;
import ffx.utilities.FileUtils;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;
import picocli.CommandLine;

@CommandLine.Command(description={" Run L-BFGS minimization on a CpHMD system."}, name="test.MinimizePh")
public class PhMinimize
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private MinimizeOptions minimizeOptions;
    @CommandLine.Option(names={"--pH", "--constantPH"}, paramLabel="7.4", defaultValue="7.4", description={"pH value for the energy evaluation. (Only applies when esvTerm is true)"})
    private double pH;
    @CommandLine.Option(names={"--coords"}, paramLabel="false", defaultValue="false", description={"Minimize spatial coordinates along with titration"})
    private boolean coords;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"Atomic coordinate files in PDB or XYZ format."})
    private String filename;
    private ForceFieldEnergy forceFieldEnergy;

    public PhMinimize() {
    }

    public PhMinimize(FFXBinding binding) {
        super(binding);
    }

    public PhMinimize(String[] args) {
        super(args);
    }

    public PhMinimize run() {
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info("\n Running MinimizePh on " + this.filename);
        this.forceFieldEnergy = this.activeAssembly.getPotentialEnergy();
        ExtendedSystem esvSystem = new ExtendedSystem(this.activeAssembly, this.pH, null);
        esvSystem.setConstantPh(this.pH);
        int numESVs = esvSystem.getExtendedResidueList().size();
        this.forceFieldEnergy.attachExtendedSystem(esvSystem);
        logger.info(String.format(" Attached extended system with %d residues.", numESVs));
        double[] x = new double[this.forceFieldEnergy.getNumberOfVariables()];
        this.forceFieldEnergy.getCoordinates(x);
        this.forceFieldEnergy.energy(x, true);
        SystemFilter systemFilter = this.algorithmFunctions.getFilter();
        if (systemFilter instanceof XYZFilter) {
            XPHFilter xphFilter = new XPHFilter(this.activeAssembly.getFile(), this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties(), esvSystem);
            xphFilter.readFile();
            logger.info(" Reading ESV lambdas from XPH file");
            this.forceFieldEnergy.getCoordinates(x);
            this.forceFieldEnergy.energy(x, true);
        }
        ffx.algorithms.optimize.PhMinimize minimize = new ffx.algorithms.optimize.PhMinimize(this.activeAssembly, (Potential)this.forceFieldEnergy, this.algorithmListener, esvSystem);
        double energy = minimize.getEnergy();
        double tolerance = 1.0E-10;
        if (this.coords) {
            while (true) {
                minimize.minimizeCoordinates(this.minimizeOptions.getNBFGS(), this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
                double newEnergy = minimize.getEnergy();
                int status = minimize.getStatus();
                if (status == 0 && !(FastMath.abs((double)(newEnergy - energy)) <= tolerance)) {
                    energy = newEnergy;
                    minimize.minimizeTitration(this.minimizeOptions.getNBFGS(), this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
                    newEnergy = minimize.getEnergy();
                    status = minimize.getStatus();
                    if (status == 0 && !(FastMath.abs((double)(newEnergy - energy)) <= tolerance)) {
                        energy = newEnergy;
                        continue;
                    }
                }
                break;
            }
        } else {
            minimize.minimizeTitration(this.minimizeOptions.getNBFGS(), this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
        }
        this.forceFieldEnergy.getCoordinates(x);
        this.forceFieldEnergy.energy(x, true);
        esvSystem.writeRestart();
        String modelFilename = this.activeAssembly.getFile().getAbsolutePath();
        if (!(this.baseDir != null && this.baseDir.exists() && this.baseDir.isDirectory() && this.baseDir.canWrite())) {
            this.baseDir = new File(FilenameUtils.getFullPath((String)modelFilename));
        }
        String dirName = this.baseDir.toString() + File.separator;
        String fileName = FilenameUtils.getName((String)modelFilename);
        String ext = FilenameUtils.getExtension((String)fileName);
        fileName = FilenameUtils.removeExtension((String)fileName);
        File saveFile = null;
        XYZFilter writeFilter = null;
        if (ext.toUpperCase().contains("XYZ")) {
            saveFile = new File(dirName + fileName + ".xyz");
            writeFilter = new XYZFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
            this.algorithmFunctions.saveAsXYZ(this.activeAssembly, saveFile);
        } else if (ext.toUpperCase().contains("ARC")) {
            saveFile = new File(dirName + fileName + ".arc");
            saveFile = this.algorithmFunctions.versionFile(saveFile);
            writeFilter = new XYZFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
            this.algorithmFunctions.saveAsXYZ(this.activeAssembly, saveFile);
        } else {
            saveFile = new File(dirName + fileName + ".pdb");
            saveFile = this.algorithmFunctions.versionFile(saveFile);
            PDBFilter pdbFilter = new PDBFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
            writeFilter = pdbFilter;
            int numModels = systemFilter.countNumModels();
            if (numModels > 1) {
                pdbFilter.setModelNumbering(0);
            }
            pdbFilter.writeFile(saveFile, true, false, false);
        }
        if (systemFilter instanceof XYZFilter || systemFilter instanceof PDBFilter) {
            while (systemFilter.readNext()) {
                Crystal crystal = this.activeAssembly.getCrystal();
                ForceFieldEnergy forceFieldEnergy = this.activeAssembly.getPotentialEnergy();
                forceFieldEnergy.setCrystal(crystal);
                if (systemFilter instanceof PDBFilter) {
                    FileUtils.append((File)saveFile, (String)"ENDMDL\n");
                    minimize.minimizeTitration(this.minimizeOptions.getNBFGS(), this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
                    PDBFilter pdbFilter = (PDBFilter)systemFilter;
                    pdbFilter.writeFile(saveFile, true, false, false);
                    continue;
                }
                minimize.minimizeTitration(this.minimizeOptions.getNBFGS(), this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
                writeFilter.writeFile(saveFile, true);
            }
            if (systemFilter instanceof PDBFilter) {
                FileUtils.append((File)saveFile, (String)"END\n");
            }
        }
        return this;
    }
}

