/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.ForceFieldFilter;
import ffx.potential.parsers.PDBFilter;
import ffx.utilities.FFXBinding;
import ffx.utilities.Keyword;
import ffx.utilities.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import picocli.CommandLine;

@CommandLine.Command(description={" Mutate PDB residue(s)."}, name="MutatePDB")
public class MutatePDB
extends AlgorithmsCommand {
    @CommandLine.Option(names={"--resid", "-r"}, paramLabel="1", defaultValue="1", description={"Residue number(s)."})
    private String resIDs;
    @CommandLine.Option(names={"--resname", "-n"}, paramLabel="ALA", defaultValue="ALA", description={"New residue name(s)."})
    private String resNameString;
    @CommandLine.Option(names={"--chain", "--ch"}, paramLabel=" ", defaultValue=" ", description={"Single character chain name (default is ' ')."})
    private String chainString;
    @CommandLine.Option(names={"--rotamer", "-R"}, paramLabel="-1", defaultValue="-1", description={"Rotamer number to apply."})
    private int rotamer;
    @CommandLine.Option(names={"--allChains"}, paramLabel="false", defaultValue="false", description={"Mutate all copies of a chains in a multimeric protein."})
    private boolean allChains;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"A PDB input file."})
    private String filename;
    private ForceFieldEnergy forceFieldEnergy;

    public MutatePDB() {
    }

    public MutatePDB(FFXBinding binding) {
        super(binding);
    }

    public MutatePDB(String[] args) {
        super(args);
    }

    public MutatePDB run() {
        int i;
        if (!this.init()) {
            return this;
        }
        MolecularAssembly falseAssembly = this.getActiveAssembly(this.filename);
        if (falseAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        List resIDint = StringUtils.parseAtomRanges((String)"residueID", (String)this.resIDs, (int)falseAssembly.getAtomList().size());
        String[] resNameArr = (String[])Arrays.stream(this.resNameString.split("\\.|,|;")).map(String::trim).toArray(String[]::new);
        String[] chainStringArr = (String[])Arrays.stream(this.chainString.split("\\.|,|;")).map(String::trim).toArray(String[]::new);
        Object s = "";
        for (String sub : chainStringArr) {
            if (sub.length() >= 2) {
                logger.warning("Chain ID's have to be single characters separated by commas!");
                return this;
            }
            s = (String)s + sub;
        }
        char[] chainArr = ((String)s).toCharArray();
        Polymer[] chains = falseAssembly.getChains();
        if (chains.length == 1 && chainArr.length == 0) {
            chainArr = new char[]{chains[0].getChainID().charValue()};
        }
        if (resIDint.size() != resNameArr.length) {
            logger.warning("The number of chains, residue names, and residue ids must be the same!");
            return this;
        }
        int destRotamer = 0;
        if (this.rotamer > -1) {
            destRotamer = this.rotamer;
        }
        File structureFile = new File(this.filename);
        int index = this.filename.lastIndexOf(".");
        String name = this.filename.substring(0, index);
        MolecularAssembly molecularAssembly = new MolecularAssembly(name);
        molecularAssembly.setFile(structureFile);
        CompositeConfiguration properties = Keyword.loadProperties((File)structureFile);
        ForceFieldFilter forceFieldFilter = new ForceFieldFilter(properties);
        ForceField forceField = forceFieldFilter.parse();
        molecularAssembly.setForceField(forceField);
        PDBFilter pdbFilter = new PDBFilter(structureFile, molecularAssembly, forceField, properties);
        ArrayList<PDBFilter.Mutation> mutations = new ArrayList<PDBFilter.Mutation>();
        for (i = 0; i <= resIDint.size() - 1; ++i) {
            if (this.allChains) {
                Polymer[] polymerArray = chains;
                int n = polymerArray.length;
                for (int j = 0; j < n; ++j) {
                    Polymer currentChain = polymerArray[j];
                    logger.info("\n Mutating residue number " + ((Integer)resIDint.get(i) + 1) + " of chain " + currentChain.getChainID() + " to " + resNameArr[i]);
                    mutations.add(new PDBFilter.Mutation((Integer)resIDint.get(i) + 1, currentChain.getChainID().charValue(), resNameArr[i]));
                }
                continue;
            }
            logger.info("\n Mutating residue number " + ((Integer)resIDint.get(i) + 1) + " of chain " + chainArr[i] + " to " + resNameArr[i]);
            mutations.add(new PDBFilter.Mutation((Integer)resIDint.get(i) + 1, chainArr[i], resNameArr[i]));
        }
        pdbFilter.mutate(mutations);
        pdbFilter.readFile();
        pdbFilter.applyAtomProperties();
        molecularAssembly.finalize(true, forceField);
        if (destRotamer > -1) {
            if (this.allChains) {
                for (Polymer currentChain : chains = molecularAssembly.getChains()) {
                    for (int i2 = 0; i2 <= resIDint.size() - 1; ++i2) {
                        Residue residue = currentChain.getResidue((Integer)resIDint.get(i2) + 1);
                        Rotamer[] rotamers = residue.getRotamers();
                        if (rotamers != null && rotamers.length > 0) {
                            RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamers[destRotamer]);
                            continue;
                        }
                        logger.info(" No rotamer to apply.");
                    }
                }
            } else {
                for (i = 0; i <= resIDint.size() - 1; ++i) {
                    Polymer polymer = molecularAssembly.getChain(String.valueOf(chainArr[i]));
                    Residue residue = polymer.getResidue((Integer)resIDint.get(i) + 1);
                    Rotamer[] rotamers = residue.getRotamers();
                    if (rotamers != null && rotamers.length > destRotamer) {
                        RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamers[destRotamer]);
                        continue;
                    }
                    logger.info(" No rotamer to apply.");
                }
            }
        }
        pdbFilter.writeFile(structureFile, false);
        for (PDBFilter.Mutation mut : mutations) {
            mut.calculateTorsion();
        }
        this.forceFieldEnergy = molecularAssembly.getPotentialEnergy();
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        List<Object> potentials = this.forceFieldEnergy == null ? Collections.emptyList() : Collections.singletonList(this.forceFieldEnergy);
        return potentials;
    }
}

