/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.cli.LambdaParticleOptions;
import ffx.algorithms.cli.MultiDynamicsOptions;
import ffx.algorithms.cli.OSTOptions;
import ffx.algorithms.cli.ThermodynamicsOptions;
import ffx.algorithms.thermodynamics.OrthogonalSpaceTempering;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Evaluate the Orthogonal Space Histogram."}, name="Histogram")
public class Histogram
extends AlgorithmsCommand {
    @CommandLine.Option(names={"-s", "--save"}, paramLabel="false", description={"Save the bias histogram to histogram.txt, the total PMF to pmf.txt, and 2D PMF to pmf.2D.txt"})
    private boolean save = false;
    @CommandLine.Option(names={"-b", "--bias"}, paramLabel="false", description={"By default, the PMF is saved. This flag flips the sign to give the OST bias."})
    private boolean bias = false;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"XYZ or PDB input file."})
    private String filename;
    private OrthogonalSpaceTempering orthogonalSpaceTempering;
    private File saveDir = null;

    public Histogram() {
    }

    public Histogram(FFXBinding binding) {
        super(binding);
    }

    public Histogram(String[] args) {
        super(args);
    }

    public Histogram run() {
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info("\n Evaluating Histogram for " + this.filename);
        File structureFile = new File(FilenameUtils.normalize((String)this.filename));
        structureFile = new File(structureFile.getAbsolutePath());
        String baseFilename = FilenameUtils.removeExtension((String)structureFile.getName());
        File histogramRestart = new File(baseFilename + ".his");
        File lambdaRestart = null;
        ForceFieldEnergy energy = this.activeAssembly.getPotentialEnergy();
        energy.energy(true, true);
        logger.info("");
        if (!(this.saveDir != null && this.saveDir.exists() && this.saveDir.isDirectory() && this.saveDir.canWrite())) {
            this.saveDir = new File(FilenameUtils.getFullPath((String)this.filename));
        }
        DynamicsOptions dynamicsOptions = new DynamicsOptions();
        LambdaParticleOptions lambdaParticleOptions = new LambdaParticleOptions();
        MultiDynamicsOptions multiDynamicsOptions = new MultiDynamicsOptions();
        ThermodynamicsOptions thermodynamicsOptions = new ThermodynamicsOptions();
        OSTOptions ostOptions = new OSTOptions();
        this.orthogonalSpaceTempering = ostOptions.constructOST((CrystalPotential)energy, lambdaRestart, histogramRestart, this.activeAssembly, null, dynamicsOptions, thermodynamicsOptions, lambdaParticleOptions, this.algorithmListener, !multiDynamicsOptions.isSynchronous());
        if (this.save) {
            FileWriter fileWriter;
            this.orthogonalSpaceTempering.setMolecularAssembly(this.activeAssembly);
            OrthogonalSpaceTempering.Histogram histogram = this.orthogonalSpaceTempering.getHistogram();
            histogram.updateFreeEnergyDifference(false, true);
            StringBuffer sb = histogram.evaluateTotalOSTBias(this.bias);
            String dirName = this.saveDir.toString() + File.separator;
            String file = dirName + "pmf.txt";
            logger.info(" Writing " + file);
            try {
                fileWriter = new FileWriter(file);
                try {
                    fileWriter.write(sb.toString());
                }
                finally {
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                logger.severe("Error writing file " + file + ": " + e.getMessage());
            }
            sb = histogram.evaluate2DOSTBias(this.bias);
            file = dirName + "pmf.2D.txt";
            logger.info(" Writing " + file);
            try {
                fileWriter = new FileWriter(file);
                try {
                    fileWriter.write(sb.toString());
                }
                finally {
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                logger.severe("Error writing file " + file + ": " + e.getMessage());
            }
        }
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        List<Object> potentials = this.orthogonalSpaceTempering == null ? Collections.emptyList() : Collections.singletonList(this.orthogonalSpaceTempering);
        return potentials;
    }
}

