/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.ParallelStateEnergy;
import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.crystal.Crystal;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.numerics.estimator.FreeEnergyDifferenceReporter;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.AlchemicalOptions;
import ffx.potential.cli.TopologyOptions;
import ffx.potential.parsers.BARFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.utils.PotentialsFunctions;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Evaluates a free energy change with the Bennett Acceptance Ratio algorithm using pregenerated snapshots."}, name="BAR")
public class BAR
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private AlchemicalOptions alchemicalOptions;
    @CommandLine.Mixin
    private TopologyOptions topologyOptions;
    @CommandLine.Option(names={"--eb", "--evaluateBAR"}, paramLabel="false", defaultValue="false", description={"Evaluate Free Energy Differences from Tinker BAR files."})
    private boolean evaluateBARFiles = false;
    @CommandLine.Option(names={"--l2", "--lambdaTwo"}, paramLabel="1.0", description={"Lambda value for the upper edge of the window"})
    private double lambda2 = 1.0;
    @CommandLine.Option(names={"-t", "--temperature"}, paramLabel="298.15", description={"Temperature for system"})
    private double temperature = 298.15;
    @CommandLine.Option(names={"--dV", "--volume"}, paramLabel="false", description={"Write out snapshot volumes to the Tinker BAR file."})
    private boolean includeVolume = false;
    @CommandLine.Option(names={"--ns", "--nStates"}, paramLabel="2", description={"If not equal to two, auto-determine lambda values and subdirectories (overrides other flags)."})
    private int nStates = 2;
    @CommandLine.Option(names={"--sa", "--sortedArc"}, paramLabel="false", description={"If set, use sorted archive values."})
    private boolean sortedArc = false;
    @CommandLine.Option(names={"--ss", "--startSnapshot"}, paramLabel="0", description={"Start at this snapshot when reading in Tinker BAR files (indexed from 0)."})
    private int startingSnapshot = 0;
    @CommandLine.Option(names={"--es", "--endSnapshot"}, paramLabel="0", description={"End at this snapshot when reading in Tinker BAR files (indexed from 0)."})
    private int endingSnapshot = 0;
    @CommandLine.Option(names={"--ni", "--nIterations"}, paramLabel="1000", description={"Specify the maximum number of iterations for BAR convergence."})
    private int nIterations = 1000;
    @CommandLine.Option(names={"-e", "--eps"}, paramLabel="1.0E-4", description={"Specify convergence cutoff for BAR calculation."})
    private double eps = 1.0E-4;
    @CommandLine.Parameters(arity="0..*", paramLabel="files", description={"A single PDB/XYZ when windows are auto-determined (or two for dual topology). Two trajectory files for BAR between two ensembles (or four for dual topology)."})
    private List<String> filenames = null;
    private Configuration additionalProperties;
    MolecularAssembly[] topologies;
    private int numTopologies;
    CrystalPotential potential;
    int nFiles;
    private String[] files;
    double[] lambdaValues;
    private FreeEnergyDifferenceReporter reporter;

    public BAR() {
    }

    public BAR(FFXBinding binding) {
        super(binding);
    }

    public BAR(String[] args) {
        super(args);
    }

    public void setProperties(Configuration additionalProps) {
        this.additionalProperties = additionalProps;
    }

    public BAR run() {
        boolean isPBC;
        if (!this.init()) {
            return this;
        }
        if (this.filenames == null) {
            this.nFiles = 0;
            this.files = null;
        } else {
            this.nFiles = this.filenames.size();
            this.files = new String[this.nFiles];
            for (int i = 0; i < this.nFiles; ++i) {
                this.files[i] = this.filenames.get(i);
            }
        }
        if (this.evaluateBARFiles) {
            if (this.nFiles == 0) {
                logger.info(" Please supply a BAR file or directory to be evaluated.");
                return this;
            }
            BARFilter[] barFilters = null;
            if (this.nStates == 2 && this.nFiles == 1) {
                logger.info(String.format(" Evaluating a single BAR file: %s.", this.files[0]));
                barFilters = new BARFilter[]{new BARFilter(new File(this.files[0]), this.startingSnapshot, this.endingSnapshot)};
                this.lambdaValues = new double[2];
                this.lambdaValues[0] = this.alchemicalOptions.getInitialLambda();
                this.lambdaValues[1] = this.lambda2;
            } else if (this.nStates > 2 && this.nFiles == 1) {
                logger.info(String.format(" Evaluating BAR files from directory %s.", this.files[0]));
                logger.info(" Auto-detecting BAR files and lambda values.");
                Path subdirectoryPath = Paths.get(this.files[0], new String[0]);
                Pattern pattern = Pattern.compile(".*_(\\d+)\\.bar");
                ArrayList fileList = new ArrayList();
                try (Stream<Path> paths = Files.list(subdirectoryPath);){
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                        Matcher matcher = pattern.matcher(path.getFileName().toString());
                        return matcher.matches();
                    }).sorted(Comparator.comparingInt(path -> {
                        Matcher matcher = pattern.matcher(path.getFileName().toString());
                        matcher.matches();
                        return Integer.parseInt(matcher.group(1));
                    })).forEach(path -> fileList.add(path.toString()));
                }
                catch (IOException e) {
                    logger.info(" Error reading files from a directory.\n" + e.toString());
                    e.printStackTrace();
                    return this;
                }
                int numFiles = fileList.size();
                if (numFiles != this.nStates - 1) {
                    logger.info(String.format(" The number of bar files (%d) does not concord with the number of states (%d).", numFiles, this.nStates));
                    return this;
                }
                this.lambdaValues = new double[this.nStates];
                for (int l = 0; l < this.nStates; ++l) {
                    this.lambdaValues[l] = this.alchemicalOptions.getInitialLambda(this.nStates, l, true);
                }
                barFilters = new BARFilter[numFiles];
                for (int i = 0; i < numFiles; ++i) {
                    String filename = (String)fileList.get(i);
                    File barFile = new File(filename);
                    barFilters[i] = new BARFilter(barFile, this.startingSnapshot, this.endingSnapshot);
                    logger.info(String.format(" Window L=%6.4f to L=%6.4f from %s", this.lambdaValues[i], this.lambdaValues[i + 1], filename));
                }
            }
            double[][] energiesLow = new double[this.nStates][];
            double[][] energiesAt = new double[this.nStates][];
            double[][] energiesHigh = new double[this.nStates][];
            double[][] volume = new double[this.nStates][];
            double[] temperatures = new double[this.nStates];
            this.readBARFiles(barFilters, energiesLow, energiesAt, energiesHigh, volume, temperatures);
            this.reporter = new FreeEnergyDifferenceReporter(this.nStates, this.lambdaValues, temperatures, this.eps, this.nIterations, (double[][])energiesLow, (double[][])energiesAt, (double[][])energiesHigh, (double[][])volume);
            this.reporter.report();
            return this;
        }
        logger.info(" Writing BAR files.");
        this.numTopologies = 1;
        if (this.nFiles <= 1 && this.nStates < 2) {
            logger.info(" At least two states must be specified");
            return this;
        }
        if (this.nFiles == 1 && this.nStates >= 2) {
            logger.info(String.format(" Auto-detecting %d states for single topology:\n %s.", this.nStates, this.files[0]));
        } else if (this.nFiles == 2 && this.nStates >= 2) {
            logger.info(String.format(" Auto-detecting %d states for dual topology:\n %s\n %s.", this.nStates, this.files[0], this.files[1]));
            this.numTopologies = 2;
        } else if (this.nFiles == 2) {
            logger.info(String.format(" Applying BAR between two single topology ensembles:\n %s\n %s.", this.files[0], this.files[1]));
            this.nStates = 2;
        } else if (this.nFiles == 4) {
            logger.info(String.format(" Applying BAR between two dual topology ensembles:\n %s %s\n %s %s.", this.files[0], this.files[1], this.files[2], this.files[3]));
            this.numTopologies = 2;
            this.nStates = 2;
        } else {
            logger.info(String.format(" Inconsistent input of files (%3d) and/or states (%3d).", this.nFiles, this.nStates));
            return this;
        }
        boolean autodetect = false;
        if (this.nStates > 2) {
            autodetect = true;
            this.lambdaValues = new double[this.nStates];
            for (int i = 0; i < this.nStates; ++i) {
                this.lambdaValues[i] = this.alchemicalOptions.getInitialLambda(this.nStates, i, true);
            }
        } else {
            this.lambdaValues = new double[2];
            this.lambdaValues[0] = this.alchemicalOptions.getInitialLambda(2, 0, true);
            this.lambdaValues[1] = this.lambda2;
            this.nStates = 2;
        }
        logger.info(" Lambda values for each window: ");
        int nLambda = this.lambdaValues.length;
        for (int i = 0; i < nLambda; ++i) {
            logger.info(String.format(" Window %3d: %6.4f", i, this.lambdaValues[i]));
        }
        int threadsPerTopology = this.topologyOptions.getThreadsPerTopology(this.numTopologies);
        this.topologies = new MolecularAssembly[this.numTopologies];
        SystemFilter[] openers = new SystemFilter[this.numTopologies];
        this.alchemicalOptions.setAlchemicalProperties();
        this.topologyOptions.setAlchemicalProperties(this.numTopologies);
        if (this.numTopologies == 2) {
            logger.info(String.format(" Initializing two topologies for each window.", new Object[0]));
        } else {
            logger.info(String.format(" Initializing a single topology for each window.", new Object[0]));
        }
        for (int i = 0; i < this.numTopologies; ++i) {
            MolecularAssembly ma;
            this.topologies[i] = ma = this.alchemicalOptions.openFile((PotentialsFunctions)this.algorithmFunctions, this.topologyOptions, threadsPerTopology, this.filenames.get(i), i);
            openers[i] = this.algorithmFunctions.getFilter();
        }
        StringBuilder sb = new StringBuilder(String.format("\n Using BAR to analyze a free energy change for %s\n ", this.filenames));
        this.potential = (CrystalPotential)this.topologyOptions.assemblePotential(this.topologies, sb);
        Crystal unitCell = this.potential.getCrystal().getUnitCell();
        boolean bl = isPBC = this.includeVolume && !unitCell.aperiodic();
        if (this.nFiles > 0) {
            String directoryPath;
            String[][] fullFilePaths;
            int dtIndex = 0;
            if (this.numTopologies == 2 && this.nFiles == 4) {
                fullFilePaths = new String[this.nStates][2];
                dtIndex = 2;
            } else {
                fullFilePaths = new String[this.nStates][this.nFiles];
            }
            for (int i = 0; i < this.nStates; ++i) {
                for (int j = 0; j < this.nFiles; ++j) {
                    if (i == 1 && j == 0) {
                        j = dtIndex;
                    }
                    File file = new File(this.files[j]);
                    directoryPath = file.getAbsoluteFile().getParent() + File.separator;
                    String archiveName = this.sortedArc ? FilenameUtils.getBaseName((String)this.files[j]) + "_E" + String.valueOf(i) + ".arc" : FilenameUtils.getBaseName((String)this.files[j]) + ".arc";
                    int col = j;
                    if (dtIndex == 2) {
                        col = Math.floorMod(j - dtIndex, 2);
                    }
                    fullFilePaths[i][col] = !autodetect ? directoryPath + File.separator + archiveName : directoryPath + i + File.separator + archiveName;
                    if (i != 0 || j != 1) continue;
                    j += dtIndex * this.nFiles;
                }
            }
            ParallelStateEnergy pe = new ParallelStateEnergy(this.nStates, this.lambdaValues, this.topologies, (Potential)this.potential, fullFilePaths, openers);
            double[][] energiesLow = new double[this.nStates][];
            double[][] energiesAt = new double[this.nStates][];
            double[][] energiesHigh = new double[this.nStates][];
            double[][] volume = new double[this.nStates][];
            pe.evaluateStates(energiesLow, energiesAt, energiesHigh, volume);
            if (pe.getRank() != 0) {
                return this;
            }
            File file = new File(this.files[0]);
            directoryPath = file.getAbsoluteFile().getParent() + File.separator;
            String tinkerDirectoryPath = directoryPath + File.separator + "windows";
            File directory = new File(tinkerDirectoryPath);
            String barFilePath = tinkerDirectoryPath + File.separator;
            directory.mkdir();
            for (int state = 0; state < this.nStates - 1; ++state) {
                File xyzFile = new File(this.filenames.get(0));
                BARFilter barFilter = new BARFilter(xyzFile, energiesAt[state], energiesHigh[state], energiesLow[state + 1], energiesAt[state + 1], volume[state], volume[state + 1], this.temperature, this.temperature);
                String barFileName = barFilePath + "window_" + String.valueOf(state) + ".bar";
                barFilter.writeFile(barFileName, isPBC, false);
            }
        }
        return this;
    }

    void readBARFiles(BARFilter[] barFilters, double[][] energyLow, double[][] energyAt, double[][] energyHigh, double[][] volume, double[] temperatures) {
        for (BARFilter barFilter : barFilters) {
            barFilter.readFile();
        }
        for (int state = 0; state < this.nStates; ++state) {
            if (state == 0) {
                energyAt[state] = barFilters[state].getE1l1();
                energyHigh[state] = barFilters[state].getE1l2();
                volume[state] = barFilters[state].getVolume1();
                temperatures[state] = barFilters[state].getTemperature1();
                continue;
            }
            if (state == this.nStates - 1) {
                energyLow[state] = barFilters[state - 1].getE2l1();
                energyAt[state] = barFilters[state - 1].getE2l2();
                volume[state] = barFilters[state - 1].getVolume2();
                temperatures[state] = barFilters[state - 1].getTemperature2();
                continue;
            }
            energyLow[state] = barFilters[state - 1].getE2l1();
            energyAt[state] = barFilters[state].getE1l1();
            energyHigh[state] = barFilters[state].getE1l2();
            volume[state] = barFilters[state].getVolume1();
            temperatures[state] = barFilters[state].getTemperature1();
        }
    }

    @Override
    public List<Potential> getPotentials() {
        List<Potential> potentials;
        if (this.potential == null) {
            potentials = Collections.emptyList();
        } else {
            potentials = new ArrayList();
            potentials.add((Potential)this.potential);
        }
        return potentials;
    }

    public FreeEnergyDifferenceReporter getReporter() {
        return this.reporter;
    }
}

