/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.AnnealOptions;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.optimize.anneal.SimulatedAnnealing;
import ffx.numerics.OptimizationInterface;
import ffx.numerics.Potential;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.WriteoutOptions;
import ffx.potential.utils.PotentialsFunctions;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Run simulated annealing on a system."}, name="Anneal")
public class Anneal
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    private DynamicsOptions dynamics;
    @CommandLine.Mixin
    private AnnealOptions anneal;
    @CommandLine.Mixin
    private WriteoutOptions writeOut;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"XYZ or PDB input file."})
    private String filename;
    private SimulatedAnnealing simulatedAnnealing = null;
    private Potential potential;

    public Anneal() {
    }

    public Anneal(FFXBinding binding) {
        super(binding);
    }

    public Anneal(String[] args) {
        super(args);
    }

    public Anneal run() {
        if (!this.init()) {
            return this;
        }
        this.dynamics.init();
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        this.atomSelectionOptions.setActiveAtoms(this.activeAssembly);
        logger.info("\n Running simulated annealing on " + this.filename + "\n");
        File dyn = new File(FilenameUtils.removeExtension((String)this.filename) + ".dyn");
        if (!dyn.exists()) {
            dyn = null;
        }
        this.potential = this.activeAssembly.getPotentialEnergy();
        this.simulatedAnnealing = this.anneal.createAnnealer(this.dynamics, this.activeAssembly, (Potential)this.activeAssembly.getPotentialEnergy(), this.algorithmListener, dyn);
        this.simulatedAnnealing.setPrintInterval(this.dynamics.getReport());
        this.simulatedAnnealing.setSaveFrequency(this.dynamics.getWrite());
        this.simulatedAnnealing.setRestartFrequency(this.dynamics.getCheckpoint());
        this.simulatedAnnealing.setTrajectorySteps(this.dynamics.getTrajSteps());
        this.simulatedAnnealing.anneal();
        if (!(this.baseDir != null && this.baseDir.exists() && this.baseDir.isDirectory() && this.baseDir.canWrite())) {
            this.baseDir = new File(FilenameUtils.getFullPath((String)this.filename));
        }
        String dirName = this.baseDir.toString() + File.separator;
        String fileName = FilenameUtils.getName((String)this.filename);
        fileName = FilenameUtils.removeExtension((String)fileName);
        this.writeOut.saveFile(String.format("%s%s", dirName, fileName), (PotentialsFunctions)this.algorithmFunctions, this.activeAssembly);
        return this;
    }

    public SimulatedAnnealing getAnnealing() {
        return this.simulatedAnnealing;
    }

    @Override
    public List<Potential> getPotentials() {
        List<Potential> potentials = this.potential == null ? Collections.emptyList() : Collections.singletonList(this.potential);
        return potentials;
    }

    @Override
    public boolean destroyPotentials() {
        return this.getPotentials().stream().allMatch(OptimizationInterface::destroy);
    }
}

