/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.cli;

import picocli.CommandLine;

public class RepExOptions {
    @CommandLine.ArgGroup(heading="%n Replica Exchange Options%n", validate=false)
    private final RepExOptionGroup group = new RepExOptionGroup();

    public boolean getRepEx() {
        return this.group.repEx;
    }

    public void setRepEx(boolean repEx) {
        this.group.repEx = repEx;
    }

    public int getReplicaSteps() {
        return this.group.replicaSteps;
    }

    public void setReplicaSteps(int numSteps) {
        this.group.replicaSteps = numSteps;
    }

    public double getExponent() {
        return this.group.exponent;
    }

    public void setExponent(double exponent) {
        this.group.exponent = exponent;
    }

    public void setMonteCarlo(boolean monteCarlo) {
        this.group.monteCarlo = monteCarlo;
    }

    public boolean getMonteCarlo() {
        return this.group.monteCarlo;
    }

    private static class RepExOptionGroup {
        @CommandLine.Option(names={"-x", "--repEx"}, paramLabel="false", description={"Execute temperature replica exchange"})
        boolean repEx = false;
        @CommandLine.Option(names={"--rs", "--replicaSteps"}, paramLabel="100", defaultValue="100", description={"Number of steps for replica exchange."})
        private int replicaSteps = 100;
        @CommandLine.Option(names={"-e", "--exponent"}, paramLabel="0.05", defaultValue="0.05", description={"Exponent to set the exponential temperature ladder."})
        private double exponent = 0.05;
        @CommandLine.Option(names={"--oMC", "--oneMonteCarlo"}, paramLabel="false", description={"Execute 1 Monte Carlo move for each temperature in each cycle"})
        boolean monteCarlo = false;

        private RepExOptionGroup() {
        }
    }
}

