/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.cli;

import ffx.potential.MolecularAssembly;
import picocli.CommandLine;

public class RandomUnitCellOptions {
    @CommandLine.ArgGroup(heading="%n Random Unit Cell Options%n", validate=false)
    private final RandomUnitCellOptionGroup group = new RandomUnitCellOptionGroup();

    public void randomize(MolecularAssembly assembly) {
        if (this.group.randomSymOp >= 0.0) {
            assembly.applyRandomSymOp(this.group.randomSymOp);
        }
        if (this.group.randomUnitCell > 0.0) {
            assembly.applyRandomDensity(this.group.randomUnitCell);
        }
    }

    public double getRandomSymOp() {
        return this.group.randomSymOp;
    }

    public void setRandomSymOp(double randomSymOp) {
        this.group.randomSymOp = randomSymOp;
    }

    public double getRandomUnitCell() {
        return this.group.randomUnitCell;
    }

    public void setRandomUnitCell(double randomUnitCell) {
        this.group.randomUnitCell = randomUnitCell;
    }

    private static class RandomUnitCellOptionGroup {
        @CommandLine.Option(names={"--rsym", "--randomSymOp"}, paramLabel="-1.0", defaultValue="-1.0", description={"Apply a random SymOp with translation range -X/2 .. X/2 (0 for random placement in the unit cell, negative for no SymOp)"})
        private double randomSymOp = -1.0;
        @CommandLine.Option(names={"--ruc", "--randomUnitCell"}, paramLabel="-1.0", defaultValue="-1.0", description={"Apply random unit cell parameters to achieve the specified density (g/cc)."})
        private double randomUnitCell = -1.0;

        private RandomUnitCellOptionGroup() {
        }
    }
}

