/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.cli;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.cli.BarostatOptions;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.cli.LambdaParticleOptions;
import ffx.algorithms.cli.ThermodynamicsOptions;
import ffx.algorithms.dynamics.MDEngine;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.algorithms.thermodynamics.HistogramData;
import ffx.algorithms.thermodynamics.LambdaData;
import ffx.algorithms.thermodynamics.MonteCarloOST;
import ffx.algorithms.thermodynamics.OrthogonalSpaceTempering;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.cli.WriteoutOptions;
import java.io.File;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import picocli.CommandLine;

public class OSTOptions {
    private static final Logger logger = Logger.getLogger(OSTOptions.class.getName());
    @CommandLine.ArgGroup(heading="%n Orthogonal Space Tempering Options%n", validate=false)
    private final OSTOptionGroup group = new OSTOptionGroup();
    @CommandLine.ArgGroup(heading="%n Monte Carlo Orthogonal Space Tempering Options%n", validate=false)
    private final MCOSTOptionGroup mcGroup = new MCOSTOptionGroup();

    public CrystalPotential applyAllOSTOptions(OrthogonalSpaceTempering orthogonalSpaceTempering, MolecularAssembly firstAssembly, DynamicsOptions dynamicsOptions, BarostatOptions barostatOptions) {
        if (dynamicsOptions.getOptimize()) {
            OrthogonalSpaceTempering.OptimizationParameters opt = orthogonalSpaceTempering.getOptimizationParameters();
            opt.setOptimization(true, firstAssembly);
        }
        return barostatOptions.checkNPT(firstAssembly, orthogonalSpaceTempering);
    }

    public void beginMCOST(MonteCarloOST monteCarloOST, DynamicsOptions dynamicsOptions, ThermodynamicsOptions thermodynamicsOptions) {
        long nEquil = thermodynamicsOptions.getEquilSteps();
        if (nEquil > 0L) {
            logger.info("\n Beginning MC-OST equilibration.");
            monteCarloOST.setTotalSteps(nEquil);
            if (this.mcGroup.twoStep) {
                monteCarloOST.sampleTwoStep();
            } else {
                monteCarloOST.sampleOneStep();
            }
            monteCarloOST.setEquilibration(false);
            logger.info("\n Finished MC-OST equilibration.");
        }
        logger.info("\n Beginning MC-OST sampling.");
        monteCarloOST.setLambdaStdDev(this.mcGroup.mcLambdaStdDev);
        monteCarloOST.setTotalSteps(dynamicsOptions.getSteps());
        if (this.mcGroup.twoStep) {
            monteCarloOST.sampleTwoStep();
        } else {
            monteCarloOST.sampleOneStep();
        }
    }

    public MolecularDynamics assembleMolecularDynamics(MolecularAssembly[] molecularAssemblies, CrystalPotential crystalPotential, DynamicsOptions dynamicsOptions, AlgorithmListener algorithmListener) {
        MolecularAssembly firstTop = molecularAssemblies[0];
        dynamicsOptions.init();
        MolecularDynamics molDyn = MolecularDynamics.dynamicsFactory(firstTop, (Potential)crystalPotential, algorithmListener, dynamicsOptions.thermostat, dynamicsOptions.integrator, MDEngine.FFX);
        for (int i = 1; i < molecularAssemblies.length; ++i) {
            molDyn.addAssembly(molecularAssemblies[i]);
        }
        molDyn.setRestartFrequency(dynamicsOptions.getCheckpoint());
        return molDyn;
    }

    public OrthogonalSpaceTempering constructOST(CrystalPotential crystalPotential, @Nullable File lambdaRestartFile, File histogramRestartFile, MolecularAssembly firstAssembly, @Nullable Configuration addedProperties, DynamicsOptions dynamicsOptions, ThermodynamicsOptions thermodynamicsOptions, LambdaParticleOptions lambdaParticleOptions, @Nullable AlgorithmListener algorithmListener, boolean async) {
        LambdaData lambdaData;
        LambdaInterface lambdaInterface = (LambdaInterface)crystalPotential;
        CompositeConfiguration compositeConfiguration = new CompositeConfiguration((Configuration)firstAssembly.getProperties());
        if (addedProperties != null) {
            compositeConfiguration.addConfiguration(addedProperties);
        }
        HistogramData histogramData = HistogramData.readHistogram(histogramRestartFile);
        int histogramIndex = 0;
        if (histogramData.wasHistogramRead()) {
            logger.info("\n Read histogram restart from: " + String.valueOf(histogramRestartFile));
            logger.info(histogramData.toString());
        } else {
            histogramData.applyProperties(compositeConfiguration);
            histogramData.setIndependentWalkers(this.group.independentWalkers);
            histogramData.setWriteIndependent(this.group.independentWalkers);
            histogramData.setAsynchronous(async);
            histogramData.setTemperingFactor(this.getTemperingParameter(histogramIndex));
            if (this.thresholdsSet()) {
                histogramData.setTemperingOffset(this.getTemperingThreshold(histogramIndex));
            }
            histogramData.setMetaDynamics(this.group.metaDynamics);
            histogramData.setBiasMag(this.getBiasMag(histogramIndex));
            histogramData.setCountInterval(this.group.countInterval);
            logger.info("\n OST Histogram Settings");
            logger.info(histogramData.toString());
        }
        if (lambdaRestartFile == null) {
            String filename = histogramRestartFile.toString().replaceFirst("\\.his$", ".lam");
            lambdaRestartFile = new File(filename);
        }
        if ((lambdaData = LambdaData.readLambdaData(lambdaRestartFile)).wasLambdaRead()) {
            logger.info(" Read lambda restart from:    " + String.valueOf(lambdaRestartFile));
        } else {
            lambdaData.setHistogramIndex(histogramIndex);
            if (thermodynamicsOptions.getResetNumSteps()) {
                lambdaData.setStepsTaken(0);
            }
        }
        OrthogonalSpaceTempering orthogonalSpaceTempering = new OrthogonalSpaceTempering(lambdaInterface, crystalPotential, histogramData, lambdaData, compositeConfiguration, dynamicsOptions, lambdaParticleOptions, algorithmListener);
        orthogonalSpaceTempering.setHardWallConstraint(this.mcGroup.mcHardWall);
        return orthogonalSpaceTempering;
    }

    public void beginMDOST(OrthogonalSpaceTempering orthogonalSpaceTempering, MolecularAssembly[] molecularAssemblies, CrystalPotential crystalPotential, DynamicsOptions dynamicsOptions, WriteoutOptions writeoutOptions, ThermodynamicsOptions thermodynamicsOptions, File dynFile, AlgorithmListener algorithmListener) {
        dynamicsOptions.init();
        MolecularDynamics molDyn = this.assembleMolecularDynamics(molecularAssemblies, crystalPotential, dynamicsOptions, algorithmListener);
        boolean initVelocities = true;
        long nSteps = dynamicsOptions.getSteps();
        long nEquil = thermodynamicsOptions.getEquilSteps();
        if (nEquil > 0L) {
            logger.info("\n Beginning equilibration");
            orthogonalSpaceTempering.setPropagateLambda(false);
            this.runDynamics(molDyn, nEquil, dynamicsOptions, writeoutOptions, true, dynFile);
            logger.info(" Beginning OST sampling");
            orthogonalSpaceTempering.setPropagateLambda(true);
        } else {
            long nEnergyCount;
            logger.info(" Beginning OST sampling without equilibration");
            if (!thermodynamicsOptions.getResetNumSteps() && (nEnergyCount = orthogonalSpaceTempering.getEnergyCount()) > 0L) {
                logger.info(String.format(" Lambda file: %12d steps picked up, now sampling %12d steps", nEnergyCount, nSteps -= nEnergyCount));
                initVelocities = false;
            }
        }
        if (nSteps > 0L) {
            this.runDynamics(molDyn, nSteps, dynamicsOptions, writeoutOptions, initVelocities, dynFile);
        } else {
            logger.info(" No steps remaining for this process!");
        }
    }

    public boolean getIndependentWalkers() {
        return this.group.independentWalkers;
    }

    public boolean isMonteCarlo() {
        return this.mcGroup.monteCarlo;
    }

    public void setMonteCarlo(boolean monteCarlo) {
        this.mcGroup.monteCarlo = monteCarlo;
    }

    public boolean isTwoStep() {
        return this.mcGroup.twoStep;
    }

    public void setTwoStep(boolean twoStep) {
        this.mcGroup.twoStep = twoStep;
    }

    public MonteCarloOST setupMCOST(OrthogonalSpaceTempering orthogonalSpaceTempering, MolecularAssembly[] molecularAssemblies, CrystalPotential crystalPotential, DynamicsOptions dynamicsOptions, ThermodynamicsOptions thermodynamicsOptions, boolean verbose, File dynRestart, AlgorithmListener algorithmListener) {
        dynamicsOptions.init();
        MonteCarloOST monteCarloOST = new MonteCarloOST((Potential)crystalPotential, orthogonalSpaceTempering, molecularAssemblies[0], molecularAssemblies[0].getProperties(), algorithmListener, dynamicsOptions, verbose, this.mcGroup.mcMDSteps, dynRestart);
        MolecularDynamics md = monteCarloOST.getMD();
        for (int i = 1; i < molecularAssemblies.length; ++i) {
            md.addAssembly(molecularAssemblies[i]);
        }
        long nEquil = thermodynamicsOptions.getEquilSteps();
        if (nEquil > 0L) {
            monteCarloOST.setEquilibration(true);
        }
        return monteCarloOST;
    }

    private boolean thresholdsSet() {
        return this.group.temperingThreshold.length != 1 || this.group.temperingThreshold[0] >= 0.0;
    }

    private double getBiasMag(int i) {
        return this.group.biasMag.length > 1 ? this.group.biasMag[i] : this.group.biasMag[0];
    }

    private void runDynamics(MolecularDynamics molecularDynamics, long numSteps, DynamicsOptions dynamicsOptions, WriteoutOptions writeoutOptions, boolean initVelocities, File dyn) {
        molecularDynamics.dynamic(numSteps, dynamicsOptions.getDt(), dynamicsOptions.getReport(), dynamicsOptions.getWrite(), dynamicsOptions.getTemperature(), initVelocities, writeoutOptions.getFileType(), dynamicsOptions.getCheckpoint(), dyn);
    }

    private double getTemperingThreshold(int i) {
        return this.group.temperingThreshold.length > 1 ? this.group.temperingThreshold[i] : this.group.temperingThreshold[0];
    }

    private double getTemperingParameter(int i) {
        return this.group.temperingRate.length > 1 ? this.group.temperingRate[i] : this.group.temperingRate[0];
    }

    public int getCountInterval() {
        return this.group.countInterval;
    }

    public void setCountInterval(int countInterval) {
        this.group.countInterval = countInterval;
    }

    public double[] getBiasMag() {
        return this.group.biasMag;
    }

    public void setBiasMag(double[] biasMag) {
        this.group.biasMag = biasMag;
    }

    public boolean isIndependentWalkers() {
        return this.group.independentWalkers;
    }

    public void setIndependentWalkers(boolean independentWalkers) {
        this.group.independentWalkers = independentWalkers;
    }

    public boolean isMetaDynamics() {
        return this.group.metaDynamics;
    }

    public void setMetaDynamics(boolean metaDynamics) {
        this.group.metaDynamics = metaDynamics;
    }

    public double[] getTemperingRate() {
        return this.group.temperingRate;
    }

    public void setTemperingRate(double[] temperingRate) {
        this.group.temperingRate = temperingRate;
    }

    public double[] getTemperingThreshold() {
        return this.group.temperingThreshold;
    }

    public void setTemperingThreshold(double[] temperingThreshold) {
        this.group.temperingThreshold = temperingThreshold;
    }

    public boolean isMcHardWall() {
        return this.mcGroup.mcHardWall;
    }

    public void setMcHardWall(boolean mcHardWall) {
        this.mcGroup.mcHardWall = mcHardWall;
    }

    public int getMcMDSteps() {
        return this.mcGroup.mcMDSteps;
    }

    public void setMcMDSteps(int mcMDSteps) {
        this.mcGroup.mcMDSteps = mcMDSteps;
    }

    public double getMcLambdaStdDev() {
        return this.mcGroup.mcLambdaStdDev;
    }

    public void setMcLambdaStdDev(double mcLambdaStdDev) {
        this.mcGroup.mcLambdaStdDev = mcLambdaStdDev;
    }

    public double getLambdaWriteOut() {
        return this.group.lambdaWriteOut;
    }

    public void setLambdaWriteOut(double lambdaWriteOut) {
        this.group.lambdaWriteOut = lambdaWriteOut;
    }

    private static class OSTOptionGroup {
        @CommandLine.Option(names={"-C", "--count"}, paramLabel="10", defaultValue="10", description={"Time steps between MD Orthogonal Space counts."})
        private int countInterval = 10;
        @CommandLine.Option(names={"--bM", "--biasMag"}, paramLabel="0.05", defaultValue="0.05", split=",", description={"Orthogonal Space Gaussian bias magnitude (kcal/mol); RepEx OST uses a comma-separated list."})
        private double[] biasMag = new double[]{0.05};
        @CommandLine.Option(names={"--iW", "--independentWalkers"}, defaultValue="false", description={"Enforces that each walker maintains their own histogram."})
        private boolean independentWalkers = false;
        @CommandLine.Option(names={"--meta", "--metaDynamics"}, defaultValue="false", description={"Use a 1D metadynamics style bias."})
        private boolean metaDynamics = false;
        @CommandLine.Option(names={"--tp", "--temperingRate"}, paramLabel="4.0", defaultValue="4.0", split=",", description={"Tempering rate parameter in multiples of kBT; RepEx OST uses a comma-separated list."})
        private double[] temperingRate = new double[]{4.0};
        @CommandLine.Option(names={"--tth", "--temperingThreshold"}, paramLabel="20*bias", defaultValue="-1", split=",", description={"Tempering threshold in kcal/mol; RepEx OST uses a comma-separated list."})
        private double[] temperingThreshold = new double[]{-1.0};
        @CommandLine.Option(names={"--lw", "--lambdaWriteOut"}, paramLabel="0.0", defaultValue="0.0", description={"Only write out snapshots if lambda is greater than the value specified."})
        private double lambdaWriteOut = 0.0;

        private OSTOptionGroup() {
        }
    }

    private static class MCOSTOptionGroup {
        @CommandLine.Option(names={"--mc", "--monteCarlo"}, defaultValue="false", description={"Specify use of Monte Carlo OST"})
        private boolean monteCarlo = false;
        @CommandLine.Option(names={"--mcHW", "--mcHardWall"}, defaultValue="false", description={"Monte Carlo OST hard wall constraint."})
        private boolean mcHardWall = false;
        @CommandLine.Option(names={"--mcMD", "--mcMDSteps"}, paramLabel="100", defaultValue="100", description={"Number of dynamics steps to take for each MD trajectory for Monte Carlo OST"})
        private int mcMDSteps = 100;
        @CommandLine.Option(names={"--mcL", "--mcLambdaStdDev"}, paramLabel="0.01", defaultValue="0.01", description={"Standard deviation for lambda move."})
        private double mcLambdaStdDev = 0.01;
        @CommandLine.Option(names={"--ts", "--twoStep"}, defaultValue="false", description={"MC Orthogonal Space sampling using separate lambda and MD moves."})
        private boolean twoStep = false;

        private MCOSTOptionGroup() {
        }
    }
}

