/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.cli;

import ffx.algorithms.AlgorithmFunctions;
import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.potential.DualTopologyEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.QuadTopologyEnergy;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.cli.AlchemicalOptions;
import ffx.potential.cli.TopologyOptions;
import ffx.potential.utils.PotentialsFunctions;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.CompositeConfiguration;
import picocli.CommandLine;

public class MultiDynamicsOptions {
    private static final Logger logger = Logger.getLogger(MultiDynamicsOptions.class.getName());
    @CommandLine.ArgGroup(heading="%n Multiple Walker Options for MPI Simulations%n", validate=false)
    private final MultiDynamicsOptionGroup group = new MultiDynamicsOptionGroup();

    public void distribute(MolecularAssembly[] molecularAssemblies, Potential[] potentials, CrystalPotential crystalPotential, AlgorithmFunctions algorithmFunctions, int rank, int worldSize) {
        if (!this.group.distributeWalkersString.equalsIgnoreCase("AUTO") && !this.group.distributeWalkersString.equalsIgnoreCase("OFF")) {
            logger.info(" Distributing walker conformations.");
            int nSys = molecularAssemblies.length;
            assert (nSys == potentials.length);
            switch (nSys) {
                case 1: {
                    this.optStructure(molecularAssemblies[0], (Potential)crystalPotential, algorithmFunctions, rank, worldSize);
                    break;
                }
                case 2: {
                    DualTopologyEnergy dte = (DualTopologyEnergy)crystalPotential;
                    if (dte.getNumSharedVariables() == dte.getNumberOfVariables()) {
                        logger.info(" Generating starting structures based on dual-topology:");
                        this.optStructure(molecularAssemblies[0], (Potential)dte, algorithmFunctions, rank, worldSize);
                        break;
                    }
                    logger.info(" Generating separate starting structures for each topology of the dual topology:");
                    this.optStructure(molecularAssemblies[0], potentials[0], algorithmFunctions, rank, worldSize);
                    this.optStructure(molecularAssemblies[1], potentials[1], algorithmFunctions, rank, worldSize);
                    break;
                }
                case 4: {
                    QuadTopologyEnergy qte = (QuadTopologyEnergy)crystalPotential;
                    this.optStructure(molecularAssemblies[0], (Potential)qte.getDualTopA(), algorithmFunctions, rank, worldSize);
                    this.optStructure(molecularAssemblies[3], (Potential)qte.getDualTopB(), algorithmFunctions, rank, worldSize);
                    break;
                }
                default: {
                    logger.severe(" First: must have 1, 2, or 4 topologies.");
                }
            }
        } else {
            logger.finer(" Skipping RO-based distribution of initial configurations.");
        }
    }

    public void distribute(MolecularAssembly[] molecularAssemblies, CrystalPotential crystalPotential, AlgorithmFunctions algorithmFunctions, int rank, int worldSize) {
        int ntops = molecularAssemblies.length;
        Potential[] energies = new Potential[ntops];
        for (int i = 0; i < ntops; ++i) {
            energies[i] = molecularAssemblies[i].getPotentialEnergy();
        }
        this.distribute(molecularAssemblies, energies, crystalPotential, algorithmFunctions, rank, worldSize);
    }

    public boolean isSynchronous() {
        return this.group.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.group.synchronous = synchronous;
    }

    public MolecularAssembly openFile(AlgorithmFunctions algorithmFunctions, TopologyOptions topologyOptions, int threadsPer, String toOpen, int topNum, AlchemicalOptions alchemicalOptions, File structureFile, int rank) {
        boolean autoDist = this.group.distributeWalkersString.equalsIgnoreCase("AUTO");
        if (autoDist) {
            String openName = String.format("%s_%d", toOpen, rank + 1);
            File testFile = new File(openName);
            if (testFile.exists()) {
                toOpen = openName;
            } else {
                logger.warning(String.format(" File %s does not exist; using default %s", openName, toOpen));
            }
        }
        MolecularAssembly assembly = alchemicalOptions.openFile((PotentialsFunctions)algorithmFunctions, topologyOptions, threadsPer, toOpen, topNum);
        assembly.setFile(structureFile);
        return assembly;
    }

    private String[] parseDistributed() {
        String distributeWalkersString = this.group.distributeWalkersString;
        if (distributeWalkersString.equalsIgnoreCase("OFF") || distributeWalkersString.equalsIgnoreCase("AUTO") || distributeWalkersString.isEmpty()) {
            return null;
        }
        return distributeWalkersString.split("\\.");
    }

    public String getDistributeWalkersString() {
        return this.group.distributeWalkersString;
    }

    private void optStructure(MolecularAssembly molecularAssembly, Potential potential, AlgorithmFunctions algorithmFunctions, int rank, int worldSize) {
        RotamerLibrary rLib = new RotamerLibrary(false);
        String[] distribRes = this.parseDistributed();
        if (distribRes == null || distribRes.length == 0) {
            throw new IllegalArgumentException(" Programming error: Must have list of residues to split on!");
        }
        LambdaInterface lambdaInterface = potential instanceof LambdaInterface ? (LambdaInterface)potential : null;
        double initLam = -1.0;
        if (lambdaInterface != null) {
            initLam = lambdaInterface.getLambda();
            lambdaInterface.setLambda(0.5);
        }
        Pattern chainMatcher = Pattern.compile("^([a-zA-Z])?([0-9]+)$");
        ArrayList<Residue> residueList = new ArrayList<Residue>(distribRes.length);
        for (String ts : distribRes) {
            int resNum;
            Character chainID;
            Matcher m = chainMatcher.matcher(ts);
            if (m.find()) {
                if (m.groupCount() == 2) {
                    chainID = Character.valueOf(m.group(1).charAt(0));
                    resNum = Integer.parseInt(m.group(2));
                } else {
                    chainID = Character.valueOf(' ');
                    resNum = Integer.parseInt(m.group(1));
                }
            } else {
                logger.warning(String.format(" Could not parse %s as a valid residue!", ts));
                continue;
            }
            logger.info(String.format(" Looking for chain %c residue %d", chainID, resNum));
            for (Polymer p : molecularAssembly.getChains()) {
                if (p.getChainID() != chainID) continue;
                for (Residue r : p.getResidues()) {
                    if (r.getResidueNumber() != resNum || r.setRotamers(rLib) == null) continue;
                    residueList.add(r);
                }
            }
        }
        if (residueList.isEmpty()) {
            throw new IllegalArgumentException(" No valid entries for distWalkers!");
        }
        AlgorithmListener alist = algorithmFunctions.getDefaultListener();
        RotamerOptimization ropt = new RotamerOptimization(molecularAssembly, potential, alist);
        ropt.setRotamerLibrary(rLib);
        ropt.setThreeBodyEnergy(false);
        CompositeConfiguration properties = molecularAssembly.getProperties();
        if (!properties.containsKey("ro-ensembleNumber") && !properties.containsKey("ro-ensembleEnergy")) {
            logger.info(String.format(" Setting ensemble to default of number of walkers %d", worldSize));
            ropt.setEnsemble(worldSize);
        }
        ropt.setPrintFiles(false);
        ropt.setResiduesIgnoreNull(residueList);
        RotamerLibrary.measureRotamers(residueList, (boolean)false);
        ropt.optimize(RotamerOptimization.Algorithm.ALL);
        ropt.setCoordinatesToEnsemble(rank);
        double[] xyz = new double[potential.getNumberOfVariables()];
        potential.getCoordinates(xyz);
        logger.info(" Final Optimized Energy:");
        potential.energy(xyz, true);
        if (lambdaInterface != null) {
            lambdaInterface.setLambda(initLam);
        }
    }

    public void setDistributeWalkersString(String distributeWalkersString) {
        this.group.distributeWalkersString = distributeWalkersString;
    }

    public int getFirstDir() {
        return this.group.firstDir;
    }

    public void setFirstDir(int firstDir) {
        this.group.firstDir = firstDir;
    }

    private static class MultiDynamicsOptionGroup {
        @CommandLine.Option(names={"--firstDir"}, defaultValue="0", paramLabel="0", description={"The first directory to use for multiple walker jobs."})
        private int firstDir = 0;
        @CommandLine.Option(names={"-y", "--synchronous"}, defaultValue="false", description={"Walker communication is synchronous"})
        private boolean synchronous = false;
        @CommandLine.Option(names={"--dw", "--distributeWalkers"}, paramLabel="OFF", defaultValue="OFF", description={"AUTO: Pick up per-walker configurations as [filename.pdb]_[num], or specify a residue to distribute on."})
        private String distributeWalkersString = "OFF";

        private MultiDynamicsOptionGroup() {
        }
    }
}

