/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.cli;

import picocli.CommandLine;

public class MinimizeOptions {
    @CommandLine.ArgGroup(heading="%n Minimization Options%n", validate=false)
    private final MinimizeOptionGroup group = new MinimizeOptionGroup();

    public double getEps() {
        return this.group.eps;
    }

    public void setEps(double eps) {
        this.group.eps = eps;
    }

    public int getNBFGS() {
        return this.group.nbfgs;
    }

    public void setNBFGS(int nbfgs) {
        this.group.nbfgs = nbfgs;
    }

    public int getIterations() {
        return this.group.iterations;
    }

    public void setIterations(int iterations) {
        this.group.iterations = iterations;
    }

    private static class MinimizeOptionGroup {
        @CommandLine.Option(names={"-I", "--iterations"}, paramLabel="Unlimited", defaultValue="2147483647", description={"Number of minimization steps."})
        private int iterations = Integer.MAX_VALUE;
        @CommandLine.Option(names={"-e", "--eps"}, paramLabel="1.0", defaultValue="1.0", description={"Convergence criteria."})
        private double eps = 1.0;
        @CommandLine.Option(names={"--nbfgs"}, paramLabel="7", defaultValue="7", description={"The number of correction vectors used by the L-BFGS optimization routine (0 for steepest-decent)."})
        private int nbfgs = 7;

        private MinimizeOptionGroup() {
        }
    }
}

