/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.cli;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.dynamics.MDEngine;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.algorithms.dynamics.integrators.Integrator;
import ffx.algorithms.dynamics.integrators.IntegratorEnum;
import ffx.algorithms.dynamics.thermostats.Thermostat;
import ffx.algorithms.dynamics.thermostats.ThermostatEnum;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.WriteoutOptions;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import picocli.CommandLine;

public class DynamicsOptions {
    private static final Logger logger = Logger.getLogger(DynamicsOptions.class.getName());
    public ThermostatEnum thermostat;
    public IntegratorEnum integrator;
    @CommandLine.ArgGroup(heading="%n Dynamics Options%n", validate=false)
    private final DynamicsOptionGroup group = new DynamicsOptionGroup();
    private MDEngine engine = null;

    public double getCheckpoint() {
        return this.group.checkpoint;
    }

    public int getCheckpointFrequency(int defaultFrequency) {
        if (this.group.checkpoint > this.getDtPsec()) {
            return (int)(this.group.checkpoint / this.getDtPsec());
        }
        return defaultFrequency;
    }

    public void setCheckpoint(double checkpoint) {
        this.group.checkpoint = checkpoint;
    }

    public double getDt() {
        return this.group.dt;
    }

    public double getDtPsec() {
        return this.group.dt * 0.001;
    }

    public void setDt(double dt) {
        this.group.dt = dt;
    }

    public MolecularDynamics getDynamics(WriteoutOptions writeoutOptions, Potential potential, MolecularAssembly activeAssembly, AlgorithmListener algorithmListener) {
        return this.getDynamics(writeoutOptions, potential, activeAssembly, algorithmListener, this.engine);
    }

    public MolecularDynamics getDynamics(WriteoutOptions writeoutOptions, Potential potential, MolecularAssembly activeAssembly, AlgorithmListener algorithmListener, @Nullable MDEngine requestedEngine) {
        MolecularDynamics molDyn = requestedEngine == null ? MolecularDynamics.dynamicsFactory(activeAssembly, potential, algorithmListener, this.thermostat, this.integrator) : MolecularDynamics.dynamicsFactory(activeAssembly, potential, algorithmListener, this.thermostat, this.integrator, requestedEngine);
        molDyn.setFileType(writeoutOptions.getFileType());
        molDyn.setRestartFrequency(this.group.checkpoint);
        molDyn.setIntervalSteps(this.group.trajSteps);
        return molDyn;
    }

    public long getNumSteps() {
        return this.group.steps;
    }

    public boolean getOptimize() {
        return this.group.optimize;
    }

    public double getReport() {
        return this.group.report;
    }

    public int getReportFrequency(int defaultFrequency) {
        if (this.group.report > this.getDtPsec()) {
            return (int)(this.group.report / this.getDtPsec());
        }
        return defaultFrequency;
    }

    public void setReport(double report) {
        this.group.report = report;
    }

    public double getSnapshotInterval() {
        return this.group.write;
    }

    public double getTemperature() {
        return this.group.temperature;
    }

    public void setTemperature(double temperature) {
        this.group.temperature = temperature;
    }

    public void init() {
        this.thermostat = Thermostat.parseThermostat(this.group.thermostatString);
        this.integrator = Integrator.parseIntegrator(this.group.integratorString);
        if (this.group.engineString != null) {
            try {
                this.engine = MDEngine.valueOf(this.group.engineString.toUpperCase());
            }
            catch (Exception ex) {
                logger.warning(String.format(" Could not parse %s as a valid dynamics engine! Defaulting to the Platform-recommended engine.", this.group.engineString));
                this.engine = null;
            }
        }
    }

    public String getThermostatString() {
        return this.group.thermostatString;
    }

    public void setThermostat(ThermostatEnum thermostat) {
        this.thermostat = thermostat;
    }

    public void setIntegrator(IntegratorEnum integrator) {
        this.integrator = integrator;
    }

    public void setThermostatString(String thermostatString) {
        this.group.thermostatString = thermostatString;
    }

    public String getIntegratorString() {
        return this.group.integratorString;
    }

    public void setIntegratorString(String integratorString) {
        this.group.integratorString = integratorString;
    }

    public double getWrite() {
        return this.group.write;
    }

    public void setWrite(double write) {
        this.group.write = write;
    }

    public long getSteps() {
        return this.group.steps;
    }

    public void setSteps(long steps) {
        this.group.steps = steps;
    }

    public int getTrajSteps() {
        return this.group.trajSteps;
    }

    public void setTrajSteps(int trajSteps) {
        this.group.trajSteps = trajSteps;
    }

    public boolean isOptimize() {
        return this.group.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.group.optimize = optimize;
    }

    public String getEngineString() {
        return this.group.engineString;
    }

    public void setEngineString(String engineString) {
        this.group.engineString = engineString;
    }

    private static class DynamicsOptionGroup {
        @CommandLine.Option(names={"-d", "--dt"}, paramLabel="1.0", defaultValue="1.0", description={"Time discretization step in femtoseconds."})
        private double dt = 1.0;
        @CommandLine.Option(names={"-b", "--thermostat"}, paramLabel="Bussi", defaultValue="Bussi", description={"Thermostat: [Adiabatic / Berendsen / Bussi]."})
        private String thermostatString = "Bussi";
        @CommandLine.Option(names={"-i", "--integrator"}, paramLabel="Verlet", defaultValue="Verlet", description={"Integrator: [Beeman / Respa / Stochastic / Verlet]."})
        private String integratorString = "Verlet";
        @CommandLine.Option(names={"-r", "--report"}, paramLabel="0.25", defaultValue="0.25", description={"Interval in psec to report thermodynamics (psec)."})
        private double report = 0.25;
        @CommandLine.Option(names={"-w", "--write"}, paramLabel="10.0", defaultValue="10.0", description={"Interval in psec to write out coordinates (psec)."})
        private double write = 10.0;
        @CommandLine.Option(names={"-t", "--temperature"}, paramLabel="298.15", defaultValue="298.15", description={"Temperature (Kelvin)."})
        private double temperature = 298.15;
        @CommandLine.Option(names={"-n", "--numberOfSteps"}, paramLabel="1000000", defaultValue="1000000", description={"Number of molecular dynamics steps."})
        private long steps = 1000000L;
        @CommandLine.Option(names={"-z", "--trajSteps"}, paramLabel="100", defaultValue="100", description={"Number of steps per MD cycle (--mdE = OpenMM only)."})
        private int trajSteps = 100;
        @CommandLine.Option(names={"-o", "--optimize"}, defaultValue="false", description={"Optimize and save low-energy snapshots."})
        private boolean optimize = false;
        @CommandLine.Option(names={"-k", "--checkpoint"}, paramLabel="1.0", defaultValue="1.0", description={"Interval in psec to write out restart files (.dyn, .his, etc)."})
        private double checkpoint = 1.0;
        @CommandLine.Option(names={"--mdE", "--molecularDynamicsEngine"}, paramLabel="FFX", description={"Use FFX or OpenMM to integrate dynamics."})
        private String engineString = "FFX";

        private DynamicsOptionGroup() {
        }
    }
}

