/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.mp.IntegerBuf;
import edu.rit.pj.Comm;
import ffx.crystal.Crystal;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.Utilities;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.parsers.SystemFilter;
import java.io.File;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;

public class ParallelStateEnergy {
    private static final Logger logger = Logger.getLogger(ParallelStateEnergy.class.getName());
    private Comm world;
    private final boolean useMPI;
    private int numProc;
    private int rank;
    private int nStates;
    private double[] lambdaValues;
    private int statesPerProcess;
    private final int[] nSamples;
    private final double[][] energiesLowPJ;
    private final double[][] energiesAtPJ;
    private final double[][] energiesHighPJ;
    private final double[][] volumePJ;
    private final IntegerBuf bufferNSamples;
    private DoubleBuf bufferLow;
    private DoubleBuf bufferAt;
    private DoubleBuf bufferHigh;
    private DoubleBuf bufferVolume;
    private final MolecularAssembly[] molecularAssemblies;
    private final SystemFilter[] openers;
    private final Potential potential;
    private final String[][] fullFilePaths;

    public ParallelStateEnergy(int nStates, double[] lambdaValues, MolecularAssembly[] molecularAssemblies, Potential potential, String[][] fullFilePaths, SystemFilter[] openers) {
        this.nStates = nStates;
        this.lambdaValues = lambdaValues;
        this.molecularAssemblies = molecularAssemblies;
        this.potential = potential;
        this.fullFilePaths = fullFilePaths;
        this.openers = openers;
        this.world = Comm.world();
        this.numProc = 1;
        this.rank = 0;
        this.statesPerProcess = nStates;
        CompositeConfiguration properties = molecularAssemblies[0].getProperties();
        this.useMPI = properties.getBoolean("pj.use.mpi", true);
        if (this.useMPI) {
            this.numProc = this.world.size();
            this.rank = this.world.rank();
            int extra = nStates % this.numProc;
            int paddednWindows = nStates;
            if (extra != 0) {
                paddednWindows = nStates - extra + this.numProc;
            }
            this.statesPerProcess = paddednWindows / this.numProc;
            if (this.numProc > 1) {
                logger.fine(String.format(" Number of MPI Processes:  %d", this.numProc));
                logger.fine(String.format(" Rank of this MPI Process: %d", this.rank));
                logger.fine(String.format(" States per process per row: %d", this.statesPerProcess));
            }
        }
        this.nSamples = new int[this.statesPerProcess];
        this.energiesLowPJ = new double[this.statesPerProcess][];
        this.energiesAtPJ = new double[this.statesPerProcess][];
        this.energiesHighPJ = new double[this.statesPerProcess][];
        this.volumePJ = new double[this.statesPerProcess][];
        this.bufferNSamples = IntegerBuf.buffer((int[])this.nSamples);
        this.bufferLow = DoubleBuf.buffer((double[][])this.energiesLowPJ);
        this.bufferAt = DoubleBuf.buffer((double[][])this.energiesAtPJ);
        this.bufferHigh = DoubleBuf.buffer((double[][])this.energiesHighPJ);
        this.bufferVolume = DoubleBuf.buffer((double[][])this.volumePJ);
    }

    public int getRank() {
        return this.rank;
    }

    public void evaluateStates(double[][] energiesLow, double[][] energiesAt, double[][] energiesHigh, double[][] volume) {
        for (int state = 0; state < this.nStates; ++state) {
            double[] currentLambdas = state == 0 ? new double[]{this.lambdaValues[state], this.lambdaValues[state + 1]} : (state == this.nStates - 1 ? new double[]{this.lambdaValues[state - 1], this.lambdaValues[state]} : new double[]{this.lambdaValues[state - 1], this.lambdaValues[state], this.lambdaValues[state + 1]});
            int nCurrLambdas = currentLambdas.length;
            double[][] energy = new double[nCurrLambdas][];
            this.evaluateEnergies(state, currentLambdas, energy, this.fullFilePaths);
        }
        this.gatherAllValues(energiesLow, energiesAt, energiesHigh, volume);
    }

    private void evaluateEnergies(int state, double[] lambdaValues, double[][] energy, String[][] fullFilePaths) {
        if (state % this.numProc == this.rank) {
            int len;
            int workItem = state / this.numProc;
            double[] vol = this.getEnergyForLambdas(lambdaValues, fullFilePaths[state], energy);
            this.nSamples[workItem] = len = energy[0].length;
            this.energiesLowPJ[workItem] = new double[len];
            this.energiesAtPJ[workItem] = new double[len];
            this.energiesHighPJ[workItem] = new double[len];
            this.volumePJ[workItem] = new double[len];
            if (state == 0) {
                System.arraycopy(energy[0], 0, this.energiesAtPJ[workItem], 0, len);
                System.arraycopy(energy[1], 0, this.energiesHighPJ[workItem], 0, len);
            } else if (state < this.nStates - 1) {
                System.arraycopy(energy[0], 0, this.energiesLowPJ[workItem], 0, len);
                System.arraycopy(energy[1], 0, this.energiesAtPJ[workItem], 0, len);
                System.arraycopy(energy[2], 0, this.energiesHighPJ[workItem], 0, len);
            } else if (state == this.nStates - 1) {
                System.arraycopy(energy[0], 0, this.energiesLowPJ[workItem], 0, len);
                System.arraycopy(energy[1], 0, this.energiesAtPJ[workItem], 0, len);
            }
            if (vol != null) {
                System.arraycopy(vol, 0, this.volumePJ[workItem], 0, len);
            }
        }
    }

    private void gatherAllValues(double[][] energiesLow, double[][] energiesAt, double[][] energiesHigh, double[][] volume) {
        if (this.useMPI) {
            try {
                if (this.rank != 0) {
                    this.world.send(0, (Buf)this.bufferNSamples);
                    for (int workItem = 0; workItem < this.statesPerProcess; ++workItem) {
                        this.bufferLow = DoubleBuf.buffer((double[])this.energiesLowPJ[workItem]);
                        this.bufferAt = DoubleBuf.buffer((double[])this.energiesAtPJ[workItem]);
                        this.bufferHigh = DoubleBuf.buffer((double[])this.energiesHighPJ[workItem]);
                        this.bufferVolume = DoubleBuf.buffer((double[])this.volumePJ[workItem]);
                        this.world.send(0, (Buf)this.bufferLow);
                        this.world.send(0, (Buf)this.bufferAt);
                        this.world.send(0, (Buf)this.bufferHigh);
                        this.world.send(0, (Buf)this.bufferVolume);
                    }
                } else {
                    for (int proc = 0; proc < this.numProc; ++proc) {
                        if (proc > 0) {
                            this.world.receive(Integer.valueOf(proc), (Buf)this.bufferNSamples);
                        }
                        for (int workItem = 0; workItem < this.statesPerProcess; ++workItem) {
                            int state = this.numProc * workItem + proc;
                            int nSnapshots = this.nSamples[workItem];
                            if (state >= this.nStates) continue;
                            if (proc > 0) {
                                this.updateMemory(workItem, nSnapshots);
                                this.world.receive(Integer.valueOf(proc), (Buf)this.bufferLow);
                                this.world.receive(Integer.valueOf(proc), (Buf)this.bufferAt);
                                this.world.receive(Integer.valueOf(proc), (Buf)this.bufferHigh);
                                this.world.receive(Integer.valueOf(proc), (Buf)this.bufferVolume);
                            }
                            energiesLow[state] = new double[nSnapshots];
                            energiesAt[state] = new double[nSnapshots];
                            energiesHigh[state] = new double[nSnapshots];
                            volume[state] = new double[nSnapshots];
                            System.arraycopy(this.energiesLowPJ[workItem], 0, energiesLow[state], 0, nSnapshots);
                            System.arraycopy(this.energiesAtPJ[workItem], 0, energiesAt[state], 0, nSnapshots);
                            System.arraycopy(this.energiesHighPJ[workItem], 0, energiesHigh[state], 0, nSnapshots);
                            System.arraycopy(this.volumePJ[workItem], 0, volume[state], 0, nSnapshots);
                        }
                    }
                }
                this.world.barrier();
            }
            catch (Exception ex) {
                logger.severe(" Exception collecting energy values." + String.valueOf(ex) + Utilities.stackTraceToString((Throwable)ex));
            }
        } else {
            for (int i = 0; i < this.nStates; ++i) {
                int len = this.energiesAtPJ[this.rank].length;
                energiesLow[i] = new double[len];
                energiesAt[i] = new double[len];
                energiesHigh[i] = new double[len];
                volume[i] = new double[len];
                System.arraycopy(this.energiesLowPJ[i], 0, energiesLow[i], 0, len);
                System.arraycopy(this.energiesAtPJ[i], 0, energiesAt[i], 0, len);
                System.arraycopy(this.energiesHighPJ[i], 0, energiesHigh[i], 0, len);
                System.arraycopy(this.volumePJ[i], 0, volume[i], 0, len);
            }
        }
    }

    private double[] getEnergyForLambdas(double[] lambdaValues, String[] arcFileName, double[][] energy) {
        int numTopologies = this.molecularAssemblies.length;
        StringBuilder sb = new StringBuilder("\n");
        for (int j = 0; j < numTopologies; ++j) {
            File archiveFile = new File(arcFileName[j]);
            this.openers[j].setFile(archiveFile);
            this.molecularAssemblies[j].setFile(archiveFile);
            sb.append(String.format(" Evaluating energies for file: %s\n", arcFileName[j]));
        }
        sb.append("\n");
        logger.info(sb.toString());
        int nSnapshots = this.openers[0].countNumModels();
        double[] x = new double[this.potential.getNumberOfVariables()];
        double[] vol = new double[nSnapshots];
        int nLambdas = lambdaValues.length;
        for (int k = 0; k < nLambdas; ++k) {
            energy[k] = new double[nSnapshots];
        }
        LambdaInterface linter1 = (LambdaInterface)this.potential;
        int endWindow = this.nStates - 1;
        String endWindows = endWindow + File.separator;
        if (arcFileName[0].contains(endWindows)) {
            logger.info(String.format(" %s     %s   %s     %s   %s ", "Snapshot", "Lambda Low", "Energy Low", "Lambda At", "Energy At"));
        } else if (arcFileName[0].contains("0/")) {
            logger.info(String.format(" %s     %s   %s     %s   %s ", "Snapshot", "Lambda At", "Energy At", "Lambda High", "Energy High"));
        } else {
            logger.info(String.format(" %s     %s   %s     %s   %s     %s   %s ", "Snapshot", "Lambda Low", "Energy Low", "Lambda At", "Energy At", "Lambda High", "Energy High"));
        }
        for (int i = 0; i < nSnapshots; ++i) {
            boolean resetPosition = i == 0;
            int nOpeners = this.openers.length;
            for (int n = 0; n < nOpeners; ++n) {
                this.openers[n].readNext(resetPosition, false);
            }
            x = this.potential.getCoordinates(x);
            nLambdas = lambdaValues.length;
            for (int k = 0; k < nLambdas; ++k) {
                double lambda = lambdaValues[k];
                linter1.setLambda(lambda);
                energy[k][i] = this.potential.energy(x, false);
            }
            if (nLambdas == 2) {
                logger.info(String.format(" %8d     %6.3f   %14.4f     %6.3f   %14.4f ", i + 1, lambdaValues[0], energy[0][i], lambdaValues[1], energy[1][i]));
            } else {
                logger.info(String.format(" %8d     %6.3f   %14.4f     %6.3f   %14.4f     %6.3f   %14.4f ", i + 1, lambdaValues[0], energy[0][i], lambdaValues[1], energy[1][i], lambdaValues[2], energy[2][i]));
            }
            Crystal unitCell = this.potential instanceof CrystalPotential ? ((CrystalPotential)this.potential).getCrystal().getUnitCell() : this.molecularAssemblies[0].getCrystal().getUnitCell();
            if (unitCell.aperiodic()) continue;
            int nSymm = unitCell.getNumSymOps();
            vol[i] = unitCell.volume / (double)nSymm;
        }
        return vol;
    }

    private void updateMemory(int workItem, int nSnapshots) {
        if (this.energiesAtPJ[workItem].length < nSnapshots) {
            this.energiesLowPJ[workItem] = new double[nSnapshots];
            this.energiesAtPJ[workItem] = new double[nSnapshots];
            this.energiesHighPJ[workItem] = new double[nSnapshots];
            this.volumePJ[workItem] = new double[nSnapshots];
        }
        this.bufferLow = DoubleBuf.buffer((double[])this.energiesLowPJ[workItem]);
        this.bufferAt = DoubleBuf.buffer((double[])this.energiesAtPJ[workItem]);
        this.bufferHigh = DoubleBuf.buffer((double[])this.energiesHighPJ[workItem]);
        this.bufferVolume = DoubleBuf.buffer((double[])this.volumePJ[workItem]);
    }
}

