/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms;

import ffx.algorithms.AlgorithmFunctions;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.algorithms.dynamics.integrators.IntegratorEnum;
import ffx.algorithms.dynamics.thermostats.ThermostatEnum;
import ffx.algorithms.optimize.Minimize;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.utils.PotentialsUtils;
import java.io.File;
import java.util.logging.Logger;

public class AlgorithmUtils
extends PotentialsUtils
implements AlgorithmFunctions {
    private static final Logger logger = Logger.getLogger(AlgorithmUtils.class.getName());
    private final long initTime;
    private long interTime;

    public AlgorithmUtils() {
        this.interTime = this.initTime = System.nanoTime();
    }

    @Override
    public void md(MolecularAssembly assembly, int nStep, double timeStep, double printInterval, double saveInterval, double temperature, boolean initVelocities, File dyn) {
        if (assembly == null) {
            logger.info(" No active system to minimize.");
        } else {
            MolecularDynamics molecularDynamics = new MolecularDynamics(assembly, (Potential)assembly.getPotentialEnergy(), null, ThermostatEnum.BUSSI, IntegratorEnum.BEEMAN);
            molecularDynamics.dynamic(nStep, timeStep, printInterval, saveInterval, temperature, initVelocities, dyn);
        }
    }

    @Override
    public Potential minimize(MolecularAssembly assembly, double eps) {
        if (assembly == null) {
            logger.info(" No active system to minimize.");
            return null;
        }
        Minimize minimize = new Minimize(assembly, null);
        return minimize.minimize(eps);
    }

    public double time() {
        long currTime = System.nanoTime();
        logger.info(String.format(" Time since interface established: %f", (double)(currTime - this.initTime) * 1.0E-9));
        double elapsed = (double)(currTime - this.interTime) * 1.0E-9;
        this.interTime = currTime;
        logger.info(String.format(" Time since last timer call: %f", elapsed));
        return elapsed;
    }
}

