/*
 * Decompiled with CFR 0.152.
 */
package ffx.crystal;

import ffx.crystal.HKL;
import ffx.numerics.math.DoubleMath;
import ffx.numerics.math.MatrixMath;
import ffx.numerics.math.ScalarMath;
import org.apache.commons.math3.util.FastMath;

public class SymOp {
    private static final double ZERO = 0.0;
    public static final double[][] ZERO_ROTATION = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    public static final double[] Tr_0_0_0 = new double[]{0.0, 0.0, 0.0};
    private static final double f12 = 0.5;
    static final double[] Tr_12_0_12 = new double[]{0.5, 0.0, 0.5};
    static final double[] Tr_0_12_12 = new double[]{0.0, 0.5, 0.5};
    static final double[] Tr_12_12_0 = new double[]{0.5, 0.5, 0.0};
    static final double[] Tr_12_12_12 = new double[]{0.5, 0.5, 0.5};
    static final double[] Tr_0_12_0 = new double[]{0.0, 0.5, 0.0};
    static final double[] Tr_12_0_0 = new double[]{0.5, 0.0, 0.0};
    static final double[] Tr_0_0_12 = new double[]{0.0, 0.0, 0.5};
    private static final double f13 = 0.3333333333333333;
    static final double[] Tr_0_0_13 = new double[]{0.0, 0.0, 0.3333333333333333};
    private static final double f23 = 0.6666666666666666;
    static final double[] Tr_23_13_13 = new double[]{0.6666666666666666, 0.3333333333333333, 0.3333333333333333};
    static final double[] Tr_13_23_23 = new double[]{0.3333333333333333, 0.6666666666666666, 0.6666666666666666};
    static final double[] Tr_0_0_23 = new double[]{0.0, 0.0, 0.6666666666666666};
    private static final double f14 = 0.25;
    static final double[] Tr_12_0_14 = new double[]{0.5, 0.0, 0.25};
    static final double[] Tr_0_12_14 = new double[]{0.0, 0.5, 0.25};
    static final double[] Tr_14_14_14 = new double[]{0.25, 0.25, 0.25};
    static final double[] Tr_12_12_14 = new double[]{0.5, 0.5, 0.25};
    static final double[] Tr_0_0_14 = new double[]{0.0, 0.0, 0.25};
    private static final double f34 = 0.75;
    static final double[] Tr_0_0_34 = new double[]{0.0, 0.0, 0.75};
    static final double[] Tr_12_0_34 = new double[]{0.5, 0.0, 0.75};
    static final double[] Tr_0_12_34 = new double[]{0.0, 0.5, 0.75};
    static final double[] Tr_34_14_14 = new double[]{0.75, 0.25, 0.25};
    static final double[] Tr_14_14_34 = new double[]{0.25, 0.25, 0.75};
    static final double[] Tr_14_34_14 = new double[]{0.25, 0.75, 0.25};
    static final double[] Tr_12_12_34 = new double[]{0.5, 0.5, 0.75};
    static final double[] Tr_14_34_34 = new double[]{0.25, 0.75, 0.75};
    static final double[] Tr_34_34_14 = new double[]{0.75, 0.75, 0.25};
    static final double[] Tr_34_34_34 = new double[]{0.75, 0.75, 0.75};
    static final double[] Tr_34_14_34 = new double[]{0.75, 0.25, 0.75};
    private static final double f16 = 0.16666666666666666;
    static final double[] Tr_13_23_16 = new double[]{0.3333333333333333, 0.6666666666666666, 0.16666666666666666};
    static final double[] Tr_0_0_16 = new double[]{0.0, 0.0, 0.16666666666666666};
    private static final double f56 = 0.8333333333333334;
    static final double[] Tr_0_0_56 = new double[]{0.0, 0.0, 0.8333333333333334};
    static final double[] Tr_23_13_56 = new double[]{0.6666666666666666, 0.3333333333333333, 0.8333333333333334};
    private static final double[] X = new double[]{1.0, 0.0, 0.0};
    private static final double[] Y = new double[]{0.0, 1.0, 0.0};
    private static final double[] Z = new double[]{0.0, 0.0, 1.0};
    static final double[][] Rot_Y_Z_X = new double[][]{Y, Z, X};
    static final double[][] Rot_X_Y_Z = new double[][]{X, Y, Z};
    static final double[][] Rot_Z_X_Y = new double[][]{Z, X, Y};
    static final double[][] Rot_X_Z_Y = new double[][]{X, Z, Y};
    static final double[][] Rot_Z_Y_X = new double[][]{Z, Y, X};
    static final double[][] Rot_Y_X_Z = new double[][]{Y, X, Z};
    private static final double[] mX = new double[]{-1.0, 0.0, 0.0};
    static final double[][] Rot_Y_mX_Z = new double[][]{Y, mX, Z};
    static final double[][] Rot_mX_Z_Y = new double[][]{mX, Z, Y};
    static final double[][] Rot_Y_Z_mX = new double[][]{Y, Z, mX};
    static final double[][] Rot_mX_Y_Z = new double[][]{mX, Y, Z};
    static final double[][] Rot_Z_Y_mX = new double[][]{Z, Y, mX};
    static final double[][] Rot_Z_mX_Y = new double[][]{Z, mX, Y};
    private static final double[] mY = new double[]{0.0, -1.0, 0.0};
    static final double[][] Rot_Z_mY_X = new double[][]{Z, mY, X};
    static final double[][] Rot_X_Z_mY = new double[][]{X, Z, mY};
    static final double[][] Rot_mY_X_Z = new double[][]{mY, X, Z};
    static final double[][] Rot_mY_Z_mX = new double[][]{mY, Z, mX};
    static final double[][] Rot_mY_Z_X = new double[][]{mY, Z, X};
    static final double[][] Rot_Z_X_mY = new double[][]{Z, X, mY};
    static final double[][] Rot_Z_mX_mY = new double[][]{Z, mX, mY};
    static final double[][] Rot_mX_Z_mY = new double[][]{mX, Z, mY};
    static final double[][] Rot_X_mY_Z = new double[][]{X, mY, Z};
    static final double[][] Rot_mY_mX_Z = new double[][]{mY, mX, Z};
    static final double[][] Rot_Z_mY_mX = new double[][]{Z, mY, mX};
    static final double[][] Rot_mX_mY_Z = new double[][]{mX, mY, Z};
    private static final double[] mZ = new double[]{0.0, 0.0, -1.0};
    static final double[][] Rot_Y_mX_mZ = new double[][]{Y, mX, mZ};
    static final double[][] Rot_mX_Y_mZ = new double[][]{mX, Y, mZ};
    static final double[][] Rot_X_mZ_Y = new double[][]{X, mZ, Y};
    static final double[][] Rot_mY_mZ_X = new double[][]{mY, mZ, X};
    static final double[][] Rot_Y_X_mZ = new double[][]{Y, X, mZ};
    static final double[][] Rot_Y_mZ_X = new double[][]{Y, mZ, X};
    static final double[][] Rot_mX_mY_mZ = new double[][]{mX, mY, mZ};
    static final double[][] Rot_X_Y_mZ = new double[][]{X, Y, mZ};
    static final double[][] Rot_mZ_mY_mX = new double[][]{mZ, mY, mX};
    static final double[][] Rot_X_mZ_mY = new double[][]{X, mZ, mY};
    static final double[][] Rot_mY_mX_mZ = new double[][]{mY, mX, mZ};
    static final double[][] Rot_mY_X_mZ = new double[][]{mY, X, mZ};
    static final double[][] Rot_mX_mZ_mY = new double[][]{mX, mZ, mY};
    static final double[][] Rot_mZ_mX_mY = new double[][]{mZ, mX, mY};
    static final double[][] Rot_mZ_mY_X = new double[][]{mZ, mY, X};
    static final double[][] Rot_mZ_Y_mX = new double[][]{mZ, Y, mX};
    static final double[][] Rot_mZ_mX_Y = new double[][]{mZ, mX, Y};
    static final double[][] Rot_mX_mZ_Y = new double[][]{mX, mZ, Y};
    static final double[][] Rot_X_mY_mZ = new double[][]{X, mY, mZ};
    static final double[][] Rot_mZ_X_Y = new double[][]{mZ, X, Y};
    static final double[][] Rot_Y_mZ_mX = new double[][]{Y, mZ, mX};
    static final double[][] Rot_mY_mZ_mX = new double[][]{mY, mZ, mX};
    static final double[][] Rot_mZ_Y_X = new double[][]{mZ, Y, X};
    static final double[][] Rot_mZ_X_mY = new double[][]{mZ, X, mY};
    private static final double[] XmY = new double[]{1.0, -1.0, 0.0};
    static final double[][] Rot_XmY_X_mZ = new double[][]{XmY, X, mZ};
    static final double[][] Rot_XmY_X_Z = new double[][]{XmY, X, Z};
    static final double[][] Rot_XmY_mY_Z = new double[][]{XmY, mY, Z};
    static final double[][] Rot_X_XmY_Z = new double[][]{X, XmY, Z};
    static final double[][] Rot_X_XmY_mZ = new double[][]{X, XmY, mZ};
    static final double[][] Rot_mY_XmY_mZ = new double[][]{mY, XmY, mZ};
    static final double[][] Rot_mY_XmY_Z = new double[][]{mY, XmY, Z};
    static final double[][] Rot_XmY_mY_mZ = new double[][]{XmY, mY, mZ};
    private static final double[] mXY = new double[]{-1.0, 1.0, 0.0};
    static final double[][] Rot_Y_mXY_Z = new double[][]{Y, mXY, Z};
    static final double[][] Rot_mX_mXY_mZ = new double[][]{mX, mXY, mZ};
    static final double[][] Rot_mXY_Y_Z = new double[][]{mXY, Y, Z};
    static final double[][] Rot_mXY_mX_Z = new double[][]{mXY, mX, Z};
    static final double[][] Rot_mXY_Y_mZ = new double[][]{mXY, Y, mZ};
    static final double[][] Rot_mXY_mX_mZ = new double[][]{mXY, mX, mZ};
    static final double[][] Rot_mX_mXY_Z = new double[][]{mX, mXY, Z};
    static final double[][] Rot_Y_mXY_mZ = new double[][]{Y, mXY, mZ};
    public final double[][] rot;
    public final double[] tr;
    private static final int XX = 0;
    private static final int YY = 1;
    private static final int ZZ = 2;
    public final int[] replicatesVector;

    public SymOp(double[][] rot, double[] tr) {
        this.rot = rot;
        this.tr = tr;
        this.replicatesVector = new int[]{0, 0, 0};
    }

    public SymOp(double[][] rot, double[] tr, int[] replicatesVector) {
        this.rot = rot;
        this.tr = tr;
        this.replicatesVector = replicatesVector;
    }

    public SymOp(double[][] m) {
        this.rot = new double[3][3];
        this.rot[0][0] = m[0][0];
        this.rot[0][1] = m[0][1];
        this.rot[0][2] = m[0][2];
        this.rot[1][0] = m[1][0];
        this.rot[1][1] = m[1][1];
        this.rot[1][2] = m[1][2];
        this.rot[2][0] = m[2][0];
        this.rot[2][1] = m[2][1];
        this.rot[2][2] = m[2][2];
        this.tr = new double[3];
        this.tr[0] = m[0][3] / m[3][3];
        this.tr[1] = m[1][3] / m[3][3];
        this.tr[2] = m[2][3] / m[3][3];
        this.replicatesVector = new int[]{0, 0, 0};
    }

    public double symPhaseShift(double[] hkl) {
        return Math.PI * -2 * (hkl[0] * this.tr[0] + hkl[1] * this.tr[1] + hkl[2] * this.tr[2]);
    }

    public double symPhaseShift(HKL hkl) {
        return Math.PI * -2 * ((double)hkl.getH() * this.tr[0] + (double)hkl.getK() * this.tr[1] + (double)hkl.getL() * this.tr[2]);
    }

    public double[][] asMatrix() {
        return new double[][]{{this.rot[0][0], this.rot[0][1], this.rot[0][2], this.tr[0]}, {this.rot[1][0], this.rot[1][1], this.rot[1][2], this.tr[1]}, {this.rot[2][0], this.rot[2][1], this.rot[2][2], this.tr[2]}, {0.0, 0.0, 0.0, 1.0}};
    }

    public SymOp append(SymOp symOp) {
        return new SymOp(MatrixMath.mat4Mat4((double[][])symOp.asMatrix(), (double[][])this.asMatrix()));
    }

    public SymOp prepend(SymOp symOp) {
        return new SymOp(MatrixMath.mat4Mat4((double[][])this.asMatrix(), (double[][])symOp.asMatrix()));
    }

    public static SymOp combineSymOps(SymOp symOp1, SymOp symOp2) {
        return new SymOp(MatrixMath.mat4Mat4((double[][])symOp2.asMatrix(), (double[][])symOp1.asMatrix()));
    }

    public static void applyCartSymOp(int n, double[] x, double[] y, double[] z, double[] mateX, double[] mateY, double[] mateZ, SymOp symOp) {
        if (x == null || y == null || z == null) {
            throw new IllegalArgumentException("The input arrays x, y and z must not be null.");
        }
        if (x.length < n || y.length < n || z.length < n) {
            throw new IllegalArgumentException("The input arrays x, y and z must be of length n: " + n);
        }
        if (mateX == null || mateY == null || mateZ == null) {
            throw new IllegalArgumentException("The output arrays mateX, mateY and mateZ must not be null.");
        }
        if (mateX.length < n || mateY.length < n || mateZ.length < n) {
            throw new IllegalArgumentException("The output arrays mateX, mateY and mateZ must be of length n: " + n);
        }
        double[][] rot = symOp.rot;
        double[] trans = symOp.tr;
        double rot00 = rot[0][0];
        double rot10 = rot[1][0];
        double rot20 = rot[2][0];
        double rot01 = rot[0][1];
        double rot11 = rot[1][1];
        double rot21 = rot[2][1];
        double rot02 = rot[0][2];
        double rot12 = rot[1][2];
        double rot22 = rot[2][2];
        double t0 = trans[0];
        double t1 = trans[1];
        double t2 = trans[2];
        for (int i = 0; i < n; ++i) {
            double xc = x[i];
            double yc = y[i];
            double zc = z[i];
            mateX[i] = rot00 * xc + rot01 * yc + rot02 * zc + t0;
            mateY[i] = rot10 * xc + rot11 * yc + rot12 * zc + t1;
            mateZ[i] = rot20 * xc + rot21 * yc + rot22 * zc + t2;
        }
    }

    public static void applyCartesianSymOp(double[] xyz, double[] mate, SymOp symOp) {
        SymOp.applyCartesianSymOp(xyz, mate, symOp, null);
    }

    public static void applyCartesianSymOp(double[] xyz, double[] mate, SymOp symOp, boolean[] mask) {
        double[][] rot = symOp.rot;
        double[] trans = symOp.tr;
        assert (xyz.length % 3 == 0);
        assert (xyz.length == mate.length);
        int len = xyz.length / 3;
        double rot00 = rot[0][0];
        double rot10 = rot[1][0];
        double rot20 = rot[2][0];
        double rot01 = rot[0][1];
        double rot11 = rot[1][1];
        double rot21 = rot[2][1];
        double rot02 = rot[0][2];
        double rot12 = rot[1][2];
        double rot22 = rot[2][2];
        double tx = trans[0];
        double ty = trans[1];
        double tz = trans[2];
        if (mask == null) {
            for (int i = 0; i < len; ++i) {
                int index = i * 3;
                double xc = xyz[index + 0];
                double yc = xyz[index + 1];
                double zc = xyz[index + 2];
                mate[index + 0] = rot00 * xc + rot01 * yc + rot02 * zc + tx;
                mate[index + 1] = rot10 * xc + rot11 * yc + rot12 * zc + ty;
                mate[index + 2] = rot20 * xc + rot21 * yc + rot22 * zc + tz;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                int index = i * 3;
                double xc = xyz[index + 0];
                double yc = xyz[index + 1];
                double zc = xyz[index + 2];
                if (mask[i]) {
                    mate[index + 0] = rot00 * xc + rot01 * yc + rot02 * zc + tx;
                    mate[index + 1] = rot10 * xc + rot11 * yc + rot12 * zc + ty;
                    mate[index + 2] = rot20 * xc + rot21 * yc + rot22 * zc + tz;
                    continue;
                }
                mate[index + 0] = xc;
                mate[index + 1] = yc;
                mate[index + 2] = zc;
            }
        }
    }

    public static void applyFracSymOp(double[] xyz, double[] mate, SymOp symOp) {
        double[][] rot = symOp.rot;
        double[] trans = symOp.tr;
        double xf = xyz[0];
        double yf = xyz[1];
        double zf = xyz[2];
        mate[0] = rot[0][0] * xf + rot[0][1] * yf + rot[0][2] * zf + trans[0];
        mate[1] = rot[1][0] * xf + rot[1][1] * yf + rot[1][2] * zf + trans[1];
        mate[2] = rot[2][0] * xf + rot[2][1] * yf + rot[2][2] * zf + trans[2];
    }

    public static void applySymOp(int h, int k, int l, int[] mate, SymOp symOp, int nx, int ny, int nz) {
        double[][] rot = symOp.rot;
        double[] trans = symOp.tr;
        mate[0] = (int)rot[0][0] * h + (int)rot[0][1] * k + (int)rot[0][2] * l + (int)FastMath.rint((double)((double)nx * trans[0]));
        mate[1] = (int)rot[1][0] * h + (int)rot[1][1] * k + (int)rot[1][2] * l + (int)FastMath.rint((double)((double)ny * trans[1]));
        mate[2] = (int)rot[2][0] * h + (int)rot[2][1] * k + (int)rot[2][2] * l + (int)FastMath.rint((double)((double)nz * trans[2]));
        mate[0] = ScalarMath.mod((int)mate[0], (int)nx);
        mate[1] = ScalarMath.mod((int)mate[1], (int)ny);
        mate[2] = ScalarMath.mod((int)mate[2], (int)nz);
    }

    public static void applySymRot(HKL hkl, HKL mate, SymOp symOp) {
        double[][] rot = symOp.rot;
        double h = hkl.getH();
        double k = hkl.getK();
        double l = hkl.getL();
        double hs = rot[0][0] * h + rot[0][1] * k + rot[0][2] * l;
        double ks = rot[1][0] * h + rot[1][1] * k + rot[1][2] * l;
        double ls = rot[2][0] * h + rot[2][1] * k + rot[2][2] * l;
        mate.setH((int)FastMath.rint((double)hs));
        mate.setK((int)FastMath.rint((double)ks));
        mate.setL((int)FastMath.rint((double)ls));
    }

    public static void applyCartesianSymRot(double[] xyz, double[] mate, SymOp symOp) {
        SymOp.applyCartesianSymRot(xyz, mate, symOp, null);
    }

    public static void applyCartesianSymRot(double[] xyz, double[] mate, SymOp symOp, boolean[] mask) {
        int l = xyz.length;
        int n = l / 3;
        assert (l % 3 == 0);
        assert (mate.length == l);
        double[][] rot = symOp.rot;
        double rot00 = rot[0][0];
        double rot10 = rot[1][0];
        double rot20 = rot[2][0];
        double rot01 = rot[0][1];
        double rot11 = rot[1][1];
        double rot21 = rot[2][1];
        double rot02 = rot[0][2];
        double rot12 = rot[1][2];
        double rot22 = rot[2][2];
        if (mask == null) {
            for (int i = 0; i < n; ++i) {
                int index = i * 3;
                double xi = xyz[index + 0];
                double yi = xyz[index + 1];
                double zi = xyz[index + 2];
                mate[index + 0] = rot00 * xi + rot01 * yi + rot02 * zi;
                mate[index + 1] = rot10 * xi + rot11 * yi + rot12 * zi;
                mate[index + 2] = rot20 * xi + rot21 * yi + rot22 * zi;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int index = i * 3;
                double xi = xyz[index + 0];
                double yi = xyz[index + 1];
                double zi = xyz[index + 2];
                if (mask[i]) {
                    mate[index + 0] = rot00 * xi + rot01 * yi + rot02 * zi;
                    mate[index + 1] = rot10 * xi + rot11 * yi + rot12 * zi;
                    mate[index + 2] = rot20 * xi + rot21 * yi + rot22 * zi;
                    continue;
                }
                mate[index + 0] = xi;
                mate[index + 1] = yi;
                mate[index + 2] = zi;
            }
        }
    }

    public static void applyTransSymRot(HKL hkl, HKL mate, SymOp symOp) {
        double[][] rot = symOp.rot;
        double h = hkl.getH();
        double k = hkl.getK();
        double l = hkl.getL();
        double hs = rot[0][0] * h + rot[1][0] * k + rot[2][0] * l;
        double ks = rot[0][1] * h + rot[1][1] * k + rot[2][1] * l;
        double ls = rot[0][2] * h + rot[1][2] * k + rot[2][2] * l;
        mate.setH((int)FastMath.rint((double)hs));
        mate.setK((int)FastMath.rint((double)ks));
        mate.setL((int)FastMath.rint((double)ls));
    }

    public static String asMatrixString(SymOp symOp) {
        double[][] values = symOp.asMatrix();
        return String.format(" %14.8f %14.8f %14.8f \\\n           %14.8f %14.8f %14.8f \\\n           %14.8f %14.8f %14.8f \\\n           %14.8f %14.8f %14.8f ", values[0][0], values[0][1], values[0][2], values[1][0], values[1][1], values[1][2], values[2][0], values[2][1], values[2][2], values[0][3], values[1][3], values[2][3]);
    }

    public static SymOp invertSymOp(SymOp symOp) {
        double[] tr = symOp.tr;
        double[][] rot = symOp.rot;
        double[][] inv = MatrixMath.mat3Inverse((double[][])rot);
        return new SymOp(inv, new double[]{-DoubleMath.dot((double[])inv[0], (double[])tr), -DoubleMath.dot((double[])inv[1], (double[])tr), -DoubleMath.dot((double[])inv[2], (double[])tr)});
    }

    public static SymOp parse(String s) {
        String[] tokens = s.split(" +");
        if (tokens.length < 12) {
            return null;
        }
        return new SymOp(new double[][]{{Double.parseDouble(tokens[0]), Double.parseDouble(tokens[1]), Double.parseDouble(tokens[2])}, {Double.parseDouble(tokens[3]), Double.parseDouble(tokens[4]), Double.parseDouble(tokens[5])}, {Double.parseDouble(tokens[6]), Double.parseDouble(tokens[7]), Double.parseDouble(tokens[8])}}, new double[]{Double.parseDouble(tokens[9]), Double.parseDouble(tokens[10]), Double.parseDouble(tokens[11])});
    }

    public static SymOp randomSymOpFactory(double scalar) {
        double[] tr = new double[]{scalar * (FastMath.random() - 0.5), scalar * (FastMath.random() - 0.5), scalar * (FastMath.random() - 0.5)};
        return SymOp.randomSymOpFactory(tr);
    }

    public static SymOp randomSymOpFactory(double[] tr) {
        double[][] rot = new double[3][3];
        double PI2 = Math.PI * 2;
        double[] x = new double[]{FastMath.random(), FastMath.random(), FastMath.random()};
        double theta = x[0] * PI2;
        double phi = x[1] * PI2;
        double z = x[2] * 2.0;
        double r = FastMath.sqrt((double)z);
        double Vx = FastMath.sin((double)phi) * r;
        double Vy = FastMath.cos((double)phi) * r;
        double Vz = FastMath.sqrt((double)(2.0 - z));
        double st = FastMath.sin((double)theta);
        double ct = FastMath.cos((double)theta);
        double Sx = Vx * ct - Vy * st;
        double Sy = Vx * st + Vy * ct;
        rot[0][0] = Vx * Sx - ct;
        rot[0][1] = Vx * Sy - st;
        rot[0][2] = Vx * Vz;
        rot[1][0] = Vy * Sx + st;
        rot[1][1] = Vy * Sy - ct;
        rot[1][2] = Vy * Vz;
        rot[2][0] = Vz * Sx;
        rot[2][1] = Vz * Sy;
        rot[2][2] = 1.0 - z;
        return new SymOp(rot, tr);
    }

    private static String trtoString(double tr) {
        if (tr == 0.5) {
            return "+1/2";
        }
        if (tr == 0.3333333333333333) {
            return "+1/3";
        }
        if (tr == 0.6666666666666666) {
            return "+2/3";
        }
        if (tr == 0.25) {
            return "+1/4";
        }
        if (tr == 0.75) {
            return "+3/4";
        }
        if (tr == 0.16666666666666666) {
            return "+1/6";
        }
        if (tr == 0.8333333333333334) {
            return "+5/6";
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(" Rotation operator:\n");
        sb.append(String.format(" [[%4.1f,%4.1f,%4.1f]\n  [%4.1f,%4.1f,%4.1f]\n  [%4.1f,%4.1f,%4.1f]]\n", this.rot[0][0], this.rot[0][1], this.rot[0][2], this.rot[1][0], this.rot[1][1], this.rot[1][2], this.rot[2][0], this.rot[2][1], this.rot[2][2]));
        sb.append(" Translation:\n");
        sb.append(String.format(" [%4.2f,%4.2f,%4.2f]", this.tr[0], this.tr[1], this.tr[2]));
        return sb.toString();
    }

    public String toStringPrecise() {
        StringBuilder sb = new StringBuilder(" Rotation operator:\n");
        sb.append(String.format(" [[%18.16e,%18.16e,%18.16e]\n  [%18.16e,%18.16e,%18.16e]\n  [%18.16e,%18.16e,%18.16e]]\n", this.rot[0][0], this.rot[0][1], this.rot[0][2], this.rot[1][0], this.rot[1][1], this.rot[1][2], this.rot[2][0], this.rot[2][1], this.rot[2][2]));
        sb.append(" Translation:\n");
        sb.append(String.format(" [%18.16e,%18.16e,%18.16e]", this.tr[0], this.tr[1], this.tr[2]));
        return sb.toString();
    }

    public String toXYZString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            boolean s = false;
            if (this.rot[i][0] < 0.0) {
                sb.append("-X");
                s = true;
            } else if (this.rot[i][0] > 0.0) {
                sb.append("X");
                s = true;
            }
            if (this.rot[i][1] < 0.0) {
                sb.append("-Y");
                s = true;
            } else if (this.rot[i][1] > 0.0) {
                sb.append(s ? "+Y" : "Y");
                s = true;
            }
            if (this.rot[i][2] < 0.0) {
                sb.append("-Z");
            } else if (this.rot[i][2] > 0.0) {
                sb.append(s ? "+Z" : "Z");
            }
            if (this.tr[i] > 0.0) {
                sb.append(SymOp.trtoString(this.tr[i]));
            }
            if (i >= 2) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

