/*
 * Decompiled with CFR 0.152.
 */
package ffx.crystal;

import ffx.crystal.Crystal;
import ffx.crystal.LatticeSystem;
import ffx.crystal.SpaceGroup;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class SpaceGroupConversions {
    private static final Logger logger = Logger.getLogger(SpaceGroupConversions.class.getName());

    private SpaceGroupConversions() {
    }

    public static Crystal hrConversion(Crystal crystal) {
        return SpaceGroupConversions.hrConversion(crystal.a, crystal.b, crystal.c, crystal.alpha, crystal.beta, crystal.gamma, crystal.spaceGroup);
    }

    public static Crystal hrConversion(double a, double b, double c, double alpha, double beta, double gamma, SpaceGroup currentSG) {
        String xtalName;
        boolean hexStart = false;
        switch (currentSG.shortName) {
            case "H3": {
                logger.info(" Converting from H3 to R3:");
                xtalName = "R3";
                hexStart = true;
                break;
            }
            case "H-3": {
                logger.info(" Converting from H-3 to R-3:");
                xtalName = "R-3";
                hexStart = true;
                break;
            }
            case "H32": {
                logger.info(" Converting from H32 to R32:");
                xtalName = "R32";
                hexStart = true;
                break;
            }
            case "H3m": {
                logger.info(" Converting from H3m to R3m:");
                xtalName = "R3m";
                hexStart = true;
                break;
            }
            case "H3c": {
                logger.info(" Converting from H3c to R3c:");
                xtalName = "R3c";
                hexStart = true;
                break;
            }
            case "H-3m": {
                logger.info(" Converting from H-3m to R-3m:");
                xtalName = "R-3m";
                hexStart = true;
                break;
            }
            case "H-3c": {
                logger.info(" Converting from H-3c to R-3c:");
                xtalName = "R-3c";
                hexStart = true;
                break;
            }
            case "R3": {
                logger.info(" Converting from R3 to H3:");
                xtalName = "H3";
                break;
            }
            case "R-3": {
                logger.info(" Converting from R-3 to H-3:");
                xtalName = "H-3";
                break;
            }
            case "R32": {
                logger.info(" Converting from R32 to H32:");
                xtalName = "H32";
                break;
            }
            case "R3m": {
                logger.info(" Converting from R3m to H3m:");
                xtalName = "H3m";
                break;
            }
            case "R3c": {
                logger.info(" Converting from R3c to H3c:");
                xtalName = "H3c";
                break;
            }
            case "R-3m": {
                logger.info(" Converting from R-3m to H-3m:");
                xtalName = "H-3m";
                break;
            }
            case "R-3c": {
                logger.info(" Converting from R-3c to H-3c:");
                xtalName = "H-3c";
                break;
            }
            default: {
                logger.severe(String.format(" Unable to determine converted version for space group: %s", currentSG));
                return new Crystal(a, b, c, alpha, beta, gamma, currentSG.shortName);
            }
        }
        if (hexStart) {
            if (LatticeSystem.RHOMBOHEDRAL_LATTICE.validParameters(a, b, c, alpha, beta, gamma)) {
                logger.info(" Crystal already has valid lattice parameters for new space group " + xtalName);
                return new Crystal(a, b, c, alpha, beta, gamma, xtalName);
            }
            double aR = FastMath.sqrt((double)(0.1111111111111111 * (FastMath.pow((double)c, (int)2) + 3.0 * FastMath.pow((double)a, (int)2))));
            double aRAlpha = FastMath.acos((double)((2.0 * FastMath.pow((double)c, (int)2) - 3.0 * FastMath.pow((double)a, (int)2)) / (2.0 * FastMath.pow((double)c, (int)2) + 6.0 * FastMath.pow((double)a, (int)2)))) / Math.PI * 180.0;
            return new Crystal(aR, aR, aR, aRAlpha, aRAlpha, aRAlpha, xtalName);
        }
        if (LatticeSystem.HEXAGONAL_LATTICE.validParameters(a, b, c, alpha, beta, gamma)) {
            logger.info(" Crystal already has valid lattice parameters for new space group " + xtalName);
            return new Crystal(a, b, c, alpha, beta, gamma, xtalName);
        }
        double aH = 2.0 * FastMath.pow((double)a, (int)2) * (1.0 - FastMath.cos((double)(alpha / 180.0 * Math.PI)));
        double cH = FastMath.sqrt((double)(3.0 * FastMath.pow((double)a, (int)2) * (1.0 + 2.0 * FastMath.cos((double)(alpha / 180.0 * Math.PI)))));
        return new Crystal(aH, aH, cH, 90.0, 90.0, 120.0, xtalName);
    }
}

