/*
 * Decompiled with CFR 0.152.
 */
package ffx.crystal;

import ffx.crystal.ReflectionList;
import org.apache.commons.math3.util.FastMath;

public class ReflectionSpline {
    private final ReflectionList reflectionList;
    private final int nParams;
    private double f;
    private int i0;
    private int i1;
    private int i2;
    private double dfi0;
    private double dfi1;
    private double dfi2;

    public ReflectionSpline(ReflectionList reflectionList, int nParams) {
        this.reflectionList = reflectionList;
        this.nParams = nParams;
    }

    public double dfi0() {
        return this.dfi0;
    }

    public double dfi1() {
        return this.dfi1;
    }

    public double dfi2() {
        return this.dfi2;
    }

    public double f() {
        return this.f;
    }

    public double f(double invResSq, double[] params) {
        double s = (double)this.nParams * this.reflectionList.ordinal(invResSq);
        int i = (int)FastMath.floor((double)s);
        double ds = s - (double)i - 0.5;
        this.i0 = FastMath.min((int)FastMath.max((int)0, (int)(i - 1)), (int)(this.nParams - 1));
        this.i1 = FastMath.min((int)FastMath.max((int)0, (int)i), (int)(this.nParams - 1));
        this.i2 = FastMath.min((int)FastMath.max((int)0, (int)(i + 1)), (int)(this.nParams - 1));
        this.f = params[this.i0] * 0.5 * (ds - 0.5) * (ds - 0.5) + params[this.i1] * (0.75 - ds * ds) + params[this.i2] * 0.5 * (ds + 0.5) * (ds + 0.5);
        this.dfi0 = 0.5 * (ds - 0.5) * (ds - 0.5);
        this.dfi1 = 0.75 - ds * ds;
        this.dfi2 = 0.5 * (ds + 0.5) * (ds + 0.5);
        return this.f;
    }

    public int i0() {
        return this.i0;
    }

    public int i1() {
        return this.i1;
    }

    public int i2() {
        return this.i2;
    }
}

