/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.tornado;

import uk.ac.manchester.tornado.api.TornadoBackend;
import uk.ac.manchester.tornado.api.TornadoTargetDevice;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;

public class FFXTornado {
    private FFXTornado() {
    }

    public static TornadoDevice getDevice() {
        return TornadoRuntimeProvider.getTornadoRuntime().getDefaultDevice();
    }

    public static TornadoDevice getDevice(int driverIndex, int deviceIndex) {
        TornadoBackend tornadoBackend = TornadoRuntimeProvider.getTornadoRuntime().getBackend(driverIndex);
        return tornadoBackend.getDevice(deviceIndex);
    }

    public static TornadoDevice getDevice(int deviceID) {
        int n = 0;
        int numBackends = TornadoRuntimeProvider.getTornadoRuntime().getNumBackends();
        for (int backendIndex = 0; backendIndex < numBackends; ++backendIndex) {
            TornadoBackend tornadoBackend = TornadoRuntimeProvider.getTornadoRuntime().getBackend(backendIndex);
            for (int deviceIndex = 0; deviceIndex < tornadoBackend.getNumDevices(); ++deviceIndex) {
                if (n == deviceID) {
                    TornadoRuntimeProvider.setProperty((String)"devices", (String)(backendIndex + ":" + deviceIndex));
                    return FFXTornado.getDevice(backendIndex, deviceIndex);
                }
                ++n;
            }
        }
        return null;
    }

    public static int getNumberOfDevices() {
        int n = 0;
        int numBackends = TornadoRuntimeProvider.getTornadoRuntime().getNumBackends();
        for (int backendIndex = 0; backendIndex < numBackends; ++backendIndex) {
            TornadoBackend tornadoBackend = TornadoRuntimeProvider.getTornadoRuntime().getBackend(backendIndex);
            int count = tornadoBackend.getNumDevices();
            n += count;
        }
        return n;
    }

    public static void logDevice(TornadoDevice device) {
        TornadoTargetDevice tornadoTargetDevice = device.getPhysicalDevice();
        long[] workItemSize = tornadoTargetDevice.getDeviceMaxWorkItemSizes();
        System.out.printf("\n Device Name:         %s%n", tornadoTargetDevice.getDeviceName());
        System.out.printf(" Backend:             %s%n", device.getTornadoVMBackend().name());
        System.out.printf(" Compute Units:       %s%n", tornadoTargetDevice.getDeviceMaxComputeUnits());
        System.out.printf(" Max Work Item Sizes: [%d, %d, %d]%n", workItemSize[0], workItemSize[1], workItemSize[2]);
        System.out.printf(" Clock Frequency:     %6d Ghz%n", tornadoTargetDevice.getDeviceMaxClockFrequency());
        System.out.printf(" Global Memory:       %6d MB%n", tornadoTargetDevice.getDeviceGlobalMemorySize() / 1024L / 1024L);
        System.out.printf(" Local Memory:        %6d KB%n", tornadoTargetDevice.getDeviceLocalMemorySize() / 1024L);
    }
}

