/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.switching;

import ffx.numerics.switching.BellCurveSwitch;
import ffx.numerics.switching.ConstantSwitch;
import ffx.numerics.switching.LinearDerivativeSwitch;
import ffx.numerics.switching.MultiplicativeSwitch;
import ffx.numerics.switching.PowerSwitch;
import ffx.numerics.switching.SquaredTrigSwitch;
import ffx.numerics.switching.UnivariateSwitchingFunction;
import java.util.Arrays;

public class UnivariateFunctionFactory {
    private UnivariateFunctionFactory() {
    }

    public static UnivariateSwitchingFunction parseUSF(String[] toks, int offset) {
        return UnivariateFunctionFactory.parseUSF(Arrays.copyOfRange(toks, offset, toks.length));
    }

    public static UnivariateSwitchingFunction parseUSF(String[] toks) {
        String selectionString;
        return switch (selectionString = toks[0].toUpperCase().replaceAll("-", "").replaceAll("_", "").replaceAll(" ", "")) {
            case "BELL", "BELLCURVE", "BELLCURVESWITCH" -> UnivariateFunctionFactory.parseBell(toks);
            case "CONSTANT", "NONE", "FLAT" -> new ConstantSwitch();
            case "LINEARDERIVATIVE" -> new LinearDerivativeSwitch();
            case "MULTIPLICATIVE", "PENTICHERMITE" -> UnivariateFunctionFactory.parseMultiplicative(toks);
            case "POWER" -> UnivariateFunctionFactory.parsePower(toks);
            case "LINEAR" -> UnivariateFunctionFactory.parseSpecificPow(1.0, toks);
            case "QUADRATIC" -> UnivariateFunctionFactory.parseSpecificPow(2.0, toks);
            case "CUBIC" -> UnivariateFunctionFactory.parseSpecificPow(3.0, toks);
            case "TRIGONOMETRIC", "TRIG", "SINSQUARED" -> UnivariateFunctionFactory.parseTrig(toks);
            default -> throw new IllegalArgumentException(String.format(" Could not parse %s as a valid univariate switching function!", Arrays.toString(toks)));
        };
    }

    private static BellCurveSwitch parseBell(String[] toks) {
        double midpoint = 0.5;
        if (toks.length > 2) {
            midpoint = Double.parseDouble(toks[1]);
        }
        double width = 1.0;
        if (toks.length > 3) {
            width = Double.parseDouble(toks[2]);
        }
        return new BellCurveSwitch(midpoint, width);
    }

    private static MultiplicativeSwitch parseMultiplicative(String[] toks) {
        if (toks.length > 3) {
            return new MultiplicativeSwitch(Double.parseDouble(toks[2]), Double.parseDouble(toks[1]));
        }
        return new MultiplicativeSwitch();
    }

    private static PowerSwitch parsePower(String[] toks) {
        double pow = 1.0;
        if (toks.length > 1) {
            pow = Double.parseDouble(toks[1]);
        }
        double alpha = 1.0;
        if (toks.length > 2) {
            alpha = Double.parseDouble(toks[2]);
        }
        return new PowerSwitch(alpha, pow);
    }

    private static PowerSwitch parseSpecificPow(double pow, String[] toks) {
        double alpha = 1.0;
        if (toks.length > 1) {
            alpha = Double.parseDouble(toks[1]);
        }
        return new PowerSwitch(alpha, pow);
    }

    private static SquaredTrigSwitch parseTrig(String[] toks) {
        boolean trig = false;
        if (toks.length > 1) {
            trig = Boolean.parseBoolean(toks[1]);
        }
        if (toks.length > 2) {
            return new SquaredTrigSwitch(Double.parseDouble(toks[2]), trig);
        }
        return new SquaredTrigSwitch(trig);
    }
}

