/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.switching;

import ffx.numerics.switching.UnivariateSwitchingFunction;

public class LinearDerivativeSwitch
implements UnivariateSwitchingFunction {
    @Override
    public boolean constantOutsideBounds() {
        return false;
    }

    @Override
    public double firstDerivative(double x) throws IllegalArgumentException {
        return 2.0 - 2.0 * x;
    }

    @Override
    public int getHighestOrderZeroDerivative() {
        return 0;
    }

    @Override
    public double getOneBound() {
        return 1.0;
    }

    @Override
    public double getZeroBound() {
        return 0.0;
    }

    @Override
    public double nthDerivative(double x, int order) throws IllegalArgumentException {
        if (order < 1) {
            throw new IllegalArgumentException("Order must be >= 1");
        }
        return switch (order) {
            case 1 -> this.firstDerivative(x);
            case 2 -> this.secondDerivative(x);
            default -> 0.0;
        };
    }

    @Override
    public double secondDerivative(double x) throws IllegalArgumentException {
        return -2.0;
    }

    @Override
    public boolean symmetricToUnity() {
        return false;
    }

    public String toString() {
        return "Polynomial switch of form f(x) = 2x - x^2";
    }

    @Override
    public boolean validOutsideBounds() {
        return false;
    }

    @Override
    public double valueAt(double x) throws IllegalArgumentException {
        return 2.0 * x - x * x;
    }
}

