/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.switching;

import ffx.numerics.switching.UnivariateSwitchingFunction;

public class ConstantSwitch
implements UnivariateSwitchingFunction {
    private final double val;

    public ConstantSwitch() {
        this(1.0);
    }

    public ConstantSwitch(double value) {
        this.val = value;
    }

    @Override
    public boolean constantOutsideBounds() {
        return true;
    }

    @Override
    public double firstDerivative(double x) {
        return 0.0;
    }

    @Override
    public int getHighestOrderZeroDerivative() {
        return 1;
    }

    @Override
    public double getOneBound() {
        return Double.NaN;
    }

    @Override
    public double getZeroBound() {
        return Double.NaN;
    }

    @Override
    public double nthDerivative(double x, int order) throws IllegalArgumentException {
        if (order < 0) {
            throw new IllegalArgumentException(String.format(" Order must be > 0, was %d", order));
        }
        if (order == 0) {
            return this.val;
        }
        return 0.0;
    }

    @Override
    public double secondDerivative(double x) {
        return 0.0;
    }

    @Override
    public boolean symmetricToUnity() {
        return true;
    }

    public String toString() {
        return String.format("Constant-value f(x) = %f, with no switching behavior (i.e. a dummy switch)", this.val);
    }

    @Override
    public boolean validOutsideBounds() {
        return false;
    }

    @Override
    public double valueAt(double x) throws IllegalArgumentException {
        return this.val;
    }
}

